---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：System.ComponentModel.Composition.Registration 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **C-094（複数規約適用）**：複合シナリオのため実際の動作確認が必要
  2. **C-016（スレッドセーフティ）**：並行性テストの実装詳細が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.ComponentModel.Composition.Registration/src/System/ComponentModel/Composition/Registration/RegistrationBuilder.cs`
- E-02: `src/libraries/System.ComponentModel.Composition.Registration/src/System/ComponentModel/Composition/Registration/PartBuilder.cs`
- E-03: `src/libraries/System.ComponentModel.Composition.Registration/src/System/ComponentModel/Composition/Registration/PartBuilderOfT.cs`
- E-04: `src/libraries/System.ComponentModel.Composition.Registration/src/System/ComponentModel/Composition/Registration/ExportBuilder.cs`
- E-05: `src/libraries/System.ComponentModel.Composition.Registration/src/System/ComponentModel/Composition/Registration/ImportBuilder.cs`
- E-06: `src/libraries/System.ComponentModel.Composition.Registration/src/System/ComponentModel/Composition/Registration/ParameterImportBuilder.cs`
- E-07: `src/libraries/System.ComponentModel.Composition.Registration/src/System/Threading/ReadWriteLock.cs`
- E-08: `src/libraries/System.ComponentModel.Composition.Registration/src/System/Threading/ReadLock.cs`
- E-09: `src/libraries/System.ComponentModel.Composition.Registration/src/System/Threading/WriteLock.cs`
- E-10: `src/libraries/System.ComponentModel.Composition.Registration/ref/System.ComponentModel.Composition.Registration.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### RegistrationBuilder クラス (UT-CCR-001 〜 UT-CCR-016)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | ForTypesDerivedFrom<T>で派生型にマッチ | E-01 L33-38: `typeof(T) != t && typeof(T).IsAssignableFrom(t)` | ○ |
| C-002 | 基底型自身はマッチしない | E-01 L35: `typeof(T) != t` の条件 | ○ |
| C-003 | ForTypesDerivedFrom(Type)で派生型にマッチ | E-01 L41-49: 非ジェネリック版実装 | ○ |
| C-004 | nullでArgumentNullException | E-01 L43: `ArgumentNullException.ThrowIfNull(type)` | ○ |
| C-005 | ForType<T>で指定型のみマッチ | E-01 L51-57: `t == typeof(T)` | ○ |
| C-006 | ForType(Type)で指定型にマッチ | E-01 L59-67: 非ジェネリック版実装 | ○ |
| C-007 | ForType(Type)でnullはArgumentNullException | E-01 L61: `ArgumentNullException.ThrowIfNull(type)` | ○ |
| C-008 | ForTypesMatching<T>でカスタム条件マッチ | E-01 L69-77: Predicate<Type>を使用 | ○ |
| C-009 | ForTypesMatching<T>でnullはArgumentNullException | E-01 L71: `ArgumentNullException.ThrowIfNull(typeFilter)` | ○ |
| C-010 | ForTypesMatching(Predicate)で条件マッチ | E-01 L79-87: 非ジェネリック版実装 | ○ |
| C-011 | ForTypesMatching(Predicate)でnullはArgumentNullException | E-01 L81: `ArgumentNullException.ThrowIfNull(typeFilter)` | ○ |
| C-012 | GetCustomAttributesで型の属性返却 | E-01 L118-206: GetCustomAttributes実装 | ○ |
| C-013 | GetCustomAttributesでプロパティ属性返却 | E-01 L200-203: PropertyInfo処理 | ○ |
| C-014 | GetCustomAttributesでコンストラクタ属性返却 | E-01 L151-160: Constructor処理 | ○ |
| C-015 | GetCustomAttributesでパラメータ属性返却 | E-01 L209-215: ParameterInfo処理 | ○ |
| C-016 | スレッドセーフなキャッシュ動作 | E-01 L128-131, L135-197: ReadLock/WriteLockの使用 | △ |

### PartBuilder クラス (UT-CCR-017 〜 UT-CCR-047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-017 | Export()で型エクスポート設定 | E-02 L45-48: Export()実装 | ○ |
| C-018 | Export(Action)で構成付きエクスポート | E-02 L50-57: exportConfiguration?.Invoke | ○ |
| C-019 | Export(Action)でnull許容 | E-02 L53: `exportConfiguration?.Invoke` | ○ |
| C-020 | Export<T>()で型指定エクスポート | E-02 L59-71: AsContractType<T>呼び出し | ○ |
| C-021 | Export<T>(Action)で複合設定 | E-02 L64-71: 型指定と構成アクション | ○ |
| C-022 | SelectConstructorでコンストラクタ選択 | E-02 L74-77: _constructorFilter設定 | ○ |
| C-023 | SelectConstructor(Func, Action)で両方設定 | E-02 L79-86: filter + import config | ○ |
| C-024 | ExportInterfaces()で全インターフェースエクスポート | E-02 L94-97: `t => true` フィルタ | ○ |
| C-025 | ExportInterfaces(Predicate)でフィルタ付き | E-02 L89-107: interfaceFilter使用 | ○ |
| C-026 | ExportInterfaces(Predicate)でnullはException | E-02 L102: `ArgumentNullException.ThrowIfNull(interfaceFilter)` | ○ |
| C-027 | ExportInterfaces(Predicate, Action)で複合設定 | E-02 L99-107: filter + exportConfiguration | ○ |
| C-028 | ExportPropertiesでフィルタ付きエクスポート | E-02 L110-125: propertyFilter使用 | ○ |
| C-029 | ExportProperties(Predicate)でnullはException | E-02 L112, L120: `ArgumentNullException.ThrowIfNull` | ○ |
| C-030 | ExportProperties(Predicate, Action)で複合設定 | E-02 L117-125: filter + exportConfiguration | ○ |
| C-031 | ExportProperties<T>で型指定 | E-02 L128-143: typeof(T)をコントラクト型に | ○ |
| C-032 | ImportPropertiesでフィルタ付きインポート | E-02 L146-160: propertyFilter使用 | ○ |
| C-033 | ImportProperties(Predicate)でnullはException | E-02 L148, L156: `ArgumentNullException.ThrowIfNull` | ○ |
| C-034 | ImportProperties(Predicate, Action)で複合設定 | E-02 L153-160: filter + importConfiguration | ○ |
| C-035 | ImportProperties<T>で型指定 | E-02 L163-177: typeof(T)をコントラクト型に | ○ |
| C-036 | SetCreationPolicyで設定 | E-02 L179-184: _creationPolicy設定 | ○ |
| C-037 | CreationPolicy.NonShared設定 | E-02 L179-184: CreationPolicy enum | ○ |
| C-038 | CreationPolicy.Any設定 | E-02 L179-184: CreationPolicy enum | ○ |
| C-039 | AddMetadata(string, object)で静的メタデータ | E-02 L186-192: _metadataItems追加 | ○ |
| C-040 | AddMetadata(string, Func)で動的メタデータ | E-02 L194-200: _metadataItemFuncs追加 | ○ |
| C-041 | 既存ExportAttributeでオーバーライド防止 | E-02 L229-240: isConfiguredチェック | ○ |
| C-042 | 既存PartCreationPolicyでオーバーライド防止 | E-02 L243-257: isConfiguredチェック | ○ |
| C-043 | 既存ImportingConstructorでオーバーライド防止 | E-02 L340-349: attributes.Length != 0 チェック | ○ |
| C-044 | 最長コンストラクタ選択 | E-02 L511-551: FindLongestConstructors | ○ |
| C-045 | 同パラメータ数で複数選択 | E-02 L534-544: constructorsFound > 1 の処理 | ○ |
| C-046 | パラメータなしで選択なし | E-02 L520: `length != 0` 条件 | ○ |
| C-047 | 複数インポート規約で警告 | E-02 L460-463: importsBuilt > 1 で警告 | ○ |

### PartBuilder<T> クラス (UT-CCR-048 〜 UT-CCR-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-048 | SelectConstructor(Expression)で式木選択 | E-03 L148-156: ConstructorExpressionAdapter | ○ |
| C-049 | SelectConstructor(Expression)でnullはException | E-03 L150: `ArgumentNullException.ThrowIfNull` | ○ |
| C-050 | New式以外でArgumentException | E-03 L99-102: `ExpressionType.New`チェック | ○ |
| C-051 | ExportProperty(Expression)で式木エクスポート | E-03 L159-174: PropertyExpressionAdapter | ○ |
| C-052 | ExportProperty(Expression)でnullはException | E-03 L168: `ArgumentNullException.ThrowIfNull` | ○ |
| C-053 | プロパティ以外でArgumentException | E-03 L47-57: MemberTypes.Property チェック | ○ |
| C-054 | ExportProperty(Expression, Action)で複合設定 | E-03 L164-174: exportConfiguration | ○ |
| C-055 | ExportProperty<TContract>で型指定 | E-03 L176-190: ExportProperties<TContract> | ○ |
| C-056 | ImportProperty(Expression)で式木インポート | E-03 L192-206: PropertyExpressionAdapter | ○ |
| C-057 | ImportProperty(Expression)でnullはException | E-03 L200: `ArgumentNullException.ThrowIfNull` | ○ |
| C-058 | ImportProperty(Expression, Action)で複合設定 | E-03 L197-206: importConfiguration | ○ |
| C-059 | ImportProperty<TContract>で型指定 | E-03 L208-222: ImportProperties<TContract> | ○ |

### ExportBuilder クラス (UT-CCR-060 〜 UT-CCR-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-060 | AsContractType<T>でジェネリック型設定 | E-04 L18-21: AsContractType(typeof(T)) | ○ |
| C-061 | AsContractType(Type)で型設定 | E-04 L23-27: _contractType = type | ○ |
| C-062 | AsContractNameでコントラクト名設定 | E-04 L29-33: _contractName = contractName | ○ |
| C-063 | Inherited()で継承エクスポート | E-04 L35-39, L61-64: InheritedExportAttribute | ○ |
| C-064 | AddMetadata(string, object)で静的メタデータ | E-04 L41-47: _metadataItems追加 | ○ |
| C-065 | AddMetadata(string, Func)で動的メタデータ | E-04 L49-55: _metadataItemFuncs追加 | ○ |
| C-066 | itemFuncがnullでメタデータ値null | E-04 L87: `item.Item2 != null ? item.Item2(type) : null` | ○ |
| C-067 | 複数メタデータが正しく生成 | E-04 L73-89: foreachでメタデータ追加 | ○ |
| C-068 | コントラクト名と型の両方設定 | E-04 L69: `ExportAttribute(_contractName, _contractType)` | ○ |

### ImportBuilder クラス (UT-CCR-069 〜 UT-CCR-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-069 | AsContractType<T>でジェネリック型設定 | E-05 L23-26: AsContractType(typeof(T)) | ○ |
| C-070 | AsContractType(Type)で型設定 | E-05 L28-32: _contractType = type | ○ |
| C-071 | AsContractNameでコントラクト名設定 | E-05 L34-38: _contractName = contractName | ○ |
| C-072 | AsMany(true)でImportMany | E-05 L40-45, L88-94: ImportManyAttribute | ○ |
| C-073 | AsMany(false)でImport | E-05 L77-85: ImportAttribute | ○ |
| C-074 | AllowDefault()で設定 | E-05 L47-51: _allowDefault = true | ○ |
| C-075 | AllowRecomposition()で設定 | E-05 L53-57: _allowRecomposition = true | ○ |
| C-076 | RequiredCreationPolicyで設定 | E-05 L59-63: _requiredCreationPolicy設定 | ○ |
| C-077 | Source()でImportSource設定 | E-05 L65-69: _source = source | ○ |
| C-078 | IEnumerableで自動ImportMany | E-05 L76: `typeof(IEnumerable).IsAssignableFrom(type)` | ○ |
| C-079 | stringはImport | E-05 L76: `type != s_stringType` 条件 | ○ |
| C-080 | 全プロパティ設定 | E-05 L79-85: ImportAttributeの全プロパティ | ○ |

### ParameterImportBuilder クラス (UT-CCR-081 〜 UT-CCR-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-081 | Import<T>()でデフォルト値 | E-06 L9-12: `return default` | ○ |
| C-082 | 参照型でnull | E-06 L11: `return default` (参照型はnull) | ○ |
| C-083 | Import<T>(Action)でデフォルト値 | E-06 L14-17: `return default` | ○ |

### スレッド同期クラス (UT-CCR-084 〜 UT-CCR-093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-084 | ReadWriteLock読み取りロック | E-07 L11-14: EnterReadLock/ExitReadLock | ○ |
| C-085 | ReadWriteLock書き込みロック | E-07 L16-22: EnterWriteLock/ExitWriteLock | ○ |
| C-086 | ReadWriteLock.Disposeで解放 | E-07 L31-37: _thisLock.Dispose() | ○ |
| C-087 | ReadWriteLock複数回Dispose | E-07 L33: Interlocked.CompareExchange | ○ |
| C-088 | ReadLock構築で読み取りロック | E-08 L11-16: _lock.EnterReadLock() | ○ |
| C-089 | ReadLock.Disposeで解放 | E-08 L18-24: _lock.ExitReadLock() | ○ |
| C-090 | ReadLock複数回Dispose | E-08 L20: Interlocked.CompareExchange | ○ |
| C-091 | WriteLock構築で書き込みロック | E-09 L11-16: _lock.EnterWriteLock() | ○ |
| C-092 | WriteLock.Disposeで解放 | E-09 L18-24: _lock.ExitWriteLock() | ○ |
| C-093 | WriteLock複数回Dispose | E-09 L20: Interlocked.CompareExchange | ○ |

### 複合シナリオ (UT-CCR-094 〜 UT-CCR-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-094 | 複数規約が同じ型に適用 | E-01 L97: _conventions.Where(c => c.SelectType(...)) | △ |
| C-095 | PartBuilderメソッドチェーン | E-02: 全メソッドが`return this` | ○ |
| C-096 | PartBuilder<T>メソッドチェーン | E-03: 全メソッドが`return this` | ○ |
| C-097 | ExportBuilderメソッドチェーン | E-04: 全メソッドが`return this` | ○ |
| C-098 | ImportBuilderメソッドチェーン | E-05: 全メソッドが`return this` | ○ |
| C-099 | マッチしない型で空属性 | E-01 L97: Where条件でフィルタ | ○ |
| C-100 | プロパティなしでも例外なし | E-02 L419: foreach (PropertyInfo pi in type.GetProperties()) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-016（スレッドセーフティ）**：ReadWriteLockを使用したスレッドセーフ実装は確認できるが、実際の並行テストシナリオの詳細設計が必要
  - 候補：並行テストフレームワークの選定 / 競合状態の具体的なテストケース / デッドロック検出メカニズム
- **C-094（複数規約適用）**：複数のPartBuilderが同じ型にマッチした場合の属性マージロジックの詳細確認が必要
  - 候補：属性の優先順位 / 重複属性の処理 / 競合解決メカニズム

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - UT-CCR-081〜083（ParameterImportBuilder）：単純なデフォルト値返却のみ
- **0: 低リスク** - UT-CCR-087, 090, 093（冪等Dispose）：Interlocked.CompareExchangeで保護済み
- **1: 中リスク** - UT-CCR-041〜043（属性オーバーライド防止）：既存属性との競合処理
- **1: 中リスク** - UT-CCR-044〜046（コンストラクタ選択）：複数コンストラクタの選択ロジック
- **2: 高リスク** - UT-CCR-016（スレッドセーフティ）：並行アクセス時の正確性
- **2: 高リスク** - UT-CCR-094（複数規約適用）：複合シナリオでの動作確認

## 6) レビュアーチェックリスト（最小）
- [ ] スレッドセーフティテスト（UT-CCR-016）の並行テスト実装方針は適切か
- [ ] 複数規約適用（UT-CCR-094）の属性マージ動作は期待通りか
- [ ] null検証テスト（UT-CCR-004, 007, 009, 011, 026, 029, 033, 049, 052, 057）のArgumentNullException検証は網羅的か
- [ ] 式木検証テスト（UT-CCR-050, 053）のArgumentException条件は正確か
- [ ] IEnumerable自動検出（UT-CCR-078）とstring例外（UT-CCR-079）の境界条件は正しいか
- [ ] 冪等Dispose（UT-CCR-087, 090, 093）のInterlocked処理は安全か
