---
generated_at: 2026-01-30 14:30:00
metrics:
  claims_total: 166
  claims_with_evidence: 166
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.ComponentModel.Composition.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：166 / 166、根拠なし：0
- 優先レビュー（高）
  1. **CompositionContainer関連テスト（UT-CMP-001〜018）**：コア機能のテストケース
  2. **ExportProvider関連テスト（UT-CMP-019〜026）**：エクスポート検索のテストケース
  3. **ImportEngine関連テスト（UT-CMP-123〜133）**：インポート処理のテストケース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/CompositionContainer.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/ExportProvider.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/ComposablePart.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/ComposablePartCatalog.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/ExportDefinition.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/ImportDefinition.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/TypeCatalog.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/AggregateCatalog.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/AssemblyCatalog.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/CompositionException.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/CompositionBatch.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/AttributedModelServices.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/ImportEngine.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/ReflectionModel/ReflectionModelServices.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/ExportAttribute.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/ImportAttribute.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/ContractBasedImportDefinition.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/Export.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CompositionContainer (UT-CMP-001〜018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CompositionContainerのデフォルトコンストラクタ | E-01 line 35-38 | ○ |
| C-02 | カタログ指定コンストラクタ | E-01 line 93-96 | ○ |
| C-03 | ExportProvider指定コンストラクタ | E-01 line 53-56 | ○ |
| C-04 | providers配列のnull要素検証 | E-01 line 178-181 | ○ |
| C-05 | 無効なCompositionOptionsの検証 | E-01 line 139-142 | ○ |
| C-06 | Catalogプロパティの取得 | E-01 line 250-258 | ○ |
| C-07 | Dispose後のObjectDisposedException | E-01 line 602-607 | ○ |
| C-08 | Providersプロパティの取得 | E-01 line 282-291 | ○ |
| C-09 | Disposeメソッドの実装 | E-01 line 296-366 | ○ |
| C-10 | Composeメソッドの正常系 | E-01 line 368-374 | ○ |
| C-11 | Composeのnull検証 | E-01 line 370 (Requires.NotNull) | ○ |
| C-12 | ReleaseExportの正常系 | E-01 line 395-403 | ○ |
| C-13 | ReleaseExportのnull検証 | E-01 line 397 (Requires.NotNull) | ○ |
| C-14 | ReleaseExportsの正常系 | E-01 line 445-453 | ○ |
| C-15 | ReleaseExportsのnull要素検証 | E-01 line 447 (Requires.NotNullOrNullElements) | ○ |
| C-16 | SatisfyImportsOnceの正常系 | E-01 line 514-534 | ○ |
| C-17 | GetExportsCoreのImportSource.Any | E-01 line 579-585 | ○ |
| C-18 | GetExportsCoreのImportSource.Local | E-01 line 586-591 | ○ |

### ExportProvider (UT-CMP-019〜026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | GetExportsの正常系 | E-02 line 63-116 | ○ |
| C-20 | GetExportsのnull検証 | E-02 line 99 (Requires.NotNull) | ○ |
| C-21 | ExactlyOne/0件でのException | E-02 line 107-108 | ○ |
| C-22 | ExactlyOne/2件以上でのException | E-02 line 110-114 | ○ |
| C-23 | TryGetExportsの正常系 | E-02 line 144-150 | ○ |
| C-24 | TryGetExportsのfalse返却 | E-02 line 149 | ○ |
| C-25 | OnExportsChangedイベント | E-02 line 182-190 | ○ |
| C-26 | OnExportsChangingイベント | E-02 line 198-206 | ○ |

### ComposablePart (UT-CMP-027〜034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | ExportDefinitionsプロパティ | E-03 line 47 | ○ |
| C-28 | ImportDefinitionsプロパティ | E-03 line 75 | ○ |
| C-29 | Metadataデフォルト値 | E-03 line 107-113 | ○ |
| C-30 | Activateメソッド | E-03 line 125-127 | ○ |
| C-31 | GetExportedValueの正常系 | E-03 line 157 | ○ |
| C-32 | GetExportedValueのnull検証 | E-03 line 140-142 (XMLコメント記載) | ○ |
| C-33 | SetImportの正常系 | E-03 line 206 | ○ |
| C-34 | SetImportのカーディナリティ検証 | E-03 line 187-195 (XMLコメント記載) | ○ |

### ComposablePartCatalog (UT-CMP-035〜040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Partsプロパティ | E-04 line 51-69 | ○ |
| C-36 | PartsのObjectDisposedException | E-04 line 56 (ThrowIfDisposed) | ○ |
| C-37 | GetExportsの正常系 | E-04 line 97-118 | ○ |
| C-38 | GetExportsのnull検証 | E-04 line 101 (Requires.NotNull) | ○ |
| C-39 | Disposeメソッド | E-04 line 128-137 | ○ |
| C-40 | GetEnumeratorの正常系 | E-04 line 158-166 | ○ |

### ExportDefinition (UT-CMP-041〜048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | protectedコンストラクタ | E-05 line 30-32 | ○ |
| C-42 | パラメータ付きコンストラクタ | E-05 line 54-64 | ○ |
| C-43 | contractNameのnull検証 | E-05 line 56 (Requires.NotNullOrEmpty) | ○ |
| C-44 | contractNameの空文字検証 | E-05 line 56 (Requires.NotNullOrEmpty) | ○ |
| C-45 | ContractNameプロパティ | E-05 line 82-93 | ○ |
| C-46 | Metadataプロパティ（設定あり） | E-05 line 115-123 | ○ |
| C-47 | Metadataプロパティ（デフォルト） | E-05 line 17 | ○ |
| C-48 | ToStringメソッド | E-05 line 131-134 | ○ |

### ImportDefinition (UT-CMP-049〜059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | パラメータ付きコンストラクタ | E-06 line 81-87 | ○ |
| C-50 | constraintのnull検証 | E-06 line 84 (Requires.NotNull) | ○ |
| C-51 | 無効なカーディナリティ検証 | E-06 line 99-106 | ○ |
| C-52 | ContractNameプロパティ | E-06 line 129-137 | ○ |
| C-53 | Cardinalityプロパティ | E-06 line 178-181 | ○ |
| C-54 | Constraintプロパティ | E-06 line 200-211 | ○ |
| C-55 | IsPrerequisiteプロパティ | E-06 line 222-225 | ○ |
| C-56 | IsRecomposableプロパティ | E-06 line 235-238 | ○ |
| C-57 | IsConstraintSatisfiedBy（true） | E-06 line 262-269 | ○ |
| C-58 | IsConstraintSatisfiedBy（false） | E-06 line 262-269 | ○ |
| C-59 | IsConstraintSatisfiedByのnull検証 | E-06 line 264 (Requires.NotNull) | ○ |

### TypeCatalog (UT-CMP-060〜068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | 型配列コンストラクタ | E-07 line 52-54 | ○ |
| C-61 | IEnumerable<Type>コンストラクタ | E-07 line 74-82 | ○ |
| C-62 | typesのnull検証 | E-07 line 76 (Requires.NotNull) | ○ |
| C-63 | typesのnull要素検証 | E-07 line 179-182 | ○ |
| C-64 | ReflectionContext付きコンストラクタ | E-07 line 130-139 | ○ |
| C-65 | GetEnumeratorの正常系 | E-07 line 223-227 | ○ |
| C-66 | GetEnumeratorのObjectDisposedException | E-07 line 225 (ThrowIfDisposed) | ○ |
| C-67 | GetCandidatePartsの正常系 | E-07 line 287-303 | ○ |
| C-68 | Disposeメソッド | E-07 line 347-355 | ○ |

### AggregateCatalog (UT-CMP-069〜077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | デフォルトコンストラクタ | E-08 line 27-29 | ○ |
| C-70 | カタログ配列コンストラクタ | E-08 line 46-48 | ○ |
| C-71 | catalogsのnull要素検証 | E-08 line 65 (Requires.NullOrNotNullElements) | ○ |
| C-72 | Catalogsプロパティ | E-08 line 165-174 | ○ |
| C-73 | CatalogsのObjectDisposedException | E-08 line 169 (ThrowIfDisposed) | ○ |
| C-74 | GetExportsの正常系 | E-08 line 119-153 | ○ |
| C-75 | Changedイベント | E-08 line 73-83 | ○ |
| C-76 | Changingイベント | E-08 line 88-98 | ○ |
| C-77 | Disposeメソッド | E-08 line 176-192 | ○ |

### AssemblyCatalog (UT-CMP-078〜087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | codeBaseコンストラクタ | E-09 line 73-79 | ○ |
| C-79 | codeBaseのnull検証 | E-09 line 75 (Requires.NotNullOrEmpty) | ○ |
| C-80 | codeBaseの空文字検証 | E-09 line 75 (Requires.NotNullOrEmpty) | ○ |
| C-81 | FileNotFoundException | E-09 line 545-571 (LoadAssembly) | ○ |
| C-82 | Assemblyコンストラクタ | E-09 line 350-356 | ○ |
| C-83 | assemblyのnull検証 | E-09 line 352 (Requires.NotNull) | ○ |
| C-84 | ReflectionOnlyアセンブリ検証 | E-09 line 392-395 | ○ |
| C-85 | Assemblyプロパティ | E-09 line 466-474 | ○ |
| C-86 | GetExportsの正常系 | E-09 line 425-428 | ○ |
| C-87 | Disposeメソッド | E-09 line 509-525 | ○ |

### CompositionException (UT-CMP-088〜095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | デフォルトコンストラクタ | E-10 line 29-32 | ○ |
| C-89 | メッセージ付きコンストラクタ | E-10 line 43-46 | ○ |
| C-90 | エラーコレクションコンストラクタ | E-10 line 86-89 | ○ |
| C-91 | errorsのnull要素検証 | E-10 line 94 (Requires.NullOrNotNullElements) | ○ |
| C-92 | Errorsプロパティ | E-10 line 106-109 | ○ |
| C-93 | Message（エラーなし） | E-10 line 119-131 | ○ |
| C-94 | Message（エラーあり） | E-10 line 119-131 | ○ |
| C-95 | RootCausesプロパティ | E-10 line 134-158 | ○ |

### CompositionBatch (UT-CMP-096〜106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | デフォルトコンストラクタ | E-11 line 25-28 | ○ |
| C-97 | パラメータ付きコンストラクタ | E-11 line 35-64 | ○ |
| C-98 | partsToAddのnull要素検証 | E-11 line 42-45 | ○ |
| C-99 | PartsToAddプロパティ | E-11 line 70-81 | ○ |
| C-100 | PartsToRemoveプロパティ | E-11 line 87-98 | ○ |
| C-101 | AddPartの正常系 | E-11 line 109-122 | ○ |
| C-102 | AddPartのnull検証 | E-11 line 111 (Requires.NotNull) | ○ |
| C-103 | RemovePartの正常系 | E-11 line 133-146 | ○ |
| C-104 | RemovePartのnull検証 | E-11 line 135 (Requires.NotNull) | ○ |
| C-105 | AddExportの正常系 | E-11 line 163-172 | ○ |
| C-106 | AddExportのnull検証 | E-11 line 165 (Requires.NotNull) | ○ |

### AttributedModelServices (UT-CMP-107〜122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | GetMetadataViewの正常系 | E-12 line 19-24 | ○ |
| C-108 | GetMetadataViewのnull検証 | E-12 line 21 (Requires.NotNull) | ○ |
| C-109 | CreatePartの正常系 | E-12 line 26-31 | ○ |
| C-110 | CreatePartのnull検証 | E-12 line 28 (Requires.NotNull) | ○ |
| C-111 | CreatePartDefinitionの正常系 | E-12 line 55-73 | ○ |
| C-112 | CreatePartDefinitionのnull検証 | E-12 line 57 (Requires.NotNull) | ○ |
| C-113 | GetTypeIdentity(Type)の正常系 | E-12 line 75-80 | ○ |
| C-114 | GetTypeIdentity(Type)のnull検証 | E-12 line 77 (Requires.NotNull) | ○ |
| C-115 | GetTypeIdentity(MethodInfo)の正常系 | E-12 line 82-87 | ○ |
| C-116 | GetContractNameの正常系 | E-12 line 89-94 | ○ |
| C-117 | AddExportedValue<T>の正常系 | E-12 line 96-103 | ○ |
| C-118 | ComposeExportedValue<T>の正常系 | E-12 line 105-112 | ○ |
| C-119 | ComposePartsの正常系 | E-12 line 148-158 | ○ |
| C-120 | SatisfyImportsOnceの正常系 | E-12 line 178-188 | ○ |
| C-121 | Exportsの正常系 | E-12 line 230-236 | ○ |
| C-122 | Importsの正常系 | E-12 line 261-267 | ○ |

### ImportEngine (UT-CMP-123〜133)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | コンストラクタの正常系 | E-13 line 37-55 | ○ |
| C-124 | sourceProviderのnull検証 | E-13 line 49 (Requires.NotNull) | ○ |
| C-125 | PreviewImportsの正常系 | E-13 line 83-134 | ○ |
| C-126 | PreviewImportsのObjectDisposedException | E-13 line 85 (ThrowIfDisposed) | ○ |
| C-127 | PreviewImportsの失敗 | E-13 line 116 | ○ |
| C-128 | SatisfyImportsの正常系 | E-13 line 156-174 | ○ |
| C-129 | SatisfyImportsのnull検証 | E-13 line 160 (Requires.NotNull) | ○ |
| C-130 | SatisfyImportsOnceの正常系 | E-13 line 193-211 | ○ |
| C-131 | ReleaseImportsの正常系 | E-13 line 227-241 | ○ |
| C-132 | Disposeメソッド | E-13 line 246-288 | ○ |
| C-133 | 最大反復回数チェック | E-13 line 20, 424-428 | ○ |

### ReflectionModelServices (UT-CMP-134〜145)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-134 | GetPartTypeの正常系 | E-14 line 17-28 | ○ |
| C-135 | GetPartTypeのnull検証 | E-14 line 19 (Requires.NotNull) | ○ |
| C-136 | GetPartTypeの非リフレクション型検証 | E-14 line 22-25 | ○ |
| C-137 | IsDisposalRequiredの正常系 | E-14 line 30-41 | ○ |
| C-138 | GetExportingMemberの正常系 | E-14 line 43-56 | ○ |
| C-139 | GetImportingMemberの正常系 | E-14 line 58-71 | ○ |
| C-140 | GetImportingParameterの正常系 | E-14 line 73-87 | ○ |
| C-141 | IsImportingParameterの正常系 | E-14 line 89-102 | ○ |
| C-142 | CreatePartDefinitionの正常系 | E-14 line 126-144 | ○ |
| C-143 | CreateExportDefinitionの正常系 | E-14 line 146-159 | ○ |
| C-144 | CreateImportDefinitionの正常系 | E-14 line 161-245 | ○ |
| C-145 | TryMakeGenericPartDefinitionの正常系 | E-14 line 302-314 | ○ |

### Attributes (UT-CMP-146〜157)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146 | ExportAttribute() | E-15 line 30-33 | ○ |
| C-147 | ExportAttribute(Type) | E-15 line 61-64 | ○ |
| C-148 | ExportAttribute(string) | E-15 line 86-89 | ○ |
| C-149 | ExportAttribute(string, Type) | E-15 line 116-120 | ○ |
| C-150 | ImportAttribute() | E-16 line 31-34 | ○ |
| C-151 | ImportAttribute(Type) | E-16 line 60-63 | ○ |
| C-152 | ImportAttribute(string) | E-16 line 84-87 | ○ |
| C-153 | AllowDefault=true時のCardinality | E-16 line 182-191 | ○ |
| C-154 | AllowDefault=false時のCardinality | E-16 line 182-191 | ○ |
| C-155 | AllowRecompositionプロパティ | E-16 line 148 | ○ |
| C-156 | RequiredCreationPolicyプロパティ | E-16 line 164 | ○ |
| C-157 | Sourceプロパティ | E-16 line 180 | ○ |

### Primitives (UT-CMP-158〜166)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-158 | ContractBasedImportDefinitionコンストラクタ | E-17 | ○ |
| C-159 | RequiredTypeIdentityプロパティ | E-17 | ○ |
| C-160 | RequiredMetadataプロパティ | E-17 | ○ |
| C-161 | RequiredCreationPolicyプロパティ | E-17 | ○ |
| C-162 | Export(string, Func)コンストラクタ | E-18 | ○ |
| C-163 | Export(ExportDefinition, Func)コンストラクタ | E-18 | ○ |
| C-164 | Valueプロパティ | E-18 | ○ |
| C-165 | Definitionプロパティ | E-18 | ○ |
| C-166 | Metadataプロパティ | E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません
- すべてのテストケースはソースコードの実装に基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードから根拠を持っています
- テストの実装時に考慮すべき点:
  - スレッドセーフ性のテスト（CompositionOptions.IsThreadSafe）
  - Dispose後の状態管理テスト
  - 循環参照のテスト（ImportEngine.MaximumNumberOfCompositionIterations）

## 6) レビュアーチェックリスト（最小）
- [ ] CompositionContainerのコンストラクタバリエーションが網羅されているか
- [ ] ExportProvider.GetExportsのカーディナリティ検証が適切か
- [ ] ImportEngineの状態遷移テストが十分か
- [ ] 各カタログ（TypeCatalog, AggregateCatalog, AssemblyCatalog）のDispose処理が検証されているか
- [ ] 属性（ExportAttribute, ImportAttribute）のすべてのプロパティが検証されているか
- [ ] null引数に対する検証が漏れなく含まれているか
