---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 78
  claims_with_evidence: 78
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.ComponentModel.EventBasedAsync 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：78 / 78、根拠なし：0
- 優先レビュー（高）
  1. なし（全てのテストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.ComponentModel.EventBasedAsync/src/System/ComponentModel/BackgroundWorker.cs`
- E-02: `src/libraries/System.ComponentModel.EventBasedAsync/src/System/ComponentModel/AsyncOperation.cs`
- E-03: `src/libraries/System.ComponentModel.EventBasedAsync/src/System/ComponentModel/AsyncOperationManager.cs`
- E-04: `src/libraries/System.ComponentModel.EventBasedAsync/src/System/ComponentModel/AsyncCompletedEvent.cs`
- E-05: `src/libraries/System.ComponentModel.EventBasedAsync/src/System/ComponentModel/RunWorkerCompletedEvent.cs`
- E-06: `src/libraries/System.ComponentModel.EventBasedAsync/src/System/ComponentModel/ProgressChangedEvent.cs`
- E-07: `src/libraries/System.ComponentModel.EventBasedAsync/src/System/ComponentModel/DoWorkEvent.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### BackgroundWorker クラス（UT-EVB-001 〜 UT-EVB-030）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタで_operationCompleted, _progressReporterが初期化される | E-01 (行22-26) | ○ |
| C-02 | IsBusyは_isRunningフィールドの値を返す | E-01 (行55-61) | ○ |
| C-03 | CancellationPendingは_cancellationPendingフィールドの値を返す | E-01 (行35-41) | ○ |
| C-04 | WorkerReportsProgressはget/set可能 | E-01 (行139-150) | ○ |
| C-05 | WorkerSupportsCancellationはget/set可能 | E-01 (行152-163) | ○ |
| C-06 | RunWorkerAsync()はRunWorkerAsync(null)を呼び出す | E-01 (行112-115) | ○ |
| C-07 | RunWorkerAsync(object)は_isRunning=trueの場合InvalidOperationExceptionをスロー | E-01 (行117-122) | ○ |
| C-08 | RunWorkerAsync(object)はAsyncOperationを作成しTask.Factory.StartNewを呼ぶ | E-01 (行124-135) | ○ |
| C-09 | CancelAsync()はWorkerSupportsCancellation=falseの場合InvalidOperationExceptionをスロー | E-01 (行43-51) | ○ |
| C-10 | CancelAsync()は_cancellationPending=trueを設定 | E-01 (行50) | ○ |
| C-11 | ReportProgress(int)はReportProgress(int, null)を呼び出す | E-01 (行87-90) | ○ |
| C-12 | ReportProgress(int, object)はWorkerReportsProgress=falseの場合InvalidOperationExceptionをスロー | E-01 (行93-98) | ○ |
| C-13 | ReportProgress(int, object)はProgressChangedEventArgsを作成しポストする | E-01 (行100-109) | ○ |
| C-14 | OnDoWork(DoWorkEventArgs)はDoWorkイベントを発火 | E-01 (行63-66) | ○ |
| C-15 | OnRunWorkerCompleted(RunWorkerCompletedEventArgs)はRunWorkerCompletedイベントを発火 | E-01 (行68-71) | ○ |
| C-16 | OnProgressChanged(ProgressChangedEventArgs)はProgressChangedイベントを発火 | E-01 (行73-76) | ○ |
| C-17 | WorkerThreadStartは例外をキャッチしRunWorkerCompletedEventArgsに設定 | E-01 (行165-193) | ○ |
| C-18 | WorkerThreadStartはdoWorkArgs.Cancel=trueの場合cancelled=trueを設定 | E-01 (行177-180) | ○ |
| C-19 | Dispose(bool)は空の実装 | E-01 (行195-197) | ○ |

### AsyncOperation クラス（UT-EVB-031 〜 UT-EVB-044）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | コンストラクタでUserSuppliedState, _syncContext, _alreadyCompletedを初期化 | E-02 (行17-23) | ○ |
| C-21 | UserSuppliedStateはget専用プロパティ | E-02 (行36) | ○ |
| C-22 | SynchronizationContextは_syncContextを返す | E-02 (行38-44) | ○ |
| C-23 | Post(SendOrPostCallback, object)はPostCore(d, arg, markCompleted: false)を呼ぶ | E-02 (行46-49) | ○ |
| C-24 | PostOperationCompleted(SendOrPostCallback, object)はPostCore(d, arg, markCompleted: true)とOperationCompletedCore()を呼ぶ | E-02 (行51-55) | ○ |
| C-25 | OperationCompleted()はVerifyNotCompleted後_alreadyCompleted=trueを設定しOperationCompletedCore()を呼ぶ | E-02 (行57-62) | ○ |
| C-26 | PostCoreはd=nullの場合ArgumentNullExceptionをスロー | E-02 (行67) | ○ |
| C-27 | PostCoreはVerifyNotCompleted()を呼ぶ | E-02 (行66) | ○ |
| C-28 | PostCoreはmarkCompleted=trueの場合_alreadyCompleted=trueを設定 | E-02 (行68-75) | ○ |
| C-29 | OperationCompletedCoreは_syncContext.OperationCompleted()を呼びGC.SuppressFinalize(this)を呼ぶ | E-02 (行79-89) | ○ |
| C-30 | VerifyNotCompletedは_alreadyCompleted=trueの場合InvalidOperationExceptionをスロー | E-02 (行91-97) | ○ |
| C-31 | ファイナライザは_alreadyCompleted=falseかつ_syncContext!=nullの場合_syncContext.OperationCompleted()を呼ぶ | E-02 (行28-34) | ○ |
| C-32 | CreateOperation(object, SynchronizationContext)は新しいAsyncOperationを返す | E-02 (行102-106) | ○ |

### AsyncOperationManager クラス（UT-EVB-045 〜 UT-EVB-050）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | CreateOperation(object)はAsyncOperation.CreateOperationを呼ぶ | E-03 (行12-15) | ○ |
| C-34 | SynchronizationContext getterはSynchronizationContext.Current=nullの場合新しいSynchronizationContextを設定して返す | E-03 (行20-28) | ○ |
| C-35 | SynchronizationContext setterはSynchronizationContext.SetSynchronizationContext(value)を呼ぶ | E-03 (行31-34) | ○ |

### AsyncCompletedEventArgs クラス（UT-EVB-051 〜 UT-EVB-059）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | コンストラクタでCancelled, Error, UserStateを初期化 | E-04 (行12-17) | ○ |
| C-37 | Cancelledはget専用プロパティ | E-04 (行31) | ○ |
| C-38 | Errorはget専用プロパティ | E-04 (行32) | ○ |
| C-39 | UserStateはget専用プロパティ | E-04 (行33) | ○ |
| C-40 | RaiseExceptionIfNecessary()はError!=nullの場合TargetInvocationExceptionをスロー | E-04 (行19-24) | ○ |
| C-41 | RaiseExceptionIfNecessary()はCancelled=trueの場合InvalidOperationExceptionをスロー | E-04 (行25-28) | ○ |

### RunWorkerCompletedEventArgs クラス（UT-EVB-060 〜 UT-EVB-065）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | コンストラクタで_resultを設定し基底クラスを初期化 | E-05 (行12-18) | ○ |
| C-43 | Result getterはRaiseExceptionIfNecessary()を呼んでから_resultを返す | E-05 (行20-27) | ○ |
| C-44 | UserStateはnew修飾子でbase.UserStateを返す | E-05 (行30-37) | ○ |

### ProgressChangedEventArgs クラス（UT-EVB-066 〜 UT-EVB-071）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | コンストラクタで_progressPercentage, _userStateを設定 | E-06 (行13-17) | ○ |
| C-46 | ProgressPercentageは_progressPercentageを返す | E-06 (行19-25) | ○ |
| C-47 | UserStateは_userStateを返す | E-06 (行27-33) | ○ |

### DoWorkEventArgs クラス（UT-EVB-072 〜 UT-EVB-078）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | コンストラクタでArgumentを設定 | E-07 (行10-13) | ○ |
| C-49 | Argumentはget専用プロパティ | E-07 (行15) | ○ |
| C-50 | Resultはget/set可能プロパティ | E-07 (行17) | ○ |
| C-51 | DoWorkEventArgsはCancelEventArgsを継承しているためCancelプロパティを持つ | E-07 (行8) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースはソースコードから直接導出）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに直接対応

### 補足
- イベントベース非同期パターン（EAP）の標準的な実装
- スレッドセーフティに関するテストは統合テストレベルで別途検討が必要
- ファイナライザのテスト（UT-EVB-042, UT-EVB-043）はGCの動作に依存するため、実装上の工夫が必要

## 6) レビュアーチェックリスト（最小）
- [ ] BackgroundWorkerの状態遷移（IsBusy, CancellationPending）のテストケースが適切か確認
- [ ] 例外がスローされるケース（InvalidOperationException, ArgumentNullException）の条件が正しいか確認
- [ ] AsyncOperationの完了状態管理（_alreadyCompleted）のテストが網羅的か確認
- [ ] RaiseExceptionIfNecessary()の例外種別（TargetInvocationException vs InvalidOperationException）が正しいか確認
- [ ] 境界値テスト（進捗0%, 100%, 負値）の妥当性を確認
