---
generated_at: 2026-01-30 14:30:00
metrics:
  claims_total: 175
  claims_with_evidence: 175
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.ComponentModel.Primitives 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：モジュール内の全クラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：175 / 175、根拠なし：0
- 優先レビュー（高）
  1. **Disposeパターンのテスト（UT-SCP-006〜010）**：リソース解放の正確性が重要
  2. **EventHandlerListのイベント抑制（UT-SCP-025）**：CanRaiseEventsとの連携
  3. **InvalidEnumArgumentExceptionのnull検証（UT-SCP-164）**：例外処理の正確性

## 2) 参照した情報（Evidence一覧）
> ソースコードファイルを根拠として列挙

- E-01: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/Component.cs`
- E-02: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/EventHandlerList.cs`
- E-03: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ComponentCollection.cs`
- E-04: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/BrowsableAttribute.cs`
- E-05: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/CategoryAttribute.cs`
- E-06: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DescriptionAttribute.cs`
- E-07: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DisplayNameAttribute.cs`
- E-08: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/EditorAttribute.cs`
- E-09: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DesignerAttribute.cs`
- E-10: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DesignerCategoryAttribute.cs`
- E-11: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DesignerSerializationVisibilityAttribute.cs`
- E-12: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DesignOnlyAttribute.cs`
- E-13: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ImmutableObjectAttribute.cs`
- E-14: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/InitializationEventAttribute.cs`
- E-15: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/LocalizableAttribute.cs`
- E-16: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/MergablePropertyAttribute.cs`
- E-17: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/NotifyParentPropertyAttribute.cs`
- E-18: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ParenthesizePropertyNameAttribute.cs`
- E-19: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ReadOnlyAttribute.cs`
- E-20: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/RefreshPropertiesAttribute.cs`
- E-21: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/InvalidAsynchronousStateException.cs`
- E-22: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/InvalidEnumArgumentException.cs`
- E-23: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/Design/Serialization/DesignerSerializerAttribute.cs`
- E-24: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/IComponent.cs`
- E-25: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/IContainer.cs`
- E-26: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ISite.cs`
- E-27: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ISupportInitialize.cs`
- E-28: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ISynchronizeInvoke.cs`
- E-29: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DesignerSerializationVisibility.cs`
- E-30: `src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/RefreshProperties.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Componentクラス（UT-SCP-001〜020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CanRaiseEventsがデフォルトでtrueを返す | E-01 (L33: `protected virtual bool CanRaiseEvents => true;`) | ○ |
| C-02 | Eventsプロパティが遅延初期化される | E-01 (L55: `_events ??= new EventHandlerList(this)`) | ○ |
| C-03 | Siteプロパティの設定/取得 | E-01 (L62-66: Site get/set) | ○ |
| C-04 | Dispose()がGC.SuppressFinalizeを呼ぶ | E-01 (L71-75: Dispose実装) | ○ |
| C-05 | Dispose(true)でDisposedイベント発火 | E-01 (L80-93: Dispose(bool)実装) | ○ |
| C-06 | ContainerがSite経由で取得される | E-01 (L101: `_site?.Container`) | ○ |
| C-07 | GetServiceがSite経由で取得 | E-01 (L107: `_site?.GetService(service)`) | ○ |
| C-08 | DesignModeがSite経由で取得 | E-01 (L115: `_site?.DesignMode ?? false`) | ○ |
| C-09 | ToStringの実装 | E-01 (L122-131: ToString実装) | ○ |

### EventHandlerListクラス（UT-SCP-021〜033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | インデクサのget/set動作 | E-02 (L33-57: this[object]実装) | ○ |
| C-11 | CanRaiseEvents=falseでnull返却 | E-02 (L37-41: `if (_parent == null \|\| _parent.CanRaiseEventsInternal)`) | ○ |
| C-12 | AddHandlerでDelegate.Combine | E-02 (L59-70: AddHandler実装) | ○ |
| C-13 | AddHandlersでArgumentNullException | E-02 (L72-81: `ArgumentNullException.ThrowIfNull`) | ○ |
| C-14 | RemoveHandlerでDelegate.Remove | E-02 (L100-104: RemoveHandler実装) | ○ |
| C-15 | Disposeで_head=null | E-02 (L84: `_head = null`) | ○ |

### ComponentCollectionクラス（UT-SCP-034〜041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | 名前検索で大文字小文字無視 | E-03 (L25: `StringComparison.OrdinalIgnoreCase`) | ○ |
| C-17 | インデックスアクセス | E-03 (L39: `InnerList[index]`) | ○ |
| C-18 | CopyTo実装 | E-03 (L41: `InnerList.CopyTo`) | ○ |

### 属性クラス群（UT-SCP-042〜155）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | BrowsableAttribute.Yes/No/Default | E-04 (L19-32: 静的フィールド定義) | ○ |
| C-20 | CategoryAttributeのローカライズ | E-05 (L145-169: GetLocalizedString実装) | ○ |
| C-21 | CategoryAttribute静的プロパティ | E-05 (L27-92: Action〜WindowStyle) | ○ |
| C-22 | DescriptionAttribute.Default | E-06 (L18: `Default = new DescriptionAttribute()`) | ○ |
| C-23 | DisplayNameAttribute.Default | E-07 (L19: `Default = new DisplayNameAttribute()`) | ○ |
| C-24 | EditorAttributeのTypeId実装 | E-08 (L79-95: TypeId実装) | ○ |
| C-25 | EditorAttributeのnull検証 | E-08 (L32, L43-44: `ArgumentNullException.ThrowIfNull`) | ○ |
| C-26 | DesignerAttributeのTypeId実装 | E-09 (L96-112: TypeId実装) | ○ |
| C-27 | DesignerAttributeのnull検証 | E-09 (L22, L34, L46, L58, L71-72: null検証) | ○ |
| C-28 | DesignerCategoryAttribute静的フィールド | E-10 (L18-36: Component/Default/Form/Generic) | ○ |
| C-29 | DesignerSerializationVisibilityAttribute | E-11 (L20-40: Content/Hidden/Visible/Default) | ○ |
| C-30 | DesignOnlyAttribute.Yes/No/Default | E-12 (L18-31: 静的フィールド) | ○ |
| C-31 | ImmutableObjectAttribute.Yes/No/Default | E-13 (L20-34: 静的フィールド) | ○ |
| C-32 | InitializationEventAttribute.EventName | E-14 (L15-23: EventName実装) | ○ |
| C-33 | LocalizableAttribute.Yes/No/Default | E-15 (L31-44: 静的フィールド) | ○ |
| C-34 | MergablePropertyAttribute.Yes/No/Default | E-16 (L20-35: 静的フィールド) | ○ |
| C-35 | NotifyParentPropertyAttribute.Yes/No/Default | E-17 (L19-32: 静的フィールド) | ○ |
| C-36 | ParenthesizePropertyNameAttribute.Default | E-18 (L19: `Default = new ParenthesizePropertyNameAttribute()`) | ○ |
| C-37 | ReadOnlyAttribute.Yes/No/Default | E-19 (L20-34: 静的フィールド) | ○ |
| C-38 | RefreshPropertiesAttribute.All/Repaint/Default | E-20 (L18-30: 静的フィールド) | ○ |

### 例外クラス（UT-SCP-156〜165）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | InvalidAsynchronousStateExceptionの継承 | E-21 (L16: `class InvalidAsynchronousStateException : ArgumentException`) | ○ |
| C-40 | InvalidEnumArgumentExceptionの継承 | E-22 (L15: `class InvalidEnumArgumentException : ArgumentException`) | ○ |
| C-41 | InvalidEnumArgumentException(string,int,Type)のnull検証 | E-22 (L53: `ArgumentNullException.ThrowIfNull(enumClass)`) | ○ |

### DesignerSerializerAttribute（UT-SCP-166〜175）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | コンストラクタのnull検証 | E-23 (L21-22, L33: `ArgumentNullException.ThrowIfNull`) | ○ |
| C-43 | TypeIdの実装 | E-23 (L65-81: TypeId実装) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
- 全てのテストケースはソースコードの実装に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードから直接導出されており、根拠が明確

注意点：
- インターフェース（IComponent, IContainer, ISite, ISupportInitialize, ISynchronizeInvoke）はインターフェース定義のみであり、実装テストは実装クラスで行う必要がある
- 列挙型（DesignerSerializationVisibility, RefreshProperties）は値の定義のみであり、単体テストの対象外

## 6) レビュアーチェックリスト（最小）
- [ ] Component.Dispose()でContainerからの削除が正しく行われるか確認
- [ ] EventHandlerListのCanRaiseEvents連携が正しく動作するか確認
- [ ] CategoryAttributeのローカライズが全カテゴリで正しく動作するか確認
- [ ] 各属性クラスのEquals/GetHashCode/IsDefaultAttributeの整合性確認
- [ ] 例外クラスのメッセージフォーマットが適切か確認
- [ ] ArgumentNullExceptionがスローされる全ケースで正しい引数名が使用されているか確認
