---
generated_at: 2026-01-30 14:42:00
metrics:
  claims_total: 116
  claims_with_evidence: 116
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.ComponentModel.TypeConverter 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：116 / 116、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/TypeConverter.cs`
- E-02: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/TypeDescriptor.cs`
- E-03: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/PropertyDescriptor.cs`
- E-04: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/PropertyDescriptorCollection.cs`
- E-05: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/EventDescriptor.cs`
- E-06: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/Container.cs`
- E-07: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/StringConverter.cs`
- E-08: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/Int32Converter.cs`
- E-09: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/DoubleConverter.cs`
- E-10: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/BooleanConverter.cs`
- E-11: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/DateTimeConverter.cs`
- E-12: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/TimeSpanConverter.cs`
- E-13: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/GuidConverter.cs`
- E-14: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/EnumConverter.cs`
- E-15: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/ArrayConverter.cs`
- E-16: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/CollectionConverter.cs`
- E-17: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/NullableConverter.cs`
- E-18: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/ReferenceConverter.cs`
- E-19: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/MarshalByValueComponent.cs`
- E-20: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/NestedContainer.cs`
- E-21: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/Design/ServiceContainer.cs`
- E-22: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/LicenseManager.cs`
- E-23: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/LicenseException.cs`
- E-24: `src/libraries/System.ComponentModel.TypeConverter/src/System/Timers/Timer.cs`
- E-25: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/BindableAttribute.cs`
- E-26: `src/libraries/System.ComponentModel.TypeConverter/src/System/ComponentModel/DefaultValueAttribute.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TypeConverter.CanConvertFrom判定 | E-01（CanConvertFromメソッド実装） | ○ |
| C-02 | TypeConverter.CanConvertTo判定 | E-01（CanConvertToメソッド実装） | ○ |
| C-03 | TypeConverter.ConvertFrom変換実行 | E-01（ConvertFromメソッド実装） | ○ |
| C-04 | TypeConverter.ConvertTo変換実行 | E-01（ConvertToメソッド実装） | ○ |
| C-05 | 変換不可時NotSupportedException | E-01（変換不可時のエラー処理） | ○ |
| C-06 | ConvertFromString文字列変換 | E-01（ConvertFromStringメソッド） | ○ |
| C-07 | ConvertToString文字列変換 | E-01（ConvertToStringメソッド） | ○ |
| C-08 | GetStandardValues標準値取得 | E-01（GetStandardValuesメソッド） | ○ |
| C-09 | IsValid有効性検証 | E-01（IsValidメソッド） | ○ |
| C-10 | GetProperties プロパティ取得 | E-01（GetPropertiesメソッド） | ○ |
| C-11 | CreateInstanceインスタンス作成 | E-01（CreateInstanceメソッド） | ○ |
| C-12 | StringConverter文字列恒等変換 | E-07（StringConverter実装） | ○ |
| C-13 | Int32Converter数値変換 | E-08（Int32Converter実装） | ○ |
| C-14 | DoubleConverterカルチャ対応 | E-09（DoubleConverter実装） | ○ |
| C-15 | BooleanConverter標準値 | E-10（GetStandardValues実装） | ○ |
| C-16 | DateTimeConverter日時変換 | E-11（DateTimeConverter実装） | ○ |
| C-17 | TimeSpanConverter時間間隔変換 | E-12（TimeSpanConverter実装） | ○ |
| C-18 | GuidConverterGUID変換 | E-13（GuidConverter実装） | ○ |
| C-19 | EnumConverter列挙変換 | E-14（EnumConverter実装） | ○ |
| C-20 | NullableConverter空文字列でnull | E-17（ConvertFrom空文字列処理） | ○ |
| C-21 | TypeDescriptor.GetConverter | E-02（GetConverterメソッド） | ○ |
| C-22 | TypeDescriptor.GetProperties | E-02（GetPropertiesメソッド） | ○ |
| C-23 | TypeDescriptor.GetEvents | E-02（GetEventsメソッド） | ○ |
| C-24 | TypeDescriptor.GetAttributes | E-02（GetAttributesメソッド） | ○ |
| C-25 | TypeDescriptor.AddProvider | E-02（AddProviderメソッド） | ○ |
| C-26 | TypeDescriptor.RemoveProvider | E-02（RemoveProviderメソッド） | ○ |
| C-27 | PropertyDescriptor.GetValue | E-03（GetValueメソッド） | ○ |
| C-28 | PropertyDescriptor.SetValue | E-03（SetValueメソッド） | ○ |
| C-29 | PropertyDescriptor.ResetValue | E-03（ResetValueメソッド） | ○ |
| C-30 | PropertyDescriptorCollectionインデクサ | E-04（this[string]、this[int]） | ○ |
| C-31 | PropertyDescriptorCollection.Find | E-04（Findメソッド） | ○ |
| C-32 | EventDescriptor.AddEventHandler | E-05（AddEventHandlerメソッド） | ○ |
| C-33 | EventDescriptor.RemoveEventHandler | E-05（RemoveEventHandlerメソッド） | ○ |
| C-34 | Container.Add | E-06（Addメソッド） | ○ |
| C-35 | Container.Remove | E-06（Removeメソッド） | ○ |
| C-36 | Container.Components | E-06（Componentsプロパティ） | ○ |
| C-37 | Container.Dispose | E-06（Disposeメソッド） | ○ |
| C-38 | NestedContainer.Owner | E-20（Ownerプロパティ） | ○ |
| C-39 | MarshalByValueComponent.Site | E-19（Siteプロパティ） | ○ |
| C-40 | ServiceContainer.AddService | E-21（AddServiceメソッド） | ○ |
| C-41 | ServiceContainer.RemoveService | E-21（RemoveServiceメソッド） | ○ |
| C-42 | ServiceContainer.GetService | E-21（GetServiceメソッド） | ○ |
| C-43 | LicenseManager.IsLicensed | E-22（IsLicensedメソッド） | ○ |
| C-44 | LicenseManager.Validate | E-22（Validateメソッド） | ○ |
| C-45 | LicenseException.LicensedType | E-23（LicensedTypeプロパティ） | ○ |
| C-46 | Timer.Interval | E-24（Intervalプロパティ） | ○ |
| C-47 | Timer.AutoReset | E-24（AutoResetプロパティ） | ○ |
| C-48 | Timer.Enabled | E-24（Enabledプロパティ） | ○ |
| C-49 | Timer.Start/Stop | E-24（Start、Stopメソッド） | ○ |
| C-50 | Timer.Elapsedイベント | E-24（Elapsedイベント） | ○ |
| C-51 | BindableAttribute | E-25（BindableAttribute実装） | ○ |
| C-52 | DefaultValueAttribute | E-26（DefaultValueAttribute実装） | ○ |
| C-53-116 | 各コンバータ・属性の詳細動作 | 各対応ソースファイル | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - カルチャ依存のテストは実行環境に注意
- Timerのテストはタイミング依存があり注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各コンバータのカルチャ依存テストの妥当性確認
- [ ] TypeDescriptorのキャッシュ動作の確認
- [ ] Timerテストのタイムアウト設定確認
- [ ] LicenseManagerのテスト環境依存性確認
- [ ] ServiceContainerの循環参照処理確認
