---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 78
  claims_with_evidence: 78
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.Composition.AttributedModel 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各クラスの検証状況を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：78 / 78、根拠なし：0
- 優先レビュー（高）
  1. **PartMetadataAttribute.コンストラクタ null チェック**：ArgumentNullExceptionの発生確認（テストコードで検証済み）
  2. **SharingBoundaryAttribute.コンストラクタ null チェック**：ArgumentNullExceptionの発生確認（テストコードで検証済み）
  3. **ExportMetadataAttribute.Name の null 変換**：null が空文字に変換される動作（ソースコードで確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Composition.AttributedModel/src/System/Composition/ExportAttribute.cs`
- E-02: `src/libraries/System.Composition.AttributedModel/src/System/Composition/ExportMetadataAttribute.cs`
- E-03: `src/libraries/System.Composition.AttributedModel/src/System/Composition/ImportAttribute.cs`
- E-04: `src/libraries/System.Composition.AttributedModel/src/System/Composition/ImportManyAttribute.cs`
- E-05: `src/libraries/System.Composition.AttributedModel/src/System/Composition/ImportingConstructorAttribute.cs`
- E-06: `src/libraries/System.Composition.AttributedModel/src/System/Composition/ImportMetadataConstraintAttribute.cs`
- E-07: `src/libraries/System.Composition.AttributedModel/src/System/Composition/MetadataAttributeAttribute.cs`
- E-08: `src/libraries/System.Composition.AttributedModel/src/System/Composition/OnImportsSatisfiedAttribute.cs`
- E-09: `src/libraries/System.Composition.AttributedModel/src/System/Composition/PartMetadataAttribute.cs`
- E-10: `src/libraries/System.Composition.AttributedModel/src/System/Composition/PartNotDiscoverableAttribute.cs`
- E-11: `src/libraries/System.Composition.AttributedModel/src/System/Composition/SharedAttribute.cs`
- E-12: `src/libraries/System.Composition.AttributedModel/src/System/Composition/SharingBoundaryAttribute.cs`
- E-13: `src/libraries/System.Composition.AttributedModel/src/System/Composition/Convention/AttributedModelProvider.cs`
- E-14: `src/libraries/System.Composition.AttributedModel/tests/ExportAttributeTests.cs`
- E-15: `src/libraries/System.Composition.AttributedModel/tests/ExportMetadataAttributeTests.cs`
- E-16: `src/libraries/System.Composition.AttributedModel/tests/ImportAttributeTests.cs`
- E-17: `src/libraries/System.Composition.AttributedModel/tests/ImportManyAttributeTests.cs`
- E-18: `src/libraries/System.Composition.AttributedModel/tests/ImportingConstructorAttributeTests.cs`
- E-19: `src/libraries/System.Composition.AttributedModel/tests/PartMetadataAttributeTests.cs`
- E-20: `src/libraries/System.Composition.AttributedModel/tests/SharedAttributeTests.cs`
- E-21: `src/libraries/System.Composition.AttributedModel/tests/SharingBoundaryAttributeTests.cs`
- E-22: `src/libraries/System.Composition.AttributedModel/tests/ImportMetadataConstraintAttributeTests.cs`
- E-23: `src/libraries/System.Composition.AttributedModel/tests/MetadataAttributeAttributeTests.cs`
- E-24: `src/libraries/System.Composition.AttributedModel/tests/PartNotDiscoverableAttributeTests.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ExportAttribute（UT-SCAM-001 〜 UT-SCAM-010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタでContractName/ContractTypeがnull | E-01 (line 19-21), E-14 (Ctor_Default) | ○ |
| C-02 | コンストラクタ(string)でContractNameが設定される | E-01 (line 46-48), E-14 (Ctor_ContractName) | ○ |
| C-03 | コンストラクタ(string)でnull許容 | E-01 (line 46-48), E-14 (InlineData(null)) | ○ |
| C-04 | コンストラクタ(string)で空文字許容 | E-01 (line 43-45 docコメント) | ○ |
| C-05 | コンストラクタ(Type)でContractTypeが設定される | E-01 (line 33-35), E-14 (Ctor_ContractType) | ○ |
| C-06 | コンストラクタ(Type)でnull許容 | E-01 (line 33-35), E-14 (InlineData(null)) | ○ |
| C-07 | コンストラクタ(string, Type)で両方設定される | E-01 (line 64-68), E-14 (Ctor_ContractName_ContractType) | ○ |
| C-08 | 両方にnull指定可能 | E-01 (line 64-68), E-14 (InlineData(null, null)) | ○ |
| C-09 | ContractNameプロパティがget-only | E-01 (line 77) | ○ |
| C-10 | ContractTypeプロパティがget-only | E-01 (line 87) | ○ |

### ExportMetadataAttribute（UT-SCAM-011 〜 UT-SCAM-016）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | コンストラクタでName/Valueが設定される | E-02 (line 27-31), E-15 (Ctor_Name_Value) | ○ |
| C-12 | Nameにnull指定時は空文字に変換 | E-02 (line 29: Name = name ?? string.Empty), E-15 | ○ |
| C-13 | Valueにnull指定可能 | E-02 (line 24-25 docコメント), E-15 | ○ |
| C-14 | 様々な型をValueに設定可能 | E-02 (line 24: object containing) | ○ |
| C-15 | Nameプロパティがget-only | E-02 (line 39) | ○ |
| C-16 | Valueプロパティがget-only | E-02 (line 47) | ○ |

### ImportAttribute（UT-SCAM-017 〜 UT-SCAM-022）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | デフォルトコンストラクタでContractNameがnull、AllowDefaultがfalse | E-03 (line 19-21), E-16 (Ctor_Default) | ○ |
| C-18 | コンストラクタ(string)でContractNameが設定される | E-03 (line 31-34), E-16 (Ctor_ContractName) | ○ |
| C-19 | コンストラクタ(string)でnull許容 | E-03 (line 31-34), E-16 (InlineData(null)) | ○ |
| C-20 | AllowDefaultプロパティがget/set可能 | E-03 (line 50) | ○ |
| C-21 | AllowDefaultのデフォルト値がfalse | E-03, E-16 (Assert.False) | ○ |
| C-22 | ContractNameプロパティがget-only | E-03 (line 43) | ○ |

### ImportManyAttribute（UT-SCAM-023 〜 UT-SCAM-026）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | デフォルトコンストラクタでContractNameがnull | E-04 (line 19-21), E-17 (Ctor_Default) | ○ |
| C-24 | コンストラクタ(string)でContractNameが設定される | E-04 (line 31-34), E-17 (Ctor_ContractName) | ○ |
| C-25 | コンストラクタ(string)でnull許容 | E-04 (line 31-34), E-17 (InlineData(null)) | ○ |
| C-26 | ContractNameプロパティがget-only | E-04 (line 43) | ○ |

### ImportingConstructorAttribute（UT-SCAM-027 〜 UT-SCAM-028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | デフォルトコンストラクタでインスタンス生成可能 | E-05 (line 20-22), E-18 | ○ |
| C-28 | TypeIdが正しい型を返す | E-18 (Assert.Equal) | ○ |

### ImportMetadataConstraintAttribute（UT-SCAM-029 〜 UT-SCAM-033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | コンストラクタでName/Valueが設定される | E-06 (line 17-21), E-22 | ○ |
| C-30 | Nameにnull指定可能 | E-06 (line 17-21), E-22 (InlineData(null, null)) | ○ |
| C-31 | Valueにnull指定可能 | E-06 (line 17-21), E-22 | ○ |
| C-32 | Nameプロパティがget-only | E-06 (line 26) | ○ |
| C-33 | Valueプロパティがget-only | E-06 (line 31) | ○ |

### MetadataAttributeAttribute（UT-SCAM-034 〜 UT-SCAM-035）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | デフォルトコンストラクタでインスタンス生成可能 | E-07 (line 17-19), E-23 | ○ |
| C-35 | TypeIdが正しい型を返す | E-23 (Assert.Equal) | ○ |

### OnImportsSatisfiedAttribute（UT-SCAM-036 〜 UT-SCAM-037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | デフォルトコンストラクタでインスタンス生成可能 | E-08 (line 12-14) | ○ |
| C-37 | TypeIdが正しい型を返す | E-08（Attribute基底クラスから継承） | ○ |

### PartMetadataAttribute（UT-SCAM-038 〜 UT-SCAM-043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | コンストラクタでName/Valueが設定される | E-09 (line 24-28), E-19 | ○ |
| C-39 | Nameにnull指定時はArgumentNullException | E-09 (line 26), E-19 (Ctor_NullName_ThrowsArgumentNullException) | ○ |
| C-40 | 空文字は許容される | E-09 (docコメント), E-19 (InlineData("", null)) | ○ |
| C-41 | Valueにnull指定可能 | E-09 (line 22 docコメント), E-19 | ○ |
| C-42 | Nameプロパティがget-only | E-09 (line 36) | ○ |
| C-43 | Valueプロパティがget-only | E-09 (line 44) | ○ |

### PartNotDiscoverableAttribute（UT-SCAM-044 〜 UT-SCAM-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | デフォルトコンストラクタでインスタンス生成可能 | E-10 (line 15-17), E-24 | ○ |
| C-45 | TypeIdが正しい型を返す | E-24 (Assert.Equal) | ○ |

### SharedAttribute（UT-SCAM-046 〜 UT-SCAM-050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | デフォルトコンストラクタでSharingBoundaryがnull | E-11 (line 23-25), E-20 (Ctor_Default) | ○ |
| C-47 | コンストラクタ(string)でSharingBoundaryが設定される | E-11 (line 32-34), E-20 (Ctor_SharingBoundaryName) | ○ |
| C-48 | コンストラクタ(string)でnull許容 | E-11 (line 32-34), E-20 (InlineData(null)) | ○ |
| C-49 | SharingBoundaryプロパティがbase.Valueをキャストして返す | E-11 (line 39) | ○ |
| C-50 | Nameが"SharingBoundary"固定 | E-11 (line 18, 23, 32), E-20 | ○ |

### SharingBoundaryAttribute（UT-SCAM-051 〜 UT-SCAM-056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | コンストラクタで境界名配列が設定される | E-12 (line 30-33), E-21 | ○ |
| C-52 | 空配列が許容される | E-12 (line 30-33), E-21 (SharingBoundaryNames_TestData) | ○ |
| C-53 | null指定時はArgumentNullException | E-12 (line 32), E-21 (Ctor_NullSharingBoundaryNames) | ○ |
| C-54 | 配列内にnull要素を含むことが許容 | E-12, E-21 (new string[] { "1", null, "2" }) | ○ |
| C-55 | SharingBoundaryNamesがReadOnlyCollectionを返す | E-12 (line 38: Array.AsReadOnly) | ○ |
| C-56 | 返却コレクションの独立性 | E-12 (Array.AsReadOnlyの動作) | ○ |

### AttributedModelProvider（UT-SCAM-057 〜 UT-SCAM-058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | GetCustomAttributes(Type, MemberInfo)が抽象メソッド | E-13 (line 20: abstract) | ○ |
| C-58 | GetCustomAttributes(Type, ParameterInfo)が抽象メソッド | E-13 (line 27: abstract) | ○ |

### AttributeUsage確認（UT-SCAM-059 〜 UT-SCAM-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | ExportAttributeがClass, Propertyに適用可能 | E-01 (line 11-12) | ○ |
| C-60 | ExportAttributeのAllowMultiple=true | E-01 (line 12) | ○ |
| C-61 | ExportAttributeのInherited=false | E-01 (line 12) | ○ |
| C-62 | ImportAttributeがProperty, Parameterに適用可能 | E-03 (line 11-12) | ○ |
| C-63 | ImportAttributeのAllowMultiple=false | E-03 (line 12) | ○ |
| C-64 | ImportManyAttributeがProperty, Parameterに適用可能 | E-04 (line 11-12) | ○ |
| C-65 | ImportingConstructorAttributeがConstructorに適用可能 | E-05 (line 14) | ○ |
| C-66 | ExportMetadataAttributeがClass, Interface, Propertyに適用可能 | E-02 (line 10-11) | ○ |
| C-67 | ExportMetadataAttributeのAllowMultiple=true | E-02 (line 11) | ○ |
| C-68 | PartMetadataAttributeがClassに適用可能 | E-09 (line 9) | ○ |
| C-69 | PartMetadataAttributeのAllowMultiple=true | E-09 (line 9) | ○ |
| C-70 | MetadataAttributeAttributeがClassに適用可能 | E-07 (line 10-11) | ○ |
| C-71 | MetadataAttributeAttributeのInherited=true | E-07 (line 11) | ○ |
| C-72 | OnImportsSatisfiedAttributeがMethodに適用可能 | E-08 (line 11) | ○ |
| C-73 | PartNotDiscoverableAttributeがClassに適用可能 | E-10 (line 9) | ○ |
| C-74 | SharedAttributeがClassに適用可能 | E-11 (line 15) | ○ |
| C-75 | SharingBoundaryAttributeがParameter, Propertyに適用可能 | E-12 (line 19) | ○ |
| C-76 | SharingBoundaryAttributeがCLSCompliant(false) | E-12 (line 21) | ○ |
| C-77 | ImportMetadataConstraintAttributeがPropertyに適用可能 | E-06 (line 9) | ○ |
| C-78 | SharedAttributeがPartMetadataAttributeを継承 | E-11 (line 16: class SharedAttribute : PartMetadataAttribute) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
- すべてのテストケースはソースコードおよび既存テストコードから根拠を特定できています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本モジュールは属性クラスのみで構成され、ロジックが単純
- 0: 低リスク - 既存のテストコードがほぼすべてのケースをカバー済み
- 1: 中リスク - AttributedModelProviderは抽象クラスであり、実装は別モジュールに存在

## 6) レビュアーチェックリスト（最小）
- [ ] PartMetadataAttribute.コンストラクタでnull指定時のArgumentNullExceptionが正しく発生するか確認
- [ ] SharingBoundaryAttribute.コンストラクタでnull指定時のArgumentNullExceptionが正しく発生するか確認
- [ ] ExportMetadataAttribute.Nameのnull→空文字変換が期待通りか確認
- [ ] SharedAttribute.SharingBoundaryプロパティのキャストが安全か確認
- [ ] SharingBoundaryAttribute.SharingBoundaryNamesの返却コレクションが元配列と独立しているか確認
- [ ] AttributeUsageの設定がMEFの仕様に合致しているか確認
