---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 140
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.Composition.Convention 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：140 / 140、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/ConventionBuilder.cs`
- E-02: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/ExportConventionBuilder.cs`
- E-03: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/ImportConventionBuilder.cs`
- E-04: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/PartConventionBuilder.cs`
- E-05: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/PartConventionBuilderOfT.cs`
- E-06: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/ParameterImportConventionBuilder.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConventionBuilder クラス（C-01 ~ C-25）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ForTypesDerivedFrom<T>がPartConventionBuilder<T>を返却 | E-01 (L35-40) | ○ |
| C-02 | ForTypesDerivedFrom<T>のIsDescendentOfフィルタ設定 | E-01 (L37) | ○ |
| C-03 | ForTypesDerivedFrom(Type)がPartConventionBuilderを返却 | E-01 (L48-55) | ○ |
| C-04 | ForTypesDerivedFrom(Type)のnull引数検証 | E-01 (L50) | ○ |
| C-05 | ForType<T>がPartConventionBuilder<T>を返却 | E-01 (L62-67) | ○ |
| C-06 | ForType<T>の型一致フィルタ設定 | E-01 (L64) | ○ |
| C-07 | ForType(Type)がPartConventionBuilderを返却 | E-01 (L74-81) | ○ |
| C-08 | ForType(Type)のnull引数検証 | E-01 (L76) | ○ |
| C-09 | ForTypesMatching<T>がPartConventionBuilder<T>を返却 | E-01 (L90-97) | ○ |
| C-10 | ForTypesMatching<T>のnull引数検証 | E-01 (L92) | ○ |
| C-11 | ForTypesMatchingがPartConventionBuilderを返却 | E-01 (L105-112) | ○ |
| C-12 | ForTypesMatchingのnull引数検証 | E-01 (L107) | ○ |
| C-13 | GetCustomAttributes(Type, MemberInfo)のTypeInfo処理 | E-01 (L147-230) | ○ |
| C-14 | GetCustomAttributes(Type, MemberInfo)のPropertyInfo処理 | E-01 (L218-221) | ○ |
| C-15 | GetCustomAttributes(Type, MemberInfo)のConstructorInfo処理 | E-01 (L218) | ○ |
| C-16 | GetCustomAttributes(Type, MemberInfo)のnull引数検証 | E-01 (L149) | ○ |
| C-17 | GetCustomAttributesの属性結合処理 | E-01 (L229) | ○ |
| C-18 | GetCustomAttributesのフィルタ不一致時処理 | E-01 (L224-225) | ○ |
| C-19 | GetCustomAttributes(Type, ParameterInfo)の処理 | E-01 (L284-291) | ○ |
| C-20 | GetCustomAttributes(Type, ParameterInfo)のnull引数検証 | E-01 (L286) | ○ |
| C-21 | IsDescendentOfの派生型判定 | E-01 (L357-375) | ○ |
| C-22 | IsDescendentOfの同一型判定 | E-01 (L359) | ○ |
| C-23 | IsDescendentOfのobject型判定 | E-01 (L359) | ○ |
| C-24 | IsDescendentOfのnull判定 | E-01 (L359) | ○ |
| C-25 | IsGenericDescendentOfのオープンジェネリック判定 | E-01 (L339-355) | ○ |

### ExportConventionBuilder クラス（C-26 ~ C-41）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | AsContractType<T>の契約型設定 | E-02 (L31-34) | ○ |
| C-27 | AsContractType(Type)の契約型設定 | E-02 (L41-47) | ○ |
| C-28 | AsContractType(Type)のnull引数検証 | E-02 (L43) | ○ |
| C-29 | AsContractName(string)の契約名設定 | E-02 (L54-64) | ○ |
| C-30 | AsContractName(string)のnull引数検証 | E-02 (L56) | ○ |
| C-31 | AsContractName(string)の空文字検証 | E-02 (L58-61) | ○ |
| C-32 | AsContractName(Func)の契約名関数設定 | E-02 (L71-77) | ○ |
| C-33 | AsContractName(Func)のnull引数検証 | E-02 (L73) | ○ |
| C-34 | AddMetadata(string, object)のメタデータ追加 | E-02 (L85-97) | ○ |
| C-35 | AddMetadata(string, object)のnull引数検証 | E-02 (L87) | ○ |
| C-36 | AddMetadata(string, object)の空文字検証 | E-02 (L89-92) | ○ |
| C-37 | AddMetadata(string, Func)のメタデータ関数追加 | E-02 (L105-118) | ○ |
| C-38 | AddMetadata(string, Func)のname null検証 | E-02 (L107) | ○ |
| C-39 | AddMetadata(string, Func)のgetValueFromPartType null検証 | E-02 (L108) | ○ |
| C-40 | BuildAttributesのExportAttribute生成 | E-02 (L120-125) | ○ |
| C-41 | BuildAttributesのExportMetadataAttribute生成 | E-02 (L127-145) | ○ |

### ImportConventionBuilder クラス（C-42 ~ C-64）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | AsContractName(string)の契約名設定 | E-03 (L31-41) | ○ |
| C-43 | AsContractName(string)のnull引数検証 | E-03 (L33) | ○ |
| C-44 | AsContractName(string)の空文字検証 | E-03 (L35-38) | ○ |
| C-45 | AsContractName(Func)の契約名関数設定 | E-03 (L48-54) | ○ |
| C-46 | AsContractName(Func)のnull引数検証 | E-03 (L50) | ○ |
| C-47 | AsMany()のImportMany設定 | E-03 (L60-63) | ○ |
| C-48 | AsMany(bool)のImportMany設定 | E-03 (L70-74) | ○ |
| C-49 | AllowDefaultの設定 | E-03 (L81-85) | ○ |
| C-50 | AddMetadataConstraint(string, object)の制約追加 | E-03 (L93-105) | ○ |
| C-51 | AddMetadataConstraint(string, object)のnull引数検証 | E-03 (L95) | ○ |
| C-52 | AddMetadataConstraint(string, object)の空文字検証 | E-03 (L97-100) | ○ |
| C-53 | AddMetadataConstraint(string, Func)の制約関数追加 | E-03 (L113-126) | ○ |
| C-54 | AddMetadataConstraint(string, Func)のname null検証 | E-03 (L115) | ○ |
| C-55 | AddMetadataConstraint(string, Func)のgetConstraintValueFromPartType null検証 | E-03 (L116) | ○ |
| C-56 | BuildAttributesのImportAttribute生成 | E-03 (L128-141) | ○ |
| C-57 | BuildAttributesのImportManyAttribute生成 | E-03 (L143-146) | ○ |
| C-58 | IEnumerable<T>型のImportMany自動判定 | E-03 (L135, L173-178) | ○ |
| C-59 | 配列型のImportMany自動判定 | E-03 (L175) | ○ |
| C-60 | IList<T>型のImportMany自動判定 | E-03 (L15, L176-177) | ○ |
| C-61 | ICollection<T>型のImportMany自動判定 | E-03 (L15, L176-177) | ○ |
| C-62 | IsSupportedImportManyTypeの配列判定 | E-03 (L175) | ○ |
| C-63 | IsSupportedImportManyTypeのIEnumerable判定 | E-03 (L176-177) | ○ |
| C-64 | IsSupportedImportManyTypeの単純型判定 | E-03 (L173-178) | ○ |

### PartConventionBuilder クラス（C-65 ~ C-115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | Export()のエクスポート追加 | E-04 (L54-59) | ○ |
| C-66 | Export(Action)のエクスポート構成 | E-04 (L66-74) | ○ |
| C-67 | Export(Action)のnull引数検証 | E-04 (L68) | ○ |
| C-68 | Export<T>()の契約型エクスポート | E-04 (L80-85) | ○ |
| C-69 | Export<T>(Action)の契約型エクスポート構成 | E-04 (L92-100) | ○ |
| C-70 | Export<T>(Action)のnull引数検証 | E-04 (L94) | ○ |
| C-71 | SelectConstructorのフィルタ設定 | E-04 (L107-113) | ○ |
| C-72 | SelectConstructorのnull引数検証 | E-04 (L109) | ○ |
| C-73 | SelectConstructor(Func, Action)のフィルタと構成設定 | E-04 (L121-129) | ○ |
| C-74 | SelectConstructor(Func, Action)のnull引数検証 | E-04 (L124) | ○ |
| C-75 | ExportInterfaces()の全インターフェース設定 | E-04 (L147-150) | ○ |
| C-76 | ExportInterfaces(Predicate)のフィルタ設定 | E-04 (L136-141) | ○ |
| C-77 | ExportInterfaces(Predicate)のnull引数検証 | E-04 (L138) | ○ |
| C-78 | ExportInterfaces(Predicate, Action)のフィルタと構成設定 | E-04 (L158-165) | ○ |
| C-79 | ExportInterfaces(Predicate, Action)のinterfaceFilter null検証 | E-04 (L161) | ○ |
| C-80 | ExportInterfaces(Predicate, Action)のexportConfiguration null検証 | E-04 (L162) | ○ |
| C-81 | ExportPropertiesのフィルタ設定 | E-04 (L179-184) | ○ |
| C-82 | ExportPropertiesのnull引数検証 | E-04 (L181) | ○ |
| C-83 | ExportProperties(Predicate, Action)のフィルタと構成設定 | E-04 (L192-199) | ○ |
| C-84 | ExportProperties<T>の契約型設定 | E-04 (L214-219) | ○ |
| C-85 | ImportPropertiesのフィルタ設定 | E-04 (L249-254) | ○ |
| C-86 | ImportPropertiesのnull引数検証 | E-04 (L251) | ○ |
| C-87 | ImportProperties(Predicate, Action)のフィルタと構成設定 | E-04 (L262-269) | ○ |
| C-88 | ImportProperties<T>のプロパティ型設定 | E-04 (L284-289) | ○ |
| C-89 | NotifyImportsSatisfiedのメソッドフィルタ設定 | E-04 (L319-323) | ○ |
| C-90 | Shared()の共有設定 | E-04 (L329-332) | ○ |
| C-91 | Shared(string)の共有境界設定 | E-04 (L339-349) | ○ |
| C-92 | Shared(string)のnull引数検証 | E-04 (L341) | ○ |
| C-93 | Shared(string)の空文字検証 | E-04 (L343-346) | ○ |
| C-94 | AddPartMetadata(string, object)のメタデータ追加 | E-04 (L364-376) | ○ |
| C-95 | AddPartMetadata(string, object)のnull引数検証 | E-04 (L366) | ○ |
| C-96 | AddPartMetadata(string, object)の空文字検証 | E-04 (L368-371) | ○ |
| C-97 | AddPartMetadata(string, Func)のメタデータ関数追加 | E-04 (L384-397) | ○ |
| C-98 | AddPartMetadata(string, Func)のname null検証 | E-04 (L386) | ○ |
| C-99 | AddPartMetadata(string, Func)のgetValueFromPartType null検証 | E-04 (L387) | ○ |
| C-100 | BuildTypeAttributesのExportAttribute生成 | E-04 (L420-437) | ○ |
| C-101 | BuildTypeAttributesのSharedAttribute生成 | E-04 (L440-455) | ○ |
| C-102 | BuildTypeAttributesのPartMetadataAttribute生成 | E-04 (L457-491) | ○ |
| C-103 | BuildTypeAttributesのインターフェースエクスポート生成 | E-04 (L493-525) | ○ |
| C-104 | IDisposableのインターフェースエクスポート除外 | E-04 (L506-509) | ○ |
| C-105 | BuildConstructorAttributesのImportingConstructorAttribute生成 | E-04 (L529-565) | ○ |
| C-106 | 既存ImportingConstructorAttributeの優先 | E-04 (L534-543) | ○ |
| C-107 | BuildDefaultConstructorAttributesの最長コンストラクタ選択 | E-04 (L567-575) | ○ |
| C-108 | パラメータなしコンストラクタのデフォルト処理 | E-04 (L766-779) | ○ |
| C-109 | BuildOnImportsSatisfiedNotificationのOnImportsSatisfiedAttribute生成 | E-04 (L608-660) | ○ |
| C-110 | voidパラメータなしメソッドのフィルタ | E-04 (L616-617) | ○ |
| C-111 | BuildPropertyAttributesのImportAttribute生成 | E-04 (L662-707) | ○ |
| C-112 | BuildPropertyAttributesのExportAttribute生成 | E-04 (L712-744) | ○ |
| C-113 | FindLongestConstructorsの最長コンストラクタ返却 | E-04 (L757-796) | ○ |
| C-114 | 同一パラメータ数コンストラクタの複数返却 | E-04 (L780-790) | ○ |
| C-115 | パラメータなしコンストラクタのみの空結果 | E-04 (L791-795) | ○ |

### PartConventionBuilder<T> クラス（C-116 ~ C-135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | SelectConstructor(Expression)のコンストラクタ選択 | E-05 (L209-216) | ○ |
| C-117 | SelectConstructor(Expression)のnull引数検証 | E-05 (L211) | ○ |
| C-118 | ExportProperty(Expression)のプロパティエクスポート | E-05 (L223-226) | ○ |
| C-119 | ExportProperty(Expression)のnull引数検証 | E-05 (L238) | ○ |
| C-120 | ExportProperty(Expression, Action)のプロパティエクスポート構成 | E-05 (L234-243) | ○ |
| C-121 | ExportProperty<TContract>(Expression)の契約型プロパティエクスポート | E-05 (L252-255) | ○ |
| C-122 | ImportProperty(Expression)のプロパティインポート | E-05 (L280-283) | ○ |
| C-123 | ImportProperty(Expression)のnull引数検証 | E-05 (L295) | ○ |
| C-124 | ImportProperty(Expression, Action)のプロパティインポート構成 | E-05 (L291-300) | ○ |
| C-125 | ImportProperty<TContract>(Expression)の契約型プロパティインポート | E-05 (L308-311) | ○ |
| C-126 | NotifyImportsSatisfied(Expression)のメソッド通知設定 | E-05 (L335-342) | ○ |
| C-127 | NotifyImportsSatisfied(Expression)のnull引数検証 | E-05 (L337) | ○ |
| C-128 | MethodExpressionAdapter.VerifyMethodInfoの一致判定 | E-05 (L25-28) | ○ |
| C-129 | MethodExpressionAdapter.VerifyMethodInfoの不一致判定 | E-05 (L25-28) | ○ |
| C-130 | SelectMethodsのvoidでないメソッド検証 | E-05 (L30-46) | ○ |
| C-131 | PropertyExpressionAdapter.VerifyPropertyInfoの一致判定 | E-05 (L83-86) | ○ |
| C-132 | SelectPropertiesのプロパティでない式検証 | E-05 (L98-114) | ○ |
| C-133 | ConstructorExpressionAdapter.SelectConstructorの返却 | E-05 (L136-139) | ○ |
| C-134 | ConfigureConstructorImportsのインポートビルダー呼び出し | E-05 (L141-152) | ○ |
| C-135 | ParseSelectConstructorのnew式でない場合の検証 | E-05 (L154-163) | ○ |

### ParameterImportConventionBuilder クラス（C-136 ~ C-137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-136 | Import<T>()のdefault(T)返却 | E-06 (L19-22) | ○ |
| C-137 | Import<T>(Action)のdefault(T)返却 | E-06 (L30-33) | ○ |

### スレッドセーフティとキャッシュ（C-138 ~ C-140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | ReaderWriterLockSlimによるスレッドセーフティ | E-01 (L16, L157-164, L168-215) | ○ |
| C-139 | 属性キャッシュの使用 | E-01 (L160, L172, L210) | ○ |
| C-140 | Fluent APIのメソッドチェーン | E-04 (各メソッドがthisを返却) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースはソースコード解析に基づいて生成されており、根拠が明確です。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースにソースコードの根拠があり、.NET公式ライブラリとして既存テストも存在

## 6) レビュアーチェックリスト（最小）
- [ ] テストID（UT-SCC-xxx）が連番で一意であることを確認
- [ ] 各テストケースの入力値と期待結果が明確であることを確認
- [ ] 高優先度のテストケース（引数検証、属性生成の中核機能）が網羅されていることを確認
- [ ] スレッドセーフティのテストケース（C-138）が並行処理シナリオをカバーしていることを確認
- [ ] 境界値テストケースが適切に設定されていることを確認
