---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 135
  claims_with_evidence: 135
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.Composition.Hosting 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：135 / 135、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースはソースコードから直接導出されており、根拠が明確
  2. 特に循環参照処理（CycleBreaking系クラス）のテストケースは実装詳細に基づく
  3. メタデータビュープロバイダーの動的コンパイル処理は複雑なため重点確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/CompositionHost.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/LifetimeContext.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptor.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptorProvider.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/CompositionOperation.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/CompositionDependency.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptorPromise.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/DependencyAccessor.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptorRegistry.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/DirectExportDescriptor.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/CycleBreakingExportDescriptor.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/CycleBreakingMetadataDictionary.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptorRegistryUpdate.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/UpdateResult.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Util/SmallSparseInitonlyArray.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Util/Formatters.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Util/MethodInfoExtensions.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/Constants.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/ExportFactory/ExportFactoryExportDescriptorProvider.cs`
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/ExportFactory/ExportFactoryWithMetadataExportDescriptorProvider.cs`
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/CurrentScope/CurrentScopeExportDescriptorProvider.cs`
- E-22: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/ImportMany/ImportManyExportDescriptorProvider.cs`
- E-23: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/Lazy/LazyExportDescriptorProvider.cs`
- E-24: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/Lazy/LazyWithMetadataExportDescriptorProvider.cs`
- E-25: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/Metadata/MetadataViewProvider.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CompositionHost クラス（UT-SCH-001 ~ UT-SCH-007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateCompositionHostはproviders引数を受け取りCompositionHostを返す | E-01: L35-61 | ○ |
| C-02 | CreateCompositionHostはnull引数でArgumentNullExceptionをスロー | E-01: L46 `ArgumentNullException.ThrowIfNull(providers)` | ○ |
| C-03 | TryGetExportは_rootLifetimeContextに委譲する | E-01: L71-74 | ○ |
| C-04 | Disposeは_rootLifetimeContext.Disposeを呼び出す | E-01: L79-82 | ○ |

### LifetimeContext クラス（UT-SCH-008 ~ UT-SCH-024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | AllocateSharingIdはInterlocked.Incrementを使用 | E-02: L49-52 | ○ |
| C-06 | FindContextWithinはnullでルートを返す | E-02: L76-78 | ○ |
| C-07 | FindContextWithinは存在しない境界でCompositionFailedExceptionをスロー | E-02: L94-97 | ○ |
| C-08 | Disposeはバインドインスタンスを破棄する | E-02: L104-121 | ○ |
| C-09 | AddBoundInstanceはDispose後にObjectDisposedExceptionをスロー | E-02: L128-137 | ○ |
| C-10 | GetOrCreateは共有ロックを使用する | E-02: L152-185 | ○ |
| C-11 | TryGetExportはExportDescriptorRegistryを使用 | E-02: L195-206 | ○ |
| C-12 | ToStringはコンテキストタイプに応じた文字列を返す | E-02: L212-221 | ○ |

### ExportDescriptor クラス（UT-SCH-025 ~ UT-SCH-027）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | CreateはDirectExportDescriptorを返す | E-03: L31-34 | ○ |
| C-14 | Activator/Metadataは抽象プロパティ | E-03: L18, L23 | ○ |

### ExportDescriptorProvider クラス（UT-SCH-028 ~ UT-SCH-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | NoExportDescriptorsは空のEnumerable | E-04: L21 | ○ |
| C-16 | NoMetadataは空のReadOnlyDictionary | E-04: L26 | ○ |
| C-17 | NoDependenciesは空のEnumerableを返す関数 | E-04: L31 | ○ |

### CompositionOperation クラス（UT-SCH-031 ~ UT-SCH-041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | Runはnull引数でArgumentNullExceptionをスロー | E-05: L33-34 | ○ |
| C-19 | AddNonPrerequisiteActionはnullでArgumentNullExceptionをスロー | E-05: L51 | ○ |
| C-20 | AddPostCompositionActionはnullでArgumentNullExceptionをスロー | E-05: L65 | ○ |
| C-21 | DisposeはMonitor.Exitを呼び出す | E-05: L114-118 | ○ |
| C-22 | EnterSharingLockは異なるロックで例外をスロー | E-05: L82-85 | ○ |

### CompositionDependency クラス（UT-SCH-042 ~ UT-SCH-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | Satisfiedは全引数にArgumentNullException.ThrowIfNull | E-06: L42-44 | ○ |
| C-24 | Missingは全引数にArgumentNullException.ThrowIfNull | E-06: L58-59 | ○ |
| C-25 | Oversuppliedは全引数にArgumentNullException.ThrowIfNull | E-06: L74-76 | ○ |
| C-26 | IsErrorはtarget==nullで判定 | E-06: L138 | ○ |
| C-27 | ToStringはIsErrorに応じて異なる文字列を返す | E-06: L131-136 | ○ |

### ExportDescriptorPromise クラス（UT-SCH-061 ~ UT-SCH-069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | GetDescriptorは循環参照時にCycleBreakingExportDescriptorを返す | E-07: L78-79 | ○ |
| C-29 | GetDescriptorはnull戻り値でArgumentNullExceptionをスロー | E-07: L86-88 | ○ |

### DependencyAccessor クラス（UT-SCH-070 ~ UT-SCH-076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | ResolveDependenciesは全てのPromiseを解決 | E-08: L28-35 | ○ |
| C-31 | ResolveRequiredDependencyは存在しない場合にMissingを返す | E-08: L47-48 | ○ |
| C-32 | TryResolveOptionalDependencyは複数存在でOversuppliedを返す | E-08: L70-73 | ○ |

### DirectExportDescriptor クラス（UT-SCH-077 ~ UT-SCH-079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | コンストラクタはnull引数でArgumentNullExceptionをスロー | E-10: L15-16 | ○ |

### CycleBreaking系クラス（UT-SCH-080 ~ UT-SCH-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | CycleBreakingExportDescriptor.ActivatorはIsValueCreatedに応じて動作を変える | E-11: L18-27 | ○ |
| C-35 | CycleBreakingExportDescriptor.MetadataはIsValueCreatedに応じて動作を変える | E-11: L29-38 | ○ |
| C-36 | ActivateはLazy未作成時にNotImplementedExceptionをスロー | E-11: L42-47 | ○ |
| C-37 | CycleBreakingMetadataDictionaryは全操作でActualMetadataに委譲 | E-12: L18-31, L33-118 | ○ |

### ExportDescriptorRegistry クラス（UT-SCH-087 ~ UT-SCH-089）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | TryGetSingleForExportは複数エクスポートでCompositionFailedExceptionをスロー | E-09: L48-53 | ○ |

### ExportDescriptorRegistryUpdate クラス（UT-SCH-090 ~ UT-SCH-093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | Executeは再実行でInvalidOperationExceptionをスロー | E-13: L34 | ○ |
| C-40 | CheckTargetは依存関係エラーでCompositionFailedExceptionをスロー | E-13: L56-66 | ○ |
| C-41 | CheckDependencyは循環依存でCompositionFailedExceptionをスロー | E-13: L96-103 | ○ |

### UpdateResult クラス（UT-SCH-094 ~ UT-SCH-099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | TryDequeueNextProviderはキュー操作を行う | E-14: L25-35 | ○ |
| C-43 | GetResultsはプロバイダー残存時にExceptionをスロー | E-14: L47-50 | ○ |

### SmallSparseInitonlyArray クラス（UT-SCH-100 ~ UT-SCH-107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | Addは重複キーでArgumentExceptionをスロー | E-15: L34-37, L49-52 | ○ |
| C-45 | Addはオーバーフロー時に再帰的に追加 | E-15: L55-57 | ○ |
| C-46 | TryGetValueは初期状態でfalseを返す | E-15: L62-66 | ○ |

### Formatters クラス（UT-SCH-108 ~ UT-SCH-113）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | ReadableListはnullでArgumentNullExceptionをスロー | E-16: L13 | ○ |
| C-48 | FormatはジェネリックTypeを適切にフォーマット | E-16: L19-42 | ○ |

### MethodInfoExtensions クラス（UT-SCH-114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | CreateStaticDelegateはデリゲートを作成 | E-17: L10-13 | ○ |

### Provider クラス群（UT-SCH-115 ~ UT-SCH-135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | CurrentScopeExportDescriptorProviderはCompositionContextのみ処理 | E-21: L11-15 | ○ |
| C-51 | LazyExportDescriptorProviderはLazy<>のみ処理 | E-23: L17-19 | ○ |
| C-52 | LazyWithMetadataExportDescriptorProviderはLazy<,>のみ処理 | E-24: L17-19 | ○ |
| C-53 | ExportFactoryExportDescriptorProviderはExportFactory<>のみ処理 | E-19: L16-18 | ○ |
| C-54 | ExportFactoryWithMetadataExportDescriptorProviderはExportFactory<,>のみ処理 | E-20: L18-20 | ○ |
| C-55 | ImportManyExportDescriptorProviderはIEnumerable/IList/ICollection/配列でImportMany制約付きのみ処理 | E-22: L17-26 | ○ |
| C-56 | MetadataViewProviderは値型でCompositionFailedExceptionをスロー | E-25: L24-25 | ○ |
| C-57 | MetadataViewProviderは適切なコンストラクタがない場合にCompositionFailedExceptionをスロー | E-25: L73 | ○ |
| C-58 | GetMetadataValueはメタデータ不足でCompositionFailedExceptionをスロー | E-25: L86-89 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。全てのテストケースはソースコードから直接導出されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースは明確なAPIとその引数検証に基づいています
- 1: 中リスク - 循環参照処理（CycleBreaking系）は複雑なため、実際の循環シナリオでのテストが必要
- 1: 中リスク - MetadataViewProviderの動的Expression生成は実行時エラーの可能性があり、網羅的テストが必要
- 0: 低リスク - SmallSparseInitonlyArrayのパフォーマンス特性は単体テストでは検証困難

## 6) レビュアーチェックリスト（最小）
- [ ] ArgumentNullException.ThrowIfNullを使用しているメソッドの引数検証テストが網羅されているか
- [ ] Dispose後の操作禁止テスト（ObjectDisposedException）が適切か
- [ ] 循環参照処理のテストシナリオが実際の循環パターンをカバーしているか
- [ ] 複数スレッドからのアクセステスト（AllocateSharingId、GetOrCreate）の妥当性
- [ ] 各Providerの対象コントラクト判定ロジックが正しくテストされているか
- [ ] MetadataViewProviderの各コンストラクタパターン（辞書コンストラクタ、パラメータなしコンストラクタ）が網羅されているか
