---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 82
  claims_with_evidence: 82
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: System.Composition.Runtime 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容(Claim: 主張)を検証しています:

1. **根拠の有無確認**: 各テストケースに対して、ソースコード・既存テストコードなどの根拠(Evidence)が存在するか
2. **根拠との整合性**: テストケースの内容が根拠と矛盾していないか
3. **網羅性**: 参照すべきクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー(まず見るところ)
- 総合信頼度(derived): **1.00**
  - 根拠あり: 82 / 82、根拠なし: 0
- 優先レビュー(高)
  1. 全テストケースがソースコードおよび既存テストコードに基づいて生成されている
  2. 既存テストでカバーされていない追加テストケースについては、ソースコードの実装を直接確認
  3. 境界値・異常系テストケースはソースコード内の例外処理・条件分岐を根拠として作成

## 2) 参照した情報(Evidence一覧)
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/ExportOfT.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/ExportFactoryOfT.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/ExportFactoryOfTTMetadata.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/Hosting/Core/CompositionContract.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/Hosting/CompositionFailedException.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/CompositionContext.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/Runtime/Util/Formatters.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/tests/System/Composition/ExportTests.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/tests/System/Composition/ExportFactoryTests.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/tests/System/Composition/ExportFactoryTMetadataTests.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/tests/System/Composition/Hosting/Core/CompositionContractTests.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/tests/System/Composition/Hosting/CompositionFailedExceptionTests.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/tests/System/Composition/CompositionContextTests.cs`

## 3) Claims と根拠の対応(レビューの主戦場)

### Export<T> クラス (UT-SCR-001 - UT-SCR-006)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Export<T>コンストラクタで値とdisposeActionが設定される | E-01 (line 20-24), E-08 | ○ |
| C-02 | disposeActionにnullを指定可能 | E-01 (line 34), E-08 (line 34-40) | ○ |
| C-03 | Valueプロパティが設定した値を返す | E-01 (line 29), E-08 (line 16) | ○ |
| C-04 | DisposeでdisposeActionが実行される | E-01 (line 34), E-08 (line 21-32) | ○ |
| C-05 | Disposeを複数回呼び出すとアクションが複数回実行される | E-01 (line 34), E-08 (line 27-31) | ○ |
| C-06 | disposeActionがnullの場合、Disposeで例外なし | E-01 (line 34 `?.`演算子), E-08 (line 34-40) | ○ |

### ExportFactory<T> クラス (UT-SCR-007 - UT-SCR-011)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | ExportFactory<T>コンストラクタが正常動作 | E-02 (line 18-21), E-09 (line 13) | ○ |
| C-08 | exportCreator=nullでArgumentNullException | E-02 (line 20 `throw`), E-09 (line 38-41) | ○ |
| C-09 | CreateExportでExportインスタンスが返される | E-02 (line 27-31), E-09 (line 17-18) | ○ |
| C-10 | 複数回呼び出しで異なるインスタンス | E-09 (line 28-35) | ○ |
| C-11 | Disposeでアクションが実行される | E-02, E-09 (line 22-24) | ○ |

### ExportFactory<T, TMetadata> クラス (UT-SCR-012 - UT-SCR-015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | コンストラクタでmetadataが設定される | E-03 (line 18-22), E-10 (line 13-14) | ○ |
| C-13 | exportCreator=nullでArgumentNullException | E-03 (line 19 基底クラス呼出し), E-10 (line 39-42) | ○ |
| C-14 | Metadataプロパティが値を返す | E-03 (line 27), E-10 (line 14) | ○ |
| C-15 | CreateExportが継承元通り動作 | E-03 (line 11 継承), E-10 (line 18-19) | ○ |

### CompositionContract クラス (UT-SCR-016 - UT-SCR-049)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | 1引数コンストラクタが正常動作 | E-04 (line 24-27), E-11 (line 16-22) | ○ |
| C-17 | contractType=nullでArgumentNullException | E-04 (line 47), E-11 (line 51-57) | ○ |
| C-18 | 2引数コンストラクタが正常動作 | E-04 (line 34-37), E-11 (line 27-33) | ○ |
| C-19 | contractName=nullが許容される | E-04 (line 34-37), E-11 (line 25) | ○ |
| C-20 | 3引数コンストラクタが正常動作 | E-04 (line 45-53), E-11 (line 43-49) | ○ |
| C-21 | 空Dictionary でArgumentOutOfRangeException | E-04 (line 48), E-11 (line 59-63) | ○ |
| C-22 | metadataConstraints=nullが許容される | E-04 (line 45-53), E-11 (line 37) | ○ |
| C-23 | Equals: 同一コントラクトでtrue | E-04 (line 76-83), E-11 (line 65-68) | ○ |
| C-24 | Equals: 異なるContractTypeでfalse | E-04 (line 80), E-11 (line 68) | ○ |
| C-25 | Equals: 異なるContractNameでfalse | E-04 (line 81), E-11 (line 72-74) | ○ |
| C-26 | Equals: 制約値異なるでfalse | E-04 (line 82), E-11 (line 127-131) | ○ |
| C-27 | Equals: 制約キー異なるでfalse | E-04 (line 82), E-11 (line 119-124) | ○ |
| C-28 | Equals: 配列要素同一でtrue | E-04 (line 198-202), E-11 (line 91-96) | ○ |
| C-29 | Equals: 配列要素異なるでfalse | E-04 (line 201), E-11 (line 98-103) | ○ |
| C-30 | Equals: nullとの比較でfalse | E-04 (line 78-79), E-11 (line 186) | ○ |
| C-31 | Equals: 異なる型でfalse | E-04 (line 78), E-11 (line 185) | ○ |
| C-32 | GetHashCode: 同一コントラクトで同じ値 | E-04 (line 89-97), E-11 (line 194) | ○ |
| C-33 | GetHashCode: ContractName=nullで動作 | E-04 (line 92-93) | ○ |
| C-34 | GetHashCode: MetadataConstraints=nullで動作 | E-04 (line 94-95) | ○ |
| C-35 | ToString: 型名のみ返す | E-04 (line 103-116), E-11 (line 274) | ○ |
| C-36 | ToString: ContractName付きで返す | E-04 (line 107-108), E-11 (line 275) | ○ |
| C-37 | ToString: 制約付きで返す | E-04 (line 110-113), E-11 (line 276-277) | ○ |
| C-38 | ToString: ジェネリック型の表示 | E-04 (line 105), E-07 (line 22-29), E-11 (line 277) | ○ |
| C-39 | ToString: null値でArgumentNullException | E-07 (line 13), E-11 (line 287-292) | ○ |
| C-40 | ChangeType: 新しい型が設定される | E-04 (line 125-129), E-11 (line 197-208) | ○ |
| C-41 | ChangeType: 他プロパティ保持 | E-04 (line 128), E-11 (line 206-207) | ○ |
| C-42 | ChangeType: null型でArgumentNullException | E-04 (line 127), E-11 (line 210-215) | ○ |
| C-43 | TryUnwrapMetadataConstraint: 正常取得 | E-04 (line 141-170), E-11 (line 244-263) | ○ |
| C-44 | TryUnwrapMetadataConstraint: 部分除去 | E-04 (line 163-166), E-11 (line 247-254) | ○ |
| C-45 | TryUnwrapMetadataConstraint: 全除去でnull | E-04 (line 158-161), E-11 (line 256-261) | ○ |
| C-46 | TryUnwrapMetadataConstraint: 制約なしでfalse | E-04 (line 148-149), E-11 (line 217-224) | ○ |
| C-47 | TryUnwrapMetadataConstraint: 名前不一致でfalse | E-04 (line 151-152), E-11 (line 226-233) | ○ |
| C-48 | TryUnwrapMetadataConstraint: 型不一致でfalse | E-04 (line 154-155), E-11 (line 235-242) | ○ |
| C-49 | TryUnwrapMetadataConstraint: null名でArgumentNullException | E-04 (line 143), E-11 (line 265-270) | ○ |

### CompositionFailedException クラス (UT-SCR-050 - UT-SCR-054)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | デフォルトコンストラクタが動作 | E-05 (line 16-18), E-12 (line 11-17) | ○ |
| C-51 | メッセージ付きコンストラクタが動作 | E-05 (line 24-26), E-12 (line 19-27) | ○ |
| C-52 | 空文字列メッセージが許容される | E-05 (line 25), E-12 (line 20-21) | ○ |
| C-53 | 内部例外付きコンストラクタが動作 | E-05 (line 33-35), E-12 (line 29-38) | ○ |
| C-54 | innerException=nullが許容される | E-05 (line 33-35), E-12 | ○ |

### CompositionContext クラス (UT-SCR-055 - UT-SCR-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | GetExport<T>()で取得成功 | E-06 (line 34-37), E-13 (line 30-32) | ○ |
| C-56 | GetExport<T>()で不存在時例外 | E-06 (line 149-155), E-13 (line 57-58) | ○ |
| C-57 | GetExport<T>(string)で取得成功 | E-06 (line 47-50), E-13 (line 43-44) | ○ |
| C-58 | GetExport<T>(string)で不存在時例外 | E-06 (line 149-155), E-13 (line 68-69) | ○ |
| C-59 | GetExport(Type)で取得成功 | E-06 (line 124-127), E-13 (line 33) | ○ |
| C-60 | GetExport(Type, string)で取得成功 | E-06 (line 137-140), E-13 (line 44) | ○ |
| C-61 | GetExport(CompositionContract)で取得成功 | E-06 (line 149-155), E-13 | ○ |
| C-62 | GetExport(CompositionContract)で不存在時例外 | E-06 (line 154), E-13 | ○ |
| C-63 | TryGetExport(Type, out object)成功 | E-06 (line 60-63), E-13 (line 38-39) | ○ |
| C-64 | TryGetExport(Type, out object)失敗 | E-06 (line 74-81), E-13 (line 63-64) | ○ |
| C-65 | TryGetExport(Type, string, out object)成功 | E-06 (line 74-81), E-13 (line 49-50) | ○ |
| C-66 | TryGetExport<T>(out T)成功 | E-06 (line 91-94), E-13 (line 35-36) | ○ |
| C-67 | TryGetExport<T>(out T)失敗時default | E-06 (line 105-115), E-13 (line 60-61) | ○ |
| C-68 | TryGetExport<T>(string, out T)成功 | E-06 (line 105-115), E-13 (line 46-47) | ○ |
| C-69 | TryGetExport<T>(string, out T)失敗 | E-06 (line 107-111), E-13 (line 71-72) | ○ |
| C-70 | GetExports(Type)で複数取得 | E-06 (line 163-166, 176-184), E-13 (line 100-101) | ○ |
| C-71 | GetExports時にIsImportMany制約設定 | E-06 (line 178-181), E-13 (line 91) | ○ |
| C-72 | GetExports(Type)で不存在時例外 | E-06 (line 183), E-13 (line 113-114) | ○ |
| C-73 | GetExports(Type, string)で複数取得 | E-06 (line 176-184), E-13 (line 105-106) | ○ |
| C-74 | GetExports<T>()で複数取得 | E-06 (line 193-196), E-13 (line 100) | ○ |
| C-75 | GetExports<T>(string)で複数取得 | E-06 (line 206-209), E-13 (line 105) | ○ |

### Formatters クラス (UT-SCR-076 - UT-SCR-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | Format(object): 文字列をクォート | E-07 (line 14) | ○ |
| C-77 | Format(object): 非文字列をToString | E-07 (line 15) | ○ |
| C-78 | Format(object): nullでArgumentNullException | E-07 (line 13) | ○ |
| C-79 | Format(Type): 非ジェネリック型名返却 | E-07 (line 20) | ○ |
| C-80 | Format(Type): ジェネリック型の表示 | E-07 (line 19, 22-29) | ○ |
| C-81 | Format(Type): 複数型引数の表示 | E-07 (line 28-29) | ○ |
| C-82 | Format(Type): nullでArgumentNullException | E-07 (line 18) | ○ |

## 4) 不足情報(Unknown / Missing)
- 根拠なしの項目はありません
- 全てのテストケースがソースコードまたは既存テストコードから導出されています

## 5) リスクフラグ(レビュー観点)
- 0: 低リスク - 全テストケースに明確な根拠あり
- 既存テストコードとの重複について:
  - 既存テストでカバーされているケース: UT-SCR-001〜015 (Export/ExportFactory), UT-SCR-016〜049の一部 (CompositionContract), UT-SCR-050〜054 (CompositionFailedException), UT-SCR-055〜075 (CompositionContext)
  - 本一覧では既存テストを包括し、追加の境界値・異常系テストも含めている

## 6) レビュアーチェックリスト(最小)
- [ ] Export<T>クラスのDisposeの複数回呼び出し動作が意図通りか確認
- [ ] CompositionContractのEquals/GetHashCodeの制約比較ロジックが正しく理解されているか確認
- [ ] CompositionContextの抽象メソッドTryGetExportを実装するサブクラスでのテスト方針確認
- [ ] Formattersクラスのinternal修飾子によるテスト可能性の確認
- [ ] 既存テストとの重複が問題ないか確認
