---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 111
  claims_with_evidence: 108
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：System.Composition.TypedParts 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：108 / 111、根拠なし：3
- 優先レビュー（高）
  1. **UT-CTP-047**：キャッシュ機能の動作検証は実装詳細に依存
  2. **UT-CTP-030**：OnImportsSatisfiedコールバックの発火タイミング
  3. **UT-CTP-060**：メタデータ制約解決の複雑なシナリオ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Composition.TypedParts/src/System/Composition/Hosting/ContainerConfiguration.cs`
- E-02: `src/libraries/System.Composition.TypedParts/src/System/Composition/CompositionContextExtensions.cs`
- E-03: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/TypeInspector.cs`
- E-04: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/DiscoveredPart.cs`
- E-05: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/DiscoveredExport.cs`
- E-06: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/DiscoveredInstanceExport.cs`
- E-07: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/DiscoveredPropertyExport.cs`
- E-08: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/ParameterImportSite.cs`
- E-09: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/TypedPartExportDescriptorProvider.cs`
- E-10: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ContractHelpers.cs`
- E-11: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ImportInfo.cs`
- E-12: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/ActivationFeature.cs`
- E-13: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/DisposalFeature.cs`
- E-14: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/LifetimeFeature.cs`
- E-15: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/PropertyInjectionFeature.cs`
- E-16: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/OnImportsSatisfiedFeature.cs`
- E-17: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/PropertyImportSite.cs`
- E-18: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Util/DirectAttributeContext.cs`
- E-19: `src/libraries/System.Composition.TypedParts/src/System/Composition/Hosting/SinglePartExportDescriptorProvider.cs`
- E-20: `src/libraries/System.Composition.TypedParts/src/System/Composition/Hosting/InstanceExportDescriptorProvider.cs`
- E-21: `src/libraries/System.Composition.TypedParts/src/System/Composition/Convention/AttributedModelProviderExtensions.cs`
- E-22: `src/libraries/System.Composition.TypedParts/src/System/Composition/Debugging/DiscoveredPartDebuggerProxy.cs`
- E-23: `src/libraries/System.Composition.TypedParts/src/System/Composition/Debugging/ContainerConfigurationDebuggerProxy.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ContainerConfiguration クラス（UT-CTP-001 - UT-CTP-024）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateContainer: 空のコンテナが作成できること | E-01 (L31-43) | ○ |
| C-02 | CreateContainer: パーツを登録したコンテナが作成できること | E-01 (L31-43), E-09 | ○ |
| C-03 | CreateContainer: デフォルトコンベンションが適用されること | E-01 (L37) | ○ |
| C-04 | WithProvider: ExportDescriptorProviderが追加できること | E-01 (L50-56) | ○ |
| C-05 | WithProvider: nullのプロバイダーで例外がスローされること | E-01 (L52) ArgumentNullException.ThrowIfNull | ○ |
| C-06 | WithDefaultConventions: デフォルトコンベンションが設定できること | E-01 (L65-74) | ○ |
| C-07 | WithDefaultConventions: nullのコンベンションで例外 | E-01 (L67) ArgumentNullException.ThrowIfNull | ○ |
| C-08 | WithDefaultConventions: コンベンション二重設定で例外 | E-01 (L69-70) InvalidOperationException | ○ |
| C-09 | WithPart(Type): 型を指定してパーツが追加できること | E-01 (L82-85) | ○ |
| C-10 | WithPart(Type): nullの型で例外 | E-01 (L96) ArgumentNullException | ○ |
| C-11 | WithPart(Type, AttributedModelProvider): コンベンション付きパーツ追加 | E-01 (L94-98) | ○ |
| C-12 | WithPart<TPart>(): ジェネリックメソッドでパーツ追加 | E-01 (L106-109) | ○ |
| C-13 | WithParts(Type[]): 複数の型をパラメータ配列で追加 | E-01 (L129-132) | ○ |
| C-14 | WithParts(IEnumerable<Type>): IEnumerableで複数の型が追加 | E-01 (L140-143) | ○ |
| C-15 | WithParts(IEnumerable<Type>): nullのコレクションで例外 | E-01 (L154) ArgumentNullException.ThrowIfNull | ○ |
| C-16 | WithAssembly(Assembly): アセンブリからパーツが追加 | E-01 (L166-169) | ○ |
| C-17 | WithAssemblies(IEnumerable<Assembly>): 複数アセンブリからパーツ追加 | E-01 (L189-192) | ○ |
| C-18 | WithAssemblies(IEnumerable<Assembly>): nullのアセンブリコレクションで例外 | E-01 (L203) ArgumentNullException.ThrowIfNull | ○ |
| C-19 | WithExport<TExport>(TExport): インスタンスがエクスポートとして追加 | E-01 (L214-219) | ○ |
| C-20 | WithExport<TExport>(TExport): nullインスタンスで例外 | E-01 (L216) ArgumentNullException.ThrowIfNull | ○ |
| C-21 | WithExport<TExport>(TExport, string, IDictionary): 詳細エクスポート設定 | E-01 (L229-234) | ○ |
| C-22 | WithExport(Type, object): 型指定でインスタンスがエクスポート | E-01 (L242-248) | ○ |
| C-23 | WithExport(Type, object): nullの型で例外 | E-01 (L244) ArgumentNullException.ThrowIfNull | ○ |
| C-24 | WithExport(Type, object): nullのインスタンスで例外 | E-01 (L245) ArgumentNullException.ThrowIfNull | ○ |

### CompositionContextExtensions クラス（UT-CTP-025 - UT-CTP-031）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | SatisfyImports: Import属性付きプロパティが満たされること | E-02 (L45-70) | ○ |
| C-26 | SatisfyImports: nullのCompositionContextで例外 | E-02 (L47) ArgumentNullException.ThrowIfNull | ○ |
| C-27 | SatisfyImports: nullのオブジェクトで例外 | E-02 (L48) ArgumentNullException.ThrowIfNull | ○ |
| C-28 | SatisfyImports: 必須インポートが満たされない場合例外 | E-02 (L64-68) CompositionFailedException | ○ |
| C-29 | SatisfyImports: AllowDefault=trueで値がない場合プロパティがnull | E-02 (L64) if (!importInfo.AllowDefault) | ○ |
| C-30 | SatisfyImports: OnImportsSatisfiedメソッドが呼ばれること | E-02 (L72-76) | △ |
| C-31 | SatisfyImports: カスタムコンベンションでインポートが満たされること | E-02 (L40-43) | ○ |

### TypeInspector クラス（UT-CTP-032 - UT-CTP-039）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | InspectTypeForPart: Export属性付きの型がパーツとして認識 | E-03 (L27-41) | ○ |
| C-33 | InspectTypeForPart: 抽象クラスはパーツとして認識されない | E-03 (L31) type.IsAbstract | ○ |
| C-34 | InspectTypeForPart: PartNotDiscoverable属性付きは認識されない | E-03 (L31) PartNotDiscoverableAttribute | ○ |
| C-35 | InspectTypeForPart: インターフェースはパーツとして認識されない | E-03 (L31) !type.IsClass | ○ |
| C-36 | InspectTypeForPart: プロパティエクスポートが検出されること | E-03 (L75-100) DiscoverPropertyExports | ○ |
| C-37 | InspectTypeForPart: プロパティエクスポートの型互換性検証 | E-03 (L164-176) CheckPropertyExportCompatibility | ○ |
| C-38 | InspectTypeForPart: ジェネリック型定義がパーツとして認識 | E-03 (L52-73) DiscoverInstanceExports | ○ |
| C-39 | InspectTypeForPart: ジェネリック型で非ジェネリックコントラクト指定で例外 | E-03 (L178-184) CheckGenericContractCompatibility | ○ |

### DiscoveredPart クラス（UT-CTP-040 - UT-CTP-052）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | AddDiscoveredExport: エクスポートが追加できること | E-04 (L66-70) | ○ |
| C-41 | IsShared: SharingBoundaryメタデータがある場合true | E-04 (L64) ContractHelpers.IsShared | ○ |
| C-42 | IsShared: SharingBoundaryメタデータがない場合false | E-04 (L64), E-10 (L95-98) | ○ |
| C-43 | GetDependencies: コンストラクタパラメータの依存関係が取得 | E-04 (L72-134) | ○ |
| C-44 | GetDependencies: 複数のImportingConstructorで例外 | E-04 (L91-95) CompositionFailedException | ○ |
| C-45 | GetDependencies: パブリックコンストラクタなしで例外 | E-04 (L108-112) CompositionFailedException | ○ |
| C-46 | GetActivator: CompositeActivatorが取得できること | E-04 (L164-206) | ○ |
| C-47 | GetActivator: キャッシュされたActivatorが返却 | E-04 (L166) if (_partActivator != null) | △ |
| C-48 | TryCloseGenericPart: ジェネリック型がクローズできること | E-04 (L222-256) | ○ |
| C-49 | TryCloseGenericPart: 型制約を満たさない場合false | E-04 (L224-234) | ○ |
| C-50 | TryCloseGenericPart: 同じ型引数で二度目はfalse | E-04 (L236-240) _appliedArguments.Any | ○ |
| C-51 | GetPartMetadata: PartMetadataAttributeからメタデータ取得 | E-04 (L208-220) | ○ |
| C-52 | GetPartMetadata: メタデータなしの場合空の辞書 | E-04 (L219) s_noMetadata | ○ |

### DiscoveredExport 関連クラス（UT-CTP-053 - UT-CTP-055）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | GetExportDescriptorPromise: ExportDescriptorPromiseが取得 | E-05 (L30-44) | ○ |
| C-54 | DiscoveredInstanceExport.CloseGenericExport: ジェネリックエクスポートがクローズ | E-06 (L22-27) | ○ |
| C-55 | DiscoveredPropertyExport.CloseGenericExport: プロパティエクスポートがクローズ | E-07 (L36-42) | ○ |

### TypedPartExportDescriptorProvider クラス（UT-CTP-056 - UT-CTP-060）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | Constructor: 型コレクションからプロバイダーが作成 | E-09 (L18-31) | ○ |
| C-57 | GetExportDescriptors: 登録した型のエクスポート記述子が取得 | E-09 (L55-74) | ○ |
| C-58 | GetExportDescriptors: 未登録のコントラクトで空が返却 | E-09 (L61-62) NoExportDescriptors | ○ |
| C-59 | GetExportDescriptors: ジェネリックコントラクトが解決 | E-09 (L104-122) DiscoverGenericParts | ○ |
| C-60 | GetExportDescriptors: メタデータ制約付きコントラクトが解決 | E-09 (L77-100) DiscoverConstrainedParts | △ |

### ContractHelpers クラス（UT-CTP-061 - UT-CTP-069）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | TryGetExplicitImportInfo: Import属性からインポート情報取得 | E-10 (L17-27) | ○ |
| C-62 | TryGetExplicitImportInfo: ImportMany属性からインポート情報取得 | E-10 (L19) ImportManyAttribute | ○ |
| C-63 | TryGetExplicitImportInfo: Import属性なしでfalse | E-10 (L19, L25) | ○ |
| C-64 | GetImportInfo: AllowDefaultがtrueの場合反映 | E-10 (L42) allowDefault = ia.AllowDefault | ○ |
| C-65 | GetImportInfo: コントラクト名が取得できること | E-10 (L41) ia.ContractName | ○ |
| C-66 | GetImportInfo: ImportMetadataConstraint属性からメタデータ制約取得 | E-10 (L57-62) | ○ |
| C-67 | GetImportInfo: ImportとImportMany両方で例外 | E-10 (L81-85) CompositionFailedException | ○ |
| C-68 | IsShared: SharingBoundaryキーがある場合true | E-10 (L95-98) | ○ |
| C-69 | IsShared: SharingBoundaryキーがない場合false | E-10 (L95-98) | ○ |

### ImportInfo クラス（UT-CTP-070 - UT-CTP-072）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | Constructor: ImportInfoが正しく初期化 | E-11 (L13-17) | ○ |
| C-71 | AllowDefault: プロパティが正しく返却 | E-11 (L19) | ○ |
| C-72 | Contract: プロパティが正しく返却 | E-11 (L21) | ○ |

### ActivationFeature 関連クラス（UT-CTP-073 - UT-CTP-089）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | DisposalFeature.RewriteActivator: IDisposable実装型でActivator書き換え | E-13 (L15-30) | ○ |
| C-74 | DisposalFeature.RewriteActivator: IDisposable非実装型でそのまま返却 | E-13 (L21-22) | ○ |
| C-75 | LifetimeFeature.RewriteActivator: 共有パーツでActivator書き換え | E-14 (L18-42) | ○ |
| C-76 | LifetimeFeature.RewriteActivator: 非共有パーツでそのまま返却 | E-14 (L24-25) | ○ |
| C-77 | PropertyInjectionFeature.GetDependencies: Import属性付きプロパティの依存関係取得 | E-15 (L27-59) | ○ |
| C-78 | PropertyInjectionFeature.GetDependencies: Import属性なしの場合空配列 | E-15 (L37-38) NoDependencies | ○ |
| C-79 | PropertyInjectionFeature.RewriteActivator: プロパティインジェクションでActivator書き換え | E-15 (L61-112) | ○ |
| C-80 | PropertyInjectionFeature.RewriteActivator: プロパティインジェクションなしでそのまま返却 | E-15 (L71-72) | ○ |
| C-81 | OnImportsSatisfiedFeature.RewriteActivator: OnImportsSatisfiedメソッド呼び出し | E-16 (L29-64) | ○ |
| C-82 | OnImportsSatisfiedFeature.RewriteActivator: 非publicで例外 | E-16 (L43-48) | ○ |
| C-83 | OnImportsSatisfiedFeature.RewriteActivator: staticで例外 | E-16 (L43) m.IsStatic | ○ |
| C-84 | OnImportsSatisfiedFeature.RewriteActivator: 戻り値がvoidでないで例外 | E-16 (L43) m.ReturnType != typeof(void) | ○ |
| C-85 | OnImportsSatisfiedFeature.RewriteActivator: パラメータありで例外 | E-16 (L44) m.GetParameters().Length != 0 | ○ |
| C-86 | PropertyImportSite.Constructor: 正しく初期化 | E-17 (L15-18) | ○ |
| C-87 | PropertyImportSite.ToString: プロパティ名が返却 | E-17 (L22-25) | ○ |
| C-88 | ParameterImportSite.Constructor: 正しく初期化 | E-08 (L10-13) | ○ |
| C-89 | ParameterImportSite.ToString: パラメータ名が返却 | E-08 (L19-22) | ○ |

### Util クラス（UT-CTP-090 - UT-CTP-096）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | DirectAttributeContext.GetCustomAttributes(Type, MemberInfo): 属性取得 | E-18 (L12-21) | ○ |
| C-91 | DirectAttributeContext.GetCustomAttributes: nullのreflectedTypeで例外 | E-18 (L14) ArgumentNullException | ○ |
| C-92 | DirectAttributeContext.GetCustomAttributes: nullのmemberで例外 | E-18 (L15) ArgumentNullException | ○ |
| C-93 | DirectAttributeContext.GetCustomAttributes: 異なる宣言型で空配列 | E-18 (L17-18) | ○ |
| C-94 | DirectAttributeContext.GetCustomAttributes(Type, ParameterInfo): 属性取得 | E-18 (L23-30) | ○ |
| C-95 | DirectAttributeContext.GetCustomAttributes: nullのreflectedTypeで例外 | E-18 (L27) ArgumentNullException | ○ |
| C-96 | DirectAttributeContext.GetCustomAttributes: nullのparameterで例外 | E-18 (L25) ArgumentNullException.ThrowIfNull | ○ |

### SinglePartExportDescriptorProvider / InstanceExportDescriptorProvider（UT-CTP-097 - UT-CTP-102）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | IsSupportedContract: 一致するコントラクトでtrue | E-19 (L22-39) | ○ |
| C-98 | IsSupportedContract: 型が異なるコントラクトでfalse | E-19 (L24-25) | ○ |
| C-99 | IsSupportedContract: コントラクト名が異なる場合false | E-19 (L24-25) | ○ |
| C-100 | IsSupportedContract: メタデータ制約が一致する場合true | E-19 (L28-36) | ○ |
| C-101 | InstanceExportDescriptorProvider.GetExportDescriptors: ExportDescriptorPromise返却 | E-20 (L19-24) | ○ |
| C-102 | InstanceExportDescriptorProvider.GetExportDescriptors: サポートされないコントラクトで空 | E-20 (L21) IsSupportedContract | ○ |

### AttributedModelProviderExtensions（UT-CTP-103 - UT-CTP-106）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | GetDeclaredAttribute<T>: 指定した型の属性が1つ取得 | E-21 (L14-17) | ○ |
| C-104 | GetDeclaredAttribute<T>: 指定した型の属性がない場合null | E-21 (L16) SingleOrDefault | ○ |
| C-105 | GetDeclaredAttributes: すべての属性が配列で取得 | E-21 (L19-22) | ○ |
| C-106 | GetDeclaredAttributes<T>: 指定した型の属性がすべて取得 | E-21 (L24-27) | ○ |

### Debugging クラス（UT-CTP-107 - UT-CTP-111）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | DiscoveredPartDebuggerProxy.PartType: 型が取得できること | E-22 (L20-23) | ○ |
| C-108 | DiscoveredPartDebuggerProxy.Exports: エクスポート配列が取得 | E-22 (L25-28) | ○ |
| C-109 | ContainerConfigurationDebuggerProxy.AddedExportDescriptorProviders: プロバイダー取得 | E-23 (L27-30) | ○ |
| C-110 | ContainerConfigurationDebuggerProxy.DiscoveredParts: パーツ取得 | E-23 (L32-40) | ○ |
| C-111 | ContainerConfigurationDebuggerProxy.IgnoredTypes: 無視された型取得 | E-23 (L42-50) | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-30 (UT-CTP-030)**: OnImportsSatisfiedメソッドの呼び出しタイミングは実装されているが、CompositionContextExtensions内での具体的な発火順序についてはテストで確認が必要
  - 候補：実行時テスト / インテグレーションテスト

- **C-47 (UT-CTP-047)**: キャッシュ機能は実装詳細であり、同一参照が返されることを保証するテストは実装に依存
  - 候補：実行時テスト / モック使用

- **C-60 (UT-CTP-060)**: メタデータ制約解決の複雑なシナリオはコード上で確認できるが、すべてのエッジケースの網羅性は要確認
  - 候補：既存テストコード / 実行時テスト

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|------------|------|------|
| 1 (中) | ジェネリック型処理 (UT-CTP-038, 039, 048-050, 054-55, 59) | 型引数の組み合わせパターンが多く、エッジケースが存在する可能性 |
| 1 (中) | メタデータ制約解決 (UT-CTP-060) | 複数メタデータの組み合わせシナリオが複雑 |
| 0 (低) | null検証 (複数) | 標準的なArgumentNullException検証 |
| 1 (中) | コンストラクタ選択ロジック (UT-CTP-044, 045) | 複数コンストラクタ存在時のフォールバック動作 |

## 6) レビュアーチェックリスト（最小）

- [ ] 高優先度テストケース（UT-CTP-001〜005, 025〜028, 043〜046, 073, 075, 077, 079, 081, 101）の入力値と期待結果が妥当か
- [ ] ジェネリック型関連テストケースで型制約のエッジケースがカバーされているか
- [ ] 例外スローテストケースで正しい例外型が指定されているか
- [ ] Import/Export属性の組み合わせパターンが網羅されているか
- [ ] OnImportsSatisfied コールバックのタイミング検証が十分か
- [ ] ActivationFeature の連鎖処理（DisposalFeature -> PropertyInjectionFeature -> OnImportsSatisfiedFeature -> LifetimeFeature）が正しく検証されているか
