---
generated_at: 2026-01-30 17:45:00
metrics:
  claims_total: 183
  claims_with_evidence: 180
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート: System.Configuration.ConfigurationManager 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：180 / 183、根拠なし：3
- 優先レビュー（高）
  1. **UT-CFG-166**: SettingsProperty.SerializeAs Binary非推奨動作 - 内部実装の詳細確認が必要
  2. **UT-CFG-014**: OpenMappedExeConfiguration preLoadオプション - ドキュメント不足
  3. **UT-CFG-132**: AppSettingsReader エスケープNone処理 - 特殊ケースの検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/ConfigurationManager.cs`
- E-02: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/Configuration.cs`
- E-03: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/ConfigurationSection.cs`
- E-04: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/ConfigurationElement.cs`
- E-05: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/ConfigurationElementCollection.cs`
- E-06: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/ConfigurationProperty.cs`
- E-07: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/StringValidator.cs`
- E-08: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/IntegerValidator.cs`
- E-09: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/LongValidator.cs`
- E-10: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/TimeSpanValidator.cs`
- E-11: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/RegexStringValidator.cs`
- E-12: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/DefaultValidator.cs`
- E-13: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/GenericEnumConverter.cs`
- E-14: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/TypeNameConverter.cs`
- E-15: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/TimeSpanMinutesConverter.cs`
- E-16: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/InfiniteTimeSpanConverter.cs`
- E-17: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/AppSettingsReader.cs`
- E-18: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/ApplicationSettingsBase.cs`
- E-19: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/LocalFileSettingsProvider.cs`
- E-20: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/SettingsProperty.cs`
- E-21: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/ConfigurationErrorsException.cs`
- E-22: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/SettingsPropertyNotFoundException.cs`
- E-23: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/SettingsPropertyIsReadOnlyException.cs`
- E-24: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/KeyValueConfigurationCollection.cs`
- E-25: `src/libraries/System.Configuration.ConfigurationManager/src/System/Configuration/ConnectionStringSettingsCollection.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConfigurationManager クラス (UT-CFG-001 - UT-CFG-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AppSettingsがNameValueCollectionを返却 | E-01 | ○ |
| C-02 | AppSettings不正宣言で例外スロー | E-01 | ○ |
| C-03 | ConnectionStringsがCollectionを返却 | E-01 | ○ |
| C-04 | ConnectionStrings不正宣言で例外スロー | E-01 | ○ |
| C-05 | GetSectionでセクション取得 | E-01 | ○ |
| C-06 | GetSection null/空入力処理 | E-01 | ○ |
| C-07 | GetSection存在しないセクション | E-01 | ○ |
| C-08 | RefreshSectionキャッシュ更新 | E-01 | ○ |
| C-09 | RefreshSection null/空入力処理 | E-01 | ○ |
| C-10 | OpenMachineConfiguration | E-01 | ○ |
| C-11 | OpenExeConfiguration userLevel | E-01 | ○ |
| C-12 | OpenExeConfiguration exePath | E-01 | ○ |
| C-13 | OpenMappedExeConfiguration | E-01 | ○ |
| C-14 | OpenMappedExeConfiguration preLoad | **根拠不足** | △ |

### Configuration クラス (UT-CFG-015 - UT-CFG-025)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | FilePathプロパティ | E-02 | ○ |
| C-16 | HasFile trueケース | E-02 | ○ |
| C-17 | HasFile falseケース | E-02 | ○ |
| C-18 | GetSection | E-02 | ○ |
| C-19 | GetSectionGroup | E-02 | ○ |
| C-20 | Save | E-02 | ○ |
| C-21 | Save saveMode指定 | E-02 | ○ |
| C-22 | SaveAs | E-02 | ○ |
| C-23 | SaveAs null/空例外 | E-02 | ○ |
| C-24 | Sectionsプロパティ | E-02 | ○ |
| C-25 | SectionGroupsプロパティ | E-02 | ○ |

### ConfigurationSection クラス (UT-CFG-026 - UT-CFG-032)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | SectionInformationプロパティ | E-03 | ○ |
| C-27 | IsModified true | E-03 | ○ |
| C-28 | IsModified false | E-03 | ○ |
| C-29 | ResetModified | E-03 | ○ |
| C-30 | DeserializeSection | E-03 | ○ |
| C-31 | DeserializeSection例外 | E-03 | ○ |
| C-32 | SerializeSection | E-03 | ○ |

### ConfigurationElement クラス (UT-CFG-033 - UT-CFG-039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | Item propertyName | E-04 | ○ |
| C-34 | Item ConfigurationProperty | E-04 | ○ |
| C-35 | IsReadOnly | E-04 | ○ |
| C-36 | SetReadOnly | E-04 | ○ |
| C-37 | Equals 等しい | E-04 | ○ |
| C-38 | Equals 異なる | E-04 | ○ |
| C-39 | GetHashCode | E-04 | ○ |

### ConfigurationElementCollection クラス (UT-CFG-040 - UT-CFG-055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | Count | E-05 | ○ |
| C-41 | BaseAdd | E-05 | ○ |
| C-42 | BaseAdd ReadOnly例外 | E-05 | ○ |
| C-43 | BaseAdd 重複例外 | E-05 | ○ |
| C-44 | BaseRemove | E-05 | ○ |
| C-45 | BaseRemove ReadOnly例外 | E-05 | ○ |
| C-46 | BaseRemoveAt | E-05 | ○ |
| C-47 | BaseRemoveAt 不正インデックス | E-05 | ○ |
| C-48 | BaseGet key | E-05 | ○ |
| C-49 | BaseGet 存在しないキー | E-05 | ○ |
| C-50 | BaseGet index | E-05 | ○ |
| C-51 | BaseGet 不正インデックス | E-05 | ○ |
| C-52 | BaseClear | E-05 | ○ |
| C-53 | BaseClear ReadOnly例外 | E-05 | ○ |
| C-54 | GetEnumerator | E-05 | ○ |
| C-55 | BaseGetAllKeys | E-05 | ○ |

### KeyValueConfigurationCollection クラス (UT-CFG-056 - UT-CFG-062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | Add element | E-24 | ○ |
| C-57 | Add 重複キー連結 | E-24 | ○ |
| C-58 | Add key, value | E-24 | ○ |
| C-59 | Remove | E-24 | ○ |
| C-60 | Clear | E-24 | ○ |
| C-61 | Item indexer | E-24 | ○ |
| C-62 | AllKeys | E-24 | ○ |

### ConnectionStringSettingsCollection クラス (UT-CFG-063 - UT-CFG-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | Add | E-25 | ○ |
| C-64 | Remove settings | E-25 | ○ |
| C-65 | Remove name | E-25 | ○ |
| C-66 | RemoveAt | E-25 | ○ |
| C-67 | Clear | E-25 | ○ |
| C-68 | Item int | E-25 | ○ |
| C-69 | Item string | E-25 | ○ |
| C-70 | IndexOf | E-25 | ○ |

### ConfigurationProperty クラス (UT-CFG-071 - UT-CFG-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | Name | E-06 | ○ |
| C-72 | Type | E-06 | ○ |
| C-73 | DefaultValue | E-06 | ○ |
| C-74 | IsRequired | E-06 | ○ |
| C-75 | IsKey | E-06 | ○ |
| C-76 | Converter | E-06 | ○ |
| C-77 | Validator | E-06 | ○ |
| C-78 | Validate 成功 | E-06 | ○ |
| C-79 | Validate 失敗 | E-06 | ○ |

### Validator クラス群 (UT-CFG-080 - UT-CFG-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | StringValidator CanValidate string | E-07 | ○ |
| C-81 | StringValidator CanValidate other | E-07 | ○ |
| C-82 | StringValidator Validate 成功 | E-07 | ○ |
| C-83 | StringValidator minLength | E-07 | ○ |
| C-84 | StringValidator maxLength | E-07 | ○ |
| C-85 | StringValidator invalidChars | E-07 | ○ |
| C-86 | StringValidator null | E-07 | ○ |
| C-87 | IntegerValidator CanValidate int | E-08 | ○ |
| C-88 | IntegerValidator CanValidate other | E-08 | ○ |
| C-89 | IntegerValidator Validate 成功 | E-08 | ○ |
| C-90 | IntegerValidator min | E-08 | ○ |
| C-91 | IntegerValidator max | E-08 | ○ |
| C-92 | IntegerValidator 排他範囲 有効 | E-08 | ○ |
| C-93 | IntegerValidator 排他範囲 無効 | E-08 | ○ |
| C-94 | IntegerValidator resolution 有効 | E-08 | ○ |
| C-95 | IntegerValidator resolution 無効 | E-08 | ○ |
| C-96 | IntegerValidator Constructor resolution | E-08 | ○ |
| C-97 | IntegerValidator Constructor min>max | E-08 | ○ |
| C-98 | LongValidator CanValidate | E-09 | ○ |
| C-99 | LongValidator Validate 成功 | E-09 | ○ |
| C-100 | LongValidator Validate 失敗 | E-09 | ○ |
| C-101 | TimeSpanValidator CanValidate | E-10 | ○ |
| C-102 | TimeSpanValidator Validate 成功 | E-10 | ○ |
| C-103 | TimeSpanValidator Validate 失敗 | E-10 | ○ |
| C-104 | TimeSpanValidator Constructor | E-10 | ○ |
| C-105 | RegexStringValidator CanValidate | E-11 | ○ |
| C-106 | RegexStringValidator Validate 成功 | E-11 | ○ |
| C-107 | RegexStringValidator Validate 失敗 | E-11 | ○ |
| C-108 | RegexStringValidator Constructor | E-11 | ○ |
| C-109 | DefaultValidator CanValidate | E-12 | ○ |
| C-110 | DefaultValidator Validate | E-12 | ○ |

### Converter クラス群 (UT-CFG-111 - UT-CFG-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | GenericEnumConverter ConvertTo | E-13 | ○ |
| C-112 | GenericEnumConverter ConvertFrom 成功 | E-13 | ○ |
| C-113 | GenericEnumConverter ConvertFrom 失敗 | E-13 | ○ |
| C-114 | GenericEnumConverter 数値文字列拒否 | E-13 | ○ |
| C-115 | GenericEnumConverter Constructor null | E-13 | ○ |
| C-116 | TypeNameConverter ConvertTo | E-14 | ○ |
| C-117 | TypeNameConverter ConvertFrom 成功 | E-14 | ○ |
| C-118 | TypeNameConverter ConvertFrom 失敗 | E-14 | ○ |
| C-119 | TimeSpanMinutesConverter ConvertTo | E-15 | ○ |
| C-120 | TimeSpanMinutesConverter ConvertFrom | E-15 | ○ |
| C-121 | InfiniteTimeSpanConverter ConvertTo Infinite | E-16 | ○ |
| C-122 | InfiniteTimeSpanConverter ConvertTo 通常 | E-16 | ○ |
| C-123 | InfiniteTimeSpanConverter ConvertFrom Infinite | E-16 | ○ |
| C-124 | InfiniteTimeSpanConverter ConvertFrom 通常 | E-16 | ○ |

### AppSettingsReader クラス (UT-CFG-125 - UT-CFG-132)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | GetValue 成功 | E-17 | ○ |
| C-126 | GetValue 型変換 | E-17 | ○ |
| C-127 | GetValue キー不在 | E-17 | ○ |
| C-128 | GetValue key null | E-17 | ○ |
| C-129 | GetValue type null | E-17 | ○ |
| C-130 | GetValue 型変換エラー | E-17 | ○ |
| C-131 | GetValue None | E-17 | ○ |
| C-132 | GetValue エスケープNone | **根拠不足** | △ |

### ApplicationSettingsBase クラス (UT-CFG-133 - UT-CFG-148)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | SettingsKey | E-18 | ○ |
| C-134 | Context | E-18 | ○ |
| C-135 | Properties | E-18 | ○ |
| C-136 | Providers | E-18 | ○ |
| C-137 | PropertyValues | E-18 | ○ |
| C-138 | Item get | E-18 | ○ |
| C-139 | Item set | E-18 | ○ |
| C-140 | Item キャンセル | E-18 | ○ |
| C-141 | Save | E-18 | ○ |
| C-142 | Save キャンセル | E-18 | ○ |
| C-143 | Reload | E-18 | ○ |
| C-144 | Reset | E-18 | ○ |
| C-145 | Upgrade | E-18 | ○ |
| C-146 | GetPreviousVersion | E-18 | ○ |
| C-147 | GetPreviousVersion 空例外 | E-18 | ○ |
| C-148 | GetPreviousVersion 不在例外 | E-18 | ○ |

### LocalFileSettingsProvider クラス (UT-CFG-149 - UT-CFG-160)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-149 | Initialize | E-19 | ○ |
| C-150 | Initialize デフォルト名 | E-19 | ○ |
| C-151 | ApplicationName | E-19 | ○ |
| C-152 | GetPropertyValues | E-19 | ○ |
| C-153 | GetPropertyValues 接続文字列 | E-19 | ○ |
| C-154 | GetPropertyValues 非対応例外 | E-19 | ○ |
| C-155 | SetPropertyValues | E-19 | ○ |
| C-156 | SetPropertyValues 分離保存 | E-19 | ○ |
| C-157 | Reset | E-19 | ○ |
| C-158 | Upgrade | E-19 | ○ |
| C-159 | GetPreviousVersion | E-19 | ○ |
| C-160 | GetPreviousVersion 不在 | E-19 | ○ |

### SettingsProperty クラス (UT-CFG-161 - UT-CFG-169)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-161 | Name | E-20 | ○ |
| C-162 | PropertyType | E-20 | ○ |
| C-163 | IsReadOnly | E-20 | ○ |
| C-164 | DefaultValue | E-20 | ○ |
| C-165 | SerializeAs | E-20 | ○ |
| C-166 | SerializeAs Binary非推奨 | **根拠不足** | △ |
| C-167 | Provider | E-20 | ○ |
| C-168 | Attributes | E-20 | ○ |
| C-169 | Constructor コピー | E-20 | ○ |

### 例外クラス群 (UT-CFG-170 - UT-CFG-183)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-170 | ConfigurationErrorsException Message file+line | E-21 | ○ |
| C-171 | ConfigurationErrorsException Message file | E-21 | ○ |
| C-172 | ConfigurationErrorsException Message line | E-21 | ○ |
| C-173 | ConfigurationErrorsException Filename | E-21 | ○ |
| C-174 | ConfigurationErrorsException Line | E-21 | ○ |
| C-175 | ConfigurationErrorsException Errors | E-21 | ○ |
| C-176 | GetLineNumber XmlNode | E-21 | ○ |
| C-177 | GetFilename XmlNode | E-21 | ○ |
| C-178 | GetLineNumber XmlReader | E-21 | ○ |
| C-179 | GetFilename XmlReader | E-21 | ○ |
| C-180 | SettingsPropertyNotFoundException message | E-22 | ○ |
| C-181 | SettingsPropertyNotFoundException message+inner | E-22 | ○ |
| C-182 | SettingsPropertyIsReadOnlyException message | E-23 | ○ |
| C-183 | SettingsPropertyIsReadOnlyException message+inner | E-23 | ○ |

## 4) 不足情報（Unknown / Missing）

- **UT-CFG-014 (OpenMappedExeConfiguration preLoad)**: preLoadパラメータの詳細な動作仕様が公式ドキュメントで明確でない
  - 候補：Microsoft公式ドキュメント / 既存テストコード / 内部実装コメント
- **UT-CFG-132 (AppSettingsReader エスケープNone処理)**: `((None))` が `(None)` に変換される仕様の公式根拠が不明確
  - 候補：AppSettingsReader内部実装 / 既存テストケース
- **UT-CFG-166 (SettingsProperty Binary非推奨)**: EnableUnsafeBinaryFormatterスイッチの動作詳細
  - 候補：.NET セキュリティガイドライン / BinaryFormatter非推奨ドキュメント

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 説明 |
|---|---|---|
| 1 (中) | Validator境界値テスト | 境界値の具体的な値が実装依存の可能性 |
| 1 (中) | 例外メッセージフォーマット | ローカライズやフォーマット変更の可能性 |
| 0 (低) | Converterテスト | 標準的なTypeConverter動作に依存 |

## 6) レビュアーチェックリスト（最小）

- [ ] ConfigurationManagerの静的プロパティ（AppSettings, ConnectionStrings）のスレッドセーフティが考慮されているか
- [ ] バリデーターの境界値テストで、int/longの最大値・最小値が適切にカバーされているか
- [ ] 例外テストで、実際にスローされる例外型が正しいか（ArgumentException vs ConfigurationErrorsException）
- [ ] LocalFileSettingsProviderのローミング/ローカル設定の分離が正しくテストされているか
- [ ] Binary シリアライズの非推奨警告テストが最新の.NET仕様に準拠しているか
