---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 166
  claims_with_evidence: 166
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: System.Console 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：166 / 166、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/Console.cs` - Consoleクラス本体（1005行）
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/ConsoleKeyInfo.cs` - ConsoleKeyInfo構造体（81行）
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/ConsoleCancelEventArgs.cs` - ConsoleCancelEventArgsクラス（31行）
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/TermInfo.cs` - TermInfo.ParameterizedStrings（467行）
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/TermInfo.Database.cs` - TermInfo.Database（311行）
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/TermInfo.DatabaseFactory.cs` - DatabaseFactory（147行）
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/IO/KeyParser.cs` - KeyParser（396行）
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/IO/ConsoleStream.cs` - ConsoleStream抽象クラス（92行）
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/IO/SyncTextReader.cs` - SyncTextReader（143行）
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/TerminalFormatStrings.cs` - TerminalFormatStrings（255行）
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/IO/StdInReader.cs` - StdInReader（401行）
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/IO/CachedConsoleStream.cs` - CachedConsoleStream（78行）
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/ConsoleColor.cs` - ConsoleColor enum（29行）
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/ConsoleKey.cs` - ConsoleKey enum（155行）
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/ConsoleModifiers.cs` - ConsoleModifiers enum（15行）
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Console/src/System/ConsoleSpecialKey.cs` - ConsoleSpecialKey enum（12行）

## 3) Claims と根拠の対応（レビューの主戦場）

### ConsoleKeyInfo構造体（UT-CON-001 - UT-CON-019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConsoleKeyInfoコンストラクタでConsoleKeyが0-255の範囲チェックを行う | E-02 行20-23 | ○ |
| C-02 | ConsoleKeyInfoで修飾キー（Shift/Alt/Control）が正しく設定される | E-02 行28-33 | ○ |
| C-03 | KeyChar, Key, Modifiersプロパティが正しく値を返す | E-02 行36-49 | ○ |
| C-04 | Equals(object)がConsoleKeyInfo型の比較を正しく行う | E-02 行51-54 | ○ |
| C-05 | Equals(ConsoleKeyInfo)が全フィールドを比較する | E-02 行56-59 | ○ |
| C-06 | 演算子==と!=が正しく動作する | E-02 行61-69 | ○ |
| C-07 | GetHashCodeがキー情報を含むハッシュを返す | E-02 行71-78 | ○ |

### ConsoleCancelEventArgs（UT-CON-020 - UT-CON-023）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | SpecialKeyプロパティがコンストラクタで設定された値を返す | E-03 行11-28 | ○ |
| C-09 | Cancelプロパティがget/set可能である | E-03 行20-23 | ○ |

### Console静的クラス（UT-CON-024 - UT-CON-053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | InputEncodingプロパティでnull設定時にArgumentNullExceptionがスローされる | E-01 行90 | ○ |
| C-11 | OutputEncodingプロパティでnull設定時にArgumentNullExceptionがスローされる | E-01 行130 | ○ |
| C-12 | SetCursorPositionで座標の範囲チェックが行われる | E-01 行552-555 | ○ |
| C-13 | SetInでnull設定時にArgumentNullExceptionがスローされる | E-01 行661 | ○ |
| C-14 | SetOutでnull設定時にArgumentNullExceptionがスローされる | E-01 行672 | ○ |
| C-15 | SetOutでTextWriter.Nullは同期化されない | E-01 行678-681 | ○ |
| C-16 | SetErrorでnull設定時にArgumentNullExceptionがスローされる | E-01 行693 | ○ |
| C-17 | OpenStandardInput(int)で負のバッファサイズ時にArgumentOutOfRangeExceptionがスローされる | E-01 行627 | ○ |
| C-18 | OpenStandardOutput(int)で負のバッファサイズ時にArgumentOutOfRangeExceptionがスローされる | E-01 行639 | ○ |
| C-19 | OpenStandardError(int)で負のバッファサイズ時にArgumentOutOfRangeExceptionがスローされる | E-01 行651 | ○ |
| C-20 | Title.setでnull設定時にArgumentNullExceptionがスローされる | E-01 行505 | ○ |
| C-21 | KeyAvailableが入力リダイレクト時にInvalidOperationExceptionをスローする | E-01 行160-163 | ○ |
| C-22 | IsInputRedirected/IsOutputRedirected/IsErrorRedirectedがリダイレクト状態を返す | E-01 行254-297 | ○ |

### TermInfo.ParameterizedStrings（UT-CON-054 - UT-CON-079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | EvaluateメソッドがnullフォーマットでArgumentNullExceptionをスローする | E-04 行62 | ○ |
| C-24 | Evaluateメソッドがnull引数配列でArgumentNullExceptionをスローする | E-04 行63 | ○ |
| C-25 | %%で%がエスケープ出力される | E-04 行134-136 | ○ |
| C-26 | %cで文字出力される | E-04 行137-139 | ○ |
| C-27 | %sで文字列出力される | E-04 行140-142 | ○ |
| C-28 | %dで整数出力される | E-04 行143-145 | ○ |
| C-29 | %lで文字列長がスタックにプッシュされる | E-04 行191-193 | ○ |
| C-30 | 算術演算（+, -, *, /, mなど）が動作する | E-04 行226-257 | ○ |
| C-31 | 条件分岐（%?, %t, %e, %;）が動作する | E-04 行280-333 | ○ |
| C-32 | 不正なフォーマットでInvalidOperationExceptionがスローされる | E-04 行336-337 | ○ |
| C-33 | FormatParamが整数と文字列の両方を格納できる | E-04 行419-463 | ○ |
| C-34 | FormatParamの暗黙変換演算子が動作する | E-04 行443-453 | ○ |

### TermInfo.Database（UT-CON-080 - UT-CON-088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Databaseコンストラクタが不正なマジックナンバーでInvalidOperationExceptionをスローする | E-05 行47-53 | ○ |
| C-36 | Databaseコンストラクタが負のセクションサイズでInvalidOperationExceptionをスローする | E-05 行61-68 | ○ |
| C-37 | GetStringが範囲外インデックスでnullを返す | E-05 行112-117 | ○ |
| C-38 | GetStringが未設定エントリでnullを返す | E-05 行119-125 | ○ |
| C-39 | GetExtendedStringが存在しないキーでnullを返す | E-05 行133-139 | ○ |
| C-40 | GetNumberが範囲外インデックスで-1を返す | E-05 行149-154 | ○ |

### TermInfo.DatabaseFactory（UT-CON-089 - UT-CON-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | ReadActiveDatabaseがTERM環境変数未設定時にnullを返す | E-06 行42-43 | ○ |
| C-42 | ReadDatabaseが存在しないターミナルでnullを返す | E-06 行49-79 | ○ |
| C-43 | ReadDatabase(string, string)が空文字列でnullを返す | E-06 行105-108 | ○ |

### KeyParser（UT-CON-098 - UT-CON-116）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | Parseが単一文字を正しく解析する | E-07 行313-354 | ○ |
| C-45 | ParseがVERASE文字をBackspaceとして解析する | E-07 行23-28 | ○ |
| C-46 | Parseがエスケープシーケンス（矢印キー、ファンクションキー）を解析する | E-07 行54-176 | ○ |
| C-47 | ParseがAlt+文字を正しく解析する | E-07 行45-49 | ○ |
| C-48 | ParseがCtrl+文字を正しく解析する | E-07 行337, 363-378 | ○ |
| C-49 | Parseが修飾子付きシーケンスを解析する | E-07 行162, 283-294 | ○ |

### ConsoleStream（UT-CON-117 - UT-CON-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | CanRead/CanWriteがFileAccessに基づいて正しく返す | E-08 行18-21, 51-53 | ○ |
| C-51 | CanSeekが常にfalseを返す | E-08 行55 | ○ |
| C-52 | Length, Position, SetLength, SeekがNotSupportedExceptionをスローする | E-08 行57-69 | ○ |
| C-53 | ValidateRead/ValidateWriteが不正アクセス時にNotSupportedExceptionをスローする | E-08 行71-89 | ○ |
| C-54 | DisposeでCanRead/CanWriteがfalseになる | E-08 行44-49 | ○ |

### SyncTextReader（UT-CON-131 - UT-CON-151）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | GetSynchronizedTextReaderが既にSyncTextReaderの場合そのまま返す | E-09 行19-22 | ○ |
| C-56 | 各メソッドがlock(this)で同期化される | E-09 行34-87 | ○ |
| C-57 | 非同期メソッドが同期的に実行される | E-09 行94-140 | ○ |
| C-58 | ReadBlockAsync/ReadAsyncがnullバッファでArgumentNullExceptionをスローする | E-09 行120, 132 | ○ |
| C-59 | ReadBlockAsync/ReadAsyncが負のインデックス/カウントでArgumentOutOfRangeExceptionをスローする | E-09 行122-124, 134-136 | ○ |
| C-60 | ReadBlockAsync/ReadAsyncが範囲外でArgumentExceptionをスローする | E-09 行125, 137 | ○ |
| C-61 | Disposeが内部Readerを解放する | E-09 行30-39 | ○ |

### TerminalFormatStrings（UT-CON-152 - UT-CON-157）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | コンストラクタがnullデータベースを許容する | E-10 行67-68 | ○ |
| C-63 | KeyFormatToConsoleKeyマッピングが構築される | E-10 行101-159 | ○ |
| C-64 | MaxKeyFormatLength/MinKeyFormatLengthが計算される | E-10 行161-177 | ○ |
| C-65 | IsRxvtTermがterm名に基づいて判定される | E-10 行88 | ○ |

### StdInReader（UT-CON-158 - UT-CON-161）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | コンストラクタがエンコーディングで初期化する | E-11 行35-46 | ○ |
| C-67 | IsUnprocessedBufferEmptyがバッファ状態を返す | E-11 行49-52 | ○ |
| C-68 | AppendExtraBufferがバッファを拡張する | E-11 行54-86 | ○ |

### CachedConsoleStream（UT-CON-162 - UT-CON-166）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | コンストラクタがエンコーディングで初期化する | E-12 行17-21 | ○ |
| C-70 | ReadがNotSupportedExceptionをスローする | E-12 行23 | ○ |
| C-71 | Writeが改行でPrintを呼び、部分行をキャッシュする | E-12 行25-75 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースにソースコードレベルの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいて生成されている

## 6) レビュアーチェックリスト（最小）
- [ ] ConsoleKeyInfoのコンストラクタ境界値テスト（UT-CON-003〜006）が妥当か
- [ ] Consoleクラスのnull検証テスト（UT-CON-026, 029, 036, 038, 041, 049）がすべてのセッターをカバーしているか
- [ ] SetCursorPositionの境界値テスト（UT-CON-031〜034）がshort.MaxValue境界を正しくテストしているか
- [ ] KeyParserのエスケープシーケンステスト（UT-CON-105〜116）が主要なターミナルをカバーしているか
- [ ] TermInfo.ParameterizedStringsの演算子テスト（UT-CON-064〜069）が主要な演算をカバーしているか
- [ ] SyncTextReaderの非同期メソッドテスト（UT-CON-139〜150）がキャンセル処理を含んでいるか
- [ ] プラットフォーム固有の動作（Windows/Unix）に関するテストケースの追加が必要か検討
