---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 135
  claims_with_evidence: 132
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：System.Formats.Tar 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：132 / 135、根拠なし：3
- 優先レビュー（高）
  1. **UT-TAR-074 (ExtractToFile 親ディレクトリ不在)**: IOException動作の実装詳細確認要
  2. **UT-TAR-128 (TarHeader.ReplaceNormalAttributesWithExtended)**: 内部メソッドのため公開API観点での妥当性確認要
  3. **UT-TAR-134/135 (PaxGlobalExtendedAttributesTarEntry)**: 参照ファイル読み込み未実施

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/TarReader.cs`
- E-02: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/TarWriter.cs`
- E-03: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/TarFile.cs`
- E-04: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/TarEntry.cs`
- E-05: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/TarHelpers.cs`
- E-06: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/TarHeader.cs`
- E-07: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/PaxTarEntry.cs`
- E-08: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/GnuTarEntry.cs`
- E-09: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/V7TarEntry.cs`
- E-10: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/UstarTarEntry.cs`
- E-11: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/PosixTarEntry.cs`
- E-12: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/SubReadStream.cs`
- E-13: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/TarEntryType.cs`
- E-14: `src/libraries/System.Formats.Tar/src/System/Formats/Tar/TarEntryFormat.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### TarReader クラス (UT-TAR-001 〜 UT-TAR-013)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TarReader コンストラクタでnull検証 | E-01 (L35: ArgumentNullException.ThrowIfNull) | ○ |
| C-02 | TarReader コンストラクタでCanRead検証 | E-01 (L37-40: CanRead check, ArgumentException) | ○ |
| C-03 | GetNextEntry でエントリ読み取り | E-01 (L115-157: GetNextEntry実装) | ○ |
| C-04 | GetNextEntry で空アーカイブ時null返却 | E-01 (L125-129: Length==0 check) | ○ |
| C-05 | GetNextEntry copyData=true でMemoryStreamコピー | E-01 (L103-105: copyData parameter) | ○ |
| C-06 | GetNextEntryAsync 非同期読み取り | E-01 (L175-197: GetNextEntryAsync実装) | ○ |
| C-07 | Dispose でストリーム解放 | E-01 (L54-73: Dispose実装) | ○ |
| C-08 | Dispose leaveOpen=true でストリーム保持 | E-01 (L60: !_leaveOpen条件) | ○ |
| C-09 | DisposeAsync 非同期解放 | E-01 (L79-98: DisposeAsync実装) | ○ |

### TarWriter クラス (UT-TAR-014 〜 UT-TAR-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | TarWriter コンストラクタでnull検証 | E-02 (L64: ArgumentNullException.ThrowIfNull) | ○ |
| C-11 | TarWriter コンストラクタでCanWrite検証 | E-02 (L66-69: CanWrite check) | ○ |
| C-12 | TarWriter コンストラクタでformat検証 | E-02 (L71-74: format validation) | ○ |
| C-13 | WriteEntry(TarEntry) でエントリ書き込み | E-02 (L235-242: WriteEntry実装) | ○ |
| C-14 | WriteEntry でnull検証 | E-02 (L238: ArgumentNullException.ThrowIfNull) | ○ |
| C-15 | WriteEntry でObjectDisposedException | E-02 (L237: ObjectDisposedException.ThrowIf) | ○ |
| C-16 | WriteEntry でLinkName検証 | E-02 (L239: ValidateEntryLinkName, L402-411) | ○ |
| C-17 | WriteEntry(string, string) ファイルからの書き込み | E-02 (L143-147: WriteEntry実装) | ○ |
| C-18 | WriteEntryAsync 非同期書き込み | E-02 (L279-291: WriteEntryAsync実装) | ○ |
| C-19 | Dispose で終端レコード書き込み | E-02 (L92-108: Dispose, L359-366: WriteFinalRecords) | ○ |
| C-20 | Format プロパティ取得 | E-02 (L87: Format property) | ○ |

### TarFile クラス (UT-TAR-029 〜 UT-TAR-044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | CreateFromDirectory でアーカイブ作成 | E-03 (L31-50: CreateFromDirectory実装) | ○ |
| C-22 | CreateFromDirectory でnull/empty検証 | E-03 (L33-34: ArgumentException.ThrowIfNullOrEmpty) | ○ |
| C-23 | CreateFromDirectory でディレクトリ存在確認 | E-03 (L41-44: Directory.Exists check) | ○ |
| C-24 | CreateFromDirectory でストリーム書き込み可能性検証 | E-03 (L36-39: CanWrite check) | ○ |
| C-25 | CreateFromDirectoryAsync 非同期作成 | E-03 (L66-89: CreateFromDirectoryAsync実装) | ○ |
| C-26 | ExtractToDirectory で展開 | E-03 (L171-191: ExtractToDirectory実装) | ○ |
| C-27 | ExtractToDirectory でnull検証 | E-03 (L173-174: ArgumentNullException/ArgumentException) | ○ |
| C-28 | ExtractToDirectory でディレクトリ存在確認 | E-03 (L181-184: Directory.Exists check) | ○ |
| C-29 | ExtractToDirectory でストリーム読み取り可能性検証 | E-03 (L176-179: CanRead check) | ○ |
| C-30 | ExtractToDirectoryAsync 非同期展開 | E-03 (L212-236: ExtractToDirectoryAsync実装) | ○ |

### TarEntry クラス (UT-TAR-045 〜 UT-TAR-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | Name プロパティ取得・設定 | E-04 (L160-168: Name property) | ○ |
| C-32 | Name 空文字/null検証 | E-04 (L165: ArgumentException.ThrowIfNullOrEmpty) | ○ |
| C-33 | LinkName プロパティ取得・設定 | E-04 (L124-136: LinkName property) | ○ |
| C-34 | LinkName 非リンクエントリ検証 | E-04 (L129-132: typeFlag check, InvalidOperationException) | ○ |
| C-35 | LinkName 空文字検証 | E-04 (L133: ArgumentException.ThrowIfNullOrEmpty) | ○ |
| C-36 | Mode プロパティ取得・設定 | E-04 (L142-155: Mode property) | ○ |
| C-37 | Mode 範囲検証 | E-04 (L149-152: ValidUnixFileModes check) | ○ |
| C-38 | ModificationTime プロパティ取得・設定 | E-04 (L99-110: ModificationTime property) | ○ |
| C-39 | ModificationTime V7/Ustar範囲検証 | E-04 (L104-107: FormatIsOctalOnly, UnixEpoch check) | ○ |
| C-40 | DataStream プロパティ取得・設定 | E-04 (L253-282: DataStream property) | ○ |
| C-41 | DataStream エントリタイプ検証 | E-04 (L258-261: IsDataStreamSetterSupported) | ○ |
| C-42 | DataStream ストリーム読み取り可能性検証 | E-04 (L263-266: CanRead check) | ○ |
| C-43 | Length プロパティ取得 | E-04 (L116: Length property) | ○ |
| C-44 | Checksum プロパティ取得 | E-04 (L72: Checksum property) | ○ |
| C-45 | EntryType プロパティ取得 | E-04 (L77: EntryType property) | ○ |
| C-46 | Format プロパティ取得 | E-04 (L82: Format property) | ○ |
| C-47 | Gid/Uid プロパティ取得・設定 | E-04 (L88-92, L174-178: Gid/Uid properties) | ○ |
| C-48 | DataOffset プロパティ取得 | E-04 (L291: DataOffset property) | ○ |
| C-49 | ToString でName返却 | E-04 (L297: ToString implementation) | ○ |
| C-50 | ExtractToFile ファイル展開 | E-04 (L200-208: ExtractToFile実装) | ○ |
| C-51 | ExtractToFile overwrite検証 | E-04 (L503-528: VerifyDestinationPath) | ○ |
| C-52 | ExtractToFile SymbolicLink/HardLink検証 | E-04 (L203-206: EntryType check) | ○ |
| C-53 | ExtractToFile パス検証 | E-04 (L202: ArgumentException.ThrowIfNullOrEmpty) | ○ |
| C-54 | ExtractToFile 親ディレクトリ存在確認 | E-04 (L505-510: Path.Exists check) | △ |
| C-55 | ExtractToFileAsync 非同期展開 | E-04 (L230-242: ExtractToFileAsync実装) | ○ |

### PaxTarEntry クラス (UT-TAR-078 〜 UT-TAR-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | PaxTarEntry コンストラクタ (entryType, entryName) | E-07 (L37-41: constructor) | ○ |
| C-57 | PaxTarEntry コンストラクタ (extendedAttributes) | E-07 (L65-72: constructor with extendedAttributes) | ○ |
| C-58 | PaxTarEntry 変換コンストラクタ | E-07 (L83-106: conversion constructor) | ○ |
| C-59 | PaxTarEntry GlobalExtendedAttributes変換制限 | E-04 (L55-58: PaxGlobalExtendedAttributesTarEntry check) | ○ |
| C-60 | ExtendedAttributes プロパティ取得 | E-07 (L123: ExtendedAttributes property) | ○ |

### GnuTarEntry クラス (UT-TAR-084 〜 UT-TAR-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | GnuTarEntry コンストラクタ | E-08 (L37-39: constructor) | ○ |
| C-62 | GnuTarEntry 変換コンストラクタ | E-08 (L50-65: conversion constructor) | ○ |
| C-63 | AccessTime プロパティ取得・設定 | E-08 (L74-81: AccessTime property) | ○ |
| C-64 | ChangeTime プロパティ取得・設定 | E-08 (L90-97: ChangeTime property) | ○ |

### UstarTarEntry / V7TarEntry クラス (UT-TAR-088 〜 UT-TAR-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | UstarTarEntry コンストラクタ | E-10 (L32-36: constructor) | ○ |
| C-66 | UstarTarEntry 変換コンストラクタ | E-10 (L44-55: conversion constructor) | ○ |
| C-67 | V7TarEntry コンストラクタ | E-09 (L27-30: constructor) | ○ |
| C-68 | V7TarEntry 変換コンストラクタ | E-09 (L38-41: conversion constructor) | ○ |
| C-69 | V7TarEntry エントリタイプ検証 | E-05 (L317-326: V7 supported types) | ○ |

### PosixTarEntry クラス (UT-TAR-093 〜 UT-TAR-101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | DeviceMajor プロパティ取得・設定 | E-11 (L54-72: DeviceMajor property) | ○ |
| C-71 | DeviceMajor エントリタイプ検証 | E-11 (L59-62: BlockDevice/CharacterDevice check) | ○ |
| C-72 | DeviceMajor 範囲検証 | E-11 (L64-68: negative/max value check) | ○ |
| C-73 | DeviceMinor プロパティ取得・設定 | E-11 (L80-98: DeviceMinor property) | ○ |
| C-74 | DeviceMinor V7/Ustar範囲検証 | E-11 (L91-94: FormatIsOctalOnly, max value) | ○ |
| C-75 | GroupName プロパティ取得・設定 | E-11 (L105-113: GroupName property) | ○ |
| C-76 | GroupName null検証 | E-11 (L110: ArgumentNullException.ThrowIfNull) | ○ |
| C-77 | UserName プロパティ取得・設定 | E-11 (L120-128: UserName property) | ○ |
| C-78 | UserName null検証 | E-11 (L125: ArgumentNullException.ThrowIfNull) | ○ |

### TarHelpers クラス (UT-TAR-102 〜 UT-TAR-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | CalculatePadding 計算 | E-05 (L125-130: CalculatePadding実装) | ○ |
| C-80 | IsAllNullBytes ゼロ検出 | E-05 (L133-134: IsAllNullBytes実装) | ○ |
| C-81 | ParseOctal 8進数パース | E-05 (L241-267: ParseOctal実装) | ○ |
| C-82 | ParseOctal 不正文字検出 | E-05 (L257-261: digit check, ThrowInvalidNumber) | ○ |
| C-83 | GetDateTimeOffsetFromSecondsSinceEpoch 変換 | E-05 (L137-138: 実装) | ○ |
| C-84 | GetTimestampStringFromDateTimeOffset 変換 | E-05 (L163-169: 実装) | ○ |
| C-85 | ThrowIfEntryTypeNotSupported 検証 | E-05 (L313-391: 実装) | ○ |
| C-86 | GetCorrectTypeFlagForFormat 変換 | E-05 (L200-215: 実装) | ○ |

### SubReadStream クラス (UT-TAR-115 〜 UT-TAR-127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | SubReadStream コンストラクタ | E-12 (L24-36: constructor) | ○ |
| C-88 | SubReadStream CanRead検証 | E-12 (L26-29: CanRead check) | ○ |
| C-89 | Read 範囲制限 | E-12 (L108-119: Read実装, LimitByRemaining) | ○ |
| C-90 | Length プロパティ | E-12 (L38-45: Length property) | ○ |
| C-91 | Position プロパティ取得 | E-12 (L47-59: Position property) | ○ |
| C-92 | Position 設定不可 | E-12 (L56-58: InvalidOperationException) | ○ |
| C-93 | Seek 不可 | E-12 (L164: NotSupportedException) | ○ |
| C-94 | Write 不可 | E-12 (L168: NotSupportedException) | ○ |
| C-95 | AdvanceToEnd 終端スキップ | E-12 (L80-87: AdvanceToEnd実装) | ○ |
| C-96 | AdvanceToEndAsync 非同期終端スキップ | E-12 (L71-78: AdvanceToEndAsync実装) | ○ |
| C-97 | Dispose リソース解放 | E-12 (L178-182: Dispose実装) | ○ |
| C-98 | ReadAsync 非同期読み取り | E-12 (L138-162: ReadAsync実装) | ○ |

### TarHeader クラス (UT-TAR-128 〜 UT-TAR-133)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | ReplaceNormalAttributesWithExtended 属性置換 | E-06 (内部メソッド、TarHeader.Read.csに実装) | △ |
| C-100 | ExtendedAttributes プロパティ | E-06 (L78: ExtendedAttributes property) | ○ |
| C-101 | AddExtendedAttributes 追加 | E-06 (L111-135: AddExtendedAttributes実装) | ○ |
| C-102 | AddExtendedAttributes キー検証 | E-06 (L121-125: key validation) | ○ |
| C-103 | AddExtendedAttributes 値検証 | E-06 (L126-129: value validation) | ○ |

### PaxGlobalExtendedAttributesTarEntry クラス (UT-TAR-134 〜 UT-TAR-135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | PaxGlobalExtendedAttributesTarEntry コンストラクタ | E-未読込 (PaxGlobalExtendedAttributesTarEntry.cs) | △ |
| C-105 | GlobalExtendedAttributes プロパティ | E-未読込 (PaxGlobalExtendedAttributesTarEntry.cs) | △ |

## 4) 不足情報（Unknown / Missing）

- **PaxGlobalExtendedAttributesTarEntry.cs の詳細解析未実施**
  - 候補：src/libraries/System.Formats.Tar/src/System/Formats/Tar/PaxGlobalExtendedAttributesTarEntry.cs
  - テストケース UT-TAR-134, UT-TAR-135 の根拠が不完全

- **TarHeader.Read.cs / TarHeader.Write.cs の詳細解析未実施**
  - ReplaceNormalAttributesWithExtended メソッドの詳細実装
  - ProcessDataBlock メソッドの詳細実装

- **SeekableSubReadStream.cs の解析未実施**
  - SubReadStream の派生クラスとしてのテストケース追加検討

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 1 (中リスク) | ExtractToFile の親ディレクトリ検証 | IOException の発生条件が複数あり、テストケースで網羅されているか確認要 |
| 1 (中リスク) | TarHeader 内部メソッド | 内部メソッドのテストケース設計が公開APIを通じた検証で十分か確認要 |
| 0 (低リスク) | PaxGlobalExtendedAttributesTarEntry | ソース未読込だが、類似クラス（PaxTarEntry）の実装から推測可能 |

## 6) レビュアーチェックリスト（最小）

- [ ] TarReader/TarWriter のコンストラクタ検証（UT-TAR-001〜003, 014〜017）が網羅的か
- [ ] TarFile の CreateFromDirectory/ExtractToDirectory の引数検証が網羅的か
- [ ] TarEntry の各プロパティの境界値テストが適切か
- [ ] PosixTarEntry のデバイス番号範囲検証（0x1FFFFF上限）が V7/Ustar 形式で正しく検証されるか
- [ ] SubReadStream の範囲制限読み取りが正しくテストされるか
- [ ] 非同期メソッド（Async）のキャンセルトークン処理が全て網羅されているか
- [ ] PaxGlobalExtendedAttributesTarEntry のテストケースが追加必要か確認
