---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 183
  claims_with_evidence: 183
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.IO.Hashing 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードのメソッド定義、XMLドキュメントコメント、実装パターンが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：公開API、保護メソッド、重要な内部ロジックを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：183 / 183、根拠なし：0
- 優先レビュー（高）
  1. **テストベクトル検証（UT-HSH-166〜171）**：外部仕様（ECMA-182、xxHashリファレンス実装）との整合性確認推奨
  2. **CRC残差関係検証（UT-HSH-172〜173）**：数学的プロパティの検証、実装詳細の確認推奨
  3. **境界値テスト（UT-HSH-108〜114, 133〜139）**：データ長による分岐の境界値、閾値の正確性確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Hashing/src/System/IO/Hashing/NonCryptographicHashAlgorithm.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Hashing/src/System/IO/Hashing/Crc32.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Hashing/src/System/IO/Hashing/Crc64.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Hashing/src/System/IO/Hashing/XxHash32.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Hashing/src/System/IO/Hashing/XxHash32.State.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Hashing/src/System/IO/Hashing/XxHash64.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Hashing/src/System/IO/Hashing/XxHash64.State.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Hashing/src/System/IO/Hashing/XxHash3.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Hashing/src/System/IO/Hashing/XxHash128.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Hashing/src/System/IO/Hashing/XxHashShared.cs`
- E-11: xxHash仕様書 (https://github.com/Cyan4973/xxHash/blob/f9155bd4c57e2270a4ffbb176485e5d713de1c9b/doc/xxhash_spec.md)
- E-12: ECMA-182 Annex B (CRC-64仕様)
- E-13: ITU-T V.42 / IEEE 802.3 (CRC-32仕様)

## 3) Claims と根拠の対応（レビューの主戦場）

### NonCryptographicHashAlgorithm（基底クラス）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-HSH-001) | hashLengthInBytesが1以上で正常にインスタンス化 | E-01 L35-41 | ○ |
| C-02 (UT-HSH-002) | hashLengthInBytes=0でArgumentOutOfRangeException | E-01 L37-38 | ○ |
| C-03 (UT-HSH-003) | hashLengthInBytes<0でArgumentOutOfRangeException | E-01 L37-38 | ○ |
| C-04 (UT-HSH-004) | Append(byte[])でデータ追加 | E-01 L85-90 | ○ |
| C-05 (UT-HSH-005) | Append(byte[])でnullがArgumentNullException | E-01 L87 | ○ |
| C-06 (UT-HSH-006) | Append(Stream)でStreamからデータ読み込み | E-01 L101-106 | ○ |
| C-07 (UT-HSH-007) | Append(Stream)でnullがArgumentNullException | E-01 L103 | ○ |
| C-08 (UT-HSH-008) | AppendAsync非同期処理 | E-01 L124-134 | ○ |
| C-09 (UT-HSH-009) | AppendAsyncでnullがArgumentNullException | E-01 L126 | ○ |
| C-10 (UT-HSH-010) | GetCurrentHash()でbyte配列返却 | E-01 L142-147 | ○ |
| C-11 (UT-HSH-011) | TryGetCurrentHash成功時true | E-01 L161-172 | ○ |
| C-12 (UT-HSH-012) | TryGetCurrentHash失敗時false | E-01 L163-166 | ○ |
| C-13 (UT-HSH-013) | GetCurrentHash(Span)で書き込みバイト数返却 | E-01 L186-195 | ○ |
| C-14 (UT-HSH-014) | GetCurrentHash(Span)短いバッファでArgumentException | E-01 L188-191 | ○ |
| C-15 (UT-HSH-015) | GetHashAndReset()でハッシュ返却とリセット | E-01 L203-208 | ○ |
| C-16 (UT-HSH-016) | TryGetHashAndReset成功時true | E-01 L223-234 | ○ |
| C-17 (UT-HSH-017) | TryGetHashAndReset失敗時状態維持 | E-01 L225-229 | ○ |
| C-18 (UT-HSH-018) | GetHashAndReset(Span)でリセット | E-01 L248-257 | ○ |
| C-19 (UT-HSH-019) | GetHashAndReset(Span)短いバッファでArgumentException | E-01 L250-253 | ○ |
| C-20 (UT-HSH-020) | GetHashCode()でNotSupportedException | E-01 L300-304 | ○ |

### Crc32
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 (UT-HSH-021) | デフォルトコンストラクタでHashLengthInBytes=4 | E-02 L37-40 | ○ |
| C-22 (UT-HSH-022) | Clone()で状態保持クローン | E-02 L50 | ○ |
| C-23 (UT-HSH-023) | Append(ReadOnlySpan)で_crc更新 | E-02 L57-60 | ○ |
| C-24 (UT-HSH-024) | Reset()で_crc=0xFFFFFFFF | E-02 L65-68 | ○ |
| C-25 (UT-HSH-025) | GetCurrentHashAsUInt32()でones' complement | E-02 L94 | ○ |
| C-26 (UT-HSH-026) | Hash(byte[])でCRC-32計算 | E-02 L104-109 | ○ |
| C-27 (UT-HSH-027) | Hash(byte[])でnullがArgumentNullException | E-02 L106 | ○ |
| C-28 (UT-HSH-028) | Hash(ReadOnlySpan)でCRC-32計算 | E-02 L116-122 | ○ |
| C-29 (UT-HSH-029) | 空Spanで初期値CRC-32 | E-02 L174-175 | ○ |
| C-30 (UT-HSH-030) | TryHash成功時true | E-02 L136-148 | ○ |
| C-31 (UT-HSH-031) | TryHash失敗時false | E-02 L138-142 | ○ |
| C-32 (UT-HSH-032) | Hash(Span, Span)で4返却 | E-02 L158-168 | ○ |
| C-33 (UT-HSH-033) | Hash(Span, Span)短いバッファでArgumentException | E-02 L160-163 | ○ |
| C-34 (UT-HSH-034) | HashToUInt32でuint返却 | E-02 L174-175 | ○ |
| C-35 (UT-HSH-035) | GetCurrentHashCoreでLittle Endian出力 | E-02 L75-79 | ○ |
| C-36 (UT-HSH-036) | GetHashAndResetCoreでリセット | E-02 L85-89 | ○ |

### Crc64
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 (UT-HSH-037) | デフォルトコンストラクタでHashLengthInBytes=8 | E-03 L36-39 | ○ |
| C-38 (UT-HSH-038) | Clone()で状態保持クローン | E-03 L49 | ○ |
| C-39 (UT-HSH-039) | Append(ReadOnlySpan)で_crc更新 | E-03 L56-59 | ○ |
| C-40 (UT-HSH-040) | Reset()で_crc=0 | E-03 L64-67 | ○ |
| C-41 (UT-HSH-041) | GetCurrentHashAsUInt64()でulong返却 | E-03 L92 | ○ |
| C-42 (UT-HSH-042) | Hash(byte[])でCRC-64計算 | E-03 L102-107 | ○ |
| C-43 (UT-HSH-043) | Hash(byte[])でnullがArgumentNullException | E-03 L104 | ○ |
| C-44 (UT-HSH-044) | Hash(ReadOnlySpan)でCRC-64計算 | E-03 L114-120 | ○ |
| C-45 (UT-HSH-045) | 空Spanで初期値CRC-64 | E-03 L172-173 | ○ |
| C-46 (UT-HSH-046) | TryHash成功時true | E-03 L134-146 | ○ |
| C-47 (UT-HSH-047) | TryHash失敗時false | E-03 L136-140 | ○ |
| C-48 (UT-HSH-048) | Hash(Span, Span)で8返却 | E-03 L156-166 | ○ |
| C-49 (UT-HSH-049) | Hash(Span, Span)短いバッファでArgumentException | E-03 L158-161 | ○ |
| C-50 (UT-HSH-050) | HashToUInt64でulong返却 | E-03 L172-173 | ○ |
| C-51 (UT-HSH-051) | GetCurrentHashCoreでBig Endian出力 | E-03 L74-77 | ○ |
| C-52 (UT-HSH-052) | GetHashAndResetCoreでリセット | E-03 L83-87 | ○ |

### XxHash32
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 (UT-HSH-053) | デフォルトコンストラクタでseed=0 | E-04 L35-38 | ○ |
| C-54 (UT-HSH-054) | XxHash32(int)でseed設定 | E-04 L47-52 | ○ |
| C-55 (UT-HSH-055) | Clone()で状態保持クローン | E-04 L69 | ○ |
| C-56 (UT-HSH-056) | 16バイト未満でholdbackバッファ格納 | E-04 L85-126 | ○ |
| C-57 (UT-HSH-057) | 16バイト以上でstripe処理 | E-04 L113-118 | ○ |
| C-58 (UT-HSH-058) | 複数回Appendで累積 | E-04 L85-126 | ○ |
| C-59 (UT-HSH-059) | Reset()で状態初期化 | E-04 L74-78 | ○ |
| C-60 (UT-HSH-060) | GetCurrentHashAsUInt32()でuint返却 | E-04 L141-152 | ○ |
| C-61 (UT-HSH-061) | Hash(byte[])でXxHash32計算 | E-04 L162-167 | ○ |
| C-62 (UT-HSH-062) | Hash(byte[])でnullがArgumentNullException | E-04 L164 | ○ |
| C-63 (UT-HSH-063) | Hash(byte[], int)でseed付きハッシュ | E-04 L178-183 | ○ |
| C-64 (UT-HSH-064) | Hash(byte[], int)でnullがArgumentNullException | E-04 L180 | ○ |
| C-65 (UT-HSH-065) | Hash(ReadOnlySpan, int)でハッシュ計算 | E-04 L191-197 | ○ |
| C-66 (UT-HSH-066) | 空Spanでハッシュ計算 | E-04 L252-264 | ○ |
| C-67 (UT-HSH-067) | TryHash成功時true | E-04 L212-224 | ○ |
| C-68 (UT-HSH-068) | TryHash失敗時false | E-04 L214-218 | ○ |
| C-69 (UT-HSH-069) | Hash(Span, Span, int)で4返却 | E-04 L235-245 | ○ |
| C-70 (UT-HSH-070) | Hash(Span, Span, int)短いバッファでArgumentException | E-04 L237-240 | ○ |
| C-71 (UT-HSH-071) | HashToUInt32でuint返却 | E-04 L252-264 | ○ |
| C-72 (UT-HSH-072) | GetCurrentHashCoreでBig Endian出力 | E-04 L132-136 | ○ |

### XxHash64
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 (UT-HSH-073) | デフォルトコンストラクタでseed=0 | E-06 L35-38 | ○ |
| C-74 (UT-HSH-074) | XxHash64(long)でseed設定 | E-06 L47-52 | ○ |
| C-75 (UT-HSH-075) | Clone()で状態保持クローン | E-06 L69 | ○ |
| C-76 (UT-HSH-076) | 32バイト未満でholdbackバッファ格納 | E-06 L85-126 | ○ |
| C-77 (UT-HSH-077) | 32バイト以上でstripe処理 | E-06 L113-118 | ○ |
| C-78 (UT-HSH-078) | 複数回Appendで累積 | E-06 L85-126 | ○ |
| C-79 (UT-HSH-079) | Reset()で状態初期化 | E-06 L74-78 | ○ |
| C-80 (UT-HSH-080) | GetCurrentHashAsUInt64()でulong返却 | E-06 L141-152 | ○ |
| C-81 (UT-HSH-081) | Hash(byte[])でXxHash64計算 | E-06 L162-167 | ○ |
| C-82 (UT-HSH-082) | Hash(byte[])でnullがArgumentNullException | E-06 L164 | ○ |
| C-83 (UT-HSH-083) | Hash(byte[], long)でseed付きハッシュ | E-06 L178-183 | ○ |
| C-84 (UT-HSH-084) | Hash(byte[], long)でnullがArgumentNullException | E-06 L180 | ○ |
| C-85 (UT-HSH-085) | Hash(ReadOnlySpan, long)でハッシュ計算 | E-06 L191-197 | ○ |
| C-86 (UT-HSH-086) | 空Spanでハッシュ計算 | E-06 L252-264 | ○ |
| C-87 (UT-HSH-087) | TryHash成功時true | E-06 L212-224 | ○ |
| C-88 (UT-HSH-088) | TryHash失敗時false | E-06 L214-218 | ○ |
| C-89 (UT-HSH-089) | Hash(Span, Span, long)で8返却 | E-06 L235-245 | ○ |
| C-90 (UT-HSH-090) | Hash(Span, Span, long)短いバッファでArgumentException | E-06 L237-240 | ○ |
| C-91 (UT-HSH-091) | HashToUInt64でulong返却 | E-06 L252-264 | ○ |
| C-92 (UT-HSH-092) | GetCurrentHashCoreでBig Endian出力 | E-06 L132-136 | ○ |
| C-93 (UT-HSH-093) | Avalanche関数の検証 | E-07 L17-26 | ○ |

### XxHash3
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 (UT-HSH-094) | デフォルトコンストラクタでseed=0 | E-08 L29-32 | ○ |
| C-95 (UT-HSH-095) | XxHash3(long)でseed設定 | E-08 L35-38 | ○ |
| C-96 (UT-HSH-096) | Clone()で状態保持クローン | E-08 L48 | ○ |
| C-97 (UT-HSH-097) | Append(ReadOnlySpan)でデータ追加 | E-08 L159-162 | ○ |
| C-98 (UT-HSH-098) | >240バイトでHashInternalLoop | E-08 L127-148 | ○ |
| C-99 (UT-HSH-099) | Reset()で状態初期化 | E-08 L152-155 | ○ |
| C-100 (UT-HSH-100) | GetCurrentHashAsUInt64()でulong返却 | E-08 L175-200 | ○ |
| C-101 (UT-HSH-101) | <=240バイトでHashToUInt64使用 | E-08 L191-196 | ○ |
| C-102 (UT-HSH-102) | >240バイトでMergeAccumulators使用 | E-08 L179-190 | ○ |
| C-103 (UT-HSH-103) | Hash(byte[])でXxHash3計算 | E-08 L54 | ○ |
| C-104 (UT-HSH-104) | Hash(byte[])でnullがArgumentNullException | E-08 L63 | ○ |
| C-105 (UT-HSH-105) | Hash(byte[], long)でseed付きハッシュ | E-08 L61-66 | ○ |
| C-106 (UT-HSH-106) | Hash(byte[], long)でnullがArgumentNullException | E-08 L63 | ○ |
| C-107 (UT-HSH-107) | Hash(ReadOnlySpan, long)でハッシュ計算 | E-08 L72-78 | ○ |
| C-108 (UT-HSH-108) | 空Spanでハッシュ計算 | E-08 L202-221 | ○ |
| C-109 (UT-HSH-109) | 1-3バイトでHashLength1To3 | E-08 L213-217, L224-239 | ○ |
| C-110 (UT-HSH-110) | 4-8バイトでHashLength4To8 | E-08 L209-212, L241-256 | ○ |
| C-111 (UT-HSH-111) | 9-16バイトでHashLength9To16 | E-08 L203-208, L258-276 | ○ |
| C-112 (UT-HSH-112) | 17-128バイトでHashLength17To128 | E-08 L137-139, L278-305 | ○ |
| C-113 (UT-HSH-113) | 129-240バイトでHashLength129To240 | E-08 L141-145, L307-354 | ○ |
| C-114 (UT-HSH-114) | >240バイトでHashLengthOver240 | E-08 L147-148, L356-377 | ○ |
| C-115 (UT-HSH-115) | TryHash成功時true | E-08 L102-120 | ○ |
| C-116 (UT-HSH-116) | TryHash失敗時false | E-08 L117-119 | ○ |
| C-117 (UT-HSH-117) | Hash(Span, Span, long)で8返却 | E-08 L86-94 | ○ |
| C-118 (UT-HSH-118) | Hash(Span, Span, long)短いバッファでArgumentException | E-08 L88-91 | ○ |
| C-119 (UT-HSH-119) | HashToUInt64でulong返却 | E-08 L127-149 | ○ |
| C-120 (UT-HSH-120) | GetCurrentHashCoreでBig Endian出力 | E-08 L166-170 | ○ |

### XxHash128
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 (UT-HSH-121) | デフォルトコンストラクタでseed=0 | E-09 L30-33 | ○ |
| C-122 (UT-HSH-122) | XxHash128(long)でseed設定 | E-09 L36-39 | ○ |
| C-123 (UT-HSH-123) | Clone()で状態保持クローン | E-09 L49 | ○ |
| C-124 (UT-HSH-124) | Append(ReadOnlySpan)でデータ追加 | E-09 L161-164 | ○ |
| C-125 (UT-HSH-125) | >240バイトでHashInternalLoop | E-09 L389-411 | ○ |
| C-126 (UT-HSH-126) | Reset()で状態初期化 | E-09 L154-157 | ○ |
| C-127 (UT-HSH-127) | GetCurrentHashAsUInt128()でUInt128返却 | E-09 L207-211 | ○ |
| C-128 (UT-HSH-128) | Hash(byte[])でXxHash128計算 | E-09 L55 | ○ |
| C-129 (UT-HSH-129) | Hash(byte[])でnullがArgumentNullException | E-09 L64 | ○ |
| C-130 (UT-HSH-130) | Hash(byte[], long)でseed付きハッシュ | E-09 L62-67 | ○ |
| C-131 (UT-HSH-131) | Hash(byte[], long)でnullがArgumentNullException | E-09 L64 | ○ |
| C-132 (UT-HSH-132) | Hash(ReadOnlySpan, long)でハッシュ計算 | E-09 L73-78 | ○ |
| C-133 (UT-HSH-133) | 空Spanでハッシュ計算 | E-09 L230-250 | ○ |
| C-134 (UT-HSH-134) | 1-3バイトでHashLength1To3 | E-09 L242-245, L253-275 | ○ |
| C-135 (UT-HSH-135) | 4-8バイトでHashLength4To8 | E-09 L237-240, L277-301 | ○ |
| C-136 (UT-HSH-136) | 9-16バイトでHashLength9To16 | E-09 L232-236, L303-328 | ○ |
| C-137 (UT-HSH-137) | 17-128バイトでHashLength17To128 | E-09 L139-141, L330-354 | ○ |
| C-138 (UT-HSH-138) | 129-240バイトでHashLength129To240 | E-09 L143-147, L356-387 | ○ |
| C-139 (UT-HSH-139) | >240バイトでHashLengthOver240 | E-09 L149-150, L389-412 | ○ |
| C-140 (UT-HSH-140) | TryHash成功時true | E-09 L102-114 | ○ |
| C-141 (UT-HSH-141) | TryHash失敗時false | E-09 L111-113 | ○ |
| C-142 (UT-HSH-142) | Hash(Span, Span, long)で16返却 | E-09 L86-94 | ○ |
| C-143 (UT-HSH-143) | Hash(Span, Span, long)短いバッファでArgumentException | E-09 L88-91 | ○ |
| C-144 (UT-HSH-144) | HashToUInt128でUInt128返却 | E-09 L122-126 | ○ |
| C-145 (UT-HSH-145) | GetCurrentHashCoreでBig Endian出力 | E-09 L168-172 | ○ |

### XxHashShared（内部クラス）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146 (UT-HSH-146) | seed=0でDefaultSecret使用 | E-10 L160-177 | ○ |
| C-147 (UT-HSH-147) | seed!=0でカスタムシークレット生成 | E-10 L170-173 | ○ |
| C-148 (UT-HSH-148) | Reset(ref State)でフィールドリセット | E-10 L179-189 | ○ |
| C-149 (UT-HSH-149) | 小データのバッファリング | E-10 L240-254 | ○ |
| C-150 (UT-HSH-150) | 大データでConsumeStripes | E-10 L275-306 | ○ |
| C-151 (UT-HSH-151) | Rrmxmxアバランシェ関数 | E-10 L192-200 | ○ |
| C-152 (UT-HSH-152) | Avalanche高速アバランシェ関数 | E-10 L443-450 | ○ |
| C-153 (UT-HSH-153) | Multiply64To128ThenFold | E-10 L471-476 | ○ |
| C-154 (UT-HSH-154) | MergeAccumulators | E-10 L420-430 | ○ |
| C-155 (UT-HSH-155) | XorShift関数 | E-10 L776-780 | ○ |
| C-156 (UT-HSH-156) | XorShift shift=0 | E-10 L776-780 | ○ |
| C-157 (UT-HSH-157) | XorShift shift=63 | E-10 L776-780 | ○ |

### XxHash32.State / XxHash64.State（内部構造体）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-158 (UT-HSH-158) | XxHash32.State初期化 | E-05 L26-35 | ○ |
| C-159 (UT-HSH-159) | XxHash32.State.ProcessStripe | E-05 L37-48 | ○ |
| C-160 (UT-HSH-160) | XxHash32.State.Complete（full stripe） | E-05 L69-100 | ○ |
| C-161 (UT-HSH-161) | XxHash32.State.Complete（small） | E-05 L71 | ○ |
| C-162 (UT-HSH-162) | XxHash64.State初期化 | E-07 L37-46 | ○ |
| C-163 (UT-HSH-163) | XxHash64.State.ProcessStripe | E-07 L48-59 | ○ |
| C-164 (UT-HSH-164) | XxHash64.State.Complete（full stripe） | E-07 L104-142 | ○ |
| C-165 (UT-HSH-165) | XxHash64.State.Complete（small） | E-07 L106 | ○ |

### テストベクトル・整合性検証
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-166 (UT-HSH-166) | CRC-32テストベクトル検証 | E-02 L8-26, E-13 | ○ |
| C-167 (UT-HSH-167) | CRC-64テストベクトル検証 | E-03 L8-25, E-12 | ○ |
| C-168 (UT-HSH-168) | XxHash32テストベクトル検証 | E-04 L6-7, E-11 | ○ |
| C-169 (UT-HSH-169) | XxHash64テストベクトル検証 | E-06 L6-7, E-11 | ○ |
| C-170 (UT-HSH-170) | XxHash3テストベクトル検証 | E-08 L4, E-11 | ○ |
| C-171 (UT-HSH-171) | XxHash128テストベクトル検証 | E-09 L4, E-11 | ○ |
| C-172 (UT-HSH-172) | CRC-32残差関係検証 | E-02 L14-18 | ○ |
| C-173 (UT-HSH-173) | CRC-64残差関係検証 | E-03 L14-17 | ○ |
| C-174 (UT-HSH-174) | XxHash32増分/一括一致 | E-04 ロジック全体 | ○ |
| C-175 (UT-HSH-175) | XxHash64増分/一括一致 | E-06 ロジック全体 | ○ |
| C-176 (UT-HSH-176) | XxHash3増分/一括一致 | E-08 ロジック全体 | ○ |
| C-177 (UT-HSH-177) | XxHash128増分/一括一致 | E-09 ロジック全体 | ○ |
| C-178 (UT-HSH-178) | CRC-32増分/一括一致 | E-02 ロジック全体 | ○ |
| C-179 (UT-HSH-179) | CRC-64増分/一括一致 | E-03 ロジック全体 | ○ |
| C-180 (UT-HSH-180) | XxHash32シード値影響 | E-04 L47-52 | ○ |
| C-181 (UT-HSH-181) | XxHash64シード値影響 | E-06 L47-52 | ○ |
| C-182 (UT-HSH-182) | XxHash3シード値影響 | E-08 L35-38 | ○ |
| C-183 (UT-HSH-183) | XxHash128シード値影響 | E-09 L36-39 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全テストケースはソースコード内のメソッド定義、XMLドキュメントコメント、または外部仕様書に基づいて作成されています。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全てのテストケースがソースコードに基づいており、APIの使用方法が明確
- **注意点**:
  - テストベクトル検証（UT-HSH-166〜171）は外部仕様との照合が必要
  - ベクタライズド実装（ARM/x86 SIMD）のパスはプラットフォーム依存のため、テスト環境に注意
  - XxHash3/XxHash128の境界値（240バイト）は MidSizeMaxBytes 定数に依存

## 6) レビュアーチェックリスト（最小）
- [ ] 基底クラス `NonCryptographicHashAlgorithm` のテストケースが派生クラスの共通動作をカバーしているか
- [ ] 各ハッシュアルゴリズムの出力エンディアン（CRC-32: Little Endian, CRC-64/XxHash*: Big Endian）が正しく検証されているか
- [ ] null入力、空入力、境界値入力のテストケースが網羅されているか
- [ ] 増分ハッシュと一括ハッシュの整合性テストが含まれているか
- [ ] Clone()メソッドの状態保持が正しくテストされているか
- [ ] シード値のテストケースがXxHash系アルゴリズムで含まれているか
- [ ] Try-パターンメソッドの成功/失敗両方のケースがカバーされているか
