---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 193
  claims_with_evidence: 189
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：System.IO.IsolatedStorage 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストファイルなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：対象クラスのpublicメソッド・プロパティを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：189 / 193、根拠なし：4
- 優先レビュー（高）
  1. **UT-ISO-190, 191**: Windows固有のDACL設定テスト - プラットフォーム依存のため実機確認推奨
  2. **UT-ISO-182, 183**: GetDefaultIdentityAndHash - StrongName/Url判定のエッジケース
  3. **UT-ISO-167, 168**: Lock/Unlock - macOSでは未サポート

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.IO.IsolatedStorage/src/System/IO/IsolatedStorage/IsolatedStorage.cs`
- E-02: `src/libraries/System.IO.IsolatedStorage/src/System/IO/IsolatedStorage/IsolatedStorageFile.cs`
- E-03: `src/libraries/System.IO.IsolatedStorage/src/System/IO/IsolatedStorage/IsolatedStorageFile.NonMobile.cs`
- E-04: `src/libraries/System.IO.IsolatedStorage/src/System/IO/IsolatedStorage/IsolatedStorageFileStream.cs`
- E-05: `src/libraries/System.IO.IsolatedStorage/src/System/IO/IsolatedStorage/IsolatedStorageException.cs`
- E-06: `src/libraries/System.IO.IsolatedStorage/src/System/IO/IsolatedStorage/IsolatedStorageScope.cs`
- E-07: `src/libraries/System.IO.IsolatedStorage/src/System/IO/IsolatedStorage/Helper.cs`
- E-08: `src/libraries/System.IO.IsolatedStorage/src/System/IO/IsolatedStorage/Helper.NonMobile.cs`
- E-09: `src/libraries/System.IO.IsolatedStorage/src/System/IO/IsolatedStorage/Helper.Win32.cs`
- E-10: `src/libraries/System.IO.IsolatedStorage/src/System/IO/IsolatedStorage/Helper.Unix.cs`
- E-11: `src/libraries/System.IO.IsolatedStorage/src/System/IO/IsolatedStorage/INormalizeForIsolatedStorage.cs`
- E-12: `src/libraries/System.IO.IsolatedStorage/tests/System/IO/IsolatedStorage/IsolatedStorageBaseClassTests.cs`
- E-13: `src/libraries/System.IO.IsolatedStorage/tests/System/IO/IsolatedStorage/GetStoreTests.cs`
- E-14: `src/libraries/System.IO.IsolatedStorage/tests/System/IO/IsolatedStorage/DeleteFileTests.cs`
- E-15: `src/libraries/System.IO.IsolatedStorage/tests/System/IO/IsolatedStorage/FileExistsTests.cs`
- E-16: `src/libraries/System.IO.IsolatedStorage/tests/System/IO/IsolatedStorage/CreateDirectoryTests.cs`
- E-17: `src/libraries/System.IO.IsolatedStorage/tests/System/IO/IsolatedStorage/CopyFileTests.cs`
- E-18: `src/libraries/System.IO.IsolatedStorage/tests/System/IO/IsolatedStorage/MoveFileTests.cs`
- E-19: `src/libraries/System.IO.IsolatedStorage/tests/System/IO/IsolatedStorage/OpenFileTests.cs`
- E-20: `src/libraries/System.IO.IsolatedStorage/tests/System/IO/IsolatedStorage/RemoveTests.cs`
- E-21: `src/libraries/System.IO.IsolatedStorage/tests/System/IO/IsolatedStorage/IdentityTests.cs`
- E-22: `src/libraries/System.IO.IsolatedStorage/tests/System/IO/IsolatedStorage/IsolatedStorageFileStreamTests.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### IsolatedStorage 基底クラス (UT-ISO-001 - UT-ISO-017)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ApplicationIdentityがApplication scopeで取得可能 | E-01 (L19-28), E-21 | ○ |
| C-02 | AssemblyIdentityがAssembly scopeで取得可能 | E-01 (L30-39), E-21 | ○ |
| C-03 | DomainIdentityがDomain scopeで取得可能 | E-01 (L41-50), E-21 | ○ |
| C-04 | CurrentSizeがInvalidOperationExceptionをスロー | E-01 (L54-60), E-12 | ○ |
| C-05 | UsedSizeがInvalidOperationExceptionをスロー | E-01 (L62-68), E-12 | ○ |
| C-06 | AvailableFreeSpaceがInvalidOperationExceptionをスロー | E-01 (L70-76), E-12 | ○ |
| C-07 | MaximumSizeがInvalidOperationExceptionをスロー | E-01 (L80-89), E-12 | ○ |
| C-08 | Quotaが未設定時にInvalidOperationExceptionをスロー | E-01 (L91-99), E-12 | ○ |
| C-09 | SeparatorExternalがPath.DirectorySeparatorCharを返す | E-01 (L113-116), E-12 | ○ |
| C-10 | SeparatorInternalが'.'を返す | E-01 (L118-121), E-12 | ○ |
| C-11 | IncreaseQuotaToがfalseを返す | E-01 (L123-126), E-12 | ○ |
| C-12 | InitStoreで有効なスコープが検証される | E-01 (L165-184), E-13 | ○ |

### IsolatedStorageFile ストア取得 (UT-ISO-018 - UT-ISO-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | GetUserStoreForApplicationがストアを返す | E-02 (L456-459), E-13 | ○ |
| C-14 | GetUserStoreForAssemblyがストアを返す | E-02 (L461-464), E-13 | ○ |
| C-15 | GetUserStoreForDomainがストアを返す | E-02 (L466-469), E-13 | ○ |
| C-16 | GetUserStoreForSiteがNotSupportedExceptionをスロー | E-02 (L471-475), E-13 | ○ |
| C-17 | GetMachineStoreForApplicationがストアを返す | E-02 (L477-480) | ○ |
| C-18 | GetStoreでType/object引数がPlatformNotSupportedExceptionをスロー | E-02 (L515-537), E-13 | ○ |
| C-19 | IsEnabledがtrueを返す | E-02 (L662-666) | ○ |

### IsolatedStorageFile プロパティ (UT-ISO-029 - UT-ISO-032)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | Quotaがlong.MaxValueを返す | E-02 (L430-436) | ○ |
| C-21 | UsedSizeが0を返す | E-02 (L438-444) | ○ |
| C-22 | AvailableFreeSpaceがQuota - UsedSizeを返す | E-02 (L412-418) | ○ |
| C-23 | IncreaseQuotaToがtrueを返す | E-02 (L582-586) | ○ |

### IsolatedStorageFile ファイル操作 (UT-ISO-033 - UT-ISO-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | CreateFileがIsolatedStorageFileStreamを返す | E-02 (L229-233) | ○ |
| C-25 | DeleteFileがファイルを削除する | E-02 (L74-89), E-14 | ○ |
| C-26 | DeleteFileがnull引数でArgumentNullExceptionをスロー | E-02 (L76), E-14 | ○ |
| C-27 | DeleteFileがDispose後にObjectDisposedExceptionをスロー | E-02 (L78, L559-567), E-14 | ○ |
| C-28 | FileExistsがファイル存在時にtrueを返す | E-02 (L91-98), E-15 | ○ |
| C-29 | DirectoryExistsがディレクトリ存在時にtrueを返す | E-02 (L100-107) | ○ |
| C-30 | CreateDirectoryがディレクトリを作成する | E-02 (L109-142), E-16 | ○ |
| C-31 | DeleteDirectoryが空ディレクトリを削除する | E-02 (L144-159) | ○ |
| C-32 | GetFileNamesがファイル名配列を返す | E-02 (L161-183) | ○ |
| C-33 | GetDirectoryNamesがディレクトリ名配列を返す | E-02 (L185-207) | ○ |
| C-34 | CopyFileがファイルをコピーする | E-02 (L283-317), E-17 | ○ |
| C-35 | MoveFileがファイルを移動する | E-02 (L319-345), E-18 | ○ |
| C-36 | MoveDirectoryがディレクトリを移動する | E-02 (L347-373) | ○ |

### IsolatedStorageFile ファイルオープン (UT-ISO-069 - UT-ISO-078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | OpenFileがIsolatedStorageFileStreamを返す | E-02 (L211-227), E-19 | ○ |
| C-38 | OpenFileでFileMode, FileAccess, FileShareが正しく渡される | E-02 (L211-227), E-19 | ○ |

### IsolatedStorageFile 時刻取得 (UT-ISO-102 - UT-ISO-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | GetCreationTimeが作成時刻を返す | E-02 (L235-249) | ○ |
| C-40 | GetLastAccessTimeが最終アクセス時刻を返す | E-02 (L251-265) | ○ |
| C-41 | GetLastWriteTimeが最終更新時刻を返す | E-02 (L267-281) | ○ |
| C-42 | UnauthorizedAccessException時にデフォルト日時が返る | E-02 (L245-248, L261-264, L277-280) | ○ |

### IsolatedStorageFile Enumerator/Remove (UT-ISO-112 - UT-ISO-119)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | GetEnumeratorが空のEnumeratorを返す | E-02 (L375-410), E-13 | ○ |
| C-44 | Removeがストアを削除する | E-02 (L588-642), E-20 | ○ |
| C-45 | Remove(scope)がスコープ全体を削除する | E-02 (L644-660) | ○ |

### IsolatedStorageFile Close/Dispose (UT-ISO-120 - UT-ISO-127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | CloseがRoaming scopeで何もしない | E-02 (L59-72) | ○ |
| C-47 | Disposeがリソースを解放する | E-02 (L569-573) | ○ |
| C-48 | EnsureStoreIsValidが状態を検証する | E-02 (L559-567) | ○ |

### IsolatedStorageFileStream (UT-ISO-128 - UT-ISO-170)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | コンストラクタでストリームが作成される | E-04 (L21-59, L84-149) | ○ |
| C-50 | null/空パスでArgumentExceptionがスローされる | E-04 (L86-91) | ○ |
| C-51 | Disposed IsolatedStorageFileでObjectDisposedExceptionがスローされる | E-04 (L99-100) | ○ |
| C-52 | CanRead/CanWrite/CanSeekが内部ストリームの値を返す | E-04 (L151-173) | ○ |
| C-53 | Length/Positionが内部ストリームの値を返す | E-04 (L175-193) | ○ |
| C-54 | Read/Write系メソッドが内部ストリームに委譲する | E-04 (L246-301) | ○ |
| C-55 | Flush系メソッドが内部ストリームに委譲する | E-04 (L226-239) | ○ |
| C-56 | Dispose/DisposeAsyncがリソースを解放する | E-04 (L203-224), E-22 | ○ |
| C-57 | SafeFileHandleアクセスでIsolatedStorageExceptionがスローされる | E-04 (L341-347) | ○ |
| C-58 | Lock/Unlockが内部ストリームに委譲する | E-04 (L329-339) | ○ |

### IsolatedStorageException (UT-ISO-171 - UT-ISO-174)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | デフォルトコンストラクタでHResult=COR_E_ISOSTOREが設定される | E-05 (L20-24) | ○ |
| C-60 | メッセージ付きコンストラクタが機能する | E-05 (L26-30) | ○ |
| C-61 | 内部例外付きコンストラクタが機能する | E-05 (L32-36) | ○ |

### IsolatedStorageScope (UT-ISO-175 - UT-ISO-176)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | 各フラグ値が正しい | E-06 (L9-18) | ○ |

### Helper クラス (UT-ISO-177 - UT-ISO-192)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | GetRootDirectoryがスコープに応じたルートを返す | E-07 (L32-56), E-08 (L13-29) | ○ |
| C-64 | GetExistingRandomDirectoryが既存ディレクトリを検索する | E-07 (L58-84) | ○ |
| C-65 | GetDefaultIdentityAndHashがアイデンティティとハッシュを返す | E-07 (L88-135) | ○ |
| C-66 | IsMachine/IsAssembly/IsApplication/IsRoaming/IsDomainがスコープを判定する | E-07 (L137-141) | ○ |
| C-67 | CreateDirectory(Win32)がMachine scopeでDACLを設定する | E-09 (L11-65) | ○ |
| C-68 | CreateDirectory(Unix)がディレクトリを作成する | E-10 (L8-12) | ○ |

### INormalizeForIsolatedStorage (UT-ISO-193)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | Normalizeメソッドが定義されている | E-11 (L5-9) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-ISO-167, 168 (Lock/Unlock)**: macOSでは `UnsupportedOSPlatform("macos")` 属性が付いており、プラットフォーム固有のテストが必要
  - 候補：プラットフォーム条件付きテスト / SkipOnPlatform属性の使用
- **UT-ISO-190, 191 (CreateDirectory Win32 DACL)**: Windows固有のセキュリティ設定であり、実機でのACL検証が必要
  - 候補：Windowsでの統合テスト / セキュリティ監査ツールでの確認
- **UT-ISO-182, 183 (GetDefaultIdentityAndHash)**: SingleFile deployment / Android環境でのEntryAssembly=null ケースの検証が必要
  - 候補：特殊環境でのテスト / モック使用
- **UT-ISO-119 (Remove(scope) 無効スコープ)**: VerifyGlobalScopeの内部メソッドであり、リフレクション経由でのテストが必要
  - 候補：既存テストのパターンを参照 (E-13参照)

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケース - ソースコードと既存テストから明確に根拠が取れる
- **1 (中リスク)**: プラットフォーム固有機能 (Lock/Unlock, DACL設定) - 実行環境依存
- **1 (中リスク)**: 内部メソッドのテスト (GetFullPath, EnsureStoreIsValid等) - リフレクション使用が必要
- **2 (高リスク)**: なし

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの「前提条件」と「入力値」が実装可能であることを確認
- [ ] 「期待結果」がソースコードの実装と一致していることを確認
- [ ] プラットフォーム固有テスト（Lock/Unlock, DACL）に適切なSkip属性が考慮されているか確認
- [ ] 既存テストファイル（E-12〜E-22）との重複・漏れがないことを確認
- [ ] 境界値テスト（null, 空文字, 不正パス）が網羅されていることを確認
- [ ] Dispose/Close/Remove後の状態検証テストが全メソッドに対して存在することを確認
