---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 160
  claims_with_evidence: 158
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：System.IO.Ports 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたSystem.IO.Portsモジュールの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 158 / 160 = 0.99
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：158 / 160、根拠なし：2
- 優先レビュー（高）
  1. **UT-SIO-158, UT-SIO-159**: Unix固有のSafeSerialDeviceHandle.Openテストはプラットフォーム依存
  2. **イベントテスト（UT-SIO-111〜113）**: 実際のハードウェア依存のため、モック化が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialPort.cs`
- E-02: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialStream.cs`
- E-03: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialStream.Unix.cs`
- E-04: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialStream.Windows.cs`
- E-05: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialPort.Unix.cs`
- E-06: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialPort.Win32.cs`
- E-07: `src/libraries/System.IO.Ports/src/System/IO/Ports/Parity.cs`
- E-08: `src/libraries/System.IO.Ports/src/System/IO/Ports/StopBits.cs`
- E-09: `src/libraries/System.IO.Ports/src/System/IO/Ports/Handshake.cs`
- E-10: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialData.cs`
- E-11: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialError.cs`
- E-12: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialPinChange.cs`
- E-13: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialDataReceivedEventArgs.cs`
- E-14: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialErrorReceivedEventArgs.cs`
- E-15: `src/libraries/System.IO.Ports/src/System/IO/Ports/SerialPinChangedEventArgs.cs`
- E-16: `src/libraries/System.IO.Ports/src/System/IO/Ports/InternalResources.cs`
- E-17: `src/libraries/System.IO.Ports/src/System/IO/Ports/SafeSerialDeviceHandle.Unix.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### SerialPortクラス - コンストラクタ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタで既定値が設定される | E-01 L17-35, L542-546 | ○ |
| C-02 | コンテナ付きコンストラクタでコンテナに追加される | E-01 L548-552 | ○ |
| C-03 | ポート名のみ指定でインスタンス生成できる | E-01 L557-559 | ○ |
| C-04 | ポート名とボーレート指定でインスタンス生成できる | E-01 L561-563 | ○ |
| C-05 | パリティ指定でインスタンス生成できる | E-01 L565-567 | ○ |
| C-06 | データビット指定でインスタンス生成できる | E-01 L569-571 | ○ |
| C-07 | 全パラメータ指定でインスタンス生成できる | E-01 L576-583 | ○ |

### SerialPortクラス - プロパティ（BaudRate, DataBits, Parity, StopBits）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | ボーレートを正の値に設定できる | E-01 L152-164 | ○ |
| C-09 | ボーレートに0以下を設定すると例外 | E-01 L157-158 | ○ |
| C-10 | ボーレートに負の値を設定すると例外 | E-01 L157-158 | ○ |
| C-11 | データビットを5-8の範囲で設定できる | E-01 L234-247 | ○ |
| C-12 | データビットに5未満を設定すると例外 | E-01 L240-241 | ○ |
| C-13 | データビットに8超過を設定すると例外 | E-01 L240-241 | ○ |
| C-14 | データビット最小値5を設定できる | E-01 L33-34 (MinDataBits=5) | ○ |
| C-15 | データビット最大値8を設定できる | E-01 L33 (MaxDataBits=8) | ○ |
| C-16 | パリティをNone/Odd/Even/Mark/Spaceに設定できる | E-01 L358-373, E-07 L6-13 | ○ |
| C-17 | 無効なパリティ値で例外 | E-01 L366-367 | ○ |
| C-18 | ストップビットをOne/Two/OnePointFiveに設定できる | E-01 L487-503, E-08 L6-12 | ○ |
| C-19 | 無効なストップビット値で例外 | E-01 L496-497 | ○ |

### SerialPortクラス - プロパティ（Handshake, PortName, Timeout, Buffer）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | ハンドシェイクを設定できる | E-01 L321-336, E-09 L6-12 | ○ |
| C-21 | 無効なハンドシェイク値で例外 | E-01 L329-330 | ○ |
| C-22 | ポート名を設定できる | E-01 L388-404 | ○ |
| C-23 | ポート名にnullで例外 | E-01 L396-397 | ○ |
| C-24 | ポート名に空文字で例外 | E-01 L398-399 | ○ |
| C-25 | ポートが開いている状態でポート名設定すると例外 | E-01 L401-402 | ○ |
| C-26 | 読み取りタイムアウトを設定できる | E-01 L425-441 | ○ |
| C-27 | InfiniteTimeoutを設定できる | E-01 L13 (InfiniteTimeout=-1) | ○ |
| C-28 | タイムアウト0を設定できる | E-01 L433-435 | ○ |
| C-29 | 負の値(-1以外)で例外 | E-01 L434-435 | ○ |
| C-30 | 書き込みタイムアウトを設定できる | E-01 L523-538 | ○ |
| C-31 | WriteTimeoutにInfiniteTimeoutを設定できる | E-01 L532-533 | ○ |
| C-32 | WriteTimeoutに0以下(-1以外)で例外 | E-01 L532-533 | ○ |
| C-33 | 読み取りバッファサイズを設定できる | E-01 L407-423 | ○ |
| C-34 | 読み取りバッファサイズに0以下で例外 | E-01 L415-416 | ○ |
| C-35 | 開いている状態で読み取りバッファサイズ設定すると例外 | E-01 L418-419 | ○ |
| C-36 | 書き込みバッファサイズを設定できる | E-01 L505-520 | ○ |
| C-37 | 書き込みバッファサイズに0以下で例外 | E-01 L513-514 | ○ |
| C-38 | 開いている状態で書き込みバッファサイズ設定すると例外 | E-01 L516-517 | ○ |
| C-39 | 受信バイト閾値を設定できる | E-01 L446-467 | ○ |
| C-40 | 受信バイト閾値に0以下で例外 | E-01 L454-455 | ○ |

### SerialPortクラス - プロパティ（その他）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | 改行文字を設定できる | E-01 L344-356 | ○ |
| C-42 | 改行文字にnullで例外 | E-01 L349-350 | ○ |
| C-43 | 改行文字に空文字で例外 | E-01 L351-352 | ○ |
| C-44 | エンコーディングを設定できる | E-01 L293-319 | ○ |
| C-45 | エンコーディングにnullで例外 | E-01 L301-302 | ○ |
| C-46 | サポートされないエンコーディングで例外 | E-01 L306-309 | ○ |
| C-47 | パリティ置換文字を設定できる | E-01 L375-384 | ○ |
| C-48 | NUL文字破棄フラグを設定できる | E-01 L249-261 | ○ |
| C-49 | DTRフラグを設定できる | E-01 L273-288 | ○ |
| C-50 | RTSフラグを設定できる | E-01 L469-484 | ○ |
| C-51 | ハンドシェイク中にRTS設定すると例外 | E-03 L255-264 | ○ |
| C-52 | IsOpenがポート閉じているときfalse | E-01 L338-342 | ○ |
| C-53 | IsOpenがポート開いているときtrue | E-01 L341 | ○ |
| C-54 | BaseStreamでストリーム取得できる | E-01 L141-150 | ○ |
| C-55 | BaseStreamで閉じているときに例外 | E-01 L145-146 | ○ |
| C-56 | BytesToReadで読み取り可能バイト数取得 | E-01 L196-204 | ○ |
| C-57 | BytesToReadで閉じているときに例外 | E-01 L200-201 | ○ |
| C-58 | BytesToWriteで書き込み待ちバイト数取得 | E-01 L185-193 | ○ |
| C-59 | BytesToWriteで閉じているときに例外 | E-01 L189-190 | ○ |
| C-60 | CDHoldingでキャリア検出状態取得 | E-01 L214-222 | ○ |
| C-61 | CDHoldingで閉じているときに例外 | E-01 L218-219 | ○ |
| C-62 | CtsHoldingでCTS状態取得 | E-01 L224-232 | ○ |
| C-63 | CtsHoldingで閉じているときに例外 | E-01 L228-229 | ○ |
| C-64 | DsrHoldingでDSR状態取得 | E-01 L263-271 | ○ |
| C-65 | DsrHoldingで閉じているときに例外 | E-01 L267-268 | ○ |
| C-66 | BreakStateで状態取得 | E-01 L166-182 | ○ |
| C-67 | BreakStateを設定できる | E-01 L175-181 | ○ |
| C-68 | BreakStateで閉じているときに例外 | E-01 L170-171, L177-178 | ○ |

### SerialPortクラス - メソッド（Open/Close/Dispose）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | Openでポートを開ける | E-01 L626-647 | ○ |
| C-70 | 既に開いているポートを開くと例外 | E-01 L628-629 | ○ |
| C-71 | Closeでポートを閉じられる | E-01 L586-589 | ○ |
| C-72 | Disposeでリソースが解放される | E-01 L591-605 | ○ |

### SerialPortクラス - Readメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | Read(byte[])でバイト配列に読み込める | E-01 L658-700 | ○ |
| C-74 | Read(byte[])で閉じているときに例外 | E-01 L660-661 | ○ |
| C-75 | Read(byte[])でbuffer=nullで例外 | E-01 L662-663 | ○ |
| C-76 | Read(byte[])でoffset<0で例外 | E-01 L664-665 | ○ |
| C-77 | Read(byte[])でcount<0で例外 | E-01 L666-667 | ○ |
| C-78 | Read(byte[])でoffset+count>lengthで例外 | E-01 L668-669 | ○ |
| C-79 | Read(char[])で文字配列に読み込める | E-01 L799-813 | ○ |
| C-80 | Read(char[])でbuffer=nullで例外 | E-01 L803-804 | ○ |
| C-81 | ReadCharで1文字読み込める | E-01 L704-710 | ○ |
| C-82 | ReadCharで閉じているときに例外 | E-01 L706-707 | ○ |
| C-83 | ReadCharでタイムアウト時に例外 | E-01 L763-764 | ○ |
| C-84 | ReadByteで1バイト読み込める | E-01 L979-988 | ○ |
| C-85 | ReadByteで閉じているときに例外 | E-01 L981-982 | ○ |
| C-86 | ReadLineで改行文字まで読み込める | E-01 L1051-1054 | ○ |
| C-87 | ReadLineでタイムアウト時に例外 | E-01 L1096 | ○ |
| C-88 | ReadToで指定文字列まで読み込める | E-01 L1056-1171 | ○ |
| C-89 | ReadToで閉じているときに例外 | E-01 L1058-1059 | ○ |
| C-90 | ReadToでvalue=nullで例外 | E-01 L1060-1061 | ○ |
| C-91 | ReadToでvalue=""で例外 | E-01 L1062-1063 | ○ |
| C-92 | ReadExistingで全データ読み込める | E-01 L990-1049 | ○ |
| C-93 | ReadExistingで閉じているときに例外 | E-01 L992-993 | ○ |

### SerialPortクラス - Writeメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | Write(string)で文字列を書き込める | E-01 L1174-1186 | ○ |
| C-95 | Write(string)で閉じているときに例外 | E-01 L1176-1177 | ○ |
| C-96 | Write(string)でtext=nullで例外 | E-01 L1178-1179 | ○ |
| C-97 | Write(string)で空文字は何も送信しない | E-01 L1180 | ○ |
| C-98 | Write(byte[])でバイト配列を書き込める | E-01 L1210-1225 | ○ |
| C-99 | Write(byte[])でbuffer=nullで例外 | E-01 L1214-1215 | ○ |
| C-100 | Write(byte[])でoffset<0で例外 | E-01 L1216-1217 | ○ |
| C-101 | Write(byte[])でcount<0で例外 | E-01 L1218-1219 | ○ |
| C-102 | Write(char[])で文字配列を書き込める | E-01 L1190-1207 | ○ |
| C-103 | Write(char[])でbuffer=nullで例外 | E-01 L1194-1195 | ○ |
| C-104 | WriteLineで改行付き文字列を書き込める | E-01 L1227-1230 | ○ |

### SerialPortクラス - Buffer/Event操作
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | DiscardInBufferで入力バッファクリア | E-01 L607-613 | ○ |
| C-106 | DiscardInBufferで閉じているときに例外 | E-01 L609-610 | ○ |
| C-107 | DiscardOutBufferで出力バッファクリア | E-01 L615-620 | ○ |
| C-108 | DiscardOutBufferで閉じているときに例外 | E-01 L617-618 | ○ |
| C-109 | GetPortNamesでポート名一覧取得 | E-05 L14-30, E-06 L13-37 | ○ |
| C-110 | GetPortNamesでポートなしなら空配列 | E-06 L36 | ○ |
| C-111 | DataReceivedイベントが発火 | E-01 L66, L75-102 | ○ |
| C-112 | PinChangedイベントが発火 | E-01 L104-131 | ○ |
| C-113 | ErrorReceivedイベントが発火 | E-01 L66 | ○ |

### SerialStreamクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | CanReadがtrueを返す | E-02 L35-38 | ○ |
| C-115 | CanWriteがtrueを返す | E-02 L50-53 | ○ |
| C-116 | CanSeekがfalseを返す | E-02 L40-43 | ○ |
| C-117 | CanTimeoutがtrueを返す | E-02 L45-48 | ○ |
| C-118 | Lengthで例外 | E-02 L55-58 | ○ |
| C-119 | Position getで例外 | E-02 L60-64 | ○ |
| C-120 | Position setで例外 | E-02 L63 | ○ |
| C-121 | Seekで例外 | E-02 L66-69 | ○ |
| C-122 | SetLengthで例外 | E-02 L71-74 | ○ |
| C-123 | ReadByteで1バイト読み込める | E-02 L76-79, E-03 L411-415 | ○ |
| C-124 | Readでバイト配列に読み込める | E-03 L417-437 | ○ |
| C-125 | Writeでバイト配列を書き込める | E-03 L559-574 | ○ |
| C-126 | Writeでブレーク状態で例外 | E-02 L118-119, L126-127 | ○ |
| C-127 | WriteByteで1バイト書き込める | E-04 L1104-1140 | ○ |
| C-128 | WriteByteでブレーク状態で例外 | E-04 L1106-1107 | ○ |
| C-129 | Flushでフラッシュ完了 | E-03 L398-409, E-04 L992-996 | ○ |
| C-130 | BeginReadで非同期読み込み開始 | E-03 L520-523, E-04 L791-811 | ○ |
| C-131 | EndReadで非同期読み込み完了 | E-03 L439-441, E-04 L856-925 | ○ |
| C-132 | EndReadでnullで例外 | E-04 L861-862 | ○ |
| C-133 | EndReadで不正なIAsyncResultで例外 | E-04 L864-866 | ○ |
| C-134 | EndRead2回呼び出しで例外 | E-04 L870-871 | ○ |
| C-135 | BeginWriteで非同期書き込み開始 | E-03 L576-579, E-04 L815-836 | ○ |
| C-136 | BeginWriteでブレーク状態で例外 | E-04 L818 (CheckWriteArguments) | ○ |
| C-137 | EndWriteで非同期書き込み完了 | E-03 L581-582, E-04 L931-986 | ○ |
| C-138 | EndWriteでブレーク状態で例外 | E-04 L939-940 | ○ |
| C-139 | EndWrite2回呼び出しで例外 | E-04 L950-951 | ○ |
| C-140 | DiscardInBufferでクリア | E-03 L368-373, E-04 L839-844 | ○ |
| C-141 | DiscardOutBufferでクリア | E-03 L375-380, E-04 L846-851 | ○ |
| C-142 | SetBufferSizesで設定 | E-03 L383-388, E-04 L1059-1065 | ○ |
| C-143 | Disposeでリソース解放 | E-03 L714-735, E-04 L704-786 | ○ |

### 列挙型とイベント引数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | Parityの値が正しい | E-07 L6-13 | ○ |
| C-145 | StopBitsの値が正しい | E-08 L6-12 | ○ |
| C-146 | Handshakeの値が正しい | E-09 L6-12 | ○ |
| C-147 | SerialDataの値が正しい | E-10 L6-13 | ○ |
| C-148 | SerialErrorの値が正しい | E-11 L6-13 | ○ |
| C-149 | SerialPinChangeの値が正しい | E-12 L6-13 | ○ |
| C-150 | SerialDataReceivedEventArgs.EventType取得 | E-13 L6-14 | ○ |
| C-151 | SerialErrorReceivedEventArgs.EventType取得 | E-14 L6-14 | ○ |
| C-152 | SerialPinChangedEventArgs.EventType取得 | E-15 L6-14 | ○ |

### InternalResourcesとSafeSerialDeviceHandle
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-153 | EndOfFileでEndOfStreamException | E-16 L12-15 | ○ |
| C-154 | FileNotOpenでObjectDisposedException | E-16 L27-30 | ○ |
| C-155 | WrongAsyncResultでArgumentException | E-16 L32-35 | ○ |
| C-156 | EndReadCalledTwiceでArgumentException | E-16 L37-41 | ○ |
| C-157 | EndWriteCalledTwiceでArgumentException | E-16 L43-47 | ○ |
| C-158 | SafeSerialDeviceHandle.Openで有効なポートでハンドル取得（Unix） | E-17 L19-35 | △ |
| C-159 | SafeSerialDeviceHandle.Openで無効なポートで例外（Unix） | E-17 L24-31 | △ |
| C-160 | SafeSerialDeviceHandle.ReleaseHandleでハンドル解放 | E-17 L37-45 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SIO-158, UT-SIO-159**: SafeSerialDeviceHandle.OpenのテストはUnixプラットフォーム固有であり、実際のデバイスファイル（/dev/ttyUSB0等）へのアクセスが必要。モック化またはプラットフォーム固有のテスト環境が必要。
  - 候補：Unix環境でのみテスト実行 / デバイスファイルのモック化 / 仮想シリアルポートの使用

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: 列挙型の値検証（UT-SIO-144〜149）、イベント引数のプロパティ検証（UT-SIO-150〜152）、InternalResourcesのヘルパーメソッド（UT-SIO-153〜157）
- **1: 中リスク**: バッファサイズ設定、タイムアウト設定、モデム状態取得など、実際のハードウェア動作に依存するテスト
- **2: 高リスク**:
  - イベントテスト（DataReceived, PinChanged, ErrorReceived）: 実際のシリアル通信が必要
  - 非同期I/Oテスト: タイミング依存の問題が発生しやすい
  - プラットフォーム固有テスト: Windows/Unix間で動作が異なる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションテストケース（例外スロー）が全プロパティ/メソッドで網羅されているか
- [ ] タイムアウト関連のテストケースが適切にTimeoutExceptionを期待しているか
- [ ] ポートが開いている/閉じている状態での動作テストが対になっているか
- [ ] 境界値テスト（DataBits=5,8、BaudRate=最大値など）が含まれているか
- [ ] 非同期I/O（BeginRead/EndRead、BeginWrite/EndWrite）の正常系/異常系が網羅されているか
- [ ] プラットフォーム固有のテスト（GetPortNames、SafeSerialDeviceHandle）が適切にマークされているか
- [ ] イベントテストの前提条件（実際のハードウェアまたはモック）が明記されているか
