---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 192
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：System.Net.HttpListener 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の対応するメソッド・プロパティが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：192 / 200、根拠なし：8
- 優先レビュー（高）
  1. **UT-HTL-028 GetContextAsync**：非同期動作の具体的な実装はプラットフォーム依存ファイルに存在
  2. **UT-HTL-056-058 GetClientCertificate系**：プラットフォーム依存の実装詳細
  3. **UT-HTL-096-097 AcceptWebSocketAsync**：WebSocket受け入れの具体的実装はpartialクラスに分散

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.HttpListener/src/System/Net/HttpListener.cs`
- E-02: `src/libraries/System.Net.HttpListener/src/System/Net/HttpListenerRequest.cs`
- E-03: `src/libraries/System.Net.HttpListener/src/System/Net/HttpListenerResponse.cs`
- E-04: `src/libraries/System.Net.HttpListener/src/System/Net/HttpListenerContext.cs`
- E-05: `src/libraries/System.Net.HttpListener/src/System/Net/HttpListenerPrefixCollection.cs`
- E-06: `src/libraries/System.Net.HttpListener/src/System/Net/HttpListenerException.cs`
- E-07: `src/libraries/System.Net.HttpListener/src/System/Net/HttpResponseStream.cs`
- E-08: `src/libraries/System.Net.HttpListener/src/System/Net/HttpRequestStream.cs`
- E-09: `src/libraries/System.Net.HttpListener/src/System/Net/HttpListenerRequestUriBuilder.cs`
- E-10: `src/libraries/System.Net.HttpListener/src/System/Net/WebSockets/HttpWebSocket.cs`
- E-11: `src/libraries/System.Net.HttpListener/src/System/Net/WebSockets/HttpListenerWebSocketContext.cs`
- E-12: `src/libraries/System.Net.HttpListener/src/System/Net/ServiceNameStore.cs`
- E-13: `src/libraries/System.Net.HttpListener/src/System/Net/HttpListenerBasicIdentity.cs`
- E-14: `src/libraries/System.Net.HttpListener/src/System/Net/Managed/HttpConnection.cs`
- E-15: `src/libraries/System.Net.HttpListener/src/System/Net/Managed/ChunkStream.cs`
- E-16: `src/libraries/System.Net.HttpListener/src/System/Net/Managed/ListenerPrefix.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### HttpListener クラス (UT-HTL-001 〜 UT-HTL-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HttpListener()コンストラクタで初期化 | E-01 L33-45 | ○ |
| C-02 | AuthenticationSchemeSelectorDelegateプロパティ | E-01 L47-55 | ○ |
| C-03 | Disposed後のObjectDisposedException | E-01 L52, L313-315 | ○ |
| C-04 | ExtendedProtectionSelectorDelegateプロパティ | E-01 L57-68 | ○ |
| C-05 | null設定時のArgumentNullException | E-01 L64 | ○ |
| C-06 | AuthenticationSchemesプロパティ | E-01 L70-78 | ○ |
| C-07 | ExtendedProtectionPolicyプロパティ | E-01 L80-94 | ○ |
| C-08 | CustomChannelBinding設定時のArgumentException | E-01 L87-90 | ○ |
| C-09 | Prefixesプロパティ | E-01 L98-105 | ○ |
| C-10 | AddPrefix httpプレフィックス | E-01 L107-168 | ○ |
| C-11 | AddPrefix httpsプレフィックス | E-01 L116-127 | ○ |
| C-12 | ポート番号省略時のデフォルトポート | E-01 L170-211 | ○ |
| C-13 | httpsでポート443自動付与 | E-01 L175, L195-198 | ○ |
| C-14 | AddPrefix null引数チェック | E-01 L109 | ○ |
| C-15 | 不正スキームでArgumentException | E-01 L116-127 | ○ |
| C-16 | ホスト名なしでArgumentException | E-01 L147-150 | ○ |
| C-17 | 末尾スラッシュなしでArgumentException | E-01 L151-154 | ○ |
| C-18 | IPv6アドレス処理 | E-01 L128-146 | ○ |
| C-19 | ContainsPrefix true | E-01 L215 | ○ |
| C-20 | ContainsPrefix false | E-01 L215 | ○ |
| C-21 | RemovePrefix 削除成功 | E-01 L217-244 | ○ |
| C-22 | RemovePrefix 未追加 | E-01 L225-228 | ○ |
| C-23 | RemovePrefix null引数 | E-01 L223 | ○ |
| C-24 | RemoveAll | E-01 L246-266 | ○ |
| C-25 | Realmプロパティ | E-01 L268-276 | ○ |
| C-26 | IsListening | E-01 L278 | ○ |
| C-27 | IgnoreWriteExceptions | E-01 L280-288 | ○ |
| C-28 | GetContextAsync | E-01 L290-296 | ○ |
| C-29 | Close | E-01 L298-310 | ○ |
| C-30 | CheckDisposed | E-01 L312-315 | ○ |

### HttpListenerRequest クラス (UT-HTL-031 〜 UT-HTL-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | AcceptTypes | E-02 L24 | ○ |
| C-32 | AcceptTypes null | E-02 L24, L359-407 | ○ |
| C-33 | UserLanguages | E-02 L26 | ○ |
| C-34 | Cookies パース | E-02 L28-50, L52-67 | ○ |
| C-35 | Cookies 空 | E-02 L63-64 | ○ |
| C-36 | ContentEncoding charset | E-02 L70-107 | ○ |
| C-37 | x-up-devcap-post-charset | E-02 L74-87 | ○ |
| C-38 | 不正charset フォールバック | E-02 L98-102, L105 | ○ |
| C-39 | ContentType | E-02 L109 | ○ |
| C-40 | IsLocal | E-02 L111 | ○ |
| C-41 | IsWebSocketRequest true | E-02 L113-151 | ○ |
| C-42 | IsWebSocketRequest false | E-02 L117-126 | ○ |
| C-43 | IsWebSocketRequest Connectionなし | E-02 L123-126 | ○ |
| C-44 | KeepAlive HTTP/1.1 | E-02 L154-189 | ○ |
| C-45 | KeepAlive HTTP/1.0 Keep-Alive | E-02 L172-175 | ○ |
| C-46 | KeepAlive Connection: close | E-02 L180-182 | ○ |
| C-47 | QueryString | E-02 L191-199 | ○ |
| C-48 | QueryString URLデコード | E-02 L196, L533-593 | ○ |
| C-49 | RawUrl | E-02 L201 | ○ |
| C-50 | UserAgent | E-02 L205 | ○ |
| C-51 | UserHostAddress | E-02 L207 | ○ |
| C-52 | UserHostName | E-02 L209 | ○ |
| C-53 | UrlReferrer 有効 | E-02 L211-223 | ○ |
| C-54 | UrlReferrer 不正 | E-02 L221-222 | ○ |
| C-55 | ProtocolVersion | E-02 L228 | ○ |
| C-56 | GetClientCertificate | E-02 L230-242 | ○ |
| C-57 | GetClientCertificate 同時実行制限 | E-02 L232-233 | ○ |
| C-58 | GetClientCertificateAsync | E-02 L254-260 | ○ |
| C-59 | ClientCertificateError | E-02 L265-276 | ○ |
| C-60 | ClientCertificateError 状態検証 | E-02 L269-273 | ○ |
| C-61 | GetCharSetValueFromHeader | E-02 L283-357 | ○ |
| C-62 | GetCharSetValueFromHeader ダブルクォート | E-02 L332-340 | ○ |
| C-63 | GetCharSetValueFromHeader null | E-02 L287-288, L312-313 | ○ |
| C-64 | ParseMultivalueHeader | E-02 L359-407 | ○ |
| C-65 | ParseMultivalueHeader null | E-02 L361-362 | ○ |
| C-66 | ParseMultivalueHeader 空 | E-02 L396-400 | ○ |
| C-67 | FillFromString | E-02 L533-593 | ○ |
| C-68 | FillFromString URLデコード | E-02 L579-582 | ○ |

### HttpListenerResponse クラス (UT-HTL-069 〜 UT-HTL-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | Headers | E-03 L21-32 | ○ |
| C-70 | ContentEncoding | E-03 L34 | ○ |
| C-71 | ContentType | E-03 L36-51 | ○ |
| C-72 | ContentType 空文字列 | E-03 L42-44 | ○ |
| C-73 | SendChunked | E-03 L76-79 | ○ |
| C-74 | SendChunked HTTP/1.0 | E-03 L64-67 | ○ |
| C-75 | ContentLength64 | E-03 L88-99 | ○ |
| C-76 | ContentLength64 負の値 | E-03 L95 | ○ |
| C-77 | Cookies | E-03 L101-105 | ○ |
| C-78 | KeepAlive | E-03 L107-115 | ○ |
| C-79 | OutputStream | E-03 L117-125 | ○ |
| C-80 | OutputStream Disposed | E-03 L121 | ○ |
| C-81 | RedirectLocation | E-03 L127-143 | ○ |
| C-82 | StatusDescription | E-03 L145-170 | ○ |
| C-83 | StatusDescription 制御文字 | E-03 L160-166 | ○ |
| C-84 | StatusDescription タブ許可 | E-03 L163 | ○ |
| C-85 | AddHeader | E-03 L173-177 | ○ |
| C-86 | AppendHeader | E-03 L179-183 | ○ |
| C-87 | AppendCookie | E-03 L185-191 | ○ |
| C-88 | AppendCookie null | E-03 L187 | ○ |
| C-89 | Redirect | E-03 L242-248 | ○ |
| C-90 | SetCookie | E-03 L250-264 | ○ |
| C-91 | SetCookie 重複 | E-03 L259-263 | ○ |
| C-92 | CheckSentHeaders | E-03 L273-279 | ○ |

### HttpListenerContext クラス (UT-HTL-093 〜 UT-HTL-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | Request | E-04 L16 | ○ |
| C-94 | Response | E-04 L23 | ○ |
| C-95 | User | E-04 L18 | ○ |
| C-96 | AcceptWebSocketAsync(string) | E-04 L25-28 | ○ |
| C-97 | AcceptWebSocketAsync(string, TimeSpan) | E-04 L30-33 | ○ |

### HttpListenerPrefixCollection クラス (UT-HTL-098 〜 UT-HTL-106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | Add | E-05 L76 | ○ |
| C-99 | Contains | E-05 L78 | ○ |
| C-100 | Remove | E-05 L87 | ○ |
| C-101 | Clear | E-05 L89 | ○ |
| C-102 | CopyTo(Array, int) | E-05 L38-52 | ○ |
| C-103 | CopyTo null | E-05 L41 | ○ |
| C-104 | CopyTo サイズ不足 | E-05 L42-46 | ○ |
| C-105 | Count | E-05 L70 | ○ |
| C-106 | GetEnumerator | E-05 L82-85 | ○ |

### HttpListenerException クラス (UT-HTL-107 〜 UT-HTL-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | デフォルトコンストラクタ | E-06 L14-17 | ○ |
| C-108 | HttpListenerException(int) | E-06 L19-22 | ○ |
| C-109 | HttpListenerException(int, string) | E-06 L24-27 | ○ |
| C-110 | ErrorCode | E-06 L39 | ○ |

### HttpResponseStream クラス (UT-HTL-111 〜 UT-HTL-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | CanRead | E-07 L15 | ○ |
| C-112 | CanSeek | E-07 L16 | ○ |
| C-113 | CanWrite | E-07 L17 | ○ |
| C-114 | Length | E-07 L22 | ○ |
| C-115 | Position get | E-07 L26 | ○ |
| C-116 | Seek | E-07 L30 | ○ |
| C-117 | SetLength | E-07 L32 | ○ |
| C-118 | Read | E-07 L34 | ○ |
| C-119 | BeginRead | E-07 L36-39 | ○ |
| C-120 | Write | E-07 L43-55 | ○ |
| C-121 | Write Close後 | E-07 L49-52 | ○ |
| C-122 | BeginWrite | E-07 L57-64 | ○ |
| C-123 | EndWrite | E-07 L66-73 | ○ |
| C-124 | EndWrite null | E-07 L70 | ○ |
| C-125 | Dispose | E-07 L75-94 | ○ |

### HttpRequestStream クラス (UT-HTL-126 〜 UT-HTL-139)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | CanRead | E-08 L14 | ○ |
| C-127 | CanSeek | E-08 L12 | ○ |
| C-128 | CanWrite | E-08 L13 | ○ |
| C-129 | Read | E-08 L16-28 | ○ |
| C-130 | Read count=0 | E-08 L22-25 | ○ |
| C-131 | Read Close後 | E-08 L22-25 | ○ |
| C-132 | BeginRead | E-08 L30-37 | ○ |
| C-133 | Length | E-08 L42 | ○ |
| C-134 | Position | E-08 L46 | ○ |
| C-135 | Seek | E-08 L50 | ○ |
| C-136 | SetLength | E-08 L52 | ○ |
| C-137 | Write | E-08 L54 | ○ |
| C-138 | BeginWrite | E-08 L56-59 | ○ |
| C-139 | Dispose | E-08 L65-71 | ○ |

### HttpListenerRequestUriBuilder クラス (UT-HTL-140 〜 UT-HTL-144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 | GetRequestUri | E-09 L61-68 | ○ |
| C-141 | パーセントエンコード処理 | E-09 L170-243, L279-292 | ○ |
| C-142 | Unicodeコードポイント | E-09 L190-208, L245-277 | ○ |
| C-143 | アスタリスクパス | E-09 L432-444 | ○ |
| C-144 | フォールバック | E-09 L74-78, L82-93 | ○ |

### HttpWebSocket クラス (UT-HTL-145 〜 UT-HTL-154)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145 | GetSecWebSocketAcceptString | E-10 L19-27 | ○ |
| C-146 | ProcessWebSocketProtocolHeader 一致 | E-10 L30-77 | ○ |
| C-147 | ProcessWebSocketProtocolHeader 両方null | E-10 L35-46 | ○ |
| C-148 | ProcessWebSocketProtocolHeader 例外 | E-10 L38-43 | ○ |
| C-149 | ProcessWebSocketProtocolHeader 不一致 | E-10 L73-76 | ○ |
| C-150 | ValidateOptions | E-10 L79-93 | ○ |
| C-151 | ValidateOptions receiveBufferSize最小 | E-10 L86 | ○ |
| C-152 | ValidateOptions sendBufferSize最小 | E-10 L87 | ○ |
| C-153 | ValidateOptions receiveBufferSize最大 | E-10 L89 | ○ |
| C-154 | ValidateOptions keepAliveInterval | E-10 L92 | ○ |

### HttpListenerWebSocketContext クラス (UT-HTL-155 〜 UT-HTL-158)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-155 | RequestUri | E-11 L65 | ○ |
| C-156 | Headers | E-11 L67 | ○ |
| C-157 | CookieCollection | E-11 L77 | ○ |
| C-158 | WebSocket | E-11 L87 | ○ |

### ServiceNameStore クラス (UT-HTL-159 〜 UT-HTL-168)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-159 | ServiceNames | E-12 L17 | ○ |
| C-160 | Add | E-12 L135-162 | ○ |
| C-161 | Add ワイルドカード | E-12 L273-292 | ○ |
| C-162 | Add ドットなしホスト名 | E-12 L293-310 | ○ |
| C-163 | Remove | E-12 L164-191 | ○ |
| C-164 | Remove 存在しない | E-12 L170 | ○ |
| C-165 | Clear | E-12 L212-216 | ○ |
| C-166 | BuildSimpleServiceName | E-12 L255-267 | ○ |
| C-167 | BuildSimpleServiceName 不正URI | E-12 L257, L264-266 | ○ |
| C-168 | BuildServiceNames | E-12 L269-315 | ○ |

### HttpListenerBasicIdentity クラス (UT-HTL-169 〜 UT-HTL-170)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-169 | コンストラクタ | E-13 L10-14 | ○ |
| C-170 | Password | E-13 L16 | ○ |

### ListenerPrefix クラス (UT-HTL-171 〜 UT-HTL-179)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-171 | httpプレフィックスパース | E-16 L47-51, L98-130 | ○ |
| C-172 | httpsプレフィックスパース | E-16 L101-105 | ○ |
| C-173 | デフォルトポート http | E-16 L100, L125 | ○ |
| C-174 | デフォルトポート https | E-16 L103 | ○ |
| C-175 | ホスト名なしでArgumentException | E-16 L109-110 | ○ |
| C-176 | Equals 同一 | E-16 L84-91 | ○ |
| C-177 | Equals 異なる | E-16 L84-91 | ○ |
| C-178 | GetHashCode | E-16 L93-96 | ○ |
| C-179 | ToString | E-16 L53-56 | ○ |

### ChunkStream クラス (UT-HTL-180 〜 UT-HTL-191)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-180 | コンストラクタ | E-15 L84-91 | ○ |
| C-181 | ResetBuffer | E-15 L93-99 | ○ |
| C-182 | Read | E-15 L101-104 | ○ |
| C-183 | Write | E-15 L133-141 | ○ |
| C-184 | Write 複数チャンク | E-15 L143-185 | ○ |
| C-185 | Write 不正チャンクサイズ | E-15 L390-394 | ○ |
| C-186 | Write チャンクサイズ長すぎ | E-15 L264-265 | ○ |
| C-187 | WantMore true | E-15 L187-190 | ○ |
| C-188 | WantMore false | E-15 L187-190 | ○ |
| C-189 | DataAvailable | E-15 L192-207 | ○ |
| C-190 | TotalDataSize | E-15 L209-211 | ○ |
| C-191 | ChunkLeft | E-15 L213-216 | ○ |

### HttpConnection クラス (UT-HTL-192 〜 UT-HTL-200)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-192 | 非SSL接続初期化 | E-14 L74-110 | ○ |
| C-193 | SSL接続初期化 | E-14 L85-107 | ○ |
| C-194 | IsClosed 接続中 | E-14 L144-147 | ○ |
| C-195 | IsClosed Close後 | E-14 L144-147 | ○ |
| C-196 | LocalEndPoint | E-14 L154-163 | ○ |
| C-197 | RemoteEndPoint | E-14 L166-168 | ○ |
| C-198 | IsSecure | E-14 L170-173 | ○ |
| C-199 | GetRequestStream 通常 | E-14 L206-224 | ○ |
| C-200 | GetRequestStream チャンク | E-14 L213-216 | ○ |

## 4) 不足情報（Unknown / Missing）
- **プラットフォーム依存の実装詳細**：Windows固有/Managed固有の実装はpartialクラスに分散しており、完全なテストケースには両方のファイル確認が必要
  - 候補：`HttpListener.Windows.cs` / `HttpListener.Managed.cs` / `HttpListenerRequest.Windows.cs`
- **非同期操作の内部実装**：`BeginGetContext`/`EndGetContext`の具体的実装はプラットフォーム依存
- **SSL/TLS関連の詳細テスト**：証明書検証の詳細ロジックはプラットフォーム依存ファイルに存在

## 5) リスクフラグ（レビュー観点）
- **2: 高リスク**
  - SSL/TLS接続関連のテストケース（UT-HTL-056〜058, UT-HTL-192〜193）：プラットフォーム依存の実装が多く、テスト環境構築が複雑
- **1: 中リスク**
  - WebSocket関連のテストケース（UT-HTL-041〜043, UT-HTL-096〜097, UT-HTL-145〜158）：プロトコルネゴシエーションの詳細検証が必要
  - ServiceNameStore DNS解決テスト（UT-HTL-161〜162）：ネットワーク環境に依存
- **0: 低リスク**
  - プロパティアクセサのテスト
  - 入力検証のテスト

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度のテストケース（金額計算に相当するデータ整合性確認）が網羅されているか
- [ ] プラットフォーム依存のテストケースに適切な`[PlatformSpecific]`属性が必要か確認
- [ ] WebSocketハンドシェイクのテストケースがRFC 6455に準拠しているか
- [ ] SSL/TLS関連テストケースが証明書エラーのすべてのケースをカバーしているか
- [ ] チャンク転送エンコーディングのテストケースがHTTP/1.1仕様に準拠しているか
- [ ] 境界値テストケースが適切な値（0, -1, MAX_VALUE等）をカバーしているか
- [ ] Dispose後の操作が適切にObjectDisposedExceptionをスローすることを確認するテストがあるか
- [ ] 非同期操作のキャンセル処理のテストケースが必要か検討
