---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 152
  claims_with_evidence: 152
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.Net.Security 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：152 / 152、根拠なし：0
- 優先レビュー（高）
  1. **認証関連テストケース（UT-SEC-006〜009）**：実際のSSL/TLS接続テストには証明書環境が必要
  2. **NegotiateStream認証テスト（UT-SEC-051〜058）**：Kerberos/NTLM環境依存
  3. **TlsFrameHelperテスト（UT-SEC-137〜147）**：バイナリプロトコル解析のため詳細なテストデータ準備が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Security/src/System/Net/Security/SslStream.cs`
- E-02: `src/libraries/System.Net.Security/src/System/Net/Security/AuthenticatedStream.cs`
- E-03: `src/libraries/System.Net.Security/src/System/Net/Security/NegotiateStream.cs`
- E-04: `src/libraries/System.Net.Security/src/System/Net/Security/NegotiateAuthentication.cs`
- E-05: `src/libraries/System.Net.Security/src/System/Net/Security/SslApplicationProtocol.cs`
- E-06: `src/libraries/System.Net.Security/src/System/Net/Security/SslClientAuthenticationOptions.cs`
- E-07: `src/libraries/System.Net.Security/src/System/Net/Security/SslServerAuthenticationOptions.cs`
- E-08: `src/libraries/System.Net.Security/src/System/Net/Security/SslStreamCertificateContext.cs`
- E-09: `src/libraries/System.Net.Security/src/System/Net/Security/TlsFrameHelper.cs`
- E-10: `src/libraries/System.Net.Security/src/System/Net/Security/NegotiateAuthenticationClientOptions.cs`
- E-11: `src/libraries/System.Net.Security/src/System/Net/Security/NegotiateAuthenticationServerOptions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### SslStream クラス（UT-SEC-001〜043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SslStream コンストラクタはnullストリームでArgumentNullExceptionをスロー | E-01: 行17-19 (AuthenticatedStream経由) | ○ |
| C-02 | SslStream コンストラクタは読み取り専用ストリームでArgumentExceptionをスロー | E-02: 行22-25 | ○ |
| C-03 | SslStream コンストラクタは不正なEncryptionPolicyでArgumentExceptionをスロー | E-01: 行209-212 | ○ |
| C-04 | AuthenticateAsClientはnullオプションでArgumentNullExceptionをスロー | E-01: 行334, 396 | ○ |
| C-05 | AuthenticateAsServerはnullオプションでArgumentNullExceptionをスロー | E-01: 行368, 435 | ○ |
| C-06 | IsAuthenticatedは認証完了後にtrueを返却 | E-01: 行462 | ○ |
| C-07 | IsMutuallyAuthenticatedは相互認証完了時にtrueを返却 | E-01: 行464-472 | ○ |
| C-08 | IsEncrypted/IsSignedは認証完了後にtrueを返却 | E-01: 行475-477 | ○ |
| C-09 | SslProtocolは認証前にInvalidOperationExceptionをスロー | E-01: 行485, 931-939 | ○ |
| C-10 | Read/Writeは認証前にInvalidOperationExceptionをスロー | E-01: 行920-928 | ○ |
| C-11 | ShutdownAsyncは二重呼び出しでInvalidOperationExceptionをスロー | E-01: 行942-961 | ○ |
| C-12 | NegotiateClientCertificateAsyncは既存証明書時にInvalidOperationExceptionをスロー | E-01: 行693-702 | ○ |
| C-13 | CanSeekは常にfalseを返却 | E-01: 行654 | ○ |
| C-14 | Seek/Position.setはNotSupportedExceptionをスロー | E-01: 行676-684 | ○ |
| C-15 | Disposeでリソースが解放される | E-01: 行704-714 | ○ |

### AuthenticatedStream クラス（UT-SEC-044〜049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | AuthenticatedStream コンストラクタはnullストリームでArgumentNullExceptionをスロー | E-02: 行17-19 | ○ |
| C-17 | AuthenticatedStream コンストラクタは読み取り専用ストリームでArgumentExceptionをスロー | E-02: 行22-25 | ○ |
| C-18 | LeaveInnerStreamOpenプロパティは設定値を返却 | E-02: 行31-37 | ○ |
| C-19 | Disposeはleave=falseで内部ストリームをDispose | E-02: 行47-66 | ○ |
| C-20 | Disposeはleave=trueで内部ストリームをFlushのみ | E-02: 行53-56 | ○ |

### NegotiateStream クラス（UT-SEC-050〜076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | NegotiateStream認証にはNetworkCredentialが必要 | E-03: 行640-641 | ○ |
| C-22 | 不正なImpersonationLevelでArgumentOutOfRangeExceptionをスロー | E-03: 行643-648 | ○ |
| C-23 | ExtendedProtectionPolicyの検証 | E-03: 行603-618 | ○ |
| C-24 | IsAuthenticatedはコンテキストと状態に依存 | E-03: 行219-222 | ○ |
| C-25 | IsMutuallyAuthenticatedはNTLMを除外 | E-03: 行224-227 | ○ |
| C-26 | Read/Writeは並行呼び出しでNotSupportedExceptionをスロー | E-03: 行343-346, 509-511 | ○ |
| C-27 | ImpersonationLevel/RemoteIdentityは認証前にInvalidOperationExceptionをスロー | E-03: 行239-241, 250-256 | ○ |
| C-28 | CanSeekは常にfalseを返却 | E-03: 行259 | ○ |

### NegotiateAuthentication クラス（UT-SEC-077〜105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | NegotiateAuthentication コンストラクタはnullオプションでArgumentNullExceptionをスロー | E-04: 行36, 52 | ○ |
| C-30 | IsAuthenticatedはDispose後にfalseを返却 | E-04: 行84 | ○ |
| C-31 | ProtectionLevelは署名/暗号化状態に基づく | E-04: 行96-99 | ○ |
| C-32 | RemoteIdentityは認証前にInvalidOperationExceptionをスロー | E-04: 行162-169 | ○ |
| C-33 | GetOutgoingBlobはDispose後にInvalidOperationExceptionをスロー | E-04: 行210-213 | ○ |
| C-34 | Wrap/Unwrap/ComputeIntegrityCheck/VerifyIntegrityCheckは認証前にInvalidOperationExceptionをスロー | E-04: 行291-296, 318-322, 370-374, 395-400 | ○ |

### SslApplicationProtocol 構造体（UT-SEC-106〜119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | コンストラクタはnullでArgumentNullExceptionをスロー | E-05: 行43, 48 | ○ |
| C-36 | コンストラクタは空/256バイト以上でArgumentExceptionをスロー | E-05: 行32-35 | ○ |
| C-37 | Equals/GetHashCode/ToStringの実装 | E-05: 行54-106 | ○ |
| C-38 | 静的フィールドHttp11/Http2/Http3の定義 | E-05: 行19-23 | ○ |

### SslClientAuthenticationOptions / SslServerAuthenticationOptions（UT-SEC-120〜131）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | EncryptionPolicy setterは不正値でArgumentExceptionをスロー | E-06: 行69-74, E-07: 行71-76 | ○ |
| C-40 | CertificateRevocationCheckMode setterは不正値でArgumentExceptionをスロー | E-06: 行54-58, E-07: 行57-61 | ○ |
| C-41 | デフォルト値の検証 | E-06: 行17-18, 101, 114, E-07: 行16-17, 97, 110 | ○ |

### SslStreamCertificateContext クラス（UT-SEC-132〜136）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | Createは秘密鍵のない証明書でNotSupportedExceptionをスロー | E-08: 行42-45 | ○ |
| C-43 | TargetCertificate/IntermediateCertificatesプロパティ | E-08: 行17-22 | ○ |
| C-44 | Duplicateメソッドの実装 | E-08: 行170-181 | ○ |

### TlsFrameHelper クラス（UT-SEC-137〜147）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | TryGetFrameHeaderは5バイト未満でfalseを返却 | E-09: 行172-177 | ○ |
| C-46 | TryGetFrameInfoはSNI/ALPN/Versionsを解析 | E-09: 行227-288 | ○ |
| C-47 | GetServerNameはSNIを取得 | E-09: 行292-301 | ○ |
| C-48 | TryGetAlertInfoは7バイト未満でfalseを返却 | E-09: 行304-306 | ○ |
| C-49 | CreateAlertFrameはアラートフレームを生成 | E-09: 行332-363 | ○ |

### NegotiateAuthenticationClientOptions / ServerOptions（UT-SEC-148〜152）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | デフォルト値の検証 | E-10: 行46-47, 52, 68, 79, E-11: 行30, 36, 47, 58 | ○ |

## 4) 不足情報（Unknown / Missing）
- 本テストケース一覧は全てソースコード解析に基づいて生成されており、根拠なしの項目はありません。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：プロパティ取得、デフォルト値確認等の単純なテスト
- **1（中リスク）**：状態遷移、例外処理等の標準的なテスト
- **2（高リスク）**：
  - 実際のSSL/TLS接続を伴うテスト（証明書環境依存）
  - Kerberos/NTLM認証を伴うテスト（AD環境依存）
  - バイナリプロトコル解析テスト（詳細なテストデータ準備が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] SSL/TLS認証テストケースの前提条件（証明書、サーバー環境）が明確か
- [ ] NegotiateStream/NegotiateAuthentication テストのKerberos/NTLM環境要件が明確か
- [ ] TlsFrameHelperテストのバイナリテストデータ準備方針が明確か
- [ ] 各テストケースの優先度が適切に設定されているか（セキュリティ関連は高優先度）
- [ ] 境界値テスト（配列サイズ、バッファサイズ）が十分にカバーされているか
- [ ] Dispose後の動作テストが網羅されているか
- [ ] 並行処理制限テスト（Read/Write同時呼び出し）が含まれているか
