---
generated_at: 2026-01-30 17:45:00
metrics:
  claims_total: 73
  claims_with_evidence: 71
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：System.Net.WebProxy 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：71 / 73、根拠なし：2
- 優先レビュー（高）
  1. **UT-WPX-063〜065**：IWebProxyScriptインターフェースの実装テスト - 実装クラスがモジュール内に存在しない
  2. **UT-WPX-070〜073**：ネットワーク変更イベント関連 - 静的フィールドの動作検証が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.WebProxy/src/System/Net/WebProxy.cs` - WebProxyクラスのメイン実装
- E-02: `src/libraries/System.Net.WebProxy/src/System/Net/WebProxy.NonWasm.cs` - 非WASM環境向けIsLocal実装
- E-03: `src/libraries/System.Net.WebProxy/src/System/Net/WebProxy.Wasm.cs` - WASM環境向けIsLocal実装
- E-04: `src/libraries/System.Net.WebProxy/src/System/Net/IWebProxyScript.cs` - IWebProxyScriptインターフェース定義
- E-05: `src/libraries/System.Net.WebProxy/ref/System.Net.WebProxy.cs` - 公開API定義（リファレンスアセンブリ）
- E-06: `src/libraries/System.Net.WebProxy/tests/WebProxyTest.cs` - 既存単体テスト

## 3) Claims と根拠の対応（レビューの主戦場）

### コンストラクタ関連（UT-WPX-001〜012）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebProxy()でデフォルト値が設定される | E-01 L21, E-06 L16 | ○ |
| C-02 | WebProxy(Uri)でAddress設定 | E-01 L23, E-06 L25 | ○ |
| C-03 | WebProxy(Uri)でnull許容 | E-01 L23, E-06 L256-257 | ○ |
| C-04 | WebProxy(Uri, bool)でBypassOnLocal設定 | E-01 L25, E-06 L27-28 | ○ |
| C-05 | WebProxy(Uri, bool, string[])でBypassList設定 | E-01 L27, E-06 L30-31 | ○ |
| C-06 | 無効な正規表現で例外スロー | E-01 L37, E-06 L124 | ○ |
| C-07 | WebProxy(Uri, bool, string[], ICredentials)で資格情報設定 | E-01 L29-39, E-06 L33-35 | ○ |
| C-08 | WebProxy(string)で文字列からUri作成 | E-01 L46-48, E-06 L18 | ○ |
| C-09 | スキームなし文字列にhttp://付与 | E-01 L115-117, E-06 L20 | ○ |
| C-10 | null文字列でAddressがnull | E-01 L108-113, E-06 L256 | ○ |
| C-11 | WebProxy(string, int)でホスト・ポート指定 | E-01 L41-44, E-06 L21 | ○ |
| C-12 | 既存ポートが上書きされる | E-01 L122-124, E-06 L23 | ○ |

### プロパティ関連（UT-WPX-013〜025）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | Addressプロパティの取得・設定 | E-01 L66, E-06 L106-116 | ○ |
| C-14 | Addressにnull設定可能 | E-01 L66, E-06 L114-115 | ○ |
| C-15 | BypassProxyOnLocal=trueでローカルバイパス | E-01 L68, E-06 L93-103 | ○ |
| C-16 | BypassProxyOnLocal=falseでバイパスなし | E-01 L68, E-06 L262-265 | ○ |
| C-17 | BypassListの取得・設定 | E-01 L71-89, E-06 L52-74 | ○ |
| C-18 | BypassListにnull設定で空配列返却 | E-01 L86, E-06 L70-73 | ○ |
| C-19 | 無効な正規表現で例外 | E-01 L87, E-06 L124 | ○ |
| C-20 | BypassArrayList取得可能 | E-01 L91, E-06 L47 | ○ |
| C-21 | BypassListとBypassArrayListの同期 | E-01 L91, E-06 L62-63 | ○ |
| C-22 | Credentials取得・設定 | E-01 L93, E-06 L48 | ○ |
| C-23 | Credentialsにnull設定可能 | E-01 L93, E-06 L81 | ○ |
| C-24 | UseDefaultCredentials=trueでDefaultCredentials | E-01 L95-98, E-06 L83-85 | ○ |
| C-25 | UseDefaultCredentials=falseでnull | E-01 L95-98, E-06 L87-89 | ○ |

### GetProxy/IsBypassed関連（UT-WPX-026〜045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | GetProxyでプロキシアドレス返却 | E-01 L101-106, E-06 L179-181 | ○ |
| C-27 | バイパス時に宛先アドレス返却 | E-01 L105, E-06 L186-188 | ○ |
| C-28 | Address=nullで宛先返却 | E-01 L105, E-06 L255-257 | ○ |
| C-29 | GetProxyにnullでArgumentNullException | E-01 L103, E-06 L122 | ○ |
| C-30 | IsBypassed: Address=nullでtrue | E-01 L200, E-06 L255-257 | ○ |
| C-31 | IsBypassed: ローカルホストでtrue | E-01 L201, E-06 L258 | ○ |
| C-32 | IsBypassed: バイパスリストマッチでtrue | E-01 L202, E-06 L186-188 | ○ |
| C-33 | IsBypassed: 該当なしでfalse | E-01 L199-202, E-06 L139 | ○ |
| C-34 | IsBypassedにnullでArgumentNullException | E-01 L197, E-06 L123 | ○ |
| C-35 | IsLocal: ループバックでtrue | E-02 L18-21, E-06 L258 | ○ |
| C-36 | IsLocal: ドットなしホスト名でtrue | E-02 L33-37, E-06 L194 | ○ |
| C-37 | IsLocal: ローカルIPでtrue | E-02 L25-29, E-06 L196-206 | ○ |
| C-38 | IsLocal: プライマリドメイン一致でtrue | E-02 L40-44, E-06 L208-218 | ○ |
| C-39 | IsLocal: 外部ホストでfalse | E-02 L42-44, E-06 L223-224 | ○ |
| C-40 | IsMatchInBypassList: パターンマッチでtrue | E-01 L183-188, E-06 L142 | ○ |
| C-41 | IsMatchInBypassList: 不一致でfalse | E-01 L192, E-06 L139 | ○ |
| C-42 | ポート番号含むURLもマッチ | E-01 L177-179, E-06 L186-188 | ○ |
| C-43 | 大文字小文字無視 | E-01 L140 (RegexOptions.IgnoreCase) | ○ |
| C-44 | BypassArrayList変更の反映 | E-01 L156-166, E-06 L136-174 | ○ |
| C-45 | 無効正規表現の例外抑制 | E-01 L158-165, E-06 L128-133 | ○ |

### CreateProxyUri関連（UT-WPX-046〜048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | スキーム補完 | E-01 L115-117, E-06 L20 | ○ |
| C-47 | スキーム保持 | E-01 L115, E-06 L24 | ○ |
| C-48 | ポート上書き | E-01 L122-124, E-06 L23 | ○ |

### シリアル化関連（UT-WPX-049〜052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | GetDefaultProxyでPlatformNotSupportedException | E-01 L216-220, E-06 L268-272 | ○ |
| C-50 | シリアル化コンストラクタで例外 | E-01 L205-208 | ○ |
| C-51 | ISerializable.GetObjectDataで例外 | E-01 L210-211 | ○ |
| C-52 | GetObjectDataで例外 | E-01 L213-214 | ○ |

### ChangeTrackingArrayList関連（UT-WPX-053〜062）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | Add: IsChanged=true | E-01 L248-252 | ○ |
| C-54 | AddRange: IsChanged=true | E-01 L254-258 | ○ |
| C-55 | Insert: IsChanged=true | E-01 L260-264 | ○ |
| C-56 | InsertRange: IsChanged=true | E-01 L266-270 | ○ |
| C-57 | SetRange: IsChanged=true | E-01 L272-276 | ○ |
| C-58 | Remove: IsChanged=true | E-01 L278-282 | ○ |
| C-59 | RemoveAt: IsChanged=true | E-01 L284-288 | ○ |
| C-60 | RemoveRange: IsChanged=true | E-01 L290-294 | ○ |
| C-61 | Clear: IsChanged=true | E-01 L296-300 | ○ |
| C-62 | インデクサ設定: IsChanged=true | E-01 L238-246 | ○ |

### IWebProxyScript関連（UT-WPX-063〜065）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | Close()呼び出し可能 | E-04 L8 | △ |
| C-64 | Load()呼び出し可能 | E-04 L9 | △ |
| C-65 | Run()呼び出し可能 | E-04 L10 | △ |

### その他（UT-WPX-066〜073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | デフォルトポートURL処理 | E-01 L170, L177-178 | ○ |
| C-67 | 非デフォルトポートURL処理 | E-01 L170-173, L179 | ○ |
| C-68 | 空配列設定 | E-01 L86-88 | ○ |
| C-69 | 複数パターン適用 | E-01 L183-189, E-06 L186 | ○ |
| C-70 | ネットワーク変更イベント登録 | E-02 L48-73 | ○ |
| C-71 | 二重登録防止 | E-02 L56-58 | ○ |
| C-72 | NetworkAddressChangedでキャッシュクリア | E-02 L62-66 | ○ |
| C-73 | NetworkAvailabilityChangedでキャッシュクリア | E-02 L67-71 | ○ |

## 4) 不足情報（Unknown / Missing）
- **IWebProxyScript実装クラス**: インターフェース定義のみ存在し、実装クラスがSystem.Net.WebProxyモジュール内に存在しない。テストケースはインターフェースの契約確認レベルにとどまる。
  - 候補：別モジュールでの実装確認 / モック実装によるテスト / インターフェーステストの除外検討

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コンストラクタ、プロパティ、GetProxy/IsBypassedの基本動作（根拠が明確）
- **1: 中リスク** - ChangeTrackingArrayListの内部クラステスト（privateクラスへのアクセス方法要検討）
- **1: 中リスク** - ネットワーク変更イベント関連テスト（静的フィールドの状態制御が必要）
- **2: 高リスク** - IWebProxyScriptインターフェーステスト（実装クラス不在）

## 6) レビュアーチェックリスト（最小）
- [ ] コンストラクタのパラメータ組み合わせが網羅されているか
- [ ] GetProxy/IsBypassedの境界値テストが十分か
- [ ] ChangeTrackingArrayListのテストアクセス方法が適切か（リフレクションまたは間接テスト）
- [ ] IWebProxyScriptのテスト方針を決定（除外またはモック実装）
- [ ] 既存テスト（WebProxyTest.cs）との重複・不足を確認
- [ ] WASM環境とNonWASM環境のIsLocal実装の差異がテストに反映されているか
