---
generated_at: 2026-01-30 18:15:00
metrics:
  claims_total: 200
  claims_with_evidence: 196
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：System.Net.WebSockets 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：196 / 200、根拠なし：4
- 優先レビュー（高）
  1. **UT-WS-020**: DefaultKeepAliveInterval - WebSocketDefaultsクラスの内部実装が未確認
  2. **UT-WS-053, UT-WS-057**: KeepAliveInterval/Timeout デフォルト値 - WebSocketDefaultsクラスの定数値が未確認
  3. **UT-WS-191**: HeartBeatIntervalMs計算式 - 実装の詳細計算ロジックの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocket.cs`
- E-02: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/ManagedWebSocket.cs`
- E-03: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/ManagedWebSocket.KeepAlive.cs`
- E-04: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketReceiveResult.cs`
- E-05: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/ValueWebSocketReceiveResult.cs`
- E-06: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketException.cs`
- E-07: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketCreationOptions.cs`
- E-08: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketDeflateOptions.cs`
- E-09: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketStream.cs`
- E-10: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketStateHelper.cs`
- E-11: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/ManagedWebSocketStates.cs`
- E-12: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/AsyncMutex.cs`
- E-13: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/Compression/WebSocketDeflater.cs`
- E-14: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/Compression/WebSocketInflater.cs`
- E-15: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketState.cs`
- E-16: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketMessageType.cs`
- E-17: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketMessageFlags.cs`
- E-18: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketCloseStatus.cs`
- E-19: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketError.cs`
- E-20: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketContext.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### WebSocket クラス (UT-WS-001 - UT-WS-026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateClientBuffer: receiveBufferSizeとsendBufferSizeの大きい方が使用される | E-01 (113-118行目) | ○ |
| C-02 | CreateClientBuffer: receiveBufferSizeが0以下で例外 | E-01 (115行目) ArgumentOutOfRangeException.ThrowIfNegativeOrZero | ○ |
| C-03 | CreateClientBuffer: sendBufferSizeが0以下で例外 | E-01 (116行目) ArgumentOutOfRangeException.ThrowIfNegativeOrZero | ○ |
| C-04 | CreateServerBuffer: 正しいサイズのバッファ作成 | E-01 (120-124行目) | ○ |
| C-05 | CreateFromStream: streamがnullで例外 | E-01 (134行目) ArgumentNullException.ThrowIfNull | ○ |
| C-06 | CreateFromStream: 読み取り不可Streamで例外 | E-01 (136-139行目) | ○ |
| C-07 | CreateFromStream: 書き込み不可Streamで例外 | E-01 (136-139行目) | ○ |
| C-08 | CreateFromStream: keepAliveIntervalが負の値で例外 | E-01 (146-151行目) | ○ |
| C-09 | CreateFromStream: subProtocolがnull以外の場合検証 | E-01 (141-144行目) WebSocketValidate.ValidateSubprotocol | ○ |
| C-10 | ThrowOnInvalidState: 有効な状態では例外なし | E-01 (90-108行目) | ○ |
| C-11 | IsStateTerminal: Closed/Abortedでtrue | E-01 (110-111行目) | ○ |
| C-12 | DefaultKeepAliveInterval: デフォルト値取得 | E-01 (84-88行目) WebSocketDefaults参照 | △ |
| C-13 | ReceiveAsync(Memory): ArrayPool使用パス | E-01 (35-54行目) | ○ |
| C-14 | SendAsync(ReadOnlyMemory): バッファ最適化 | E-01 (56-59行目) | ○ |
| C-15 | SendAsync(WebSocketMessageFlags): フラグ処理 | E-01 (61-64行目) | ○ |
| C-16 | RegisterPrefixes: PlatformNotSupportedException | E-01 (175-181行目) | ○ |
| C-17 | IsApplicationTargeting45: 常にtrue | E-01 (171-172行目) | ○ |

### WebSocketReceiveResult クラス (UT-WS-027 - UT-WS-032)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | コンストラクタ: 正しいプロパティ値で初期化 | E-04 (10-28行目) | ○ |
| C-19 | コンストラクタ: countが負の値で例外 | E-04 (21行目) ArgumentOutOfRangeException.ThrowIfNegative | ○ |
| C-20 | プロパティ: Count, EndOfMessage, MessageType取得 | E-04 (30-34行目) | ○ |

### ValueWebSocketReceiveResult 構造体 (UT-WS-033 - UT-WS-037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | コンストラクタ: 正しいプロパティ値で初期化 | E-05 (18-29行目) | ○ |
| C-22 | コンストラクタ: countが負の値で例外 | E-05 (20行目) ArgumentOutOfRangeException.ThrowIfNegative | ○ |
| C-23 | コンストラクタ: messageTypeが無効で例外 | E-05 (21行目) ThrowMessageTypeOutOfRange | ○ |
| C-24 | Count: ビット演算で値取得 | E-05 (31行目) 0x7FFFFFFF マスク | ○ |
| C-25 | EndOfMessage: 最上位ビット判定 | E-05 (32行目) 0x80000000 判定 | ○ |

### WebSocketException クラス (UT-WS-038 - UT-WS-047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | 各種コンストラクタ: エラーコード設定 | E-06 (17-96行目) | ○ |
| C-27 | コンストラクタ(int): ネイティブエラーコード処理 | E-06 (43-62行目) | ○ |
| C-28 | GetErrorMessage: エラータイプ別メッセージ | E-06 (129-144行目) switch式 | ○ |
| C-29 | SetErrorCodeOnError: HResult設定 | E-06 (148-154行目) | ○ |
| C-30 | ErrorCode: NativeErrorCode返却 | E-06 (113-119行目) | ○ |

### WebSocketCreationOptions クラス (UT-WS-048 - UT-WS-061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | IsServer: デフォルトfalse | E-07 (20行目) | ○ |
| C-32 | SubProtocol: バリデーション実行 | E-07 (25-36行目) WebSocketValidate.ValidateSubprotocol | ○ |
| C-33 | KeepAliveInterval: デフォルト値 | E-07 (14行目) WebSocketDefaults.DefaultKeepAliveInterval | △ |
| C-34 | KeepAliveInterval: 負の値で例外 | E-07 (47-53行目) | ○ |
| C-35 | KeepAliveTimeout: デフォルト値 | E-07 (15行目) WebSocketDefaults.DefaultKeepAliveTimeout | △ |
| C-36 | KeepAliveTimeout: 負の値で例外 | E-07 (67-72行目) | ○ |
| C-37 | DangerousDeflateOptions: null許容 | E-07 (83行目) | ○ |

### WebSocketDeflateOptions クラス (UT-WS-062 - UT-WS-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | ClientMaxWindowBits: デフォルト15 | E-08 (14行目) MaxDeflateWindowBits | ○ |
| C-39 | ClientMaxWindowBits: 範囲外で例外 | E-08 (28-32行目) | ○ |
| C-40 | ClientContextTakeover: デフォルトtrue | E-08 (42行目) | ○ |
| C-41 | ServerMaxWindowBits: デフォルト15 | E-08 (15行目) | ○ |
| C-42 | ServerMaxWindowBits: 範囲外で例外 | E-08 (54-59行目) | ○ |
| C-43 | ServerContextTakeover: デフォルトtrue | E-08 (69行目) | ○ |

### ManagedWebSocket クラス (UT-WS-074 - UT-WS-123)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | コンストラクタ: 初期化処理 | E-02 (140-199行目) | ○ |
| C-45 | コンストラクタ: キープアライブタイマー作成 | E-02 (169-198行目) | ○ |
| C-46 | コンストラクタ: 圧縮オプション処理 | E-02 (204-222行目) | ○ |
| C-47 | Dispose: リソース解放 | E-02 (224-257行目) | ○ |
| C-48 | Abort: 中断処理 | E-02 (433-464行目) | ○ |
| C-49 | SendAsync: メッセージ送信 | E-02 (297-349行目) | ○ |
| C-50 | ReceiveAsync: メッセージ受信 | E-02 (351-385行目, 767-1033行目) | ○ |
| C-51 | CloseAsync: クローズ処理 | E-02 (387-404行目) | ○ |
| C-52 | WriteFrameToSendBuffer: ヘッダ作成 | E-02 (633-683行目) | ○ |
| C-53 | WriteHeader: ペイロード長エンコード | E-02 (685-750行目) | ○ |
| C-54 | ApplyMask: XOR演算 | E-02 (参照) | ○ |

### WebSocketStream クラス (UT-WS-124 - UT-WS-153)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | Create: ストリーム作成 | E-09 (35-44行目) | ○ |
| C-56 | Create: webSocketがnullで例外 | E-09 (37行目) | ○ |
| C-57 | Create: 無効なmessageTypeで例外 | E-09 (38行目) ThrowIfInvalidMessageType | ○ |
| C-58 | CanRead: 状態判定 | E-09 (98行目) | ○ |
| C-59 | CanWrite: 状態判定 | E-09 (101行目) | ○ |
| C-60 | CanSeek: 常にfalse | E-09 (104行目) | ○ |
| C-61 | Length/Position/Seek/SetLength: NotSupportedException | E-09 (173-186行目) | ○ |
| C-62 | ReadWriteStream: 読み書き処理 | E-09 (189-286行目) | ○ |
| C-63 | WriteMessageStream: フラグメント書き込み | E-09 (289-327行目) | ○ |
| C-64 | ReadMessageStream: 単一メッセージ読み取り | E-09 (330-382行目) | ○ |

### WebSocketStateHelper クラス (UT-WS-154 - UT-WS-160)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | IsValidSendState: 状態判定 | E-10 (19行目) | ○ |
| C-66 | ThrowIfInvalidState: 例外スロー | E-10 (21-41行目) | ○ |

### AsyncMutex クラス (UT-WS-161 - UT-WS-168)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | EnterAsync: 高速パス | E-12 (53-72行目) | ○ |
| C-68 | EnterAsync: 競合パス | E-12 (78-183行目) | ○ |
| C-69 | Exit: 解放処理 | E-12 (186-243行目) | ○ |
| C-70 | IsHeld: 状態確認 | E-12 (45行目) | ○ |

### WebSocketDeflater クラス (UT-WS-169 - UT-WS-177)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | コンストラクタ: windowBits設定 | E-13 (21-25行目) | ○ |
| C-72 | Deflate: 圧縮処理 | E-13 (41-77行目) | ○ |
| C-73 | ReleaseBuffer: バッファ返却 | E-13 (32-39行目) | ○ |
| C-74 | Dispose: リソース解放 | E-13 (27-30行目) | ○ |

### WebSocketInflater クラス (UT-WS-178 - UT-WS-189)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | コンストラクタ: windowBits設定 | E-14 (49-53行目) | ○ |
| C-76 | Prepare: バッファ準備 | E-14 (70-85行目) | ○ |
| C-77 | AddBytes: バイト追加とフラッシュマーカー | E-14 (87-121行目) | ○ |
| C-78 | Inflate: 展開処理 | E-14 (126-158行目) | ○ |
| C-79 | Dispose: リソース解放 | E-14 (59-63行目) | ○ |

### KeepAlivePingState クラス (UT-WS-190 - UT-WS-200)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | コンストラクタ: タイムアウト設定 | E-03 (143-152行目) | ○ |
| C-81 | HeartBeatIntervalMs: 間隔計算 | E-03 (135行目) | △ |
| C-82 | OnDataReceived: タイムスタンプ更新 | E-03 (154-160行目) | ○ |
| C-83 | OnPongResponseReceived: Pong処理 | E-03 (162-186行目) | ○ |
| C-84 | OnKeepAliveFaulted: フォールト処理 | E-03 (197-246行目) | ○ |
| C-85 | HeartBeat: Pong/Ping送信 | E-03 (16-111行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- **WebSocketDefaults クラス**: DefaultKeepAliveInterval, DefaultKeepAliveTimeout の実際の定数値が未確認
  - 候補：Commonライブラリ内 / 別のソースファイル / 内部定数
- **HeartBeatIntervalMs計算式**: 実装では `Math.Max(Math.Min(DelayMs, TimeoutMs) / 4, MinIntervalMs)` だが、MinIntervalMsの値（1ms）の妥当性確認が必要

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードから直接導出可能
- **1（中リスク）**: WebSocketDefaultsのデフォルト値に依存するテストケース（UT-WS-020, UT-WS-053, UT-WS-057）
- **0（低リスク）**: 圧縮関連（WebSocketDeflater/WebSocketInflater）のテストケースは実装詳細に基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] WebSocketDefaultsクラスのデフォルト値（DefaultKeepAliveInterval, DefaultKeepAliveTimeout）が期待値と一致するか確認
- [ ] ManagedWebSocketのマスク適用ロジック（ApplyMask）の境界値テストが十分か確認
- [ ] WebSocketExceptionの各コンストラクタオーバーロードが網羅されているか確認
- [ ] 圧縮機能（Deflate/Inflate）のエラーケース（ZLibエラー）が十分にカバーされているか確認
- [ ] WebSocketStreamの各派生クラス（ReadWriteStream, WriteMessageStream, ReadMessageStream）のDispose処理が正しくテストされているか確認
- [ ] AsyncMutexのスレッドセーフティに関するテストケースが実際のマルチスレッド環境で有効か確認
