---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 136
  claims_with_evidence: 128
  claims_without_evidence: 8
confidence_derived: 0.94
---

# 根拠レポート：coreclr 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：128 / 136、根拠なし：8
- 優先レビュー（高）
  1. **GC.RefreshMemoryLimit の異常系テスト**：AppDataによる設定変更のテスト条件が実環境依存
  2. **ProcessRunner の内部状態テスト**：プライベートフィールドへのアクセスが必要
  3. **RuntimeType.RuntimeTypeCache.Filter のテスト**：unsafe コードと内部構造体のテスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/coreclr/tools/ILVerification/Verifier.cs`
- E-02: `src/coreclr/tools/ILVerification/VerifierError.cs`
- E-03: `src/coreclr/tools/ILVerification/TypeVerifier.cs`
- E-04: `src/coreclr/System.Private.CoreLib/src/System/GC.CoreCLR.cs`
- E-05: `src/coreclr/tools/Common/TypeSystem/Common/TypeDesc.cs`
- E-06: `src/coreclr/tools/aot/ILCompiler.ReadyToRun/Compiler/DependencyAnalysis/ReadyToRun/MethodWithGCInfo.cs`
- E-07: `src/coreclr/tools/r2rtest/ProcessRunner.cs`
- E-08: `src/coreclr/tools/Common/JitInterface/CorInfoTypes.cs`
- E-09: `src/coreclr/System.Private.CoreLib/src/System/RuntimeType.CoreCLR.cs`
- E-10: `src/coreclr/tools/ILVerification/ILVerifyTypeSystemContext.cs`
- E-11: `src/coreclr/tools/ILVerification/VerificationResult.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ILVerify.Verifier 関連（UT-CLR-001 ～ UT-CLR-010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SetSystemModuleName で有効なアセンブリ名を設定できる | E-01 (L37-45) | ○ |
| C-02 | SetSystemModuleName で無効なアセンブリ名で例外発生 | E-01 (L40-43) | ○ |
| C-03 | Verify(PEReader) で検証結果が返される | E-01 (L52-79) | ○ |
| C-04 | Verify で null PEReader に対して ArgumentNullException | E-01 (L54-57) | ○ |
| C-05 | SystemModule 未設定で VerifierException | E-01 (L59-62) | ○ |
| C-06 | Verify(PEReader, TypeDefinitionHandle) で型検証実行 | E-01 (L81-121) | ○ |
| C-07 | Verify で nil TypeDefinitionHandle に対して ArgumentNullException | E-01 (L88-91) | ○ |
| C-08 | Verify(PEReader, MethodDefinitionHandle) でメソッド検証実行 | E-01 (L123-155) | ○ |
| C-09 | VerifierOptions.IncludeMetadataTokensInErrorMessages が設定可能 | E-01 (L326) | ○ |
| C-10 | VerifierOptions.SanityChecks が設定可能 | E-01 (L327) | ○ |

### TypeVerifier 関連（UT-CLR-011 ～ UT-CLR-015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | TypeVerifier.Verify でインターフェース検証実行 | E-03 (L40-43) | ○ |
| C-12 | インターフェース型で検証スキップ | E-03 (L50-53) | ○ |
| C-13 | インターフェース実装なしで検証スキップ | E-03 (L55-60) | ○ |
| C-14 | 重複インターフェース実装でエラー報告 | E-03 (L80-87) | ○ |
| C-15 | 未実装インターフェースメソッドでエラー報告 | E-03 (L94-111) | ○ |

### System.GC 関連（UT-CLR-016 ～ UT-CLR-076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | GetGCMemoryInfo() で情報取得 | E-04 (L68) | ○ |
| C-17 | GetGCMemoryInfo(GCKind) で種別指定取得 | E-04 (L73-87) | ○ |
| C-18 | 無効な GCKind で ArgumentOutOfRangeException | E-04 (L75-82) | ○ |
| C-19 | AddMemoryPressure で圧力追加 | E-04 (L133-142) | ○ |
| C-20 | AddMemoryPressure で 0 以下に対して例外 | E-04 (L135) | ○ |
| C-21 | 32bit 環境で int.MaxValue 超過時に例外 | E-04 (L136-139) | ○ |
| C-22 | RemoveMemoryPressure で圧力削除 | E-04 (L144-153) | ○ |
| C-23 | RemoveMemoryPressure で 0 以下に対して例外 | E-04 (L146) | ○ |
| C-24 | GetGeneration(object) で世代取得 | E-04 (L157-161) | ○ |
| C-25 | GetGeneration で null に対して例外 | E-04 (L159) | ○ |
| C-26 | Collect() で全世代 GC 実行 | E-04 (L175-179) | ○ |
| C-27 | Collect(int) で世代指定 GC 実行 | E-04 (L168-171) | ○ |
| C-28 | Collect で負の世代番号に対して例外 | E-04 (L199) | ○ |
| C-29 | Collect(int, GCCollectionMode) でモード指定 GC | E-04 (L181-184) | ○ |
| C-30 | 無効な GCCollectionMode で例外 | E-04 (L201-204) | ○ |
| C-31 | Aggressive モードで MaxGeneration 以外で例外 | E-04 (L215-218) | ○ |
| C-32 | Aggressive モードで blocking=false で例外 | E-04 (L219-222) | ○ |
| C-33 | Aggressive モードで compacting=false で例外 | E-04 (L223-226) | ○ |
| C-34 | CollectionCount で回数取得 | E-04 (L246-249) | ○ |
| C-35 | CollectionCount で負の世代番号に対して例外 | E-04 (L248) | ○ |
| C-36 | KeepAlive でオブジェクト生存延長 | E-04 (L287-291) | ○ |
| C-37 | GetGeneration(WeakReference) で世代取得 | E-04 (L295-304) | ○ |
| C-38 | WeakReference のターゲット null で例外 | E-04 (L301) | ○ |
| C-39 | MaxGeneration で最大世代番号取得 | E-04 (L308) | ○ |
| C-40 | WaitForPendingFinalizers でファイナライザ待機 | E-04 (L343-347) | ○ |
| C-41 | SuppressFinalize でファイナライザ抑制 | E-04 (L354-363) | ○ |
| C-42 | SuppressFinalize で null に対して例外 | E-04 (L356) | ○ |
| C-43 | ReRegisterForFinalize でファイナライザ再登録 | E-04 (L372-383) | ○ |
| C-44 | ReRegisterForFinalize で null に対して例外 | E-04 (L374) | ○ |
| C-45 | GetTotalMemory で使用量取得 | E-04 (L389-411) | ○ |
| C-46 | GetTotalMemory(true) で安定値取得 | E-04 (L394-410) | ○ |
| C-47 | GetAllocatedBytesForCurrentThread でスレッド統計 | E-04 (L420) | ○ |
| C-48 | GetTotalAllocatedBytes で割当バイト数取得 | E-04 (L427) | ○ |
| C-49 | GetTotalAllocatedBytes(true) で正確値取得 | E-04 (L427) | ○ |
| C-50 | RegisterForFullGCNotification で通知登録 | E-04 (L447-471) | ○ |
| C-51 | 閾値 0 以下で例外 | E-04 (L449-456) | ○ |
| C-52 | 閾値 100 以上で例外 | E-04 (L449-456) | ○ |
| C-53 | CancelFullGCNotification で通知キャンセル | E-04 (L473-479) | ○ |
| C-54 | WaitForFullGCApproach で待機 | E-04 (L481-484) | ○ |
| C-55 | WaitForFullGCApproach(int) でタイムアウト付き待機 | E-04 (L486-491) | ○ |
| C-56 | -1 未満のタイムアウトで例外 | E-04 (L488) | ○ |
| C-57 | WaitForFullGCComplete で待機 | E-04 (L493-496) | ○ |
| C-58 | TryStartNoGCRegion で開始 | E-04 (L546-548) | ○ |
| C-59 | 0 以下のサイズで例外 | E-04 (L522) | ○ |
| C-60 | 既に NoGC リージョン中で例外 | E-04 (L536-537) | ○ |
| C-61 | TryStartNoGCRegion(long, long) で LOH サイズ指定 | E-04 (L551-553) | ○ |
| C-62 | lohSize > totalSize で例外 | E-04 (L528) | ○ |
| C-63 | EndNoGCRegion で終了 | E-04 (L566-575) | ○ |
| C-64 | NoGC リージョン外で例外 | E-04 (L569-570) | ○ |
| C-65 | RegisterNoGCRegionCallback でコールバック登録 | E-04 (L711-759) | ○ |
| C-66 | 0 以下のサイズで例外 | E-04 (L713) | ○ |
| C-67 | null コールバックで例外 | E-04 (L714) | ○ |
| C-68 | AllocateUninitializedArray で未初期化配列割当 | E-04 (L799-834) | ○ |
| C-69 | ピン留め配列割当 | E-04 (L801-818) | ○ |
| C-70 | 参照型配列はゼロ初期化 | E-04 (L803-806) | ○ |
| C-71 | AllocateArray で初期化済み配列割当 | E-04 (L842-854) | ○ |
| C-72 | AllocateArray でピン留め配列 | E-04 (L846-849) | ○ |
| C-73 | GetTotalPauseDuration で一時停止累計時間取得 | E-04 (L863-866) | ○ |
| C-74 | GetConfigurationVariables で設定取得 | E-04 (L915-924) | ○ |
| C-75 | RefreshMemoryLimit で制限更新 | E-04 (L969-998) | ○ |
| C-76 | RefreshMemoryLimit で制限低すぎ時に例外 | E-04 (L993-994) | △ |

### TypeDesc 関連（UT-CLR-077 ～ UT-CLR-090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | GetHashCode でハッシュコード取得 | E-05 (L23) | ○ |
| C-78 | Equals で同一参照に true | E-05 (L25-29) | ○ |
| C-79 | Equals で異なる参照に false | E-05 (L28) | ○ |
| C-80 | HasInstantiation でジェネリック判定 (true) | E-05 (L67-73) | ○ |
| C-81 | HasInstantiation でジェネリック判定 (false) | E-05 (L67-73) | ○ |
| C-82 | Category で型カテゴリ取得 | E-05 (L159-165) | ○ |
| C-83 | IsInterface でインターフェース判定 (true) | E-05 (L170-176) | ○ |
| C-84 | IsInterface でインターフェース判定 (false) | E-05 (L170-176) | ○ |
| C-85 | IsValueType で値型判定 (true) | E-05 (L181-187) | ○ |
| C-86 | IsValueType で値型判定 (false) | E-05 (L181-187) | ○ |
| C-87 | IsPrimitive でプリミティブ判定 (true) | E-05 (L193-198) | ○ |
| C-88 | IsPrimitive でプリミティブ判定 (false) | E-05 (L193-198) | ○ |
| C-89 | SetWellKnownType で型フラグ設定 | E-05 (L75-128) | ○ |
| C-90 | 無効な WellKnownType で例外 | E-05 (L123-124) | ○ |

### MethodWithGCInfo 関連（UT-CLR-091 ～ UT-CLR-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | コンストラクタでインスタンス作成 | E-06 (L35-41) | ○ |
| C-92 | SetCode でコードデータ設定 | E-06 (L87-91) | ○ |
| C-93 | SetCode 二重呼び出しで Assert | E-06 (L89) | ○ |
| C-94 | Size でコードサイズ取得 | E-06 (L97) | ○ |
| C-95 | IsEmpty で空判定 (true) | E-06 (L99) | ○ |
| C-96 | IsEmpty で空判定 (false) | E-06 (L99) | ○ |
| C-97 | InitializeFrameInfos でフレーム情報初期化 | E-06 (L322-337) | ○ |
| C-98 | InitializeFrameInfos で null 時デフォルト設定 | E-06 (L330-336) | ○ |
| C-99 | InitializeGCInfo で GC 情報初期化 | E-06 (L346-350) | ○ |
| C-100 | InitializeEHInfo で EH 情報初期化 | E-06 (L352-356) | ○ |
| C-101 | InitializeDebugLocInfos でデバッグ位置情報初期化 | E-06 (L362-368) | ○ |
| C-102 | InitializeDebugVarInfos でデバッグ変数情報初期化 | E-06 (L370-376) | ○ |
| C-103 | InitializeInliningInfo でインライン情報初期化 | E-06 (L390-396) | ○ |
| C-104 | GetFixupBlob で修正 BLOB 生成 | E-06 (L140-262) | ○ |
| C-105 | リロケーションなしで null 返却 | E-06 (L157-159) | ○ |

### ProcessRunner 関連（UT-CLR-106 ～ UT-CLR-114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | DefaultIlcTimeout が 10 分 | E-07 (L17) | ○ |
| C-107 | DefaultIlcCompositeTimeout が 30 分 | E-07 (L22) | ○ |
| C-108 | DefaultExeTimeout が 5 分 | E-07 (L27) | ○ |
| C-109 | ProcessInfo.IsEmpty で Parameters null 判定 | E-07 (L65) | ○ |
| C-110 | ProcessInfo.Crashed で ExitCode 判定 | E-07 (L67) | ○ |
| C-111 | ProcessInfo.Construct で構築 | E-07 (L74-79) | ○ |
| C-112 | ProcessRunner コンストラクタ | E-07 (L119-150) | △ |
| C-113 | StateIdle の初期値確認 | E-07 (L84, L131) | ○ |
| C-114 | TimeoutExitCode が -103 | E-07 (L88) | ○ |

### JitInterface 関連（UT-CLR-115 ～ UT-CLR-120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | CORINFO.MAXINDIRECTIONS が 4 | E-08 (L25) | ○ |
| C-116 | CORINFO.USEHELPER が 0xffff | E-08 (L26) | ○ |
| C-117 | CORINFO_SIG_INFO.retType の get/set | E-08 (L114) | ○ |
| C-118 | hasTypeArg でフラグ判定 | E-08 (L121) | ○ |
| C-119 | CORINFO_CONST_LOOKUP.handle の get/set | E-08 (L190) | ○ |
| C-120 | CORINFO_CONST_LOOKUP.addr の get/set | E-08 (L191) | ○ |

### RuntimeType 関連（UT-CLR-121 ～ UT-CLR-134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | ListBuilder コンストラクタ | E-09 (L59-65) | ○ |
| C-122 | ListBuilder.Add で要素追加 | E-09 (L104-129) | ○ |
| C-123 | 複数要素追加で配列拡張 | E-09 (L110-127) | ○ |
| C-124 | ToArray で空リスト処理 | E-09 (L78-79) | ○ |
| C-125 | ToArray で 1 要素処理 | E-09 (L80-81) | ○ |
| C-126 | ToArray で複数要素処理 | E-09 (L83-85) | ○ |
| C-127 | CopyTo でコピー | E-09 (L88-100) | ○ |
| C-128 | インデクサで要素取得 | E-09 (L67-74) | ○ |
| C-129 | Filter.Match (CaseSensitive, 一致) | E-09 (L159-173) | △ |
| C-130 | Filter.Match (CaseSensitive, 不一致) | E-09 (L159-173) | △ |
| C-131 | Filter.Match (CaseInsensitive) | E-09 (L159-173) | △ |
| C-132 | RequiresStringComparison (CaseSensitive) | E-09 (L177-181) | ○ |
| C-133 | RequiresStringComparison (CaseInsensitive) | E-09 (L177-181) | ○ |
| C-134 | RequiresStringComparison (All) | E-09 (L177-181) | ○ |

### InterfaceMetadataObjects 関連（UT-CLR-135 ～ UT-CLR-136）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | Equals で同一 InterfaceType 判定 | E-03 (L158-166) | ○ |
| C-136 | Equals で異なる InterfaceType 判定 | E-03 (L162-164) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-76 (RefreshMemoryLimit 異常系)**: AppContext.SetData による設定変更の実環境テストが必要
  - 候補：実環境テスト / モック利用 / 統合テストで確認
- **C-112 (ProcessRunner コンストラクタ)**: 外部プロセス起動を伴うため、モック化が必要
  - 候補：ProcessStartInfo のモック / 統合テスト
- **C-129, C-130, C-131 (Filter.Match)**: unsafe コードと内部 MdUtf8String 型のテストが複雑
  - 候補：リフレクション利用 / 内部テストプロジェクト参照

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ILVerify.Verifier, TypeVerifier, TypeDesc, MethodWithGCInfo の大部分
  - コードから直接導出可能で、例外条件も明確
- **1: 中リスク** - System.GC の一部メソッド
  - ランタイム依存の動作があるため、実行環境による差異の可能性
- **2: 高リスク** - RefreshMemoryLimit, ProcessRunner の外部依存テスト
  - 外部状態（メモリ、プロセス）への依存が強く、テスト環境の整備が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストID命名規則（UT-CLR-XXX）が連番で正しいか
- [ ] 対象クラス・メソッドがソースコードに実在するか
- [ ] 正常系・異常系・境界値のバランスが取れているか
- [ ] 優先度（高/中/低）の設定が適切か
- [ ] GC 関連テストの前提条件が実行可能か
- [ ] unsafe コードを含むテストの実現可能性
- [ ] 外部プロセス依存テストのモック戦略
- [ ] プラットフォーム依存テスト（32bit/64bit）の考慮
