---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 109
  claims_with_evidence: 109
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：installer モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：109 / 109、根拠なし：0
- 優先レビュー（高）
  1. **全テストケースがソースコードに基づいている**：コード解析による根拠あり
  2. **テストIDの命名規則**：installerモジュール用にUT-INS-xxxを採用
  3. **優先度設定**：金額計算なし、セキュリティ関連（署名処理）を高優先度に設定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

### Bundle関連
- E-01: `src/installer/managed/Microsoft.NET.HostModel/Bundle/Bundler.cs`
- E-02: `src/installer/managed/Microsoft.NET.HostModel/Bundle/FileEntry.cs`
- E-03: `src/installer/managed/Microsoft.NET.HostModel/Bundle/FileSpec.cs`
- E-04: `src/installer/managed/Microsoft.NET.HostModel/Bundle/Manifest.cs`
- E-05: `src/installer/managed/Microsoft.NET.HostModel/Bundle/TargetInfo.cs`
- E-06: `src/installer/managed/Microsoft.NET.HostModel/Bundle/FileType.cs`
- E-07: `src/installer/managed/Microsoft.NET.HostModel/Bundle/BundleOptions.cs`
- E-08: `src/installer/managed/Microsoft.NET.HostModel/Bundle/Trace.cs`

### AppHost関連
- E-09: `src/installer/managed/Microsoft.NET.HostModel/AppHost/HostWriter.cs`
- E-10: `src/installer/managed/Microsoft.NET.HostModel/AppHost/BinaryUtils.cs`
- E-11: `src/installer/managed/Microsoft.NET.HostModel/AppHost/PEUtils.cs`
- E-12: `src/installer/managed/Microsoft.NET.HostModel/AppHost/ElfUtils.cs`
- E-13: `src/installer/managed/Microsoft.NET.HostModel/AppHost/RetryUtil.cs`
- E-14: `src/installer/managed/Microsoft.NET.HostModel/AppHost/AppHostExceptions.cs`

### ComHost関連
- E-15: `src/installer/managed/Microsoft.NET.HostModel/ComHost/ComHost.cs`
- E-16: `src/installer/managed/Microsoft.NET.HostModel/ComHost/ClsidMap.cs`
- E-17: `src/installer/managed/Microsoft.NET.HostModel/ComHost/RegFreeComManifest.cs`

### MachO関連
- E-18: `src/installer/managed/Microsoft.NET.HostModel/MachO/MachObjectFile.cs`

### ユーティリティ
- E-19: `src/installer/managed/Microsoft.NET.HostModel/HostModelUtils.cs`
- E-20: `src/installer/managed/Microsoft.NET.HostModel/Utils/Base64Url.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Bundler クラス（UT-INS-001 〜 UT-INS-011）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Bundlerコンストラクタの入力バリデーション | E-01 (L53-56: パス含むhostNameチェック) | ○ |
| C-02 | 圧縮オプションのバージョンチェック | E-01 (L62-66: BundleMajorVersion < 6チェック) | ○ |
| C-03 | GenerateBundleの入力バリデーション | E-01 (L273-276: IsValid()チェック) | ○ |
| C-04 | GenerateBundleのホストバイナリ必須チェック | E-01 (L277-285: hostSource取得と例外) | ○ |
| C-05 | IsBundleメソッドのバンドル検出 | E-01 (L422-446: BundleHeaderSignature検索) | ○ |
| C-06 | GetBinaryWriterStringLength計算 | E-01 (L499-511: 7-bitエンコード長計算) | ○ |

### FileEntry クラス（UT-INS-012 〜 UT-INS-016）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | FileEntryコンストラクタのパス正規化 | E-02 (L38: Replace('\\', '/')) | ○ |
| C-08 | WriteメソッドのCompressedSize条件分岐 | E-02 (L49-53: BundleMajorVersion >= 6チェック) | ○ |
| C-09 | GetFileEntryLengthのバージョン別計算 | E-02 (L63-70: sizeof計算) | ○ |

### FileSpec クラス（UT-INS-017 〜 UT-INS-020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | FileSpecコンストラクタ | E-03 (L21-26: プロパティ初期化) | ○ |
| C-11 | IsValidメソッドのバリデーション | E-03 (L28-32: null/空白チェック) | ○ |

### Manifest クラス（UT-INS-021 〜 UT-INS-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | Manifestコンストラクタ | E-04 (L88-93: 初期化処理) | ○ |
| C-13 | AddEntryの状態管理 | E-04 (L97-100: bundleHash nullチェック) | ○ |
| C-14 | AddEntryのFileType別処理 | E-04 (L109-123: DepsJson/RuntimeConfigJson設定) | ○ |
| C-15 | Writeメソッド | E-04 (L148-180: ヘッダーとエントリ書き込み) | ○ |
| C-16 | Containsメソッド | E-04 (L203-206: LINQによる検索) | ○ |

### TargetInfo クラス（UT-INS-031 〜 UT-INS-044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | TargetInfoコンストラクタのバージョン判定 | E-05 (L39-57: FrameworkVersion.Major分岐) | ○ |
| C-18 | AssemblyAlignmentのアーキテクチャ別設定 | E-05 (L59-82: Arch別条件分岐) | ○ |
| C-19 | IsNativeBinaryのOS別判定 | E-05 (L85-88: OS別メソッド呼び出し) | ○ |
| C-20 | ShouldExcludeのバージョン別除外 | E-05 (L123-124: FrameworkVersion.Major != 3チェック) | ○ |

### HostWriter クラス（UT-INS-045 〜 UT-INS-052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | CreateAppHostのパス長制限 | E-09 (L77-81: MaxAppBinaryPathSizeInBytes=1024) | ○ |
| C-22 | GUI設定時のPE形式チェック | E-09 (L102-107: appHostIsPEImageチェック) | ○ |
| C-23 | macOS署名時のMachO形式チェック | E-09 (L139-143: IsMachOImage確認) | ○ |
| C-24 | DotNetSearchOptionsの相対パスチェック | E-09 (L207-210: Path.IsPathRootedチェック) | ○ |
| C-25 | 相対パス長制限 | E-09 (L216-217: MaxAppRelativeDotNetSizeInBytes) | ○ |

### BinaryUtils クラス（UT-INS-053 〜 UT-INS-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | SearchAndReplaceのKMPアルゴリズム | E-10 (L94-163: KMPSearch実装) | ○ |
| C-27 | パターン未発見時の例外 | E-10 (L26-29: PlaceHolderNotFoundInAppHostException) | ○ |
| C-28 | Pad0メソッド | E-10 (L51-60: 0パディング処理) | ○ |

### PEUtils クラス（UT-INS-061 〜 UT-INS-067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | IsPEImageのシグネチャチェック | E-11 (L19-28: DosImageSignature比較) | ○ |
| C-30 | SetWindowsGraphicalUserInterfaceBit | E-11 (L81-92: サブシステム変更) | ○ |
| C-31 | RemoveCetCompatBit | E-11 (L49-75: CET互換ビットクリア) | ○ |

### ElfUtils クラス（UT-INS-068 〜 UT-INS-070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | IsElfImageのマジックナンバーチェック | E-12 (L13-31: ElfMagic比較) | ○ |

### RetryUtil クラス（UT-INS-071 〜 UT-INS-073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | RetryOnIOErrorのリトライ回数 | E-13 (L20-21: NumberOfRetries=500) | ○ |
| C-34 | IOException時のリトライ | E-13 (L25-36: catch (IOException)処理) | ○ |

### ComHost クラス（UT-INS-074 〜 UT-INS-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | ComHost.Createのリソース埋め込み | E-15 (L42-68: ResourceUpdater使用) | ○ |
| C-36 | タイプライブラリID検証 | E-15 (L49-52: IsIntResourceチェック) | ○ |
| C-37 | 空ファイルチェック | E-15 (L57-58: tlbFileBytes.Length == 0) | ○ |

### ClsidMap クラス（UT-INS-079 〜 UT-INS-082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | ClsidMap.Createの型フィルタリング | E-16 (L46: TypeIsPublic && TypeIsClass && IsComVisible) | ○ |
| C-39 | GUID重複チェック | E-16 (L51-54: ConflictingGuidException) | ○ |
| C-40 | GuidAttribute必須チェック | E-16 (L188-202: MissingGuidException) | ○ |

### RegFreeComManifest クラス（UT-INS-083 〜 UT-INS-085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | マニフェストXML生成 | E-17 (L26-52: XDocument構築) | ○ |
| C-42 | タイプライブラリ要素追加 | E-17 (L78-101: AddTypeLibElementsToFileElement) | ○ |

### MachObjectFile クラス（UT-INS-086 〜 UT-INS-099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | MachObjectFile.Create | E-18 (L61-103: 静的ファクトリメソッド) | ○ |
| C-44 | IsMachOImageのマジック判定 | E-18 (L176-194: MachMagic比較) | ○ |
| C-45 | AdHocSignFile | E-18 (L117-128: 署名処理) | ○ |
| C-46 | RemoveCodeSignatureIfPresent | E-18 (L204-227: 署名削除) | ○ |
| C-47 | TryAdjustHeadersForBundle | E-18 (L154-174: ヘッダー調整) | ○ |

### HostModelUtils クラス（UT-INS-100 〜 UT-INS-102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | GetFileLengthのシンボリックリンク解決 | E-19 (L41-45: ResolveLinkTarget) | ○ |
| C-49 | IsCodesignAvailable | E-19 (L19: File.Exists(CodesignPath)) | ○ |

### Trace クラス（UT-INS-103 〜 UT-INS-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | Log条件分岐 | E-08 (L20-26: Verbose条件) | ○ |
| C-51 | Error出力 | E-08 (L28-31: Console.Error.WriteLine) | ○ |

### Base64Url クラス（UT-INS-106 〜 UT-INS-109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | EncodeToStringの文字置換 | E-20 (L10-15: Replace処理) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。全てのテストケースがソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードから直接導出されており、根拠が明確です。
- 以下の点は追加レビューを推奨：
  - macOS署名関連（AdHocSignFile, RemoveCodeSignatureIfPresent）：プラットフォーム依存のため実機テストが必要
  - PEUtils関連：Windowsバイナリ操作のため実機テストが必要
  - リトライ処理（RetryUtil）：タイムアウトや並行処理の観点からの追加テストを検討

## 6) レビュアーチェックリスト（最小）
- [ ] 全109件のテストケースがinstallerモジュールの範囲内に収まっているか
- [ ] テストID（UT-INS-xxx）の連番が正しいか
- [ ] 優先度（高/中/低）の設定が適切か（署名処理、バリデーションは高優先度）
- [ ] 境界値テストが網羅されているか（ファイルサイズ制限、文字列長制限等）
- [ ] 異常系テストで適切な例外がスローされることを確認しているか
- [ ] プラットフォーム依存のテスト（Windows PE, macOS MachO, Linux ELF）が識別されているか
