---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 152
  claims_with_evidence: 148
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：libraries-Common 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：148 / 152、根拠なし：4
- 優先レビュー（高）
  1. **UT-COM-068〜070（NonCapturingTimer）**：ExecutionContextの動作確認が必要
  2. **UT-COM-148〜150（TargetHostNameHelper）**：IDN変換の挙動は実行環境依存
  3. **UT-COM-144〜145（ArrayBufferWriter拡張）**：最大サイズ制限の動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Common/src/System/Net/ArrayBuffer.cs`
- E-02: `src/libraries/Common/src/System/Net/MultiArrayBuffer.cs`
- E-03: `src/libraries/Common/src/Extensions/TypeNameHelper/TypeNameHelper.cs`
- E-04: `src/libraries/Common/src/System/Net/HttpDateParser.cs`
- E-05: `src/libraries/Common/src/SourceGenerators/SourceWriter.cs`
- E-06: `src/libraries/Common/src/Extensions/NonCapturingTimer/NonCapturingTimer.cs`
- E-07: `src/libraries/Common/src/System/Net/Http/aspnetcore/Http2/Hpack/IntegerEncoder.cs`
- E-08: `src/libraries/Common/src/System/Net/Http/aspnetcore/Http2/Hpack/IntegerDecoder.cs`
- E-09: `src/libraries/Common/src/System/Net/Http/aspnetcore/Http2/Hpack/DynamicTable.cs`
- E-10: `src/libraries/Common/src/System/Net/TcpValidationHelpers.cs`
- E-11: `src/libraries/Common/src/System/Net/HttpValidationHelpers.cs`
- E-12: `src/libraries/Common/src/SourceGenerators/ImmutableEquatableArray.cs`
- E-13: `src/libraries/Common/src/System/Buffers/ArrayBufferWriter.cs`
- E-14: `src/libraries/Common/src/System/Net/Security/TargetHostNameHelper.cs`
- E-15: `src/libraries/Common/src/Extensions/Logging/NullScope.cs`
- E-16: RFC 7541 (HPACK仕様書)
- E-17: RFC 6066 (TLS Extensions - Server Name Indication)
- E-18: .NET Runtime ソースコード規約

## 3) Claims と根拠の対応（レビューの主戦場）

### ArrayBuffer (UT-COM-001〜017)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ArrayBuffer初期化時にArrayPool使用でバッファが確保される | E-01 (line 38-48) | ○ |
| C-02 | ArrayBuffer初期化時に通常配列でバッファが確保される | E-01 (line 43-45) | ○ |
| C-03 | initialSize=0でusePool=trueの場合空配列で初期化される | E-01 (line 43-44) | ○ |
| C-04 | Disposeでバッファが解放される | E-01 (line 60-72) | ○ |
| C-05 | ArrayPool使用時にDisposeでプールに返却される | E-01 (line 68-71, 187-195) | ○ |
| C-06 | ClearAndReturnBufferでバッファがクリアされプールに返却される | E-01 (line 75-86) | ○ |
| C-07 | ActiveLengthプロパティの動作 | E-01 (line 88) | ○ |
| C-08 | ActiveSpanプロパティの動作 | E-01 (line 89) | ○ |
| C-09 | AvailableLengthプロパティの動作 | E-01 (line 93) | ○ |
| C-10 | Discardメソッドの動作 | E-01 (line 103-113) | ○ |
| C-11 | 全データ破棄時にインデックスがリセットされる | E-01 (line 108-112) | ○ |
| C-12 | Commitメソッドの動作 | E-01 (line 115-119) | ○ |
| C-13 | EnsureAvailableSpaceメソッドの動作 | E-01 (line 122-129) | ○ |
| C-14 | 十分なスペースがある場合は何もしない | E-01 (line 125-128) | ○ |
| C-15 | シフトで十分な場合はシフトのみ行う | E-01 (line 143-151) | ○ |
| C-16 | 最大サイズ超過時にOutOfMemoryException | E-01 (line 155-158) | ○ |
| C-17 | Growメソッドの動作 | E-01 (line 182-185) | ○ |

### MultiArrayBuffer/MultiMemory (UT-COM-018〜044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | MultiArrayBuffer初期化 | E-02 (line 35-39) | ○ |
| C-19 | Disposeで全ブロックがArrayPoolに返却される | E-02 (line 41-60) | ○ |
| C-20 | IsEmptyプロパティ（空の場合） | E-02 (line 62) | ○ |
| C-21 | IsEmptyプロパティ（データありの場合） | E-02 (line 62) | ○ |
| C-22 | Discardメソッドの動作 | E-02 (line 68-90) | ○ |
| C-23 | ブロック境界をまたぐ破棄 | E-02 (line 83-87) | ○ |
| C-24 | DiscardAllメソッドの動作 | E-02 (line 92-103) | ○ |
| C-25 | Commitメソッドの動作 | E-02 (line 118-126) | ○ |
| C-26 | EnsureAvailableSpaceメソッドの動作 | E-02 (line 145-153) | ○ |
| C-27 | EnsureAvailableSpaceUpToLimitメソッド | E-02 (line 128-143) | ○ |
| C-28 | リミット超過時は何もしない | E-02 (line 133-137) | ○ |
| C-29 | GrowAvailableSpaceメソッド | E-02 (line 155-240) | ○ |
| C-30 | MultiMemory初期化 | E-02 (line 297-316) | ○ |
| C-31 | length=0の場合に空のメモリが作成される | E-02 (line 299-304) | ○ |
| C-32 | インデクサの動作 | E-02 (line 325-338) | ○ |
| C-33 | 範囲外インデックスでIndexOutOfRangeException | E-02 (line 330-333) | ○ |
| C-34 | BlockCountプロパティ | E-02 (line 340) | ○ |
| C-35 | GetBlockメソッド | E-02 (line 342-360) | ○ |
| C-36 | 範囲外ブロックインデックスでIndexOutOfRangeException | E-02 (line 344-347) | ○ |
| C-37 | Slice(int)メソッド | E-02 (line 362-371) | ○ |
| C-38 | Slice(int)の範囲外でIndexOutOfRangeException | E-02 (line 365-368) | ○ |
| C-39 | Slice(int, int)メソッド | E-02 (line 373-383) | ○ |
| C-40 | Slice(int, int)の範囲外でIndexOutOfRangeException | E-02 (line 376-379) | ○ |
| C-41 | CopyToメソッドの動作 | E-02 (line 385-399) | ○ |
| C-42 | CopyToで宛先が小さい場合にArgumentOutOfRangeException | E-02 (line 387-390) | ○ |
| C-43 | CopyFromメソッドの動作 | E-02 (line 401-422) | ○ |
| C-44 | CopyFromでソースが大きい場合にArgumentOutOfRangeException | E-02 (line 403-406) | ○ |

### TypeNameHelper (UT-COM-045〜052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | オブジェクトから型名が取得できる | E-03 (line 36-39) | ○ |
| C-46 | nullの場合にnullが返却される | E-03 (line 38) | ○ |
| C-47 | 組み込み型の短縮名が返却される | E-03 (line 15-33, 70-75) | ○ |
| C-48 | ジェネリック型名が正しくフォーマットされる | E-03 (line 59-64, 128-178) | ○ |
| C-49 | 配列型名が正しくフォーマットされる | E-03 (line 65-68, 109-126) | ○ |
| C-50 | 多次元配列型名が正しくフォーマットされる | E-03 (line 121-123) | ○ |
| C-51 | ネストされた型名が正しくフォーマットされる | E-03 (line 91-103, 138-141) | ○ |
| C-52 | ジェネリックパラメータ名が含まれる | E-03 (line 76-84) | ○ |

### HttpDateParser (UT-COM-053〜058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | RFC 1123形式の日付がパースできる | E-04 (line 11-14) | ○ |
| C-54 | RFC 850形式の日付がパースできる | E-04 (line 25-28) | ○ |
| C-55 | ANSI C asctime形式の日付がパースできる | E-04 (line 29) | ○ |
| C-56 | 前後の空白がトリムされる | E-04 (line 42) | ○ |
| C-57 | 不正な日付形式でfalseが返却される | E-04 (line 48-50) | ○ |
| C-58 | UTCタイムゾーンの日付がパースできる | E-04 (line 13, 16, 19, 22) | ○ |

### SourceWriter (UT-COM-059〜067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | 初期化時にインデントが0 | E-05 (line 16-17) | ○ |
| C-60 | インデントが設定できる | E-05 (line 19-31) | ○ |
| C-61 | 負のインデントでArgumentOutOfRangeException | E-05 (line 24-28) | ○ |
| C-62 | WriteLine(char)の動作 | E-05 (line 34-39) | ○ |
| C-63 | WriteLine(string)の動作 | E-05 (line 41-60) | ○ |
| C-64 | 複数行文字列が各行インデントされる | E-05 (line 49-59) | ○ |
| C-65 | WriteLine()の動作 | E-05 (line 62) | ○ |
| C-66 | ToSourceTextの動作 | E-05 (line 64-68) | ○ |
| C-67 | Resetの動作 | E-05 (line 70-74) | ○ |

### NonCapturingTimer (UT-COM-068〜070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | ExecutionContextをキャプチャしないTimerが作成される | E-06 (line 14-38) | ○ |
| C-69 | callbackがnullの場合にArgumentNullException | E-06 (line 16) | ○ |
| C-70 | フローが既に抑制されている場合の動作 | E-06 (line 22-26, 33-35) | △ |

### IntegerEncoder/IntegerDecoder (UT-COM-071〜081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | 1バイトでエンコードできる値の処理 | E-07 (line 36-42), E-16 | ○ |
| C-72 | 複数バイトでエンコードが必要な値の処理 | E-07 (line 43-72), E-16 | ○ |
| C-73 | プレフィックス最大値-1のエンコード | E-07 (line 36-42) | ○ |
| C-74 | プレフィックス最大値のエンコード | E-07 (line 43-45) | ○ |
| C-75 | 宛先バッファが空の場合にfalse | E-07 (line 28-32) | ○ |
| C-76 | 宛先バッファが不足する場合にfalse | E-07 (line 47-51, 60-64) | ○ |
| C-77 | 1バイトでデコードできる値がtrueを返却 | E-08 (line 42-46) | ○ |
| C-78 | 複数バイトが必要な場合にfalseを返却 | E-08 (line 48-51) | ○ |
| C-79 | 継続バイトのデコード | E-08 (line 62-100) | ○ |
| C-80 | オーバーフロー時にHPackDecodingException | E-08 (line 71-74) | ○ |
| C-81 | 過長エンコードでHPackDecodingException | E-08 (line 88-92) | ○ |

### DynamicTable (UT-COM-082〜092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | 指定サイズで初期化される | E-09 (line 17-21) | ○ |
| C-83 | Countプロパティの動作 | E-09 (line 23) | ○ |
| C-84 | Sizeプロパティの動作 | E-09 (line 25) | ○ |
| C-85 | インデクサの動作 | E-09 (line 29-51) | ○ |
| C-86 | 範囲外インデックスでIndexOutOfRangeException | E-09 (line 33-38) | ○ |
| C-87 | エントリが正しく挿入される | E-09 (line 53-105) | ○ |
| C-88 | MaxSize超のエントリでテーブルが空になる | E-09 (line 63-69), E-16 | ○ |
| C-89 | サイズ超過時に古いエントリが削除される | E-09 (line 118-133) | ○ |
| C-90 | 循環バッファが正しく動作する | E-09 (line 98-101) | ○ |
| C-91 | MaxSizeが更新される | E-09 (line 107-116) | ○ |
| C-92 | サイズ縮小時にエントリが削除される | E-09 (line 112-115) | ○ |

### TcpValidationHelpers (UT-COM-093〜097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | 有効なポート番号でtrueが返却される | E-10 (line 8-13) | ○ |
| C-94 | ポート0でtrueが返却される | E-10 (line 12) | ○ |
| C-95 | ポート65535でtrueが返却される | E-10 (line 12) | ○ |
| C-96 | 負のポート番号でfalseが返却される | E-10 (line 12) | ○ |
| C-97 | 65536以上でfalseが返却される | E-10 (line 12) | ○ |

### HttpValidationHelpers (UT-COM-098〜112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | 有効なヘッダー名が返却される | E-11 (line 8-22) | ○ |
| C-99 | 不正文字を含む場合にArgumentException | E-11 (line 12-14) | ○ |
| C-100 | 非ASCII文字を含む場合にArgumentException | E-11 (line 17-20) | ○ |
| C-101 | ASCII文字のみの場合にfalseが返却される | E-11 (line 24-25) | ○ |
| C-102 | 非ASCII文字を含む場合にtrueが返却される | E-11 (line 24-25) | ○ |
| C-103 | 有効なトークンでtrueが返却される | E-11 (line 27-32) | ○ |
| C-104 | 空文字列でfalseが返却される | E-11 (line 29) | ○ |
| C-105 | 不正文字を含む場合にfalseが返却される | E-11 (line 30) | ○ |
| C-106 | 有効な値が返却される | E-11 (line 39-98) | ○ |
| C-107 | null/空文字列で空文字列が返却される | E-11 (line 41-45) | ○ |
| C-108 | 前後の空白がトリムされる | E-11 (line 48) | ○ |
| C-109 | 制御文字を含む場合にArgumentException | E-11 (line 69-72) | ○ |
| C-110 | 不正なCRLFでArgumentException | E-11 (line 81, 89) | ○ |
| C-111 | 有効な文字列でfalseが返却される | E-11 (line 104-140) | ○ |
| C-112 | 区切り文字を含む場合にtrueが返却される | E-11 (line 108-132) | ○ |

### ImmutableEquatableArray (UT-COM-113〜125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | 空の配列が返却される | E-12 (line 18) | ○ |
| C-114 | コレクションから初期化される | E-12 (line 24-25) | ○ |
| C-115 | インデックスで要素が取得できる | E-12 (line 21) | ○ |
| C-116 | 要素数が返却される | E-12 (line 22) | ○ |
| C-117 | 同じ要素で等価判定がtrueになる | E-12 (line 27-28) | ○ |
| C-118 | 異なる要素で等価判定がfalseになる | E-12 (line 27-28) | ○ |
| C-119 | nullでfalseが返却される | E-12 (line 27) | ○ |
| C-120 | オブジェクト等価性が正しく判定される | E-12 (line 30-31) | ○ |
| C-121 | 同じ要素で同じハッシュコードが返却される | E-12 (line 33-42) | ○ |
| C-122 | 列挙子が正しく動作する | E-12 (line 44-46) | ○ |
| C-123 | MoveNextで次の要素に移動できる | E-12 (line 59-69) | ○ |
| C-124 | 末尾でMoveNextがfalseを返却 | E-12 (line 62-68) | ○ |
| C-125 | Currentで現在の要素が返却される | E-12 (line 72) | ○ |

### ArrayBufferWriter (UT-COM-126〜145)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | デフォルト初期化される | E-13 (line 32-36) | ○ |
| C-127 | 指定容量で初期化される | E-13 (line 46-53) | ○ |
| C-128 | initialCapacity<=0でArgumentException | E-13 (line 48-49) | ○ |
| C-129 | WrittenMemoryプロパティの動作 | E-13 (line 58) | ○ |
| C-130 | WrittenSpanプロパティの動作 | E-13 (line 63) | ○ |
| C-131 | WrittenCountプロパティの動作 | E-13 (line 68) | ○ |
| C-132 | Capacityプロパティの動作 | E-13 (line 73) | ○ |
| C-133 | FreeCapacityプロパティの動作 | E-13 (line 78) | ○ |
| C-134 | Clearメソッドの動作 | E-13 (line 93-98) | ○ |
| C-135 | ResetWrittenCountメソッドの動作 | E-13 (line 112) | ○ |
| C-136 | Advanceメソッドの動作 | E-13 (line 126-135) | ○ |
| C-137 | count<0でArgumentException | E-13 (line 128-129) | ○ |
| C-138 | FreeCapacityを超えるとInvalidOperationException | E-13 (line 131-132) | ○ |
| C-139 | GetMemoryメソッドの動作 | E-13 (line 161-166) | ○ |
| C-140 | sizeHint=0で非空のMemoryが返却される | E-13 (line 204-207) | ○ |
| C-141 | sizeHint<0でArgumentException | E-13 (line 201-202) | ○ |
| C-142 | GetSpanメソッドの動作 | E-13 (line 192-197) | ○ |
| C-143 | 必要に応じてバッファが拡張される | E-13 (line 199-241) | ○ |
| C-144 | バッファが2倍に拡張される | E-13 (line 214) | △ |
| C-145 | 最大サイズ超過時にOutOfMemoryException | E-13 (line 229-232, 248-251) | △ |

### TargetHostNameHelper (UT-COM-146〜150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146 | 通常のホスト名がそのまま返却される | E-14 (line 18-38) | ○ |
| C-147 | 末尾のドットが除去される | E-14 (line 26), E-17 | ○ |
| C-148 | IDNホスト名がASCIIに変換される | E-14 (line 28-31) | △ |
| C-149 | null/空文字列で空文字列が返却される | E-14 (line 20-23) | ○ |
| C-150 | IDN変換失敗時にセーフDNS名はそのまま返却される | E-14 (line 32-36) | ○ |

### NullScope (UT-COM-151〜152)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-151 | シングルトンインスタンスが返却される | E-15 (line 13) | ○ |
| C-152 | Disposeが何もしない | E-15 (line 20-22) | ○ |

## 4) 不足情報（Unknown / Missing）

1. **C-70（NonCapturingTimer、フロー抑制済みの場合）**
   - ExecutionContext.IsFlowSuppressed()がtrueの場合の動作は、コードから推測可能だが、実行環境での検証が必要
   - 候補：ランタイムテストで確認 / ExecutionContextの仕様書参照

2. **C-144/C-145（ArrayBufferWriter最大サイズ処理）**
   - Array.MaxLengthは実行環境依存であり、実際のOutOfMemoryExceptionの発生条件は環境による
   - 候補：ランタイムテストで確認 / メモリ制限環境でのテスト

3. **C-148（IDN変換）**
   - IdnMapping.GetAscii()の動作は.NETの実装依存であり、すべての国際化ドメイン名での動作保証は困難
   - 候補：ICU仕様書参照 / 多言語テストデータでの検証

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|-------------|------|------|
| 1（中リスク） | HPACK整数エンコード/デコード | HTTP/2プロトコルの重要部分。RFC 7541準拠が必須 |
| 1（中リスク） | ArrayBuffer/MultiArrayBufferのメモリ管理 | メモリリークの可能性があるため、Disposeパスの検証が重要 |
| 0（低リスク） | TypeNameHelper | 表示用途のみで、動作に影響しない |
| 1（中リスク） | HttpValidationHelpers | セキュリティ上重要なHTTPヘッダー検証。攻撃ベクトルの可能性 |
| 0（低リスク） | SourceWriter | ソースジェネレーター用の内部ツール |
| 0（低リスク） | NullScope | 単純なno-op実装 |

## 6) レビュアーチェックリスト（最小）

- [ ] UT-COM-001〜017：ArrayBufferのDispose/ClearAndReturnBufferで確実にArrayPoolに返却されることを確認
- [ ] UT-COM-018〜029：MultiArrayBufferの複数ブロック管理でメモリリークがないことを確認
- [ ] UT-COM-071〜081：HPACKエンコード/デコードがRFC 7541に準拠していることを確認
- [ ] UT-COM-082〜092：DynamicTableのエビクションロジックがRFC 7541 Section 4.4に準拠していることを確認
- [ ] UT-COM-098〜112：HttpValidationHelpersのセキュリティ観点での検証（ヘッダーインジェクション等）
- [ ] UT-COM-136〜145：ArrayBufferWriterのAdvance/GetMemory/GetSpanの境界条件を確認
- [ ] UT-COM-146〜150：TargetHostNameHelperのIDN処理が多言語環境で正しく動作することを確認
