---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 116
  claims_with_evidence: 116
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Fuzzing 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実際のコードと矛盾していないか
3. **網羅性**：対象モジュールのクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：116 / 116、根拠なし：0
- 優先レビュー（高）
  1. なし：全てのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Assert.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/IFuzzer.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/PooledBoundedMemory.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Program.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/Base64Fuzzer.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/Base64UrlFuzzer.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/TextEncodingFuzzer.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/UTF8Fuzzer.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/IPAddressFuzzer.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/JsonDocumentFuzzer.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/Utf8JsonWriterFuzzer.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/ZipArchiveFuzzer.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/Deflate64Fuzzer.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/HttpHeadersFuzzer.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/NrbfDecoderFuzzer.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/AssemblyNameInfoFuzzer.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/TypeNameFuzzer.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/SearchValuesByteCharFuzzer.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/SearchValuesStringFuzzer.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Assert クラス (UT-FUZ-001 - UT-FUZ-015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Equal<T>メソッドが存在し、EqualityComparerで比較する | E-01 (L12-21) | ○ |
| C-02 | 値が異なる場合にExceptionをスローする | E-01 (L19-20) | ○ |
| C-03 | Trueメソッドが存在し、Equal(true, actual)を呼ぶ | E-01 (L23-24) | ○ |
| C-04 | Falseメソッドが存在し、Equal(false, actual)を呼ぶ | E-01 (L26-27) | ○ |
| C-05 | NotNullメソッドが存在し、nullの場合に例外をスロー | E-01 (L29-38) | ○ |
| C-06 | SequenceEqualメソッドが存在し、シーケンス比較を行う | E-01 (L40-55) | ○ |
| C-07 | Throwsメソッドが存在し、例外の型を検証する | E-01 (L57-75) | ○ |

### IFuzzer インターフェース (UT-FUZ-016 - UT-FUZ-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | Nameプロパティのデフォルト実装がGetType().Nameを返す | E-02 (L9) | ○ |
| C-09 | Dictionaryプロパティのデフォルト実装がnullを返す | E-02 (L20) | ○ |
| C-10 | Corpusプロパティのデフォルト実装がnullを返す | E-02 (L23) | ○ |

### PooledBoundedMemory<T> クラス (UT-FUZ-019 - UT-FUZ-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | Rentメソッドが指定サイズのメモリを確保する | E-03 (L38-55) | ○ |
| C-12 | MaxLength以上でプールを使用しない | E-03 (L40-42) | ○ |
| C-13 | 無効なPoisonPagePlacementで例外をスロー | E-03 (L49) | ○ |
| C-14 | Rent(ReadOnlySpan)でデータがコピーされる | E-03 (L57-62) | ○ |
| C-15 | Disposeでプールに返却される | E-03 (L29-36) | ○ |
| C-16 | InnerMemory, Memory, Spanプロパティが存在する | E-03 (L25-27) | ○ |

### Program クラス (UT-FUZ-029 - UT-FUZ-033)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | 引数なしで使用方法を表示する | E-04 (L37-41) | ○ |
| C-18 | prepare-onefuzzコマンドが存在する | E-04 (L43-55) | ○ |
| C-19 | Fuzzer名で実行できる | E-04 (L57-76) | ○ |
| C-20 | 存在しないFuzzer名でエラーを出力 | E-04 (L61-64) | ○ |
| C-21 | --get-instrumented-assembliesオプションが存在 | E-04 (L67-74) | ○ |

### Base64Fuzzer (UT-FUZ-034 - UT-FUZ-041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | FuzzTargetでBase64エンコード/デコードをテスト | E-05 (L17-24) | ○ |
| C-23 | PoisonPagePlacement.Before/Afterの両方でテスト | E-05 (L19-23) | ○ |
| C-24 | isFinalBlock=true/falseの両方でテスト | E-05 (L41-94) | ○ |
| C-25 | EncodeToUtf8InPlaceをテスト | E-05 (L96-109) | ○ |
| C-26 | IsValidとDecodeFromUtf8の整合性をテスト | E-05 (L111-132) | ○ |

### Base64UrlFuzzer (UT-FUZ-042 - UT-FUZ-045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | Base64Urlエンコード/デコードをテスト | E-06 (L17-46) | ○ |
| C-28 | EncodeToStringをテスト | E-06 (L37-38) | ○ |
| C-29 | TryEncodeToUtf8InPlaceをテスト | E-06 (L89-101) | ○ |
| C-30 | 無効データでInvalidDataを返却 | E-06 (L124-132) | ○ |

### TextEncodingFuzzer (UT-FUZ-046 - UT-FUZ-052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | Latin1, ASCII, Unicode, UTF32, UTF8をテスト | E-07 (L29-34) | ○ |
| C-32 | throwOnInvalidBytes=trueでDecoderFallbackExceptionをテスト | E-07 (L111-130) | ○ |
| C-33 | Convert()メソッドでブロック単位変換をテスト | E-07 (L132-187) | ○ |

### UTF8Fuzzer (UT-FUZ-053 - UT-FUZ-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | 文字数カウントがRune列挙と一致することを検証 | E-08 (L30-32) | ○ |
| C-35 | Utf8.ToUtf16をreplaceInvalidSequences=trueでテスト | E-08 (L42-59) | ○ |
| C-36 | replaceInvalidSequences=falseで無効データをスキップ | E-08 (L62-84) | ○ |
| C-37 | カスタム置換文字列でのテスト | E-08 (L87-116) | ○ |

### IPAddressFuzzer (UT-FUZ-057 - UT-FUZ-061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | IsValidUtf8とTryParseの整合性をテスト | E-09 (L23-39) | ○ |
| C-39 | 有効なIPアドレスでUriを作成 | E-09 (L68-104) | ○ |

### JsonDocumentFuzzer (UT-FUZ-062 - UT-FUZ-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | JsonDocumentOptionsでAllowTrailingCommasをテスト | E-10 (L27-31) | ○ |
| C-41 | CommentHandlingをテスト | E-10 (L30) | ○ |
| C-42 | JsonExceptionをキャッチ | E-10 (L39) | ○ |
| C-43 | 空入力で早期リターン | E-10 (L17-20) | ○ |

### Utf8JsonWriterFuzzer (UT-FUZ-067 - UT-FUZ-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | UTF8/UTF16/Base64エンコーディングをテスト | E-11 (L60-64, L102-109) | ○ |
| C-45 | JsonWriterOptionsの各フラグをテスト | E-11 (L72-80) | ○ |
| C-46 | 複数セグメントに分割して書き込みをテスト | E-11 (L92-119) | ○ |
| C-47 | エンコーディング混在でInvalidOperationExceptionをテスト | E-11 (L122-195) | ○ |
| C-48 | 最小長未満で早期リターン | E-11 (L45-49) | ○ |

### ZipArchiveFuzzer (UT-FUZ-074 - UT-FUZ-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | 同期/非同期の両方でZipArchiveをテスト | E-12 (L23-24) | ○ |
| C-50 | InvalidDataExceptionをキャッチ | E-12 (L78-81) | ○ |
| C-51 | 空入力で早期リターン | E-12 (L17-21) | ○ |

### Deflate64Fuzzer (UT-FUZ-078 - UT-FUZ-081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | 同期/非同期の両方でDeflate64をテスト | E-13 (L25-26) | ○ |
| C-53 | InvalidDataExceptionをキャッチ | E-13 (L74-77) | ○ |
| C-54 | 空入力で早期リターン | E-13 (L18-23) | ○ |

### HttpHeadersFuzzer (UT-FUZ-082 - UT-FUZ-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | HttpRequestHeaders, HttpContentHeaders, HttpResponseHeadersをテスト | E-14 (L52-54) | ○ |
| C-56 | TryAddWithoutValidationをテスト | E-14 (L60) | ○ |
| C-57 | FormatExceptionをキャッチ | E-14 (L74) | ○ |
| C-58 | CR/LF/NULが含まれないことを検証 | E-14 (L77-91) | ○ |
| C-59 | 入力長が2未満で早期リターン | E-14 (L41-44) | ○ |

### NrbfDecoderFuzzer (UT-FUZ-088 - UT-FUZ-095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | StartsWithPayloadHeaderをテスト | E-15 (L41) | ○ |
| C-61 | シーク不可ストリームでテスト | E-15 (L35-36, L282-286) | ○ |
| C-62 | 各種例外をキャッチ | E-15 (L56-60) | ○ |
| C-63 | PrimitiveTypeRecord, ClassRecord, ArrayRecordを処理 | E-15 (L84-205) | ○ |

### AssemblyNameInfoFuzzer (UT-FUZ-096 - UT-FUZ-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | TryParseとParseの整合性をテスト | E-16 (L34-43) | ○ |
| C-65 | ToAssemblyName()をテスト | E-16 (L58-89) | ○ |
| C-66 | 無効データでArgumentExceptionをキャッチ | E-16 (L105-112) | ○ |

### TypeNameFuzzer (UT-FUZ-101 - UT-FUZ-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | TryParseとParseの整合性をテスト | E-17 (L29-49) | ○ |
| C-68 | 無効データでArgumentException/InvalidOperationExceptionをキャッチ | E-17 (L53-59) | ○ |

### SearchValuesByteCharFuzzer (UT-FUZ-106 - UT-FUZ-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | バイト/文字配列でIndexOfAny系メソッドをテスト | E-18 (L30, L42) | ○ |
| C-70 | スカラー実装との比較 | E-18 (L58-61, L76-130) | ○ |
| C-71 | 改行なしで早期リターン | E-18 (L18-22) | ○ |

### SearchValuesStringFuzzer (UT-FUZ-112 - UT-FUZ-116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | Ordinal/OrdinalIgnoreCase比較をテスト | E-19 (L30-31) | ○ |
| C-73 | 参照実装との比較 | E-19 (L40, L43-57) | ○ |
| C-74 | 改行なしで早期リターン | E-19 (L18-22) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースに対してソースコードの根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのクラス・メソッドに対してソースコードを直接参照してテストケースを作成
- 注意点：
  - Fuzzingテストの性質上、入力データが多様であるため、境界値テストケースの網羅性は実際のファジング実行で補完される
  - 一部のFuzzer（NrbfDecoderFuzzer等）は複雑なデータ構造を扱うため、実際のテスト実装時には追加のモックが必要になる可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] Assert クラスのテストケース（UT-FUZ-001 - UT-FUZ-015）が実装可能か確認
- [ ] PooledBoundedMemory<T> のプール管理ロジックのテストが適切か確認
- [ ] 各Fuzzerの FuzzTarget メソッドのテストケースが入力パターンを網羅しているか確認
- [ ] 例外処理のテストケースが正しい例外型を期待しているか確認
- [ ] PoisonPagePlacement のテストがメモリ境界問題を正しく検出できるか確認
