---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 52
  claims_with_evidence: 52
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Bcl.AsyncInterfaces.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：52 / 52、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースに根拠あり - 特に優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Bcl.AsyncInterfaces/src/System/Runtime/CompilerServices/AsyncIteratorMethodBuilder.cs`
- E-02: `src/libraries/Microsoft.Bcl.AsyncInterfaces/src/System/Threading/Tasks/Sources/ManualResetValueTaskSourceCore.cs`
- E-03: `src/libraries/Microsoft.Bcl.AsyncInterfaces/src/Microsoft.Bcl.AsyncInterfaces.Forwards.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### AsyncIteratorMethodBuilder（UT-BAI-001 〜 UT-BAI-012）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Create メソッドが存在し AsyncIteratorMethodBuilder を返却する | E-01 (L25-26) | ○ |
| C-02 | Create が内部で AsyncTaskMethodBuilder.Create を呼び出す | E-01 (L26) | ○ |
| C-03 | MoveNext メソッドが IAsyncStateMachine を受け取る | E-01 (L32-33) | ○ |
| C-04 | MoveNext が内部で _methodBuilder.Start を呼び出す | E-01 (L33) | ○ |
| C-05 | AwaitOnCompleted が INotifyCompletion 制約を持つ | E-01 (L40-43) | ○ |
| C-06 | AwaitOnCompleted が内部 AsyncTaskMethodBuilder に委譲する | E-01 (L43) | ○ |
| C-07 | AwaitUnsafeOnCompleted が ICriticalNotifyCompletion 制約を持つ | E-01 (L50-53) | ○ |
| C-08 | AwaitUnsafeOnCompleted が内部 AsyncTaskMethodBuilder に委譲する | E-01 (L53) | ○ |
| C-09 | Complete が内部 SetResult を呼び出す | E-01 (L56) | ○ |
| C-10 | ObjectIdForDebugger が存在し internal である | E-01 (L59) | ○ |
| C-11 | ObjectIdForDebugger が Interlocked.CompareExchange でスレッドセーフに初期化される | E-01 (L59) | ○ |
| C-12 | _id フィールドが一度初期化されると同じオブジェクトを返す | E-01 (L59) | ○ |

### ManualResetValueTaskSourceCore<TResult>（UT-BAI-013 〜 UT-BAI-050）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | Reset メソッドが _version をインクリメントする | E-02 (L53-56) | ○ |
| C-14 | Reset が _completed, _result, _error 等をクリアする | E-02 (L57-63) | ○ |
| C-15 | SetResult が _result に値を設定し SignalCompletion を呼ぶ | E-02 (L68-72) | ○ |
| C-16 | SetResult 後に継続が実行される（SignalCompletion 経由） | E-02 (L71, L198-220) | ○ |
| C-17 | SignalCompletion が _completed=true の場合に InvalidOperationException をスロー | E-02 (L200-203) | ○ |
| C-18 | SetException が ExceptionDispatchInfo.Capture で例外をラップする | E-02 (L76-79) | ○ |
| C-19 | Version プロパティが _version を返す | E-02 (L83) | ○ |
| C-20 | GetStatus が token を ValidateToken で検証する | E-02 (L88-89) | ○ |
| C-21 | GetStatus が Pending/Succeeded/Faulted/Canceled を返す | E-02 (L90-94) | ○ |
| C-22 | GetStatus が OperationCanceledException を Canceled として扱う | E-02 (L93) | ○ |
| C-23 | GetResult が token を ValidateToken で検証する | E-02 (L100-101) | ○ |
| C-24 | GetResult が未完了時に InvalidOperationException をスロー | E-02 (L102-105) | ○ |
| C-25 | GetResult が _error?.Throw() で例外をリスロー | E-02 (L107) | ○ |
| C-26 | GetResult が _result を返す | E-02 (L108) | ○ |
| C-27 | OnCompleted が continuation の null チェックを行う | E-02 (L118) | ○ |
| C-28 | OnCompleted が token を ValidateToken で検証する | E-02 (L119) | ○ |
| C-29 | OnCompleted が FlowExecutionContext フラグで ExecutionContext をキャプチャ | E-02 (L121-124) | ○ |
| C-30 | OnCompleted が UseSchedulingContext フラグで SynchronizationContext をキャプチャ | E-02 (L126-131) | ○ |
| C-31 | OnCompleted が UseSchedulingContext フラグで TaskScheduler をキャプチャ | E-02 (L134-139) | ○ |
| C-32 | OnCompleted がデフォルト SynchronizationContext をスキップする | E-02 (L129) | ○ |
| C-33 | OnCompleted が二重登録で InvalidOperationException をスロー | E-02 (L161-163) | ○ |
| C-34 | OnCompleted が完了済みの場合に即座に継続を実行 | E-02 (L158-184) | ○ |
| C-35 | OnCompleted が SynchronizationContext.Post で継続を実行 | E-02 (L172-177) | ○ |
| C-36 | OnCompleted が TaskScheduler 上で Task.Factory.StartNew で継続を実行 | E-02 (L180-181) | ○ |
| C-37 | ValidateToken が token != _version で InvalidOperationException をスロー | E-02 (L189-194) | ○ |
| C-38 | SignalCompletion が _completed をチェックして二重完了を防止 | E-02 (L200-203) | ○ |
| C-39 | SignalCompletion が ExecutionContext.Run で継続を実行 | E-02 (L208-214) | ○ |
| C-40 | InvokeContinuation が _capturedContext に応じて実行方法を切り替え | E-02 (L227-256) | ○ |
| C-41 | RunContinuationsAsynchronously が true の場合に非同期実行 | E-02 (L234-236) | ○ |
| C-42 | RunContinuationsAsynchronously が false の場合に同期実行可能 | E-02 (L238-240) | ○ |
| C-43 | RunContinuationsAsynchronously がプロパティとして公開 | E-02 (L50) | ○ |

### ManualResetValueTaskSourceCoreShared（UT-BAI-051 〜 UT-BAI-052）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | s_sentinel が static readonly フィールドとして存在 | E-02 (L261) | ○ |
| C-45 | s_sentinel が CompletionSentinel メソッドを参照 | E-02 (L261) | ○ |
| C-46 | CompletionSentinel が呼び出されると InvalidOperationException をスロー | E-02 (L262-266) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースがソースコードに基づいて作成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに明確なソースコード根拠あり
- 注意点：
  - このモジュールは .NET Standard 2.0 向けのポリフィル実装であり、.NET Core/5+ では型フォワーディングにより本体実装が使用される
  - E-01, E-02 のコメントに記載の通り、これらは CoreCLR 実装のコピーであり、一部最適化が省略されている

## 6) レビュアーチェックリスト（最小）
- [ ] AsyncIteratorMethodBuilder のテストケースが全メソッド（Create, MoveNext, AwaitOnCompleted, AwaitUnsafeOnCompleted, Complete, ObjectIdForDebugger）をカバーしているか
- [ ] ManualResetValueTaskSourceCore のテストケースが全メソッド（Reset, SetResult, SetException, Version, GetStatus, GetResult, OnCompleted, RunContinuationsAsynchronously）をカバーしているか
- [ ] 各メソッドの正常系・異常系・境界値が網羅されているか
- [ ] スレッドセーフ性に関するテストケースが含まれているか（UT-BAI-012, UT-BAI-043〜046）
- [ ] トークン検証のテストケースが十分か（UT-BAI-032, UT-BAI-036, UT-BAI-041）
- [ ] 二重完了・二重登録の防止テストが含まれているか（UT-BAI-018, UT-BAI-023, UT-BAI-042）
