---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 130
  claims_with_evidence: 128
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-Microsoft.Bcl.Cryptography 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：128 / 130、根拠なし：2
- 優先レビュー（高）
  1. **C-106〜C-111 (CngKeyExtensions)**: Windows固有のCNG API。実行環境依存のため動作確認が必要
  2. **C-58〜C-79 (X509CertificateKeyAccessors)**: ポスト量子暗号関連。プラットフォームサポート状況の確認が必要
  3. **C-128〜C-130 (CertificateHelpers)**: Windows Interop依存。実機テストが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/PemEncoding.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/SP800108HmacCounterKdf.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/SP800108HmacCounterKdfImplementationManaged.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/SP800108HmacCounterKdfImplementationCng.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/Helpers.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/HashAlgorithmNames.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/X509Certificates/X509CertificateLoader.netstandard.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/X509Certificates/X509CertificateLoader.netfx.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/X509Certificates/X509CertificateLoader.ProcessedPkcs12.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/X509Certificates/X509CertificateKeyAccessors.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/X509Certificates/CertificateHelpers.Windows.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/PinAndClear.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/NetStandardShims.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/CngExtensions.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/CngIdentifierExtensions.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/Microsoft/Win32/SafeHandles/SafePasswordHandle.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Bcl.Cryptography/src/Microsoft.Bcl.Cryptography.Forwards.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-18 | PemEncodingクラスのテストケース | E-01 | ○ |
| C-19 | PemFieldsのテストケース | E-01 | ○ |
| C-20〜C-28 | SP800108HmacCounterKdfのテストケース | E-02 | ○ |
| C-29〜C-38 | SP800108HmacCounterKdfImplementationManagedのテストケース | E-03 | ○ |
| C-39〜C-45 | SP800108HmacCounterKdfImplementationCngのテストケース | E-04 | ○ |
| C-46〜C-57 | X509CertificateLoaderのテストケース | E-07, E-08, E-09 | ○ |
| C-58〜C-79 | X509CertificateKeyAccessorsのテストケース | E-10 | ○ |
| C-80〜C-91 | Internal.Cryptography.Helpersのテストケース | E-05 | ○ |
| C-92〜C-93 | PinAndClearのテストケース | E-12 | ○ |
| C-94〜C-101 | NetStandardShimsのテストケース | E-13 | ○ |
| C-102〜C-105 | CryptographicOperationsのテストケース | E-13 | ○ |
| C-106〜C-111 | CngKeyExtensionsのテストケース | E-14 | ○ |
| C-112〜C-119 | SafePasswordHandleのテストケース | E-16 | ○ |
| C-120〜C-127 | CngIdentifierExtensionsのテストケース | E-15 | ○ |
| C-128 | CertificateHelpers.GuessKeySpec | E-11 | ○ |
| C-129 | CertificateHelpers.CopyFromRawBytes | E-11 | ○ |
| C-130 | CertificateHelpers.DuplicateCertificateHandle | E-11 | ○ |
| C-21 | Windows 8未満でManaged実装が返却される | **推測による** | △ |
| C-28 | IsWindows8OrGreaterの動作 | **環境依存** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-21**: Windows 8未満環境での実際のテストは実施していない。コードレビューによる推測。
  - 候補：Windows 7環境でのテスト / モック化によるテスト / 条件分岐のカバレッジ確認
- **C-28**: プラットフォーム検出ロジックの正確性は実行環境に依存。
  - 候補：各Windowsバージョンでの実機テスト / CI/CDパイプラインでのマトリックステスト

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: ポスト量子暗号（ML-KEM, ML-DSA, SLH-DSA, CompositeMLDsa）関連のテストケースは、プラットフォームサポート状況により実行可否が変わる可能性がある
- **1（中リスク）**: Windows CNG API依存のテストケースはWindows環境でのみ実行可能
- **0（低リスク）**: PemEncoding、NetStandardShims、CryptographicOperationsはクロスプラットフォームで実行可能

## 6) レビュアーチェックリスト（最小）
- [ ] PemEncodingのテストケースがRFC 7468の仕様を網羅しているか確認
- [ ] SP800108HmacCounterKdfのテストケースがNIST SP 800-108の仕様に準拠しているか確認
- [ ] X509CertificateLoaderのテストケースが各証明書形式（DER, PEM, PKCS12）を網羅しているか確認
- [ ] ポスト量子暗号関連のテストケースが実行可能なプラットフォームで実施されるか確認
- [ ] Windows固有のCNG APIテストがWindows環境で実行されることを確認
- [ ] セキュリティクリティカルなメソッド（ZeroMemory, FixedTimeEquals, SafePasswordHandle）のテストが十分か確認
- [ ] 境界値テストが各メソッドの入力制限を適切にカバーしているか確認
- [ ] 異常系テストが想定されるすべての例外をカバーしているか確認
