---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 115
  claims_with_evidence: 115
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Bcl.Memory 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：115 / 115、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Bcl.Memory/src/System/ThrowHelper.cs`
- E-02: `src/libraries/Microsoft.Bcl.Memory/src/Polyfills/System.Numerics.BitOperations.netstandard20.cs`
- E-03: `src/libraries/Microsoft.Bcl.Memory/src/Microsoft.Bcl.Memory.Forwards.cs`
- E-04: `src/libraries/Microsoft.Bcl.Memory/src/Microsoft.Bcl.Memory.csproj`
- E-05: `src/libraries/System.Private.CoreLib/src/System/Index.cs`
- E-06: `src/libraries/System.Private.CoreLib/src/System/Range.cs`
- E-07: `src/libraries/System.Private.CoreLib/src/System/Buffers/Text/Base64Url/Base64UrlEncoder.cs`
- E-08: `src/libraries/System.Private.CoreLib/src/System/Buffers/Text/Base64Url/Base64UrlDecoder.cs`
- E-09: `src/libraries/System.Private.CoreLib/src/System/Buffers/Text/Base64Url/Base64UrlValidator.cs`
- E-10: `src/libraries/System.Private.CoreLib/src/System/Text/Unicode/Utf8.cs`
- E-11: `src/libraries/Microsoft.Bcl.Memory/src/Resources/Strings.resx`
- E-12: `src/libraries/Microsoft.Bcl.Memory/src/PACKAGE.md`

## 3) Claims と根拠の対応（レビューの主戦場）

### System.Index（UT-BCL-001 ~ UT-BCL-024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Index(int, bool)コンストラクタの動作 | E-05 L33-45 | ○ |
| C-02 | Index(int, bool)でfromEnd=trueの場合のビット反転 | E-05 L41-42 | ○ |
| C-03 | 負のvalue値で例外スロー | E-05 L36-39 | ○ |
| C-04 | FromStartファクトリメソッド | E-05 L61-70 | ○ |
| C-05 | FromEndファクトリメソッド | E-05 L74-83 | ○ |
| C-06 | Valueプロパティのビット反転復元 | E-05 L86-95 | ○ |
| C-07 | IsFromEndプロパティ | E-05 L98 | ○ |
| C-08 | GetOffsetメソッドのオフセット計算 | E-05 L108-121 | ○ |
| C-09 | Equals/GetHashCode実装 | E-05 L125-132 | ○ |
| C-10 | 暗黙的変換演算子 | E-05 L135 | ○ |
| C-11 | ToStringメソッド | E-05 L138-166 | ○ |
| C-12 | Start/End静的プロパティ | E-05 L54-57 | ○ |

### System.Range（UT-BCL-025 ~ UT-BCL-040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | Range(Index, Index)コンストラクタ | E-06 L39-43 | ○ |
| C-14 | Start/Endプロパティ | E-06 L31-34 | ○ |
| C-15 | GetOffsetAndLengthメソッド | E-06 L116-127 | ○ |
| C-16 | 範囲外チェックでの例外スロー | E-06 L121-124, L129-132 | ○ |
| C-17 | StartAt/EndAtファクトリメソッド | E-06 L100-103 | ○ |
| C-18 | All静的プロパティ | E-06 L106 | ○ |
| C-19 | Equals/GetHashCode実装 | E-06 L47-64 | ○ |
| C-20 | ToStringメソッド | E-06 L67-96 | ○ |

### System.Buffers.Text.Base64Url（UT-BCL-041 ~ UT-BCL-083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | GetEncodedLength計算 | E-07 L39-57 | ○ |
| C-22 | GetMaxDecodedLength計算 | E-08 L28-46 | ○ |
| C-23 | EncodeToUtf8メソッド群 | E-07 L29-93 | ○ |
| C-24 | EncodeToCharsメソッド群 | E-07 L106-144 | ○ |
| C-25 | EncodeToStringメソッド | E-07 L152-170 | ○ |
| C-26 | TryEncodeToChars/TryEncodeToUtf8 | E-07 L180-200 | ○ |
| C-27 | TryEncodeToUtf8InPlace | E-07 L213-218 | ○ |
| C-28 | DecodeFromUtf8メソッド群 | E-08 L65-180 | ○ |
| C-29 | DecodeFromUtf8InPlace | E-08 L83-96 | ○ |
| C-30 | DecodeFromCharsメソッド群 | E-08 L199-277 | ○ |
| C-31 | TryDecodeFromUtf8/TryDecodeFromChars | E-08 L141-152, L240-250 | ○ |
| C-32 | IsValidメソッド群（char版） | E-09 L20-34 | ○ |
| C-33 | IsValidメソッド群（byte版） | E-09 L42-53 | ○ |
| C-34 | パディング省略対応 | E-08 L59-64 (コメント) | ○ |
| C-35 | 無効文字検出 | E-08 L89-92, E-11 (SR.Format_BadBase64Char) | ○ |

### System.Text.Unicode.Utf8（UT-BCL-084 ~ UT-BCL-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | FromUtf16メソッド | E-10 L45-121 | ○ |
| C-37 | ToUtf16メソッド | E-10 L131-215 | ○ |
| C-38 | replaceInvalidSequencesパラメータ | E-10 L84-88, L175-179 | ○ |
| C-39 | isFinalBlockパラメータ | E-10 L75-78, L166-169 | ○ |
| C-40 | IsValidメソッド | E-10 L826-827 | ○ |
| C-41 | U+FFFD置換処理 | E-10 L101-104, L192-193 | ○ |

### System.Numerics.BitOperations（UT-BCL-101 ~ UT-BCL-109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | TrailingZeroCountメソッド | E-02 L35-49 | ○ |
| C-43 | value=0で32を返却 | E-02 L38-41 | ○ |
| C-44 | RotateLeftメソッド | E-02 L60-61 | ○ |
| C-45 | RotateRightメソッド | E-02 L72-73 | ○ |

### System.ThrowHelper（UT-BCL-110 ~ UT-BCL-115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | ThrowArgumentException_DestinationTooShort | E-01 L12-15 | ○ |
| C-47 | ThrowArgumentNullException | E-01 L17-21 | ○ |
| C-48 | ThrowArgumentOutOfRangeException | E-01 L23-27 | ○ |
| C-49 | GetArgumentName各ケース | E-01 L29-48 | ○ |
| C-50 | ExceptionArgument enum定義 | E-01 L54-61 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいて生成されている
- 共有コードファイル（CoreLib）からリンクされるコードについて、Microsoft.Bcl.Memoryパッケージとして.NET Framework/Standard向けにコンパイルされた際の動作差異を確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] Index/Range型のテストケースがC#の新しいインデックス/範囲構文をカバーしているか
- [ ] Base64Urlのテストケースでパディングあり/なしの両方がカバーされているか
- [ ] Utf8のテストケースでマルチバイト文字（日本語等）が適切にカバーされているか
- [ ] 無効なシーケンス検出のテストケースが十分か
- [ ] 境界値テスト（空入力、最大値、最小値）が網羅されているか
- [ ] .NET Framework / .NET Standard 2.0向けポリフィルとしての特殊ケースが考慮されているか
