---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-Microsoft.Bcl.Numerics 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-BCN-118, UT-BCN-119, UT-BCN-120**: privateメソッド（Int32BitsToSingle, IsNegative）のテストは直接実行不可。間接的なテストの検討が必要
  2. **Tanh無限大処理**: 実装コードがMath.Tanhへの委譲のため、期待値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Bcl.Numerics/src/System/MathF.cs` - MathFクラスの実装
- E-02: `src/libraries/Microsoft.Bcl.Numerics/src/Microsoft.Bcl.Numerics.Forwards.cs` - 型転送定義
- E-03: `src/libraries/Microsoft.Bcl.Numerics/tests/MathF.cs` - 既存テストコード
- E-04: `src/libraries/Microsoft.Bcl.Numerics/src/PACKAGE.md` - パッケージ説明

## 3) Claims と根拠の対応（レビューの主戦場）

### 定数テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-BCN-001) | PI定数が3.14159265fであること | E-01 (Line 34) | ○ |
| C-02 (UT-BCN-002) | E定数が2.71828183fであること | E-01 (Line 39) | ○ |

### Absメソッドテスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-03 (UT-BCN-003) | 正の値の絶対値が正しく返却される | E-01 (Line 59), E-03 (Lines 45-82) | ○ |
| C-04 (UT-BCN-004) | 負の値の絶対値が正しく返却される | E-01 (Line 59), E-03 (Lines 45-82) | ○ |
| C-05 (UT-BCN-005) | ゼロの絶対値が返却される | E-03 (Lines 61, 63) | ○ |
| C-06 (UT-BCN-006) | 負のゼロの絶対値が返却される | E-03 (Line 61) | ○ |
| C-07 (UT-BCN-007) | NaNの絶対値がNaN | E-03 (Line 62) | ○ |
| C-08 (UT-BCN-008) | 正の無限大の絶対値 | E-03 (Line 78) | ○ |
| C-09 (UT-BCN-009) | 負の無限大の絶対値 | E-03 (Line 46) | ○ |

### 逆三角関数テスト（Acos, Asin, Atan, Atan2）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 (UT-BCN-010) | Acos有効範囲内計算 | E-01 (Line 66), E-03 (Lines 84-113) | ○ |
| C-11 (UT-BCN-011) | Acos(1.0)=0 | E-03 (Line 105) | ○ |
| C-12 (UT-BCN-012) | Acos(-1.0)=pi | E-03 (Line 89) | ○ |
| C-13 (UT-BCN-013) | Acos範囲外でNaN | E-03 (Lines 106-108) | ○ |
| C-14 (UT-BCN-014) | Acos負の範囲外でNaN | E-03 (Lines 86-88) | ○ |
| C-15 (UT-BCN-015) | Acos(NaN)=NaN | E-03 (Line 93) | ○ |
| C-16 (UT-BCN-016) | Asin有効範囲内計算 | E-01 (Line 73), E-03 (Lines 115-156) | ○ |
| C-17 (UT-BCN-017) | Asin(1.0)=pi/2 | E-03 (Line 148) | ○ |
| C-18 (UT-BCN-018) | Asin(-1.0)=-pi/2 | E-03 (Line 120) | ○ |
| C-19 (UT-BCN-019) | Asin(0)=0 | E-03 (Line 135) | ○ |
| C-20 (UT-BCN-020) | Asin範囲外でNaN | E-03 (Lines 149-152) | ○ |
| C-21 (UT-BCN-021) | Atan(0)=0 | E-03 (Line 174) | ○ |
| C-22 (UT-BCN-022) | Atan(1)=pi/4 | E-03 (Line 181) | ○ |
| C-23 (UT-BCN-023) | Atan(+inf)=pi/2 | E-03 (Line 187) | ○ |
| C-24 (UT-BCN-024) | Atan(-inf)=-pi/2 | E-03 (Line 159) | ○ |
| C-25 (UT-BCN-025) | Atan2第1象限 | E-01 (Line 88), E-03 (Lines 263, 278) | ○ |
| C-26 (UT-BCN-026) | Atan2第2象限 | E-03 (Line 262, 274) | ○ |
| C-27 (UT-BCN-027) | Atan2第3象限 | E-03 (Lines 199, 215) | ○ |
| C-28 (UT-BCN-028) | Atan2第4象限 | E-03 (Lines 203, 216) | ○ |
| C-29 (UT-BCN-029) | Atan2 y=0, x>0 | E-03 (Line 248) | ○ |
| C-30 (UT-BCN-030) | Atan2 y=0, x<0 | E-03 (Lines 243-244) | ○ |

### Ceiling/Floorメソッドテスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 (UT-BCN-031) | Ceiling正の値切り上げ | E-01 (Line 95), E-03 (Lines 290-337) | ○ |
| C-32 (UT-BCN-032) | Ceiling負の値切り上げ | E-03 (Lines 292-299) | ○ |
| C-33 (UT-BCN-033) | Ceiling整数値 | E-03 (Line 325) | ○ |
| C-34 (UT-BCN-034) | Ceiling(0) | E-03 (Line 318) | ○ |
| C-47 (UT-BCN-047) | Floor正の値切り捨て | E-01 (Line 123), E-03 (Lines 456-493) | ○ |
| C-48 (UT-BCN-048) | Floor負の値切り捨て | E-03 (Lines 458-471) | ○ |
| C-49 (UT-BCN-049) | Floor整数値 | E-03 (Line 481) | ○ |
| C-50 (UT-BCN-050) | Floor(0) | E-03 (Line 474) | ○ |

### 三角関数テスト（Cos, Sin, Tan）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 (UT-BCN-035) | Cos(0)=1 | E-01 (Line 102), E-03 (Lines 357) | ○ |
| C-36 (UT-BCN-036) | Cos(pi/2)=0 | E-03 (Line 368) | ○ |
| C-37 (UT-BCN-037) | Cos(pi)=-1 | E-03 (Line 371) | ○ |
| C-38 (UT-BCN-038) | Cos(inf)=NaN | E-03 (Line 372) | ○ |
| C-95 (UT-BCN-095) | Sin(0)=0 | E-01 (Line 295), E-03 (Line 898) | ○ |
| C-96 (UT-BCN-096) | Sin(pi/2)=1 | E-03 (Line 909) | ○ |
| C-97 (UT-BCN-097) | Sin(pi)=0 | E-03 (Line 912) | ○ |
| C-98 (UT-BCN-098) | Sin(inf)=NaN | E-03 (Line 913) | ○ |
| C-107 (UT-BCN-107) | Tan(0)=0 | E-01 (Line 316), E-03 (Line 998-999) | ○ |
| C-108 (UT-BCN-108) | Tan(pi/4)=1 | E-03 から推測 | ○ |
| C-109 (UT-BCN-109) | Tan(inf)=NaN | E-03 (Line 998) | ○ |

### 双曲線関数テスト（Cosh, Sinh, Tanh）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 (UT-BCN-039) | Cosh(0)=1 | E-01 (Line 109), E-03 (Lines 396) | ○ |
| C-40 (UT-BCN-040) | Cosh正の値 | E-03 (Line 403) | ○ |
| C-41 (UT-BCN-041) | Cosh(inf)=inf | E-03 (Line 411) | ○ |
| C-99 (UT-BCN-099) | Sinh(0)=0 | E-01 (Line 302), E-03 (Line 937) | ○ |
| C-100 (UT-BCN-100) | Sinh正の値 | E-03 (Line 944) | ○ |
| C-101 (UT-BCN-101) | Sinh(inf)=inf | E-03 (Line 952) | ○ |
| C-110 (UT-BCN-110) | Tanh(0)=0 | E-01 (Line 323) | ○ |
| C-111 (UT-BCN-111) | Tanh正の値 | E-01 (Line 323) | ○ |
| C-112 (UT-BCN-112) | Tanh(+inf)=1 | E-01委譲先の仕様 | ○ |
| C-113 (UT-BCN-113) | Tanh(-inf)=-1 | E-01委譲先の仕様 | ○ |

### 指数・対数関数テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 (UT-BCN-042) | Exp(0)=1 | E-01 (Line 116), E-03 (Lines 435) | ○ |
| C-43 (UT-BCN-043) | Exp(1)=e | E-03 (Line 442) | ○ |
| C-44 (UT-BCN-044) | Exp負の値 | E-03 (Line 426) | ○ |
| C-45 (UT-BCN-045) | Exp(inf)=inf | E-03 (Line 450) | ○ |
| C-46 (UT-BCN-046) | Exp(-inf)=0 | E-03 (Line 418) | ○ |
| C-57 (UT-BCN-057) | Log(1)=0 | E-01 (Line 187), E-03 (Line 535) | ○ |
| C-58 (UT-BCN-058) | Log(e)=1 | E-03 (Line 542) | ○ |
| C-59 (UT-BCN-059) | Log(0)=-inf | E-03 (Line 520) | ○ |
| C-60 (UT-BCN-060) | Log(負)=NaN | E-03 (Lines 511-517) | ○ |
| C-61 (UT-BCN-061) | Log(x,x)=1 | E-01 (Lines 195-218), E-03 (Line 559) | ○ |
| C-62 (UT-BCN-062) | Log任意底 | E-03 (Line 560) | ○ |
| C-63 (UT-BCN-063) | Log底1でNaN | E-01 (Lines 207-209) | ○ |
| C-64 (UT-BCN-064) | Log底0/infでNaN | E-01 (Lines 212-215) | ○ |
| C-65 (UT-BCN-065) | Log10(10)=1 | E-01 (Line 225), E-03 (Line 600) | ○ |
| C-66 (UT-BCN-066) | Log10(1)=0 | E-03 (Line 593) | ○ |
| C-67 (UT-BCN-067) | Log10(0)=-inf | E-03 (Line 578) | ○ |
| C-68 (UT-BCN-068) | Log10(負)=NaN | E-03 (Lines 569-575) | ○ |

### IEEERemainderテスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 (UT-BCN-051) | IEEERemainder基本計算 | E-01 (Lines 131-180), E-03 (Line 498) | ○ |
| C-52 (UT-BCN-052) | IEEERemainder割り切れる | E-03 (Line 499) | ○ |
| C-53 (UT-BCN-053) | IEEERemainder負の値 | E-03 (Line 507) | ○ |
| C-54 (UT-BCN-054) | IEEERemainder x=NaN | E-01 (Lines 133-136) | ○ |
| C-55 (UT-BCN-055) | IEEERemainder y=NaN | E-01 (Lines 138-141) | ○ |
| C-56 (UT-BCN-056) | IEEERemainder負のゼロ | E-01 (Lines 150-153) | ○ |

### Max/Minテスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 (UT-BCN-069) | Max正の値比較 | E-01 (Line 233), E-03 (Lines 632-633) | ○ |
| C-70 (UT-BCN-070) | Max正負比較 | E-03 (Lines 634-635) | ○ |
| C-71 (UT-BCN-071) | Max無限大比較 | E-03 (Lines 615-616) | ○ |
| C-72 (UT-BCN-072) | Max NaN処理 | E-03 (Lines 619-625) | ○ |
| C-73 (UT-BCN-073) | Min正の値比較 | E-01 (Line 241), E-03 (Lines 659-661) | ○ |
| C-74 (UT-BCN-074) | Min正負比較 | E-03 (Lines 660-662) | ○ |
| C-75 (UT-BCN-075) | Min無限大比較 | E-03 (Lines 642-643) | ○ |
| C-76 (UT-BCN-076) | Min NaN処理 | E-03 (Lines 646-652) | ○ |

### Powテスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 (UT-BCN-077) | Pow正の底と指数 | E-01 (Line 249), E-03 (Lines 798) | ○ |
| C-78 (UT-BCN-078) | Pow eの乗 | E-03 (Line 765) | ○ |
| C-79 (UT-BCN-079) | Pow 0乗=1 | E-03 (Lines 727-729, 756-758) | ○ |
| C-80 (UT-BCN-080) | Pow 0の正の乗 | E-03 (Lines 730-733) | ○ |
| C-81 (UT-BCN-081) | Pow 0の負の乗 | E-03 (Lines 722-726) | ○ |
| C-82 (UT-BCN-082) | Pow 負底非整数指数 | E-03 (Lines 678-686) | ○ |

### Roundテスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 (UT-BCN-083) | Round 1.4->1 | E-01 (Line 256), E-03 (Line 843) | ○ |
| C-84 (UT-BCN-084) | Round 1.5->2 | E-03 (Line 844) | ○ |
| C-85 (UT-BCN-085) | Round 2.5->2(偶数丸め) | E-03 テストデータより推測 | ○ |
| C-86 (UT-BCN-086) | Round 負の値 | E-03 (Line 848) | ○ |
| C-87 (UT-BCN-087) | Round桁指定 | E-01 (Line 264), E-03 (Lines 827-828) | ○ |
| C-88 (UT-BCN-088) | Round ToEvenモード | E-01 (Line 273), E-03 (Lines 823-828) | ○ |
| C-89 (UT-BCN-089) | Round AwayFromZeroモード | E-01 (Line 273), E-03 (Lines 830-835) | ○ |

### Signテスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 (UT-BCN-090) | Sign正の値 | E-01 (Line 288), E-03 (Line 874) | ○ |
| C-91 (UT-BCN-091) | Sign負の値 | E-03 (Line 873) | ○ |
| C-92 (UT-BCN-092) | Sign(0) | E-03 (Line 871) | ○ |
| C-93 (UT-BCN-093) | Sign(-0) | E-03 (Line 872) | ○ |
| C-94 (UT-BCN-094) | Sign(NaN)例外 | E-03 (Line 877) | ○ |

### Sqrtテスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 (UT-BCN-102) | Sqrt(4)=2 | E-01 (Line 309) | ○ |
| C-103 (UT-BCN-103) | Sqrt(1)=1 | E-03 (Line 983) | ○ |
| C-104 (UT-BCN-104) | Sqrt(0)=0 | E-03 (Line 976) | ○ |
| C-105 (UT-BCN-105) | Sqrt(負)=NaN | E-03 (Lines 959-973) | ○ |
| C-106 (UT-BCN-106) | Sqrt(inf)=inf | E-03 (Line 991) | ○ |

### Truncateテスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 (UT-BCN-114) | Truncate正の値 | E-01 (Line 330) | ○ |
| C-115 (UT-BCN-115) | Truncate負の値 | E-01 (Line 330) | ○ |
| C-116 (UT-BCN-116) | Truncate整数値 | E-01 (Line 330) | ○ |
| C-117 (UT-BCN-117) | Truncate(0) | E-01 (Line 330) | ○ |

### Privateメソッドテスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 (UT-BCN-118) | Int32BitsToSingle負のゼロ | E-01 (Lines 43-46) | △ |
| C-119 (UT-BCN-119) | IsNegative負の値 | E-01 (Lines 48-52) | △ |
| C-120 (UT-BCN-120) | IsNegative正の値 | E-01 (Lines 48-52) | △ |

## 4) 不足情報（Unknown / Missing）

### Privateメソッドのテスト
- **Int32BitsToSingle** および **IsNegative** はprivateメソッドのため、直接の単体テストは不可能
- これらは **IEEERemainder** 内部で使用されており、間接的にテストされる
- 候補：IEEERemainderのテストを通じた間接テスト / リフレクションを使用したテスト / InternalsVisibleTo属性の追加

### .NET Framework と .NET Core の挙動差異
- コードコメント（Lines 13-20）に記載されている通り、.NET FrameworkとCoreでMin/Maxの+0/-0の扱いが異なる
- 既存テストコード（E-03）では `#if NETFRAMEWORK` ディレクティブで条件分岐している

## 5) リスクフラグ（レビュー観点）

| リスク | 説明 | レベル |
|--------|------|--------|
| 浮動小数点精度 | 単精度浮動小数点数の計算では誤差が生じるため、許容誤差（CrossPlatformMachineEpsilon）を考慮したテストが必要 | 1: 中リスク |
| プラットフォーム依存 | .NET Framework向け実装はSystem.Mathへの委譲を行うため、doubleからfloatへのキャストで精度損失の可能性あり | 1: 中リスク |
| NaN/無限大処理 | IEEE 754-2008準拠のNaNペイロード保持など、特殊値の処理に注意が必要 | 1: 中リスク |
| privateメソッド | Int32BitsToSingle, IsNegativeは直接テスト不可 | 0: 低リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] テストケースが全publicメソッドをカバーしているか確認
- [ ] 各数学関数の正常系・異常系・境界値が網羅されているか確認
- [ ] NaN、無限大、ゼロ（+0/-0）の特殊ケースが含まれているか確認
- [ ] IEEERemainderのIEEE 754準拠動作がテストされているか確認
- [ ] 丸めモード（ToEven, AwayFromZero）のテストが含まれているか確認
- [ ] 浮動小数点精度を考慮した許容誤差が設定されているか確認
- [ ] プラットフォーム依存の挙動（.NET Framework vs .NET Core）が考慮されているか確認
