---
generated_at: 2026-01-30 16:35:00
metrics:
  claims_total: 45
  claims_with_evidence: 45
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Bcl.TimeProvider 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各項目を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：45 / 45、根拠なし：0
- 優先レビュー（高）
  1. **すべてのテストケースにソースコード根拠あり**
  2. **#if !NET 条件コンパイルにより、.NET 8以前の環境でのみ実行される実装が主な対象**
  3. **.NET 8以降ではTask.Delay等の標準APIに委譲されるため、テスト対象が変わる**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/Microsoft.Bcl.TimeProvider/src/System/Threading/Tasks/TimeProviderTaskExtensions.cs`
- E-02: `src/libraries/Microsoft.Bcl.TimeProvider/src/Microsoft.Bcl.TimeProvider.Forwards.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Delayメソッド関連 (UT-BTP-001 - UT-BTP-011, UT-BTP-043, UT-BTP-045)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TimeProvider.Systemでショートカット処理が行われる | E-01 L54-56 | ○ |
| C-02 | カスタムTimeProviderでCreateTimerが呼ばれる | E-01 L78-84 | ○ |
| C-03 | delay=TimeSpan.ZeroでTask.CompletedTaskが返る | E-01 L71-74 | ○ |
| C-04 | Timeout.InfiniteTimeSpanは許容される | E-01 L61 | ○ |
| C-05 | CancellationTokenでキャンセル可能 | E-01 L86-100 | ○ |
| C-06 | 事前キャンセル済みTokenで即座にFromCanceledが返る | E-01 L66-69 | ○ |
| C-07 | タイマー完了時にTimer.DisposeとRegistration.Disposeが呼ばれる | E-01 L82-83 | ○ |
| C-08 | timeProvider=nullでArgumentNullExceptionがスローされる | E-01 L59 | ○ |
| C-09 | 負のdelayでArgumentOutOfRangeExceptionがスローされる | E-01 L61-64 | ○ |
| C-10 | 最小正値(1tick)でも動作する | E-01 L71-74の条件分岐 | ○ |
| C-11 | 競合状態でリソースリーク防止処理がある | E-01 L110-114 | ○ |
| C-12 | CancellationToken.Noneがデフォルト値 | E-01 L49 | ○ |
| C-13 | ThreadPool.UnsafeQueueUserWorkItemで非同期キャンセル | E-01 L92-96 | ○ |

### WaitAsyncメソッド関連 (UT-BTP-012 - UT-BTP-025, UT-BTP-044)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | ContinueWithで完了が伝播される | E-01 L177-187 | ○ |
| C-15 | 完了済みTaskは即座に返される | E-01 L144-147 | ○ |
| C-16 | InfiniteTimeSpan+CancellationTokenなしで元Taskが返る | E-01 L149-152 | ○ |
| C-17 | タイムアウト時にTimeoutExceptionが設定される | E-01 L166-175 | ○ |
| C-18 | timeout=ZeroでFromException(TimeoutException)が返る | E-01 L159-161 | ○ |
| C-19 | CancellationTokenでキャンセル可能 | E-01 L189-197 | ○ |
| C-20 | 事前キャンセル済みTokenで即座にFromCanceledが返る | E-01 L154-157 | ○ |
| C-21 | Faulted状態のTaskの例外が伝播される | E-01 L181 | ○ |
| C-22 | Canceled状態のTaskのキャンセルが伝播される | E-01 L182 | ○ |
| C-23 | タイムアウト後にContinuationCancellationがキャンセルされる | E-01 L174 | ○ |
| C-24 | task=nullでArgumentNullExceptionがスローされる | E-01 L135 | ○ |
| C-25 | timeProvider=nullでArgumentNullExceptionがスローされる | E-01 L142 | ○ |
| C-26 | 負のtimeoutでArgumentOutOfRangeExceptionがスローされる | E-01 L137-140 | ○ |
| C-27 | 競合状態でリソースリーク防止処理がある | E-01 L200-204 | ○ |
| C-28 | CancellationToken.Noneがデフォルト値 | E-01 L130 | ○ |

### WaitAsync<TResult>メソッド関連 (UT-BTP-026 - UT-BTP-029)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | Task版WaitAsyncに委譲してResultを取得 | E-01 L224-228 | ○ |
| C-30 | タイムアウト時にTimeoutExceptionがスローされる | E-01 L226 | ○ |
| C-31 | キャンセル時にTaskCanceledExceptionがスローされる | E-01 L226 | ○ |
| C-32 | ConfigureAwait(false)が使用される | E-01 L226 | ○ |

### CreateCancellationTokenSourceメソッド関連 (UT-BTP-030 - UT-BTP-036)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | TimeProvider.Systemでショートカット処理が行われる | E-01 L259-261 | ○ |
| C-34 | カスタムTimeProviderでCreateTimerが呼ばれる | E-01 L266-273 | ○ |
| C-35 | Timeout.InfiniteTimeSpanでキャンセルされない | E-01 L254 | ○ |
| C-36 | Token.RegisterでタイマーDisposeが登録される | E-01 L275 | ○ |
| C-37 | ObjectDisposedExceptionが握りつぶされる | E-01 L272 | ○ |
| C-38 | timeProvider=nullでArgumentNullExceptionがスローされる | E-01 L252 | ○ |
| C-39 | 負のdelayでArgumentOutOfRangeExceptionがスローされる | E-01 L254-257 | ○ |

### 内部クラス関連 (UT-BTP-037 - UT-BTP-042)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | DelayState.CancellationTokenがコンストラクタで設定される | E-01 L18-21 | ○ |
| C-41 | DelayState.Timerプロパティが存在する | E-01 L23 | ○ |
| C-42 | DelayState.Registrationプロパティが存在する | E-01 L25 | ○ |
| C-43 | WaitAsyncStateがRunContinuationsAsynchronouslyで初期化される | E-01 L30 | ○ |
| C-44 | WaitAsyncState.ContinuationCancellationが初期化される | E-01 L35 | ○ |
| C-45 | WaitAsyncState.CancellationTokenがコンストラクタで設定される | E-01 L36 | ○ |

## 4) 不足情報（Unknown / Missing）
- 本モジュールは型転送（TypeForwarded）を含むため、`TimeProvider`クラスや`ITimer`インターフェース自体のテストはこのモジュールの責務外
  - 候補：`System.Private.CoreLib`モジュールでのテスト / `System.Runtime`モジュールでのテスト
- .NET 8以降の環境では標準APIに委譲されるため、`#if !NET`条件下のコードのみがテスト対象
  - テスト実行時のターゲットフレームワークに注意が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースにソースコード根拠あり
- 1: 中リスク - 条件コンパイル（`#if !NET`）により実行環境でテスト対象が変わる
- 1: 中リスク - 競合状態のテスト（UT-BTP-011, UT-BTP-025）は非決定的な動作を含む可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがすべてのpublicメソッドをカバーしているか確認
- [ ] 異常系テスト（ArgumentNullException, ArgumentOutOfRangeException）が各メソッドに存在するか確認
- [ ] 競合状態のテストケースが適切に設計されているか確認
- [ ] 内部クラス（DelayState, WaitAsyncState）のテストが`#if !NET`条件下でのみ有効であることを考慮
- [ ] テスト実行環境（ターゲットフレームワーク）の確認
