---
generated_at: 2026-01-30 15:45:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 単体テストケース一覧 根拠レポート: libraries-Microsoft.CSharp

## 概要

本レポートは、Microsoft.CSharpモジュールの単体テストケース一覧の根拠を示すものです。

## 対象モジュール

- **モジュール名**: libraries-Microsoft.CSharp
- **パス**: `src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/`
- **主要機能**: C# Dynamic Language Runtime (DLR) バインダー

## 分析対象ファイル

### 公開API (Publicクラス)

| ファイル | クラス | 根拠 |
|---------|--------|------|
| `Binder.cs` | `Microsoft.CSharp.RuntimeBinder.Binder` | 静的ファクトリクラス。BinaryOperation, UnaryOperation, Convert, GetMember, SetMember, InvokeMember, GetIndex, SetIndex, Invoke, InvokeConstructor, IsEventメソッドを提供 |
| `CSharpArgumentInfo.cs` | `Microsoft.CSharp.RuntimeBinder.CSharpArgumentInfo` | Createファクトリメソッドで引数情報を生成。CSharpArgumentInfoFlagsで引数の種類を指定 |
| `RuntimeBinderException.cs` | `Microsoft.CSharp.RuntimeBinder.RuntimeBinderException` | ランタイムバインド失敗時にスローされる例外。3つのコンストラクタオーバーロード |
| `RuntimeBinderInternalCompilerException.cs` | `Microsoft.CSharp.RuntimeBinder.RuntimeBinderInternalCompilerException` | 内部コンパイラエラー用例外。3つのコンストラクタオーバーロード |

### バインダー実装クラス

| ファイル | クラス | 根拠 |
|---------|--------|------|
| `CSharpBinaryOperationBinder.cs` | `CSharpBinaryOperationBinder` | DynamicMetaObjectBinderを継承。FallbackBinaryOperationメソッドでバイナリ演算をバインド |
| `CSharpUnaryOperationBinder.cs` | `CSharpUnaryOperationBinder` | DynamicMetaObjectBinderを継承。FallbackUnaryOperationメソッドで単項演算をバインド |
| `CSharpConvertBinder.cs` | `CSharpConvertBinder` | ConvertBinderを継承。FallbackConvertメソッドで型変換をバインド |
| `CSharpGetMemberBinder.cs` | `CSharpGetMemberBinder` | GetMemberBinderを継承。FallbackGetMemberメソッドでメンバー取得をバインド |
| `CSharpSetMemberBinder.cs` | `CSharpSetMemberBinder` | SetMemberBinderを継承。FallbackSetMemberメソッドでメンバー設定をバインド |
| `CSharpInvokeMemberBinder.cs` | `CSharpInvokeMemberBinder` | InvokeMemberBinderを継承。FallbackInvokeMemberメソッドでメソッド呼び出しをバインド |
| `CSharpGetIndexBinder.cs` | `CSharpGetIndexBinder` | GetIndexBinderを継承。FallbackGetIndexメソッドでインデクサ取得をバインド |
| `CSharpSetIndexBinder.cs` | `CSharpSetIndexBinder` | SetIndexBinderを継承。FallbackSetIndexメソッドでインデクサ設定をバインド |
| `CSharpInvokeBinder.cs` | `CSharpInvokeBinder` | InvokeBinderを継承。FallbackInvokeメソッドでデリゲート呼び出しをバインド |
| `CSharpIsEventBinder.cs` | `CSharpIsEventBinder` | DynamicMetaObjectBinderを継承。FallbackIsEventメソッドでイベント判定をバインド |

### 内部実装クラス

| ファイル | クラス | 根拠 |
|---------|--------|------|
| `RuntimeBinder.cs` | `RuntimeBinder` | ICSharpBinderインターフェースを使用してバインド操作を実行。Bindメソッドがメインエントリポイント |
| `Semantics/ExpressionBinder.cs` | `ExpressionBinder` | 式のセマンティック解析を実行。BindAssignment, BindArrayIndexCore, BindToMethod, BindToField, BindToPropertyなどのメソッド |
| `Semantics/SymbolTable.cs` | `SymbolTable` | 型情報のシンボルテーブル管理。PopulateSymbolTableWithName, LookupMember, AddConversionsForType, GetCTypeFromTypeなどのメソッド |
| `BinderHelper.cs` | `BinderHelper` | バインダーのヘルパーメソッド。ToArgumentInfoArrayなど |
| `DynamicDebuggerProxy.cs` | `DynamicDebuggerProxy` | デバッガ用プロキシクラス |

## テストケース根拠詳細

### UT-MCS-001 ~ UT-MCS-028: Binderクラスのファクトリメソッド

**根拠ファイル**: `src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/Binder.cs`

```csharp
public static class Binder
{
    public static CallSiteBinder BinaryOperation(
        CSharpBinderFlags flags,
        ExpressionType operation,
        Type? context,
        IEnumerable<CSharpArgumentInfo>? argumentInfo)

    public static CallSiteBinder UnaryOperation(
        CSharpBinderFlags flags,
        ExpressionType operation,
        Type? context,
        IEnumerable<CSharpArgumentInfo>? argumentInfo)

    public static CallSiteBinder Convert(
        CSharpBinderFlags flags,
        Type type,
        Type? context)

    // ... その他のメソッド
}
```

各ファクトリメソッドに対して、正常系・異常系・境界値テストを設計。

### UT-MCS-029 ~ UT-MCS-034: CSharpArgumentInfoクラス

**根拠ファイル**: `src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/CSharpArgumentInfo.cs`

```csharp
public sealed class CSharpArgumentInfo
{
    public static CSharpArgumentInfo Create(CSharpArgumentInfoFlags flags, string? name)
    {
        return new CSharpArgumentInfo(flags, name);
    }
}
```

Createメソッドの各フラグ組み合わせに対するテストケースを設計。

### UT-MCS-035 ~ UT-MCS-040: 例外クラス

**根拠ファイル**:
- `src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/RuntimeBinderException.cs`
- `src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/RuntimeBinderInternalCompilerException.cs`

```csharp
public class RuntimeBinderException : Exception
{
    public RuntimeBinderException() : base() { }
    public RuntimeBinderException(string? message) : base(message) { }
    public RuntimeBinderException(string? message, Exception? innerException) : base(message, innerException) { }
}
```

各コンストラクタオーバーロードに対するテストケースを設計。

### UT-MCS-041 ~ UT-MCS-072: バインダー実装クラス

**根拠ファイル**: 各バインダーファイル (`CSharp*Binder.cs`)

各バインダークラスのFallback*メソッドとプロパティに対するテストケースを設計。

例（CSharpBinaryOperationBinder.cs）:
```csharp
internal sealed class CSharpBinaryOperationBinder : BinaryOperationBinder, ICSharpBinder
{
    public override DynamicMetaObject FallbackBinaryOperation(
        DynamicMetaObject target,
        DynamicMetaObject arg,
        DynamicMetaObject? errorSuggestion)

    public override ExpressionType Operation { get; }
}
```

### UT-MCS-073 ~ UT-MCS-075: RuntimeBinderクラス

**根拠ファイル**: `src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/RuntimeBinder.cs`

```csharp
internal sealed class RuntimeBinder
{
    internal Expression Bind(
        ICSharpBinder payload,
        Expression[] parameters,
        DynamicMetaObject[] args,
        out DynamicMetaObject deferredBinding)
}
```

### UT-MCS-076 ~ UT-MCS-085: ExpressionBinderクラス

**根拠ファイル**: `src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/Semantics/ExpressionBinder.cs`

主要なバインドメソッド:
- `BindAssignment`: 代入式のバインド
- `BindArrayIndexCore`: 配列インデックスのバインド
- `BindToMethod`: メソッド呼び出しのバインド
- `BindToField`: フィールドアクセスのバインド
- `BindToProperty`: プロパティアクセスのバインド

### UT-MCS-086 ~ UT-MCS-093: SymbolTableクラス

**根拠ファイル**: `src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/Semantics/SymbolTable.cs`

主要なメソッド:
- `PopulateSymbolTableWithName`: シンボルテーブルへの型登録
- `LookupMember`: メンバーの検索
- `AddConversionsForType`: 変換演算子の追加
- `GetCTypeFromType`: System.TypeからCTypeへの変換

### UT-MCS-094 ~ UT-MCS-100: ヘルパーおよび追加テスト

**根拠ファイル**:
- `src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/BinderHelper.cs`
- `src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/DynamicDebuggerProxy.cs`

## 根拠なしのテストケース

| テストID | 理由 |
|----------|------|
| UT-MCS-096 | DynamicDebuggerProxyは内部実装詳細であり、公開APIではないため直接的なソースコード根拠が限定的 |
| UT-MCS-097 | DynamicDebuggerProxyのItemsプロパティは動的に生成されるため、詳細な仕様確認が困難 |

## テスト観点カバレッジ

| 観点 | テストケース数 | カバー率 |
|------|----------------|----------|
| 正常系 | 62 | 62% |
| 異常系 | 28 | 28% |
| 境界値 | 10 | 10% |

## 優先度分布

| 優先度 | テストケース数 |
|--------|----------------|
| 高 | 75 |
| 中 | 22 |
| 低 | 3 |

## 推奨事項

1. **統合テストの追加**: RuntimeBinderの実際のバインド処理は複雑な状態を持つため、単体テストに加えて統合テストを推奨
2. **エラーメッセージの検証**: RuntimeBinderExceptionのエラーメッセージ内容の検証テストを追加することを推奨
3. **パフォーマンステスト**: SymbolTableのキャッシュ機構やバインダーのキャッシュ動作のパフォーマンステストを推奨
4. **境界値テストの拡充**: 型変換における限界ケース（非常に大きな数値、特殊な文字列など）のテストを追加することを推奨

## 結論

本テストケース一覧は、Microsoft.CSharpモジュールの主要な公開APIおよび内部実装クラスを網羅的にカバーしています。信頼度98%は、ほぼすべてのテストケースがソースコードの直接的な根拠に基づいていることを示しています。
