---
generated_at: 2026-01-30 16:35:00
metrics:
  claims_total: 175
  claims_with_evidence: 175
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Caching.Abstractions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：175 / 175、根拠なし：0
- 優先レビュー（高）
  1. **バリデーションロジック（UT-MCA-004～008, 016, 020～024）**：ArgumentOutOfRangeExceptionのスロー条件
  2. **CacheExtensions（UT-MCA-027～047）**：IMemoryCacheの拡張メソッド群
  3. **DistributedCacheExtensions（UT-MCA-078～095）**：IDistributedCacheの拡張メソッド群

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/MemoryCacheEntryOptions.cs`
- E-02: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/DistributedCacheEntryOptions.cs`
- E-03: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/MemoryCacheExtensions.cs`
- E-04: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/DistributedCacheExtensions.cs`
- E-05: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/CacheEntryExtensions.cs`
- E-06: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/MemoryCacheEntryExtensions.cs`
- E-07: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/DistributedCacheEntryExtensions.cs`
- E-08: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/IMemoryCache.cs`
- E-09: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/ICacheEntry.cs`
- E-10: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/IDistributedCache.cs`
- E-11: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/IBufferDistributedCache.cs`
- E-12: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/EvictionReason.cs`
- E-13: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/CacheItemPriority.cs`
- E-14: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/PostEvictionCallbackRegistration.cs`
- E-15: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/PostEvictionDelegate.cs`
- E-16: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/MemoryCacheStatistics.cs`
- E-17: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Hybrid/HybridCache.cs`
- E-18: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Hybrid/HybridCacheEntryOptions.cs`
- E-19: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Hybrid/HybridCacheEntryFlags.cs`
- E-20: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Hybrid/IHybridCacheSerializer.cs`
- E-21: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Hybrid/IHybridCacheSerializerFactory.cs`
- E-22: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Internal/SystemClock.cs`
- E-23: `src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Internal/ISystemClock.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### MemoryCacheEntryOptions（UT-MCA-001～016）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbsoluteExpiration の get/set が動作すること | E-01 L25-35 | ○ |
| C-02 | AbsoluteExpiration に null を設定できること | E-01 L25-35 | ○ |
| C-03 | AbsoluteExpirationRelativeToNow の get/set が動作すること | E-01 L40-58 | ○ |
| C-04 | AbsoluteExpirationRelativeToNow に 0 以下で例外 | E-01 L48-54 `if (value <= TimeSpan.Zero) throw` | ○ |
| C-05 | AbsoluteExpirationRelativeToNow に負値で例外 | E-01 L48-54 | ○ |
| C-06 | SlidingExpiration の get/set が動作すること | E-01 L64-81 | ○ |
| C-07 | SlidingExpiration に 0 以下で例外 | E-01 L72-78 `if (value <= TimeSpan.Zero) throw` | ○ |
| C-08 | SlidingExpiration に負値で例外 | E-01 L72-78 | ○ |
| C-09 | ExpirationTokens が遅延初期化されること | E-01 L86 `_expirationTokens ??= []` | ○ |
| C-10 | ExpirationTokens が同一インスタンスを返すこと | E-01 L86 | ○ |
| C-11 | PostEvictionCallbacks が遅延初期化されること | E-01 L93 `_postEvictionCallbacks ??= []` | ○ |
| C-12 | Priority の get/set が動作すること | E-01 L101 | ○ |
| C-13 | Priority のデフォルトが Normal であること | E-01 L101 `= CacheItemPriority.Normal` | ○ |
| C-14 | Size の get/set が動作すること | E-01 L106-118 | ○ |
| C-15 | Size に 0 を設定できること | E-01 L111 `if (value < 0)` | ○ |
| C-16 | Size に負値で例外 | E-01 L111-114 | ○ |

### DistributedCacheEntryOptions（UT-MCA-017～026）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | AbsoluteExpiration の get/set が動作すること | E-02 L24-28 | ○ |
| C-18 | AbsoluteExpiration に null を設定できること | E-02 L26-27 | ○ |
| C-19 | AbsoluteExpirationRelativeToNow の get/set が動作すること | E-02 L33-48 | ○ |
| C-20 | AbsoluteExpirationRelativeToNow に 0 以下で例外 | E-02 L38-44 | ○ |
| C-21 | AbsoluteExpirationRelativeToNow に負値で例外 | E-02 L38-44 | ○ |
| C-22 | SlidingExpiration の get/set が動作すること | E-02 L54-68 | ○ |
| C-23 | SlidingExpiration に 0 以下で例外 | E-02 L59-65 | ○ |
| C-24 | SlidingExpiration に負値で例外 | E-02 L59-65 | ○ |
| C-25 | Freeze が正常に実行できること | E-02 L70-74 | ○ |
| C-26 | Freeze 後の変更で例外 | E-02 L78-86 `if (_frozen) ThrowFrozen()` | ○ |

### CacheExtensions（UT-MCA-027～047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | Get でキャッシュ値が取得できること | E-03 L21-25 | ○ |
| C-28 | Get で存在しないキーは null | E-03 L23-24 | ○ |
| C-29 | Get<TItem> で型付き値が取得できること | E-03 L34-38 | ○ |
| C-30 | Get<TItem> で存在しないキーは default | E-03 L37 | ○ |
| C-31 | Get<TItem> で null 値は default | E-03 L37 `value is null ? default` | ○ |
| C-32 | TryGetValue<TItem> でキャッシュ値が取得できること | E-03 L48-67 | ○ |
| C-33 | TryGetValue<TItem> で存在しないキーは false | E-03 L65-66 | ○ |
| C-34 | TryGetValue<TItem> で null 値は true | E-03 L52-56 | ○ |
| C-35 | TryGetValue<TItem> で型不一致は false | E-03 L58-62 | ○ |
| C-36 | Set<TItem> で値が設定できること | E-03 L77-84 | ○ |
| C-37 | Set<TItem> (DateTimeOffset) で設定できること | E-03 L95-102 | ○ |
| C-38 | Set<TItem> (TimeSpan) で設定できること | E-03 L113-120 | ○ |
| C-39 | Set<TItem> (IChangeToken) で設定できること | E-03 L131-138 | ○ |
| C-40 | Set<TItem> (MemoryCacheEntryOptions) で設定できること | E-03 L149-160 | ○ |
| C-41 | Set<TItem> で null オプションでも動作 | E-03 L152-155 | ○ |
| C-42 | GetOrCreate でキャッシュミス時にファクトリ呼出 | E-03 L170-200 | ○ |
| C-43 | GetOrCreate でキャッシュヒット時はファクトリ未呼出 | E-03 L186 | ○ |
| C-44 | GetOrCreate (options) で動作すること | E-03 L184-200 | ○ |
| C-45 | GetOrCreateAsync でキャッシュミス時にファクトリ呼出 | E-03 L210-240 | ○ |
| C-46 | GetOrCreateAsync でキャッシュヒット時はファクトリ未呼出 | E-03 L226 | ○ |
| C-47 | GetOrCreateAsync (options) で動作すること | E-03 L224-240 | ○ |

### CacheEntryExtensions（UT-MCA-048～063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | SetPriority でチェーン可能 | E-05 L21-27 | ○ |
| C-49 | AddExpirationToken でトークン追加 | E-05 L35-43 | ○ |
| C-50 | AddExpirationToken で null 例外 | E-05 L39 `ArgumentNullException.ThrowIfNull` | ○ |
| C-51 | SetAbsoluteExpiration (TimeSpan) で設定 | E-05 L51-57 | ○ |
| C-52 | SetAbsoluteExpiration (DateTimeOffset) で設定 | E-05 L65-71 | ○ |
| C-53 | SetSlidingExpiration で設定 | E-05 L80-86 | ○ |
| C-54 | RegisterPostEvictionCallback でコールバック登録 | E-05 L94-117 | ○ |
| C-55 | RegisterPostEvictionCallback で null 例外 | E-05 L109 `ArgumentNullException.ThrowIfNull` | ○ |
| C-56 | RegisterPostEvictionCallback (state) で状態付き登録 | E-05 L104-117 | ○ |
| C-57 | SetValue で値設定 | E-05 L125-131 | ○ |
| C-58 | SetSize でサイズ設定 | E-05 L139-150 | ○ |
| C-59 | SetSize で 0 設定可 | E-05 L143 `if (size < 0)` | ○ |
| C-60 | SetSize で負値例外 | E-05 L143-146 | ○ |
| C-61 | SetOptions でオプション適用 | E-05 L158-188 | ○ |
| C-62 | SetOptions で null 例外 | E-05 L160 | ○ |
| C-63 | SetOptions で null コールバック例外 | E-05 L181-183, L191-196 | ○ |

### MemoryCacheEntryExtensions（UT-MCA-064～074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | SetPriority でチェーン可能 | E-06 L20-26 | ○ |
| C-65 | SetSize でサイズ設定 | E-06 L34-45 | ○ |
| C-66 | SetSize で負値例外 | E-06 L38-41 | ○ |
| C-67 | AddExpirationToken でトークン追加 | E-06 L53-61 | ○ |
| C-68 | AddExpirationToken で null 例外 | E-06 L57 | ○ |
| C-69 | SetAbsoluteExpiration (TimeSpan) で設定 | E-06 L69-75 | ○ |
| C-70 | SetAbsoluteExpiration (DateTimeOffset) で設定 | E-06 L83-89 | ○ |
| C-71 | SetSlidingExpiration で設定 | E-06 L98-104 | ○ |
| C-72 | RegisterPostEvictionCallback でコールバック登録 | E-06 L112-119 | ○ |
| C-73 | RegisterPostEvictionCallback で null 例外 | E-06 L116 | ○ |
| C-74 | RegisterPostEvictionCallback (state) で状態付き登録 | E-06 L128-141 | ○ |

### DistributedCacheEntryExtensions（UT-MCA-075～077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | SetAbsoluteExpiration (TimeSpan) で設定 | E-07 L18-24 | ○ |
| C-76 | SetAbsoluteExpiration (DateTimeOffset) で設定 | E-07 L31-37 | ○ |
| C-77 | SetSlidingExpiration で設定 | E-07 L45-51 | ○ |

### DistributedCacheExtensions（UT-MCA-078～095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | Set で byte[] 設定 | E-04 L25-31 | ○ |
| C-79 | Set で null キー例外 | E-04 L27 | ○ |
| C-80 | Set で null 値例外 | E-04 L28 | ○ |
| C-81 | SetAsync で byte[] 設定 | E-04 L42-48 | ○ |
| C-82 | SetAsync で null キー例外 | E-04 L44 | ○ |
| C-83 | SetAsync で null 値例外 | E-04 L45 | ○ |
| C-84 | SetString で文字列設定 | E-04 L57-60 | ○ |
| C-85 | SetString (options) で設定 | E-04 L70-76 | ○ |
| C-86 | SetString で null キー例外 | E-04 L72 | ○ |
| C-87 | SetString で null 値例外 | E-04 L73 | ○ |
| C-88 | SetStringAsync で文字列設定 | E-04 L87-90 | ○ |
| C-89 | SetStringAsync (options) で設定 | E-04 L102-108 | ○ |
| C-90 | SetStringAsync で null キー例外 | E-04 L104 | ○ |
| C-91 | SetStringAsync で null 値例外 | E-04 L105 | ○ |
| C-92 | GetString で文字列取得 | E-04 L116-124 | ○ |
| C-93 | GetString で存在しないキーは null | E-04 L119-122 | ○ |
| C-94 | GetStringAsync で文字列取得 | E-04 L133-141 | ○ |
| C-95 | GetStringAsync で存在しないキーは null | E-04 L136-138 | ○ |

### MemoryCacheStatistics（UT-MCA-096～101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | コンストラクタでインスタンス生成 | E-16 L16 | ○ |
| C-97 | CurrentEntryCount の init | E-16 L21 | ○ |
| C-98 | CurrentEstimatedSize の init | E-16 L27 | ○ |
| C-99 | CurrentEstimatedSize に null 設定可 | E-16 L27 `long?` | ○ |
| C-100 | TotalMisses の init | E-16 L32 | ○ |
| C-101 | TotalHits の init | E-16 L37 | ○ |

### PostEvictionCallbackRegistration（UT-MCA-102～104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | EvictionCallback の get/set | E-14 L14 | ○ |
| C-103 | State の get/set | E-14 L19 | ○ |
| C-104 | State に null 設定可 | E-14 L19 `object?` | ○ |

### CacheItemPriority（UT-MCA-105～108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | Low = 0 | E-13 L15 | ○ |
| C-106 | Normal = 1 | E-13 L20 | ○ |
| C-107 | High = 2 | E-13 L25 | ○ |
| C-108 | NeverRemove = 3 | E-13 L30 | ○ |

### EvictionReason（UT-MCA-109～114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | None = 0 | E-12 L14 | ○ |
| C-110 | Removed = 1 | E-12 L19 | ○ |
| C-111 | Replaced = 2 | E-12 L24 | ○ |
| C-112 | Expired = 3 | E-12 L29 | ○ |
| C-113 | TokenExpired = 4 | E-12 L34 | ○ |
| C-114 | Capacity = 5 | E-12 L39 | ○ |

### HybridCacheEntryOptions（UT-MCA-115～123）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | Expiration の init | E-18 L20 | ○ |
| C-116 | Expiration に null 設定可 | E-18 L20 `TimeSpan?` | ○ |
| C-117 | LocalCacheExpiration の init | E-18 L26 | ○ |
| C-118 | LocalCacheExpiration に null 設定可 | E-18 L26 `TimeSpan?` | ○ |
| C-119 | Flags の init | E-18 L31 | ○ |
| C-120 | Flags に null 設定可 | E-18 L31 `HybridCacheEntryFlags?` | ○ |
| C-121 | ToDistributedCacheEntryOptions で変換 | E-18 L35-36 | ○ |
| C-122 | ToDistributedCacheEntryOptions で null 時は null | E-18 L36 `Expiration is null ? null` | ○ |
| C-123 | ToDistributedCacheEntryOptions でメモ化 | E-18 L36 `_dc ??=` | ○ |

### HybridCacheEntryFlags（UT-MCA-124～133）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | None = 0 | E-19 L17 | ○ |
| C-125 | DisableLocalCacheRead = 1 | E-19 L21 | ○ |
| C-126 | DisableLocalCacheWrite = 2 | E-19 L25 | ○ |
| C-127 | DisableLocalCache = 3 | E-19 L29 | ○ |
| C-128 | DisableDistributedCacheRead = 4 | E-19 L33 | ○ |
| C-129 | DisableDistributedCacheWrite = 8 | E-19 L37 | ○ |
| C-130 | DisableDistributedCache = 12 | E-19 L41 | ○ |
| C-131 | DisableUnderlyingData = 16 | E-19 L45 | ○ |
| C-132 | DisableCompression = 32 | E-19 L49 | ○ |
| C-133 | 複数フラグの組み合わせ | E-19 L11 `[Flags]` | ○ |

### HybridCache（UT-MCA-134～141）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-134 | RemoveAsync(IEnumerable) 空コレクション | E-17 L175 | ○ |
| C-135 | RemoveAsync(IEnumerable) null | E-17 L175 | ○ |
| C-136 | RemoveAsync(IEnumerable) 1 要素最適化 | E-17 L176 | ○ |
| C-137 | RemoveAsync(IEnumerable) 複数要素 | E-17 L177-187 | ○ |
| C-138 | RemoveByTagAsync(IEnumerable) 空コレクション | E-17 L199 | ○ |
| C-139 | RemoveByTagAsync(IEnumerable) null | E-17 L199 | ○ |
| C-140 | RemoveByTagAsync(IEnumerable) 1 要素最適化 | E-17 L200 | ○ |
| C-141 | RemoveByTagAsync(IEnumerable) 複数要素 | E-17 L201-211 | ○ |

### SystemClock（UT-MCA-142～143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-142 | UtcNow で現在時刻取得 | E-22 L16-22 | ○ |
| C-143 | UtcNow で時間進行 | E-22 L20 `DateTimeOffset.UtcNow` | ○ |

### インターフェース契約（UT-MCA-144～175）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | IMemoryCache.TryGetValue (存在) | E-08 L19 | ○ |
| C-145 | IMemoryCache.TryGetValue (非存在) | E-08 L19 | ○ |
| C-146 | IMemoryCache.CreateEntry | E-08 L26 | ○ |
| C-147 | IMemoryCache.Remove | E-08 L32 | ○ |
| C-148 | IMemoryCache.GetCurrentStatistics | E-08 L39 | ○ |
| C-149 | ICacheEntry.Key | E-09 L19 | ○ |
| C-150 | ICacheEntry.Value | E-09 L24 | ○ |
| C-151 | ICacheEntry.AbsoluteExpiration | E-09 L29 | ○ |
| C-152 | ICacheEntry.AbsoluteExpirationRelativeToNow | E-09 L34 | ○ |
| C-153 | ICacheEntry.SlidingExpiration | E-09 L40 | ○ |
| C-154 | ICacheEntry.ExpirationTokens | E-09 L45 | ○ |
| C-155 | ICacheEntry.PostEvictionCallbacks | E-09 L50 | ○ |
| C-156 | ICacheEntry.Priority | E-09 L56 | ○ |
| C-157 | ICacheEntry.Size | E-09 L61 | ○ |
| C-158 | IDistributedCache.Get (存在) | E-10 L19 | ○ |
| C-159 | IDistributedCache.Get (非存在) | E-10 L19 | ○ |
| C-160 | IDistributedCache.GetAsync | E-10 L27 | ○ |
| C-161 | IDistributedCache.Set | E-10 L35 | ○ |
| C-162 | IDistributedCache.SetAsync | E-10 L45 | ○ |
| C-163 | IDistributedCache.Refresh | E-10 L51 | ○ |
| C-164 | IDistributedCache.RefreshAsync | E-10 L59 | ○ |
| C-165 | IDistributedCache.Remove | E-10 L65 | ○ |
| C-166 | IDistributedCache.RemoveAsync | E-10 L73 | ○ |
| C-167 | IBufferDistributedCache.TryGet (存在) | E-11 L22 | ○ |
| C-168 | IBufferDistributedCache.TryGet (非存在) | E-11 L22 | ○ |
| C-169 | IBufferDistributedCache.TryGetAsync | E-11 L32 | ○ |
| C-170 | IBufferDistributedCache.Set (ReadOnlySequence) | E-11 L41 | ○ |
| C-171 | IBufferDistributedCache.SetAsync (ReadOnlySequence) | E-11 L51 | ○ |
| C-172 | IHybridCacheSerializer.Deserialize | E-20 L17 | ○ |
| C-173 | IHybridCacheSerializer.Serialize | E-20 L22 | ○ |
| C-174 | IHybridCacheSerializerFactory.TryCreateSerializer (成功) | E-21 L19 | ○ |
| C-175 | IHybridCacheSerializerFactory.TryCreateSerializer (失敗) | E-21 L19 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースに対してソースコードから根拠を確認済み）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて作成されており、根拠が明確

注意点：
- インターフェース（IMemoryCache, ICacheEntry, IDistributedCache, IBufferDistributedCache, IHybridCacheSerializer, IHybridCacheSerializerFactory）のテストはモック実装が必要
- HybridCache は抽象クラスのため、具体的な実装クラスでのテストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションロジック（ArgumentOutOfRangeException, ArgumentNullException）のテストケースが網羅されているか
- [ ] 正常系・異常系・境界値のテストケースがバランスよく含まれているか
- [ ] インターフェース契約のテストケースが実装検証に適切か
- [ ] 列挙型の値検証が正しいか（実際のソースコードの値と一致するか）
- [ ] 拡張メソッドのチェーン呼び出しが正しくテストされているか
- [ ] 非同期メソッドのテストケースが適切に含まれているか
- [ ] Freeze機能（DistributedCacheEntryOptions）のイミュータブル状態テストが適切か
- [ ] HybridCache の仮想メソッドのデフォルト実装テストが適切か
