---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 115
  claims_with_evidence: 115
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Caching.Memory 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド・プロパティ・コンストラクタなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実装コードと矛盾していないか
3. **網羅性**：テスト対象のクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：115 / 115、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Caching.Memory/src/MemoryCache.cs`
- E-02: `src/libraries/Microsoft.Extensions.Caching.Memory/src/CacheEntry.cs`
- E-03: `src/libraries/Microsoft.Extensions.Caching.Memory/src/CacheEntry.CacheEntryTokens.cs`
- E-04: `src/libraries/Microsoft.Extensions.Caching.Memory/src/MemoryCacheOptions.cs`
- E-05: `src/libraries/Microsoft.Extensions.Caching.Memory/src/MemoryDistributedCache.cs`
- E-06: `src/libraries/Microsoft.Extensions.Caching.Memory/src/MemoryDistributedCacheOptions.cs`
- E-07: `src/libraries/Microsoft.Extensions.Caching.Memory/src/MemoryCacheServiceCollectionExtensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### MemoryCacheクラス（UT-MCM-001 〜 UT-MCM-043）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MemoryCache(IOptions<MemoryCacheOptions>)コンストラクタの正常系テスト | E-01 L42-43 | ○ |
| C-02 | optionsAccessorがnullの場合ArgumentNullException | E-01 L52 `ArgumentNullException.ThrowIfNull(optionsAccessor)` | ○ |
| C-03 | MemoryCache(IOptions<MemoryCacheOptions>, ILoggerFactory)コンストラクタの正常系テスト | E-01 L50-68 | ○ |
| C-04 | loggerFactoryがnullの場合ArgumentNullException | E-01 L53 `ArgumentNullException.ThrowIfNull(loggerFactory)` | ○ |
| C-05 | Countプロパティの正常系テスト | E-01 L80 `public int Count => _coherentState.Count` | ○ |
| C-06 | 空のキャッシュでCount=0 | E-01 L80, E-01 L780 | ○ |
| C-07 | Keysプロパティの正常系テスト | E-01 L85-86 | ○ |
| C-08 | 空のキャッシュでKeys空 | E-01 L768-778 | ○ |
| C-09 | CreateEntry(object)の正常系テスト | E-01 L99-105 | ○ |
| C-10 | CreateEntryでkeyがnullの場合ArgumentNullException | E-01 L102 `ArgumentNullException.ThrowIfNull(key)` | ○ |
| C-11 | CreateEntryでDispose後ObjectDisposedException | E-01 L101 `CheckDisposed()`, L687-696 | ○ |
| C-12 | TryGetValue(object, out object)正常系 | E-01 L205-213 | ○ |
| C-13 | TryGetValueで存在しないキーでfalse | E-01 L264-316 `PostProcessTryGetValue` | ○ |
| C-14 | TryGetValueでkeyがnullの場合ArgumentNullException | E-01 L207 `ArgumentNullException.ThrowIfNull(key)` | ○ |
| C-15 | TryGetValueでDispose後ObjectDisposedException | E-01 L209 `CheckDisposed()` | ○ |
| C-16 | 期限切れエントリがfalseを返す | E-01 L272-273 `CheckExpired` | ○ |
| C-17 | TryGetValue(ReadOnlySpan<char>, out object) | E-01 L224-230 | ○ |
| C-18 | TryGetValue<TItem>(ReadOnlySpan<char>, out TItem) | E-01 L240-261 | ○ |
| C-19 | Remove(object)正常系 | E-01 L319-339 | ○ |
| C-20 | 存在しないキーを削除しても例外なし | E-01 L327 `if (coherentState.TryRemove...)` | ○ |
| C-21 | RemoveでkeyがnullArgumentNullException | E-01 L321 `ArgumentNullException.ThrowIfNull(key)` | ○ |
| C-22 | RemoveでDispose後ObjectDisposedException | E-01 L323 `CheckDisposed()` | ○ |
| C-23 | 削除時にEvictionCallback呼び出し | E-01 L334-335 | ○ |
| C-24 | Clear()全削除 | E-01 L344-354 | ○ |
| C-25 | Clear時にEvictionCallback呼び出し | E-01 L349-353 | ○ |
| C-26 | ClearでDispose後ObjectDisposedException | E-01 L346 `CheckDisposed()` | ○ |
| C-27 | GetCurrentStatistics()正常系 | E-01 L360-375 | ○ |
| C-28 | TrackStatistics=falseでnull | E-01 L362 `if (_allStats is not null)` | ○ |
| C-29 | TotalHitsカウント | E-01 L286-292 | ○ |
| C-30 | TotalMissesカウント | E-01 L307-313 | ○ |
| C-31 | CurrentEntryCount | E-01 L369 | ○ |
| C-32 | CurrentEstimatedSize | E-01 L370 | ○ |
| C-33 | Compact(double)正常系 | E-01 L575-580 | ○ |
| C-34 | LRU順削除 | E-01 L648 `priorityEntries.Sort` | ○ |
| C-35 | Priority.NeverRemove保持 | E-01 L613-614 `case CacheItemPriority.NeverRemove: break` | ○ |
| C-36 | Priority.Low先削除 | E-01 L621-623 | ○ |
| C-37 | percentage=0で削除なし | E-01 L638-641 | ○ |
| C-38 | Dispose()正常系 | E-01 L663-685 | ○ |
| C-39 | 複数回Dispose冪等 | E-01 L675 `if (!_disposed)` | ○ |
| C-40 | SizeLimit設定時Size未設定でInvalidOperationException | E-01 L115-118 | ○ |
| C-41 | 既存エントリ置換 | E-01 L138-141, L154-170 | ○ |
| C-42 | 置換時旧エントリEvictionCallback | E-01 L140, L188 | ○ |
| C-43 | SizeLimit超過でCapacity期限切れ | E-01 L192-194 | ○ |

### CacheEntryクラス（UT-MCM-044 〜 UT-MCM-075）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | CacheEntry(object, MemoryCache)コンストラクタ | E-02 L38-51 | ○ |
| C-45 | keyがnullでArgumentNullException | E-02 L40 `ArgumentNullException.ThrowIfNull(key)` | ○ |
| C-46 | memoryCacheがnullでArgumentNullException | E-02 L41 `ArgumentNullException.ThrowIfNull(memoryCache)` | ○ |
| C-47 | AbsoluteExpiration設定・取得 | E-02 L66-94 | ○ |
| C-48 | AbsoluteExpiration null設定 | E-02 L78-82 | ○ |
| C-49 | AbsoluteExpirationRelativeToNow設定・取得 | E-02 L98-116 | ○ |
| C-50 | AbsoluteExpirationRelativeToNow 0以下で例外 | E-02 L106-112 | ○ |
| C-51 | AbsoluteExpirationRelativeToNow 負値で例外 | E-02 L106-112 | ○ |
| C-52 | SlidingExpiration設定・取得 | E-02 L122-137 | ○ |
| C-53 | SlidingExpiration 0以下で例外 | E-02 L127-133 | ○ |
| C-54 | SlidingExpiration 負値で例外 | E-02 L127-133 | ○ |
| C-55 | Size設定・取得 | E-02 L159-171 | ○ |
| C-56 | Size負値で例外 | E-02 L164-167 | ○ |
| C-57 | Size null設定 | E-02 L169 | ○ |
| C-58 | Priority設定・取得 | E-02 L155 | ○ |
| C-59 | PriorityデフォルトNormal | E-02 L34 `_priority = (byte)CacheItemPriority.Normal` | ○ |
| C-60 | Value設定・取得 | E-02 L175-183 | ○ |
| C-61 | Value null許可 | E-02 L175-183 | ○ |
| C-62 | ExpirationTokens追加 | E-02 L143, E-03 L24 | ○ |
| C-63 | トークン変更で期限切れ | E-03 L48-64 | ○ |
| C-64 | PostEvictionCallbacks追加 | E-02 L149, E-03 L25 | ○ |
| C-65 | エビクション時コールバック呼び出し | E-03 L105-138 | ○ |
| C-66 | Dispose時キャッシュ設定 | E-02 L189-204 | ○ |
| C-67 | Value未設定Disposeでキャッシュ設定なし | E-02 L199-202, L214 | ○ |
| C-68 | 複数回Dispose冪等 | E-02 L191 `if (!_isDisposed)` | ○ |
| C-69 | CheckExpired AbsoluteExpiration前false | E-02 L249-276 | ○ |
| C-70 | CheckExpired AbsoluteExpiration後true | E-02 L261-265 | ○ |
| C-71 | CheckExpired SlidingExpiration内false | E-02 L267-268 | ○ |
| C-72 | CheckExpired SlidingExpiration超過true | E-02 L267-273 | ○ |
| C-73 | SetExpired期限切れ設定 | E-02 L239-247 | ○ |
| C-74 | SetExpired EvictionReason記録 | E-02 L241-244 | ○ |
| C-75 | SetExpired最初のEvictionReason保持 | E-02 L241-244 `if (EvictionReason == EvictionReason.None)` | ○ |

### MemoryCacheOptionsクラス（UT-MCM-076 〜 UT-MCM-089）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | SizeLimit設定・取得 | E-04 L44-56 | ○ |
| C-77 | SizeLimit負値で例外 | E-04 L49-52 | ○ |
| C-78 | SizeLimit null制限解除 | E-04 L54 | ○ |
| C-79 | CompactionPercentage設定・取得 | E-04 L68-80 | ○ |
| C-80 | CompactionPercentage 0未満で例外 | E-04 L73-76 | ○ |
| C-81 | CompactionPercentage 1超過で例外 | E-04 L73-76 | ○ |
| C-82 | CompactionPercentage 0境界値 | E-04 L73 `< 0 or > 1` | ○ |
| C-83 | CompactionPercentage 1境界値 | E-04 L73 `< 0 or > 1` | ○ |
| C-84 | CompactionPercentageデフォルト0.05 | E-04 L17 `_compactionPercentage = 0.05` | ○ |
| C-85 | ExpirationScanFrequency設定・取得 | E-04 L29 | ○ |
| C-86 | ExpirationScanFrequencyデフォルト1分 | E-04 L29 `TimeSpan.FromMinutes(1)` | ○ |
| C-87 | Clockカスタム設定 | E-04 L24 | ○ |
| C-88 | TrackLinkedCacheEntries設定 | E-04 L90 | ○ |
| C-89 | TrackStatistics設定 | E-04 L99 | ○ |

### MemoryDistributedCacheクラス（UT-MCM-090 〜 UT-MCM-106）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | コンストラクタ正常系 | E-05 L25-26 | ○ |
| C-91 | optionsAccessorがnullで例外 | E-05 L35 `ArgumentNullException.ThrowIfNull(optionsAccessor)` | ○ |
| C-92 | Get(string)正常系 | E-05 L46-52 | ○ |
| C-93 | Get存在しないキーでnull | E-05 L50-51 | ○ |
| C-94 | GetkeyがnullでArgumentNullException | E-05 L48 `ArgumentNullException.ThrowIfNull(key)` | ○ |
| C-95 | GetAsync正常系 | E-05 L60-65 | ○ |
| C-96 | Set正常系 | E-05 L73-85 | ○ |
| C-97 | SetkeyがnullでArgumentNullException | E-05 L75 | ○ |
| C-98 | SetvalueがnullでArgumentNullException | E-05 L76 | ○ |
| C-99 | SetoptionsがnullでArgumentNullException | E-05 L77 | ○ |
| C-100 | SetAsync正常系 | E-05 L95-103 | ○ |
| C-101 | Refresh正常系 | E-05 L109-114 | ○ |
| C-102 | RefreshkeyがnullでArgumentNullException | E-05 L111 | ○ |
| C-103 | RefreshAsync正常系 | E-05 L122-128 | ○ |
| C-104 | Remove正常系 | E-05 L134-139 | ○ |
| C-105 | RemovekeyがnullでArgumentNullException | E-05 L136 | ○ |
| C-106 | RemoveAsync正常系 | E-05 L147-153 | ○ |

### MemoryDistributedCacheOptionsクラス（UT-MCM-107）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | デフォルトSizeLimit200MB | E-06 L18 `SizeLimit = 200 * 1024 * 1024` | ○ |

### MemoryCacheServiceCollectionExtensionsクラス（UT-MCM-108 〜 UT-MCM-115）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | AddMemoryCache正常系 | E-07 L22-30 | ○ |
| C-109 | AddMemoryCacheservicesがnullで例外 | E-07 L24 | ○ |
| C-110 | AddMemoryCacheオプション付き正常系 | E-07 L41-50 | ○ |
| C-111 | AddMemoryCachesetupActionがnullで例外 | E-07 L44 | ○ |
| C-112 | AddDistributedMemoryCache正常系 | E-07 L66-74 | ○ |
| C-113 | AddDistributedMemoryCacheservicesがnullで例外 | E-07 L68 | ○ |
| C-114 | AddDistributedMemoryCacheオプション付き正常系 | E-07 L93-102 | ○ |
| C-115 | AddDistributedMemoryCachesetupActionがnullで例外 | E-07 L96 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースがソースコードから根拠を持つ）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードの実装に基づいて作成されており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] MemoryCacheの主要メソッド（CreateEntry, TryGetValue, Remove, Clear）のテストケースが網羅されているか確認
- [ ] 有効期限関連（AbsoluteExpiration, SlidingExpiration, ExpirationTokens）のテストケースが適切か確認
- [ ] バリデーション（null検証、範囲チェック）のテストケースが漏れなく含まれているか確認
- [ ] Dispose後の動作テストが各主要メソッドに含まれているか確認
- [ ] DI拡張メソッド（AddMemoryCache, AddDistributedMemoryCache）のテストケースが適切か確認
- [ ] 優先度の割り当てが適切か確認（金額計算相当の重要ロジックは「高」になっているか）
