---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-Microsoft.Extensions.Configuration.Binder 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-CFB-066**: ミュータブル値型のHasNewValue処理 - 実装の詳細確認が必要
  2. **UT-CFB-100/101**: InterceptorVersion判定ロジックの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Configuration.Binder/src/ConfigurationBinder.cs`
- E-02: `src/libraries/Microsoft.Extensions.Configuration.Binder/src/BinderOptions.cs`
- E-03: `src/libraries/Microsoft.Extensions.Configuration.Binder/src/BindingPoint.cs`
- E-04: `src/libraries/Microsoft.Extensions.Configuration.Binder/gen/ConfigurationBindingGenerator.cs`
- E-05: `src/libraries/Microsoft.Extensions.Configuration.Binder/gen/ConfigurationBindingGenerator.Parser.cs`
- E-06: `src/libraries/Microsoft.Extensions.Configuration.Binder/gen/ConfigurationBindingGenerator.Emitter.cs`
- E-07: `src/libraries/Microsoft.Extensions.Configuration.Binder/gen/Parser/DiagnosticDescriptors.cs`
- E-08: `src/libraries/Microsoft.Extensions.Configuration.Binder/gen/Parser/BinderInvocation.cs`
- E-09: `src/libraries/Microsoft.Extensions.Configuration.Binder/gen/Specs/Types/TypeSpec.cs`
- E-10: `src/libraries/Microsoft.Extensions.Configuration.Binder/gen/Specs/Types/ObjectSpec.cs`
- E-11: `src/libraries/Microsoft.Extensions.Configuration.Binder/gen/Specs/Types/CollectionSpec.cs`
- E-12: `src/libraries/Microsoft.Extensions.Configuration.Binder/gen/Specs/Types/SimpleTypeSpec.cs`
- E-13: `src/libraries/Microsoft.Extensions.Configuration.Binder/gen/Specs/MethodsToGen.cs`
- E-14: `src/libraries/Microsoft.Extensions.Configuration.Binder/gen/Emitter/CoreBindingHelpers.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConfigurationBinder クラス（UT-CFB-001〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Get<T>メソッドでジェネリック型にバインドできる | E-01 (L37-61) | ○ |
| C-02 | Get<T>でconfigureOptionsが適用される | E-01 (L51-61) | ○ |
| C-03 | Get<T>でconfigurationがnullの場合ArgumentNullException | E-01 (L53) | ○ |
| C-04 | Get<T>でバインド失敗時にdefault(T)が返却される | E-01 (L56-60) | ○ |
| C-05 | Get(Type)でType引数でバインドできる | E-01 (L73-74) | ○ |
| C-06 | Get(Type)でtypeがnullの場合ArgumentNullException | E-01 (L93) | ○ |
| C-07 | Bind(object)で既存インスタンスにバインドできる | E-01 (L123-144) | ○ |
| C-08 | Bind(object)でinstanceがnullの場合何も行われない | E-01 (L138) | ○ |
| C-09 | Bind(string, object)で指定キーセクションにバインド | E-01 (L110-114) | ○ |
| C-10 | Bind(object, Action)でBinderOptionsが適用される | E-01 (L134-144) | ○ |
| C-11 | GetValue<T>で指定キーの値が型変換される | E-01 (L155-158) | ○ |
| C-12 | GetValue<T>で値がない場合defaultValueが返却される | E-01 (L170-173) | ○ |
| C-13 | GetValue(Type, string)でType引数で値取得 | E-01 (L183-189) | ○ |
| C-14 | GetValue(Type, string, object)でデフォルト値付き取得 | E-01 (L201-216) | ○ |
| C-15 | BindPropertiesで全プロパティにバインド | E-01 (L220-257) | ○ |
| C-16 | ErrorOnUnknownConfiguration有効時に未知キーで例外 | E-01 (L224-243) | ○ |
| C-17 | BindPropertyで単一プロパティにバインド | E-01 (L287-316) | ○ |
| C-18 | get-onlyプロパティはスキップ | E-01 (L289-295) | ○ |
| C-19 | インデクサプロパティはスキップ | E-01 (L292-293) | ○ |
| C-20 | IConfigurationSectionにバインド | E-01 (L328-332) | ○ |
| C-21 | 配列にバインド | E-01 (L382-391) | ○ |
| C-22 | ISet<T>にバインド | E-01 (L403-415) | ○ |
| C-23 | IDictionary<K,V>にバインド | E-01 (L427-439) | ○ |
| C-24 | IEnumerable<T>にバインド | E-01 (L382-391) | ○ |
| C-25 | IReadOnlyDictionary<K,V>にバインド | E-01 (L427-439) | ○ |
| C-26 | パラメータレスコンストラクタでインスタンス作成 | E-01 (L606-617) | ○ |
| C-27 | パラメータ付きコンストラクタでインスタンス作成 | E-01 (L576-604) | ○ |
| C-28 | インターフェース/抽象クラスで例外 | E-01 (L556-559) | ○ |
| C-29 | パブリックコンストラクタがない場合に例外 | E-01 (L566-569) | ○ |
| C-30 | 複数パラメータ付きコンストラクタで例外 | E-01 (L571-574) | ○ |
| C-31 | string型に変換 | E-01 (L975-979) | ○ |
| C-32 | int型に変換 | E-01 (L990-1004) | ○ |
| C-33 | Nullable<T>で空値の場合null | E-01 (L981-988) | ○ |
| C-34 | byte[]型にBase64から変換 | E-01 (L1007-1021) | ○ |
| C-35 | 変換不可能な値でエラー | E-01 (L1000-1003) | ○ |
| C-36 | object型に変換 | E-01 (L975-979) | ○ |
| C-37 | stringキーのDictionaryにバインド | E-01 (L732-798) | ○ |
| C-38 | enumキーのDictionaryにバインド | E-01 (L743, 767) | ○ |
| C-39 | integerキーのDictionaryにバインド | E-01 (L744-752, 768) | ○ |
| C-40 | サポートされないキー型は何も行われない | E-01 (L754-758) | ○ |
| C-41 | ICollection<T>にバインド | E-01 (L802-838) | ○ |
| C-42 | 配列にバインド | E-01 (L842-897) | ○ |
| C-43 | 多次元配列で例外 | E-01 (L847-850) | ○ |
| C-44 | 既存配列に要素追加 | E-01 (L860-866) | ○ |
| C-45 | ISet<string>にバインド | E-01 (L901-966) | ○ |
| C-46 | ISet<enum>にバインド | E-01 (L905-911) | ○ |
| C-47 | string/enum以外のSet型はnull | E-01 (L907-911) | ○ |
| C-48 | プロパティ名が返却される | E-01 (L1165-1193) | ○ |
| C-49 | ConfigurationKeyNameAttribute指定時にその値が返却 | E-01 (L1170-1189) | ○ |
| C-50 | 継承を含む全プロパティが取得 | E-01 (L1096-1127) | ○ |
| C-51 | オーバーライドプロパティが重複しない | E-01 (L1115-1121) | ○ |
| C-52 | コンストラクタパラメータにバインド | E-01 (L1131-1163) | ○ |
| C-53 | パラメータ名がnullの場合に例外 | E-01 (L1136-1139) | ○ |
| C-54 | バインド失敗時にデフォルト値使用 | E-01 (L1150-1155) | ○ |
| C-55 | バインド失敗かつデフォルト値なしで例外 | E-01 (L1156-1159) | ○ |

### BinderOptions クラス（UT-CFB-056〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | BindNonPublicPropertiesデフォルトfalse | E-02 (L17) | ○ |
| C-57 | BindNonPublicPropertiesをtrueに設定可能 | E-02 (L17) | ○ |
| C-58 | ErrorOnUnknownConfigurationデフォルトfalse | E-02 (L26) | ○ |
| C-59 | ErrorOnUnknownConfigurationをtrueに設定可能 | E-02 (L26) | ○ |

### BindingPoint クラス（UT-CFB-060〜071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | コンストラクタで初期値とisReadOnlyが設定 | E-03 (L16-20) | ○ |
| C-61 | 遅延初期化コンストラクタでValue取得 | E-03 (L22-26) | ○ |
| C-62 | IsReadOnlyが正しく返却 | E-03 (L28) | ○ |
| C-63 | HasNewValue初期状態でfalse | E-03 (L30-54) | ○ |
| C-64 | SetValue後にHasNewValueがtrue | E-03 (L39-42) | ○ |
| C-65 | IsReadOnly時HasNewValueは常にfalse | E-03 (L34-37) | ○ |
| C-66 | ミュータブル値型でHasNewValueがtrue | E-03 (L44-52) | △ |
| C-67 | Valueで設定された値が返却 | E-03 (L56) | ○ |
| C-68 | 遅延初期化プロバイダの値が返却 | E-03 (L56) | ○ |
| C-69 | SetValueで値が設定 | E-03 (L58-64) | ○ |
| C-70 | TrySetValueでIsReadOnlyでない場合に値設定 | E-03 (L66-72) | ○ |
| C-71 | TrySetValueでIsReadOnly時に値設定されない | E-03 (L68) | ○ |

### ConfigurationBindingGenerator（UT-CFB-072〜101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | C#12以上でソース生成 | E-04 (L166-167) | ○ |
| C-73 | C#12未満でソース生成されない | E-04 (L167), E-05 (L37-41) | ○ |
| C-74 | 有効な呼び出しからSpecが生成 | E-05 (L35-63) | ○ |
| C-75 | IConfiguration型がない場合null | E-05 (L43-46) | ○ |
| C-76 | 通常の型でIsValidRootConfigTypeがtrue | E-05 (L65-78) | ○ |
| C-77 | object型でIsValidRootConfigTypeがfalse | E-05 (L68) | ○ |
| C-78 | void型でIsValidRootConfigTypeがfalse | E-05 (L68) | ○ |
| C-79 | TypeParameterでIsValidRootConfigTypeがfalse | E-05 (L70) | ○ |
| C-80 | string型でAssignFromSectionValue | E-05 (L258-263) | ○ |
| C-81 | int型でInteger | E-05 (L277-285) | ○ |
| C-82 | double型でFloat | E-05 (L271-276) | ○ |
| C-83 | enum型でEnum | E-05 (L248-252) | ○ |
| C-84 | byte[]型でByteArray | E-05 (L236-240) | ○ |
| C-85 | DateTime型でParseInvariant | E-05 (L289-293) | ○ |
| C-86 | Uri型でUri | E-05 (L313-316) | ○ |
| C-87 | 1次元配列でArraySpec | E-05 (L338-361) | ○ |
| C-88 | 多次元配列でUnsupportedTypeSpec | E-05 (L342-345) | ○ |
| C-89 | DictionaryでDictionarySpec | E-05 (L382-452) | ○ |
| C-90 | IReadOnlyDictionaryでLinqToDictionary | E-05 (L426-433) | ○ |
| C-91 | ListでEnumerableSpec | E-05 (L454-547) | ○ |
| C-92 | IEnumerableでCopyConstructor | E-05 (L501-508) | ○ |
| C-93 | クラスでObjectSpec | E-05 (L639-798) | ○ |
| C-94 | パラメータレスコンストラクタでParameterlessConstructor | E-05 (L699) | ○ |
| C-95 | パラメータ付きコンストラクタでParameterizedConstructor | E-05 (L699) | ○ |
| C-96 | IntPtrはIsUnsupportedType | E-05 (L564) | ○ |
| C-97 | DelegateはIsUnsupportedType | E-05 (L569) | ○ |
| C-98 | MemberInfoはIsUnsupportedType | E-05 (L568) | ○ |
| C-99 | Emitでソースコード生成 | E-06 (L34-69) | ○ |
| C-100 | InterceptorVersion=0で属性宣言 | E-06 (L72-98) | △ |
| C-101 | InterceptorVersion=1で属性宣言 | E-06 (L72-98) | ○ |

### BinderInvocation（UT-CFB-102〜108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | Bind呼び出しでIsCandidateSyntaxNodeがtrue | E-08 (L34-49) | ○ |
| C-103 | Get呼び出しでIsCandidateSyntaxNodeがtrue | E-08 (L85) | ○ |
| C-104 | GetValue呼び出しでIsCandidateSyntaxNodeがtrue | E-08 (L85) | ○ |
| C-105 | Configure呼び出しでIsCandidateSyntaxNodeがtrue | E-08 (L89) | ○ |
| C-106 | ConfigurationBinder.BindでIsBindingOperationがtrue | E-08 (L52-83) | ○ |
| C-107 | OptionsBuilderConfigurationExtensions.BindでIsBindingOperationがtrue | E-08 (L75-77) | ○ |
| C-108 | 非拡張メソッドでIsBindingOperationがfalse | E-08 (L56) | ○ |

### DiagnosticDescriptors（UT-CFB-109〜112）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | TypeNotSupportedでSYSLIB1100 | E-07 (L59) | ○ |
| C-110 | PropertyNotSupportedでSYSLIB1101 | E-07 (L26) | ○ |
| C-111 | LanguageVersionNotSupportedでSYSLIB1102 | E-07 (L35) | ○ |
| C-112 | GetNotSupportedDescriptorで対応記述子返却 | E-07 (L66-78) | ○ |

### Spec クラス群（UT-CFB-113〜120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | TypeSpecでTypeRefが設定 | E-09 (L15-17) | ○ |
| C-114 | 値型でIsValueTypeがtrue | E-09 (L19) | ○ |
| C-115 | ObjectSpecでProperties取得 | E-10 (L19) | ○ |
| C-116 | ObjectSpecでConstructorParameters取得 | E-10 (L21) | ○ |
| C-117 | CollectionSpecでElementTypeRef取得 | E-11 (L13) | ○ |
| C-118 | DictionarySpecでKeyTypeRef取得 | E-11 (L44) | ○ |
| C-119 | NullableSpecでEffectiveTypeRef取得 | E-09 (L56-59) | ○ |
| C-120 | ParsableFromStringSpecでStringParsableTypeKind取得 | E-12 (L22) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-CFB-066（ミュータブル値型のHasNewValue）**: 実装のコメントでは「ミュータブル構造体の場合、明示的に値を設定していなくてもコピーを編集しているため新しい値として扱う」と説明されているが、具体的な境界条件のテストシナリオが不明確
  - 候補：既存のテストコード / 設計仕様書 / 実装者への確認

- **UT-CFB-100（InterceptorVersion=0の場合の属性宣言）**: InterceptorVersionの決定ロジックが動的に行われるため、テスト環境での再現が困難な可能性
  - 候補：既存のテストコード / ビルド設定ファイル

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: BinderOptions, DiagnosticDescriptors, Specクラス群 - シンプルなPOCO/レコードクラスで複雑なロジックなし
- **1（中リスク）**: BindingPoint, BinderInvocation - 状態管理や条件分岐が含まれる
- **2（高リスク）**: ConfigurationBinder, ConfigurationBindingGenerator.Parser - 複雑な型解析、再帰処理、例外処理が含まれる

## 6) レビュアーチェックリスト（最小）
- [ ] ConfigurationBinder の null チェック（ArgumentNullException）が全ての公開メソッドで一貫しているか
- [ ] 複数コンストラクタの検出ロジックが仕様通りか（パラメータレス優先）
- [ ] Dictionary キータイプのサポート範囲（string, enum, integer）が正しいか
- [ ] BinderOptions.BindNonPublicProperties がソースジェネレータで未サポートであることの警告が適切か
- [ ] IReadOnlyDictionary/IReadOnlySet の処理がIDictionary/ISetと異なることが明確か
- [ ] C# 12以上の言語バージョン要件が適切にチェックされているか
