---
generated_at: 2026-01-30 16:45:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：libraries-Microsoft.Extensions.Configuration.CommandLine.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **UT-CMD-042**：非常に長いキー名のテスト - コード内で明示的な長さ制限がない
  2. **UT-CMD-043**：非常に長い値のテスト - コード内で明示的な長さ制限がない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.CommandLine/src/CommandLineConfigurationProvider.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.CommandLine/src/CommandLineConfigurationSource.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.CommandLine/src/CommandLineConfigurationExtensions.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.CommandLine/ref/Microsoft.Extensions.Configuration.CommandLine.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.CommandLine/tests/CommandLineTest.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.CommandLine/tests/ConfigurationProviderCommandLineTest.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-CMD-001) | 引数のみでインスタンスが生成されること | E-01 (line 21-31), E-05 (line 22) | ○ |
| C-02 (UT-CMD-002) | 引数とスイッチマッピングでインスタンスが生成されること | E-01 (line 21-31), E-05 (line 95) | ○ |
| C-03 (UT-CMD-003) | argsがnullの場合ArgumentNullExceptionがスローされること | E-01 (line 23), E-05 (line 179-186) | ○ |
| C-04 (UT-CMD-004) | スイッチマッピングのキーが無効な場合ArgumentExceptionがスローされること | E-01 (line 144-149), E-05 (line 152-176) | ○ |
| C-05 (UT-CMD-005) | スイッチマッピングに大文字小文字違いの重複キーがある場合ArgumentExceptionがスローされること | E-01 (line 151-156), E-05 (line 108-150) | ○ |
| C-06 (UT-CMD-006) | --key=value形式の引数が正しくパースされること | E-01 (line 53-55, 121), E-05 (line 61, 70) | ○ |
| C-07 (UT-CMD-007) | /key=value形式の引数が正しくパースされること | E-01 (line 61-67), E-05 (line 62, 71) | ○ |
| C-08 (UT-CMD-008) | key=value形式（プレフィックスなし）の引数が正しくパースされること | E-01 (line 69-70), E-05 (line 60, 70) | ○ |
| C-09 (UT-CMD-009) | --key value形式（スペース区切り）の引数が正しくパースされること | E-01 (line 96-102), E-05 (line 63, 72) | ○ |
| C-10 (UT-CMD-010) | /key value形式（スペース区切り）の引数が正しくパースされること | E-01 (line 61-67, 96-102), E-05 (line 64, 73) | ○ |
| C-11 (UT-CMD-011) | スイッチマッピングで短縮キーが展開されること | E-01 (line 81-84, 109-111), E-05 (line 91, 99) | ○ |
| C-12 (UT-CMD-012) | スイッチマッピングでエイリアスキーが展開されること | E-01 (line 81-84, 109-111), E-05 (line 92, 100) | ○ |
| C-13 (UT-CMD-013) | 重複キーの場合は後の値で上書きされること | E-01 (line 127-128), E-05 (line 189-202) | ○ |
| C-14 (UT-CMD-014) | 大文字小文字を区別しないキー取得ができること | E-01 (line 43) StringComparer.OrdinalIgnoreCase | ○ |
| C-15 (UT-CMD-015) | 複数の引数が正しくパースされること | E-05 (line 56-75) | ○ |
| C-16 (UT-CMD-016) | 空の引数配列の場合は空のデータとなること | E-01 (line 46-48) | ○ |
| C-17 (UT-CMD-017) | 認識できない引数（プレフィックスなし、等号なし）は無視されること | E-01 (line 74-78), E-05 (line 219-229) | ○ |
| C-18 (UT-CMD-018) | --keyの後に値がない場合は無視されること | E-01 (line 96-100), E-05 (line 204-217) | ○ |
| C-19 (UT-CMD-019) | 未定義の短縮スイッチ（-x）は無視されること（等号なし） | E-01 (line 85-88), E-05 (line 231-245) | ○ |
| C-20 (UT-CMD-020) | 未定義の短縮スイッチ（-x=value）はFormatExceptionがスローされること | E-01 (line 113-117) | ○ |
| C-21 (UT-CMD-021) | 中間に不明な引数があっても他の引数は正しくパースされること | E-01 (line 74-78), E-05 (line 28-52) | ○ |
| C-22 (UT-CMD-022) | 値が空文字の場合も正しく設定されること | E-01 (line 124) | ○ |
| C-23 (UT-CMD-023) | 値に等号が含まれる場合も正しくパースされること | E-01 (line 69, 124) IndexOf('=')で最初の等号のみ区切り | ○ |
| C-24 (UT-CMD-024) | スラッシュプレフィックスがダブルダッシュに変換されてマッピングが適用されること | E-01 (line 61-67), E-05 (line 87, 93, 104) | ○ |
| C-25 (UT-CMD-025) | Argsプロパティがコンストラクタで渡された引数を返すこと | E-01 (line 33-36), E-04 (line 21) | ○ |
| C-26 (UT-CMD-026) | 有効なスイッチマッピングがコピーされること | E-01 (line 135-162) | ○ |
| C-27 (UT-CMD-027) | ダッシュで始まらないキーはArgumentExceptionがスローされること | E-01 (line 143-149), E-05 (line 152-176) | ○ |
| C-28 (UT-CMD-028) | Argsプロパティにセットした値が取得できること | E-02 (line 22), E-04 (line 27) | ○ |
| C-29 (UT-CMD-029) | Argsプロパティのデフォルト値が空配列であること | E-02 (line 22) Array.Empty<string>() | ○ |
| C-30 (UT-CMD-030) | SwitchMappingsプロパティにセットした値が取得できること | E-02 (line 17), E-04 (line 28) | ○ |
| C-31 (UT-CMD-031) | SwitchMappingsプロパティのデフォルト値がnullであること | E-02 (line 17) nullable型 | ○ |
| C-32 (UT-CMD-032) | BuildメソッドがCommandLineConfigurationProviderを返すこと | E-02 (line 29-32), E-04 (line 29) | ○ |
| C-33 (UT-CMD-033) | BuildメソッドがSwitchMappingsを含むProviderを返すこと | E-02 (line 31) | ○ |
| C-34 (UT-CMD-034) | 拡張メソッドがConfigurationBuilderにソースを追加すること | E-03 (line 66-69, 152-159) | ○ |
| C-35 (UT-CMD-035) | メソッドチェーンが可能であること | E-03 (line 68, 158) return configurationBuilder | ○ |
| C-36 (UT-CMD-036) | スイッチマッピング付きでソースを追加できること | E-03 (line 152-159) | ○ |
| C-37 (UT-CMD-037) | switchMappingsがnullの場合も動作すること | E-03 (line 68), E-01 (line 27-30) | ○ |
| C-38 (UT-CMD-038) | Action<CommandLineConfigurationSource>でソースを設定できること | E-03 (line 167-168), E-04 (line 11) | ○ |
| C-39 (UT-CMD-039) | configureSourceがnullの場合も動作すること | E-03 (line 167-168) nullable Action | ○ |
| C-40 (UT-CMD-040) | 階層キー（key:subkey形式）が正しくパースされること | E-01 (line 43, 128), E-06 (line 31, 36) | ○ |
| C-41 (UT-CMD-041) | 複数階層キーが正しくパースされること | E-06 (line 36) SectionToArgs | ○ |
| C-42 (UT-CMD-042) | 非常に長いキー名が正しく処理されること | **根拠なし** | △ |
| C-43 (UT-CMD-043) | 非常に長い値が正しく処理されること | **根拠なし** | △ |
| C-44 (UT-CMD-044) | 日本語キー・値が正しく処理されること | E-01 (line 43) StringComparer, Dictionary<string, string?> | ○ |
| C-45 (UT-CMD-045) | 値にスペースが含まれる場合も正しく処理されること | E-01 (line 124) Substring | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-CMD-042, UT-CMD-043**: 長いキー名・値の処理テスト
  - コード内で明示的な長さ制限チェックは存在しない
  - Dictionary<string, string?>の制限に依存するため、.NETランタイムの制限に従う
  - 候補：.NET Dictionary実装 / string型の最大長制限 / メモリ制限

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードと既存テストに基づいて網羅的にテストケースを生成
- 1: 中リスク - FormatException発生条件（UT-CMD-020）の実際の動作確認が必要
- 0: 低リスク - 拡張メソッドのnull許容性は型定義から確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CommandLineConfigurationProviderのLoad()メソッドの全分岐がテストケースでカバーされているか確認
- [ ] スイッチマッピング検証のエラーメッセージが適切か確認
- [ ] 階層キー（section:key形式）のパースが意図通りか確認
- [ ] FormatException発生条件の妥当性を確認（未定義の短縮スイッチ + 等号形式）
- [ ] 境界値テスト（空配列、空文字値、長いキー/値）の妥当性を確認
