---
generated_at: 2026-01-30 16:45:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：libraries-Microsoft.Extensions.Configuration.UserSecrets 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **UT-USR-013**：DOTNET_USER_SECRETS_FALLBACK_DIRフォールバック機能の動作確認が必要
  2. **UT-USR-028**：内部メソッドの連携確認は実装詳細に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsIdAttribute.cs` - UserSecretsIdAttributeクラスの実装
- E-02: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/PathHelper.cs` - PathHelperクラスの実装
- E-03: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsConfigurationExtensions.cs` - 拡張メソッドの実装
- E-04: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/tests/ConfigurationExtensionTest.cs` - 既存の単体テスト
- E-05: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/tests/PathHelperTest.cs` - PathHelperの既存テスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-USR-001) | UserSecretsIdAttributeコンストラクタの正常系 | E-01 (L23-31) | ○ |
| C-02 (UT-USR-002) | nullを渡すとArgumentException | E-01 (L25-28) | ○ |
| C-03 (UT-USR-003) | 空文字を渡すとArgumentException | E-01 (L25-28) | ○ |
| C-04 (UT-USR-004) | UserSecretsIdプロパティの取得 | E-01 (L36) | ○ |
| C-05 (UT-USR-005) | Windows環境でのパス生成 | E-02 (L61-62, L78-79) | ○ |
| C-06 (UT-USR-006) | Mac/Linux環境でのパス生成 | E-02 (L63, L80), E-05 (L19-24) | ○ |
| C-07 (UT-USR-007) | GetSecretsPathFromSecretsIdでnull拒否 | E-02 (L43-46) | ○ |
| C-08 (UT-USR-008) | GetSecretsPathFromSecretsIdで空文字拒否 | E-02 (L43-46) | ○ |
| C-09 (UT-USR-009) | 無効なファイル名文字の検出 | E-02 (L48-56), E-05 (L30-37) | ○ |
| C-10 (UT-USR-010) | 全不正文字の網羅テスト | E-02 (L48), E-05 (L32) | ○ |
| C-11 (UT-USR-011) | throwIfNoRoot=trueで例外 | E-02 (L70-73) | ○ |
| C-12 (UT-USR-012) | throwIfNoRoot=falseで空文字返却 | E-02 (L74-76) | ○ |
| C-13 (UT-USR-013) | DOTNET_USER_SECRETS_FALLBACK_DIRフォールバック | E-02 (L58, L66) | △ |
| C-14 (UT-USR-014) | AddUserSecrets<T>の基本動作 | E-03 (L30-32), E-04 (L71-82) | ○ |
| C-15 (UT-USR-015) | デフォルトパラメータ確認 | E-03 (L30-32) | ○ |
| C-16 (UT-USR-016) | optional=falseで属性欠落時の例外 | E-03 (L130-133), E-04 (L84-96) | ○ |
| C-17 (UT-USR-017) | optional=trueで属性欠落許容 | E-03 (L135), E-04 (L99-108) | ○ |
| C-18 (UT-USR-018) | reloadOnChange=trueの動作 | E-03 (L67-69) | ○ |
| C-19 (UT-USR-019) | AddUserSecrets(Assembly)の基本動作 | E-03 (L84-85), E-04 (L56-67) | ○ |
| C-20 (UT-USR-020) | configuration null チェック | E-03 (L121) | ○ |
| C-21 (UT-USR-021) | assembly null チェック | E-03 (L122) | ○ |
| C-22 (UT-USR-022) | optional=falseでアセンブリ名表示 | E-03 (L132) | ○ |
| C-23 (UT-USR-023) | 全パラメータ指定 | E-03 (L119-136) | ○ |
| C-24 (UT-USR-024) | AddUserSecrets(string)の基本動作 | E-03 (L149-150), E-04 (L123-134) | ○ |
| C-25 (UT-USR-025) | ファイル不存在時の許容動作 | E-04 (L136-146) | ○ |
| C-26 (UT-USR-026) | userSecretsId null チェック | E-03 (L170) | ○ |
| C-27 (UT-USR-027) | reloadOnChange=true（ID指定版） | E-03 (L164-165) | ○ |
| C-28 (UT-USR-028) | AddUserSecretsInternal連携確認 | E-03 (L167-173) | △ |
| C-29 (UT-USR-029) | ディレクトリ存在時のPhysicalFileProvider生成 | E-03 (L183-185) | ○ |
| C-30 (UT-USR-030) | ディレクトリ不存在時のnullファイルプロバイダー | E-03 (L183-185) | ○ |
| C-31 (UT-USR-031) | 空パス時の早期リターン | E-03 (L177-179) | ○ |
| C-32 (UT-USR-032) | nullパス時の早期リターン | E-03 (L177-179) | ○ |
| C-33 (UT-USR-033) | SecretsFileName定数値 | E-02 (L14) | ○ |
| C-34 (UT-USR-034) | エンドツーエンドの動作確認 | E-04 (L56-67, L71-82) | ○ |
| C-35 (UT-USR-035) | ネストキーの読み取り | E-04 (L128, L133) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-USR-013 (DOTNET_USER_SECRETS_FALLBACK_DIR)**：コード上はフォールバック環境変数が定義されているが、既存テストではこのパスの動作確認がない
  - 候補：環境変数を設定した状態での統合テスト / モック環境での単体テスト
- **UT-USR-028 (AddUserSecretsInternal)**：privateメソッドのため直接テストは困難、公開APIを通じた間接的なテストが必要
  - 候補：パブリックAPIの呼び出し結果を検証 / リフレクションを使用したテスト（非推奨）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - UT-USR-033（定数値確認）：変更される可能性が低い
- **1: 中リスク** - UT-USR-005, UT-USR-006（環境依存パス生成）：OS間の挙動差異に注意
- **1: 中リスク** - UT-USR-013（フォールバック環境変数）：実環境でのテストが困難
- **0: 低リスク** - その他のテストケース：コードから直接導出可能

## 6) レビュアーチェックリスト（最小）
- [ ] UT-USR-002, UT-USR-003：ArgumentExceptionのメッセージ内容が適切か確認
- [ ] UT-USR-005, UT-USR-006：CI/CD環境でのOS別テスト実行計画を確認
- [ ] UT-USR-009, UT-USR-010：Path.GetInvalidFileNameChars()の全文字がテストされることを確認
- [ ] UT-USR-013：DOTNET_USER_SECRETS_FALLBACK_DIR環境変数のテスト方針を検討
- [ ] UT-USR-016, UT-USR-022：例外メッセージにアセンブリ名が含まれることを確認
- [ ] UT-USR-034, UT-USR-035：統合テストの実行環境（ファイルシステムアクセス）を確認
