---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 75
  claims_with_evidence: 72
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：libraries-Microsoft.Extensions.Configuration.Xml 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：72 / 75、根拠なし：3
- 優先レビュー（高）
  1. **UT-CFGXML-055**：Browserプラットフォーム制限のテスト - 実際の動作確認が必要
  2. **UT-CFGXML-042**：深いネストの境界値テスト - 具体的な上限値の確認が必要
  3. **UT-CFGXML-007**：reloadOnChangeの動作確認 - FileConfigurationSource継承クラスの動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationExtensions.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationProvider.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlStreamConfigurationProvider.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlDocumentDecryptor.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationSource.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlStreamConfigurationSource.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationElement.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationElementAttributeValue.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationElementTextContent.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/tests/XmlConfigurationTest.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/tests/XmlConfigurationExtensionsTest.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/ref/Microsoft.Extensions.Configuration.Xml.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AddXmlFile(path)でプロバイダーが追加される | E-01 (L26-29), E-10 (L52-75) | ○ |
| C-02 | nullパスでArgumentException | E-01 (L78-81) | ○ |
| C-03 | 空文字パスでArgumentException | E-01 (L78-81), E-10 (L633-641) | ○ |
| C-04 | nullのbuilderでArgumentNullException | E-01 (L76) | ○ |
| C-05 | optional=falseで存在しないファイルはFileNotFoundException | E-10 (L717-721), E-11 (L12-20) | ○ |
| C-06 | optional=trueで存在しないファイルは例外なし | E-10 (L724-727) | ○ |
| C-07 | reloadOnChange=trueでファイル変更監視 | E-01 (L57-60) | △ |
| C-08 | カスタムFileProviderを指定可能 | E-01 (L74-91) | ○ |
| C-09 | Action経由でソース設定可能 | E-01 (L101-102) | ○ |
| C-10 | AddXmlStreamでStream読み込み | E-01 (L112-117), E-10 (L17-39) | ○ |
| C-11 | AddXmlStreamでnullのbuilderはArgumentNullException | E-01 (L114) | ○ |
| C-12 | XmlConfigurationProviderコンストラクタ | E-02 (L19-20) | ○ |
| C-13 | Loadで有効XMLからキー値ペア読み込み | E-02 (L28-31), E-10 (L52-75) | ○ |
| C-14 | ネスト要素からコロン区切りキー生成 | E-03 (L278-286), E-10 (L52-75) | ○ |
| C-15 | 属性からキー値ペア生成 | E-03 (L287-303), E-10 (L96-118) | ○ |
| C-16 | Name属性がプレフィックスに追加 | E-03 (L353-387), E-10 (L145-169) | ○ |
| C-17 | 小文字name属性も認識 | E-03 (L231-253), E-10 (L171-195) | ○ |
| C-18 | ルート要素のName属性 | E-03 (L264-275), E-10 (L197-220) | ○ |
| C-19 | 繰り返し要素がインデックス付き | E-03 (L331-350), E-10 (L245-266) | ○ |
| C-20 | 繰り返し検出が大文字小文字非依存 | E-03 (L94, 97), E-10 (L268-289) | ○ |
| C-21 | Name属性で配列シミュレート | E-10 (L222-243) | ○ |
| C-22 | 同じName属性の繰り返し要素 | E-10 (L315-337) | ○ |
| C-23 | 異なるName属性の繰り返し要素 | E-10 (L339-361) | ○ |
| C-24 | ネストした繰り返し要素 | E-10 (L363-385) | ○ |
| C-25 | 子要素と属性の混在 | E-10 (L120-143) | ○ |
| C-26 | 繰り返しと非繰り返し要素混在 | E-10 (L387-419) | ○ |
| C-27 | 空の値の読み込み | E-10 (L77-93) | ○ |
| C-28 | 自己終了タグの空値 | E-03 (L122-126) | ○ |
| C-29 | 空の属性値 | E-10 (L77-93) | ○ |
| C-30 | CDATAセクション処理 | E-03 (L145-156), E-10 (L463-479) | ○ |
| C-31 | XMLコメント無視 | E-03 (L160-163), E-10 (L481-505) | ○ |
| C-32 | XML宣言無視 | E-03 (L158), E-10 (L507-532) | ○ |
| C-33 | 処理命令無視 | E-03 (L159), E-10 (L534-561) | ○ |
| C-34 | キー取得が大文字小文字非依存 | E-03 (L257), E-10 (L445-461) | ○ |
| C-35 | ドット含む要素名 | E-10 (L17-39) | ○ |
| C-36 | DTD禁止でXmlException | E-03 (L44), E-10 (L563-597) | ○ |
| C-37 | 名前空間でFormatException | E-03 (L216-219), E-10 (L599-621) | ○ |
| C-38 | 属性の名前空間でFormatException | E-03 (L239-243) | ○ |
| C-39 | 重複キーでFormatException | E-03 (L389-410), E-10 (L643-665) | ○ |
| C-40 | 大文字小文字違い重複キー | E-03 (L400-406), E-10 (L667-689) | ○ |
| C-41 | 空XMLで空設定 | E-03 (L255-262) | ○ |
| C-42 | 深いネスト構造 | E-03 (L278-286) | △ |
| C-43 | XmlStreamConfigurationProviderコンストラクタ | E-03 (L30-31) | ○ |
| C-44 | XmlStreamConfigurationProvider.Load | E-03 (L187-190) | ○ |
| C-45 | Read静的メソッド | E-03 (L39-181), E-12 (L65) | ○ |
| C-46 | カスタムDecryptor使用 | E-03 (L51), E-10 (L730-781) | ○ |
| C-47 | XmlConfigurationSource.Build | E-05 (L20-24) | ○ |
| C-48 | EnsureDefaults呼び出し | E-05 (L22) | ○ |
| C-49 | XmlStreamConfigurationSource.Build | E-06 (L20-21) | ○ |
| C-50 | XmlDocumentDecryptor.Instance | E-04 (L24), E-12 (L49) | ○ |
| C-51 | 非暗号化XMLでXmlReader返却 | E-04 (L88-92) | ○ |
| C-52 | 暗号化XMLで復号化XmlReader | E-04 (L78-85) | ○ |
| C-53 | XmlReaderSettingsがnull許容 | E-04 (L62) | ○ |
| C-54 | DecryptDocumentAndCreateXmlReader | E-04 (L103-118) | ○ |
| C-55 | Browserプラットフォーム制限 | E-04 (L100, L106) | △ |
| C-56 | XmlConfigurationElementコンストラクタ | E-07 (L34-41) | ○ |
| C-57 | nameがnullでSiblingName | E-07 (L40) | ○ |
| C-58 | elementNameがnullでArgumentNullException | E-07 (L36) | ○ |
| C-59 | SingleChildプロパティ | E-07 (L28) | ○ |
| C-60 | ChildrenBySiblingNameプロパティ | E-07 (L23) | ○ |
| C-61 | TextContentプロパティ | E-07 (L30) | ○ |
| C-62 | Attributesプロパティ | E-07 (L32) | ○ |
| C-63 | XmlConfigurationElementAttributeValueコンストラクタ | E-08 (L10-18) | ○ |
| C-64 | attributeがnullでArgumentNullException | E-08 (L12) | ○ |
| C-65 | valueがnullでArgumentNullException | E-08 (L13) | ○ |
| C-66 | lineNumber/linePositionがnull許容 | E-08 (L10) | ○ |
| C-67 | XmlConfigurationElementTextContentコンストラクタ | E-09 (L10-17) | ○ |
| C-68 | textContentがnullでArgumentNullException | E-09 (L12) | ○ |
| C-69 | TextContentのlineNumber/linePositionがnull許容 | E-09 (L10) | ○ |
| C-70 | Prefixコンストラクタ | E-03 (L422-426) | ○ |
| C-71 | Prefix.Push動作 | E-03 (L430-442) | ○ |
| C-72 | 複数Push動作 | E-03 (L434-436) | ○ |
| C-73 | Prefix.Pop動作 | E-03 (L445-449) | ○ |
| C-74 | すべてPop | E-03 (L445-449) | ○ |
| C-75 | AsStringプロパティ | E-03 (L428) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-CFGXML-007（reloadOnChange）**: FileConfigurationSource基底クラスの実装詳細が本モジュール外にあるため、完全な動作確認には基底クラスの確認が必要
  - 候補：`Microsoft.Extensions.Configuration.FileExtensions` モジュール
- **UT-CFGXML-042（深いネスト）**: 具体的な上限値やスタックオーバーフローの閾値が明示されていない
  - 候補：実行時テストによる確認
- **UT-CFGXML-055（Browser制限）**: 実際のBrowserプラットフォームでの動作確認が必要
  - 候補：プラットフォーム固有のテスト環境

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大半のテストケース - ソースコードと既存テストで十分な根拠がある
- **1（中リスク）**: UT-CFGXML-007, UT-CFGXML-042 - 基底クラスの動作や境界値の確認が必要
- **2（高リスク）**: UT-CFGXML-055 - プラットフォーム固有の動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] XmlConfigurationExtensionsの各オーバーロードメソッドが網羅されているか
- [ ] XmlStreamConfigurationProviderのReadメソッドの各分岐（Element, EndElement, CDATA, Text等）がテストされているか
- [ ] XmlDocumentDecryptorの暗号化/非暗号化パスが両方テストされているか
- [ ] Name属性の各種パターン（大文字小文字、ルート要素、繰り返し要素）がカバーされているか
- [ ] エラーハンドリング（DTD禁止、名前空間禁止、重複キー）のテストが網羅されているか
- [ ] 内部クラス（XmlConfigurationElement, XmlConfigurationElementAttributeValue, XmlConfigurationElementTextContent, Prefix）の入力検証がテストされているか
