---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 140
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Configuration 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：クラス・メソッドの主要な機能がテストケースでカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：140 / 140、根拠なし：0
- 優先レビュー（高）
  1. なし（すべてのテストケースにソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationBuilder.cs`
- E-02: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationKeyComparer.cs`
- E-03: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationProvider.cs`
- E-04: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationReloadToken.cs`
- E-05: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationRoot.cs`
- E-06: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationSection.cs`
- E-07: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationManager.cs`
- E-08: `src/libraries/Microsoft.Extensions.Configuration/src/ChainedBuilderExtensions.cs`
- E-09: `src/libraries/Microsoft.Extensions.Configuration/src/ChainedConfigurationProvider.cs`
- E-10: `src/libraries/Microsoft.Extensions.Configuration/src/ChainedConfigurationSource.cs`
- E-11: `src/libraries/Microsoft.Extensions.Configuration/src/MemoryConfigurationBuilderExtensions.cs`
- E-12: `src/libraries/Microsoft.Extensions.Configuration/src/MemoryConfigurationProvider.cs`
- E-13: `src/libraries/Microsoft.Extensions.Configuration/src/MemoryConfigurationSource.cs`
- E-14: `src/libraries/Microsoft.Extensions.Configuration/src/StreamConfigurationProvider.cs`
- E-15: `src/libraries/Microsoft.Extensions.Configuration/src/StreamConfigurationSource.cs`
- E-16: `src/libraries/Microsoft.Extensions.Configuration/src/ReferenceCountedProviderManager.cs`
- E-17: `src/libraries/Microsoft.Extensions.Configuration/src/ReferenceCountedProviders.cs`
- E-18: `src/libraries/Microsoft.Extensions.Configuration/src/InternalConfigurationRootExtensions.cs`
- E-19: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationSectionDebugView.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConfigurationBuilder (UT-CFG-001 〜 UT-CFG-006)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Add メソッドでソースを追加できる | E-01 (L32-38) | ○ |
| C-02 | Add メソッドでnullを渡すとArgumentNullException | E-01 (L34) | ○ |
| C-03 | Build メソッドでConfigurationRootを構築 | E-01 (L45-54) | ○ |
| C-04 | Build は空のソースでも動作する | E-01 (L45-54) | ○ |
| C-05 | Sources プロパティでソースリスト取得 | E-01 (L19) | ○ |
| C-06 | Properties 辞書でプロパティ管理 | E-01 (L25) | ○ |

### ConfigurationKeyComparer (UT-CFG-007 〜 UT-CFG-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | 文字列キーの比較 | E-02 (L70-85) | ○ |
| C-08 | 数値キーの比較 | E-02 (L73-89) | ○ |
| C-09 | 数値と文字列の混合比較 | E-02 (L91-95) | ○ |
| C-10 | 階層的キー（デリミタ）の比較 | E-02 (L39-57) | ○ |
| C-11 | nullキーの処理 | E-02 (L32-33) | ○ |
| C-12 | 空文字列の処理 | E-02 (L32-33) | ○ |
| C-13 | 連続デリミタのスキップ | E-02 (L61-68) | ○ |
| C-14 | シングルトンインスタンス | E-02 (L19) | ○ |

### ConfigurationProvider (UT-CFG-015 〜 UT-CFG-024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | TryGet で値取得 | E-03 (L38-39) | ○ |
| C-16 | TryGet で存在しないキー | E-03 (L38-39) | ○ |
| C-17 | Set で値設定 | E-03 (L46-47) | ○ |
| C-18 | Set でnull値設定 | E-03 (L46-47) | ○ |
| C-19 | GetChildKeys で子キー取得 | E-03 (L61-94) | ○ |
| C-20 | GetChildKeys でルートキー取得 | E-03 (L67-72) | ○ |
| C-21 | GetChildKeys で空結果 | E-03 (L65) | ○ |
| C-22 | GetReloadToken でトークン取得 | E-03 (L107-110) | ○ |
| C-23 | OnReload でトークン更新 | E-03 (L115-119) | ○ |
| C-24 | ToString でクラス名返却 | E-03 (L125) | ○ |

### ConfigurationReloadToken (UT-CFG-025 〜 UT-CFG-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | HasChanged 初期状態 | E-04 (L28) | ○ |
| C-26 | HasChanged OnReload後 | E-04 (L28, L50) | ○ |
| C-27 | OnReload でキャンセル | E-04 (L50) | ○ |
| C-28 | RegisterChangeCallback でコールバック登録 | E-04 (L37-45) | ○ |
| C-29 | コールバック実行 | E-04 (L37-45) | ○ |
| C-30 | ActiveChangeCallbacks 初期値 | E-04 (L22) | ○ |

### ConfigurationRoot (UT-CFG-031 〜 UT-CFG-045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | コンストラクタでプロバイダーリスト初期化 | E-05 (L27-38) | ○ |
| C-32 | コンストラクタでnullプロバイダー検証 | E-05 (L29) | ○ |
| C-33 | インデクサ get で値取得 | E-05 (L50-52) | ○ |
| C-34 | プロバイダー優先順位（後勝ち） | E-05 (L114-127) | ○ |
| C-35 | 存在しないキーでnull | E-05 (L126) | ○ |
| C-36 | インデクサ set で全プロバイダーに設定 | E-05 (L53, L129-140) | ○ |
| C-37 | プロバイダー空でInvalidOperationException | E-05 (L131-134) | ○ |
| C-38 | GetSection でセクション取得 | E-05 (L77-78) | ○ |
| C-39 | 存在しないセクションで空セクション | E-05 (L73-78) | ○ |
| C-40 | GetChildren で子セクション取得 | E-05 (L60) | ○ |
| C-41 | GetReloadToken でトークン取得 | E-05 (L66) | ○ |
| C-42 | Reload で全プロバイダーリロード | E-05 (L83-90) | ○ |
| C-43 | Reload 後トークン更新 | E-05 (L89, L92-96) | ○ |
| C-44 | Dispose でリソース解放 | E-05 (L99-112) | ○ |
| C-45 | Providers プロパティ | E-05 (L43) | ○ |

### ConfigurationSection (UT-CFG-046 〜 UT-CFG-061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | コンストラクタで初期化 | E-06 (L27-34) | ○ |
| C-47 | コンストラクタでnull root検証 | E-06 (L29) | ○ |
| C-48 | コンストラクタでnull path検証 | E-06 (L30) | ○ |
| C-49 | Path プロパティ | E-06 (L39) | ○ |
| C-50 | Key プロパティ | E-06 (L44-46) | ○ |
| C-51 | Key 遅延評価 | E-06 (L44-46) | ○ |
| C-52 | Value get | E-06 (L51-56) | ○ |
| C-53 | Value set | E-06 (L57-60) | ○ |
| C-54 | インデクサ get | E-06 (L87-91) | ○ |
| C-55 | インデクサ set | E-06 (L92-96) | ○ |
| C-56 | GetSection | E-06 (L108) | ○ |
| C-57 | GetChildren | E-06 (L114) | ○ |
| C-58 | GetReloadToken | E-06 (L120) | ○ |
| C-59 | TryGetValue 存在する値 | E-06 (L69-80) | ○ |
| C-60 | TryGetValue 存在しない値 | E-06 (L69-80) | ○ |
| C-61 | TryGetValue nullキー | E-06 (L71) | ○ |

### ConfigurationManager (UT-CFG-062 〜 UT-CFG-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | コンストラクタでデフォルトソース追加 | E-07 (L43-50) | ○ |
| C-63 | インデクサ get | E-07 (L53-59) | ○ |
| C-64 | インデクサ set | E-07 (L60-65) | ○ |
| C-65 | GetSection | E-07 (L68) | ○ |
| C-66 | GetChildren | E-07 (L71) | ○ |
| C-67 | Sources プロパティ | E-07 (L76) | ○ |
| C-68 | Sources.Add で即時ロード | E-07 (L124-133, L210-214) | ○ |
| C-69 | Sources.Remove でリロード | E-07 (L245-250) | ○ |
| C-70 | Sources.Clear でリロード | E-07 (L216-220) | ○ |
| C-71 | IConfigurationBuilder.Add | E-07 (L90-96) | ○ |
| C-72 | IConfigurationBuilder.Add null検証 | E-07 (L92) | ○ |
| C-73 | IConfigurationBuilder.Build | E-07 (L98) | ○ |
| C-74 | IConfigurationRoot.Reload | E-07 (L102-113) | ○ |
| C-75 | Dispose | E-07 (L84-88) | ○ |
| C-76 | GetReloadToken | E-07 (L100) | ○ |
| C-77 | Providers プロパティ | E-07 (L81) | ○ |

### ChainedBuilderExtensions (UT-CFG-078 〜 UT-CFG-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | AddConfiguration で設定追加 | E-08 (L20-21, L30-41) | ○ |
| C-79 | AddConfiguration null builder検証 | E-08 (L32) | ○ |
| C-80 | AddConfiguration null config検証 | E-08 (L33) | ○ |
| C-81 | shouldDisposeConfiguration=false | E-08 (L38) | ○ |
| C-82 | shouldDisposeConfiguration=true | E-08 (L38) | ○ |

### ChainedConfigurationProvider (UT-CFG-083 〜 UT-CFG-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | コンストラクタ | E-09 (L22-28) | ○ |
| C-84 | コンストラクタ null source検証 | E-09 (L24) | ○ |
| C-85 | コンストラクタ null Configuration検証 | E-09 (L26) | ○ |
| C-86 | TryGet 存在する値 | E-09 (L41-45) | ○ |
| C-87 | TryGet 存在しない値 | E-09 (L41-45) | ○ |
| C-88 | TryGet 空文字列 | E-09 (L44) | ○ |
| C-89 | Set | E-09 (L52) | ○ |
| C-90 | GetReloadToken | E-09 (L58) | ○ |
| C-91 | Load 空実装 | E-09 (L63) | ○ |
| C-92 | GetChildKeys | E-09 (L73-86) | ○ |
| C-93 | GetChildKeys null parentPath | E-09 (L77) | ○ |
| C-94 | Dispose ShouldDisposeConfiguration=true | E-09 (L89-95) | ○ |
| C-95 | Dispose ShouldDisposeConfiguration=false | E-09 (L91) | ○ |
| C-96 | Configuration プロパティ | E-09 (L33) | ○ |

### ChainedConfigurationSource (UT-CFG-097 〜 UT-CFG-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | Configuration プロパティ | E-10 (L16-17) | ○ |
| C-98 | ShouldDisposeConfiguration プロパティ | E-10 (L23) | ○ |
| C-99 | Build | E-10 (L30-31) | ○ |

### MemoryConfigurationBuilderExtensions (UT-CFG-100 〜 UT-CFG-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | AddInMemoryCollection() | E-11 (L20-26) | ○ |
| C-101 | AddInMemoryCollection null検証 | E-11 (L22, L38) | ○ |
| C-102 | AddInMemoryCollection(initialData) | E-11 (L34-42) | ○ |
| C-103 | AddInMemoryCollection null initialData | E-11 (L40) | ○ |

### MemoryConfigurationProvider (UT-CFG-104 〜 UT-CFG-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | コンストラクタ | E-12 (L21-34) | ○ |
| C-105 | コンストラクタ 初期データ読み込み | E-12 (L27-33) | ○ |
| C-106 | コンストラクタ null検証 | E-12 (L23) | ○ |
| C-107 | Add | E-12 (L41-44) | ○ |
| C-108 | Add null値 | E-12 (L43) | ○ |
| C-109 | GetEnumerator | E-12 (L50-53) | ○ |
| C-110 | GetEnumerator 空 | E-12 (L50-53) | ○ |

### MemoryConfigurationSource (UT-CFG-111 〜 UT-CFG-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | InitialData プロパティ | E-13 (L16) | ○ |
| C-112 | Build | E-13 (L23-26) | ○ |

### StreamConfigurationProvider (UT-CFG-113 〜 UT-CFG-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | コンストラクタ | E-14 (L25-30) | ○ |
| C-114 | コンストラクタ null検証 | E-14 (L27) | ○ |
| C-115 | Load | E-14 (L44-58) | ○ |
| C-116 | Load 重複呼び出し | E-14 (L46-49) | ○ |
| C-117 | Load null Stream | E-14 (L51-54) | ○ |
| C-118 | Source プロパティ | E-14 (L17) | ○ |

### StreamConfigurationSource (UT-CFG-119)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | Stream プロパティ | E-15 (L17-18) | ○ |

### ReferenceCountedProviderManager (UT-CFG-120 〜 UT-CFG-127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120 | GetReference | E-16 (L21-38) | ○ |
| C-121 | GetReference Dispose後 | E-16 (L27-33) | ○ |
| C-122 | ReplaceProviders | E-16 (L41-59) | ○ |
| C-123 | ReplaceProviders Dispose後 | E-16 (L47-50) | ○ |
| C-124 | AddProvider | E-16 (L61-76) | ○ |
| C-125 | AddProvider Dispose後 | E-16 (L65-68) | ○ |
| C-126 | Dispose | E-16 (L78-91) | ○ |
| C-127 | NonReferenceCountedProviders | E-16 (L19) | ○ |

### ReferenceCountedProviders (UT-CFG-128 〜 UT-CFG-132)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 | Create | E-17 (L14) | ○ |
| C-129 | CreateDisposed | E-17 (L19) | ○ |
| C-130 | AddReference | E-17 (L60-65) | ○ |
| C-131 | Dispose refcount=0 | E-17 (L67-76) | ○ |
| C-132 | Dispose refcount>0 | E-17 (L69) | ○ |

### InternalConfigurationRootExtensions (UT-CFG-133 〜 UT-CFG-137)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | GetChildrenImplementation | E-18 (L21-41) | ○ |
| C-134 | GetChildrenImplementation with path | E-18 (L30) | ○ |
| C-135 | TryGetConfiguration | E-18 (L43-78) | ○ |
| C-136 | TryGetConfiguration 存在しない値 | E-18 (L76-77) | ○ |
| C-137 | TryGetConfiguration Dispose済みスキップ | E-18 (L62-68) | ○ |

### ConfigurationSectionDebugView (UT-CFG-138 〜 UT-CFG-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | FromConfiguration | E-19 (L43-69) | ○ |
| C-139 | GetValueProvider | E-19 (L71-82) | ○ |
| C-140 | GetValueProvider 存在しない値 | E-19 (L81) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべてのテストケースにソースコード根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいて作成されている

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度が適切か確認
- [ ] 境界値テストが十分にカバーされているか確認
- [ ] 例外処理のテストケースが網羅されているか確認
- [ ] スレッドセーフティに関するテストケース（ReferenceCountedProviders関連）の妥当性確認
- [ ] IDisposableパターンのテストケースが適切か確認
