---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 163
  claims_with_evidence: 163
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.DependencyInjection.Abstractions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：163 / 163、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全てのテストケースはソースコードから直接導出されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceDescriptor.cs`
- E-02: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceCollection.cs`
- E-03: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ActivatorUtilities.cs`
- E-04: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceProviderServiceExtensions.cs`
- E-05: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceProviderKeyedServiceExtensions.cs`
- E-06: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceCollectionServiceExtensions.cs`
- E-07: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceCollectionServiceExtensions.Keyed.cs`
- E-08: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/Extensions/ServiceCollectionDescriptorExtensions.cs`
- E-09: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/Extensions/ServiceCollectionDescriptorExtensions.Keyed.cs`
- E-10: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/AsyncServiceScope.cs`
- E-11: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceLifetime.cs`
- E-12: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceKeyLookupMode.cs`
- E-13: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/FromKeyedServicesAttribute.cs`
- E-14: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceKeyAttribute.cs`
- E-15: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ActivatorUtilitiesConstructorAttribute.cs`
- E-16: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IKeyedServiceProvider.cs`
- E-17: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IServiceCollection.cs`
- E-18: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IServiceScope.cs`
- E-19: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IServiceScopeFactory.cs`
- E-20: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IServiceProviderIsService.cs`
- E-21: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IServiceProviderIsKeyedService.cs`
- E-22: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ISupportRequiredService.cs`
- E-23: `src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IServiceProviderFactory.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ServiceDescriptor クラス (UT-DIA-001 - UT-DIA-029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ServiceDescriptor コンストラクタの正常系・異常系テスト | E-01 (L23-135) | ○ |
| C-02 | ImplementationType, KeyedImplementationType プロパティのテスト | E-01 (L152-183) | ○ |
| C-03 | ImplementationInstance, KeyedImplementationInstance プロパティのテスト | E-01 (L185-213) | ○ |
| C-04 | ImplementationFactory, KeyedImplementationFactory プロパティのテスト | E-01 (L215-243) | ○ |
| C-05 | IsKeyedService プロパティのテスト | E-01 (L248) | ○ |
| C-06 | 静的ファクトリメソッド (Transient, Scoped, Singleton) のテスト | E-01 (L360-956) | ○ |
| C-07 | Keyed静的ファクトリメソッドのテスト | E-01 (L376-918) | ○ |
| C-08 | GetImplementationType 内部メソッドのテスト | E-01 (L307-350) | ○ |
| C-09 | ToString メソッドのテスト | E-01 (L251-305) | ○ |

### ServiceCollection クラス (UT-DIA-030 - UT-DIA-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | ServiceCollection コンストラクタのテスト | E-02 (L16-19) | ○ |
| C-11 | Count, IsReadOnly プロパティのテスト | E-02 (L22-25) | ○ |
| C-12 | インデクサ (this[int]) のテスト | E-02 (L28-39) | ○ |
| C-13 | Clear, Contains, Remove メソッドのテスト | E-02 (L42-65) | ○ |
| C-14 | IndexOf, Insert, RemoveAt メソッドのテスト | E-02 (L85-102) | ○ |
| C-15 | MakeReadOnly メソッドのテスト | E-02 (L110-113) | ○ |
| C-16 | ReadOnly状態での操作例外テスト | E-02 (L115-124) | ○ |
| C-17 | GetEnumerator, CopyTo メソッドのテスト | E-02 (L68-71, L55-58) | ○ |

### ActivatorUtilities クラス (UT-DIA-051 - UT-DIA-065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | CreateInstance 正常系・異常系テスト | E-03 (L47-220) | ○ |
| C-19 | CreateInstance 抽象型エラーテスト | E-03 (L54-57) | ○ |
| C-20 | CreateInstance コンストラクタ選択ロジックテスト | E-03 (L83-166) | ○ |
| C-21 | ActivatorUtilitiesConstructorAttribute 優先テスト | E-03 (L92-115) | ○ |
| C-22 | CreateFactory メソッドテスト | E-03 (L273-296) | ○ |
| C-23 | CreateFactory<T> ジェネリック版テスト | E-03 (L310-329) | ○ |
| C-24 | GetServiceOrCreateInstance メソッドテスト | E-03 (L358-374) | ○ |

### ServiceProviderServiceExtensions クラス (UT-DIA-066 - UT-DIA-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | GetService<T> メソッドテスト | E-04 (L21-26) | ○ |
| C-26 | GetRequiredService メソッドテスト | E-04 (L35-52) | ○ |
| C-27 | GetRequiredService<T> ジェネリック版テスト | E-04 (L61-66) | ○ |
| C-28 | GetServices<T> メソッドテスト | E-04 (L74-79) | ○ |
| C-29 | GetServices (Type) メソッドテスト | E-04 (L88-95) | ○ |
| C-30 | CreateScope, CreateAsyncScope メソッドテスト | E-04 (L102-125) | ○ |

### ServiceProviderKeyedServiceExtensions クラス (UT-DIA-080 - UT-DIA-088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | GetKeyedService<T> メソッドテスト | E-05 (L22-32) | ○ |
| C-32 | GetKeyedService (Type) メソッドテスト | E-05 (L41-52) | ○ |
| C-33 | GetRequiredKeyedService メソッドテスト | E-05 (L62-73) | ○ |
| C-34 | GetRequiredKeyedService<T> ジェネリック版テスト | E-05 (L83-88) | ○ |
| C-35 | GetKeyedServices<T> メソッドテスト | E-05 (L97-102) | ○ |
| C-36 | GetKeyedServices (Type) メソッドテスト | E-05 (L112-119) | ○ |

### ServiceCollectionServiceExtensions クラス (UT-DIA-089 - UT-DIA-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | AddTransient メソッド群テスト | E-06 (L24-154) | ○ |
| C-38 | AddScoped メソッド群テスト | E-06 (L166-296) | ○ |
| C-39 | AddSingleton メソッド群テスト | E-06 (L309-483) | ○ |
| C-40 | Keyed版AddTransient, AddScoped, AddSingleton テスト | E-07 (L25-558) | ○ |

### ServiceCollectionDescriptorExtensions クラス (UT-DIA-104 - UT-DIA-127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | Add メソッドテスト | E-08 (L21-51) | ○ |
| C-42 | TryAdd メソッドテスト | E-08 (L59-97) | ○ |
| C-43 | TryAddTransient, TryAddScoped, TryAddSingleton テスト | E-08 (L105-433) | ○ |
| C-44 | TryAddEnumerable メソッドテスト | E-08 (L452-515) | ○ |
| C-45 | Replace メソッドテスト | E-08 (L524-544) | ○ |
| C-46 | RemoveAll メソッドテスト | E-08 (L551-576) | ○ |
| C-47 | Keyed版 TryAdd, RemoveAllKeyed メソッドテスト | E-09 (L19-411) | ○ |

### AsyncServiceScope 構造体 (UT-DIA-128 - UT-DIA-133)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | AsyncServiceScope コンストラクタテスト | E-10 (L22-28) | ○ |
| C-49 | ServiceProvider プロパティテスト | E-10 (L31) | ○ |
| C-50 | Dispose, DisposeAsync メソッドテスト | E-10 (L34-50) | ○ |

### 列挙型・属性 (UT-DIA-134 - UT-DIA-148)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | ServiceLifetime 列挙値テスト | E-11 (L9-26) | ○ |
| C-52 | ServiceKeyLookupMode 列挙値テスト | E-12 (L11-28) | ○ |
| C-53 | FromKeyedServicesAttribute テスト | E-13 (L14-48) | ○ |
| C-54 | KeyedService.AnyKey テスト | E-16 (L37-48) | ○ |
| C-55 | ActivatorUtilitiesConstructorAttribute 属性定義テスト | E-15 (L11-14) | ○ |
| C-56 | ServiceKeyAttribute 属性定義テスト | E-14 (L12-15) | ○ |

### インターフェース (UT-DIA-149 - UT-DIA-163)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | IServiceProviderIsService インターフェーステスト | E-20 (L11-19) | ○ |
| C-58 | IServiceProviderIsKeyedService インターフェーステスト | E-21 (L12-22) | ○ |
| C-59 | IServiceScopeFactory インターフェーステスト | E-19 (L10-24) | ○ |
| C-60 | IServiceScope インターフェーステスト | E-18 (L17-23) | ○ |
| C-61 | IKeyedServiceProvider インターフェーステスト | E-16 (L11-32) | ○ |
| C-62 | ISupportRequiredService インターフェーステスト | E-22 (L12-22) | ○ |
| C-63 | IServiceProviderFactory インターフェーステスト | E-23 (L11-26) | ○ |
| C-64 | IServiceCollection インターフェース継承テスト | E-17 (L9-13) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコードから直接導出されています
  - .NET Runtime の Microsoft.Extensions.DependencyInjection.Abstractions ライブラリの全publicクラス・メソッドを網羅

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接導出されている
- 注意点：
  - 本モジュールは抽象化層であり、実際のDI実装は Microsoft.Extensions.DependencyInjection に依存
  - インターフェースのテストは実装クラスのモックが必要
  - ActivatorUtilities のテストは複雑なコンストラクタ選択ロジックを含む

## 6) レビュアーチェックリスト（最小）
- [ ] ServiceDescriptor のKeyed/非Keyed切り替えロジックが正しくテストされているか
- [ ] ActivatorUtilities のコンストラクタ選択優先度（属性 > 引数マッチ > デフォルト）が網羅されているか
- [ ] ServiceCollection の ReadOnly 状態でのエラーハンドリングが網羅されているか
- [ ] TryAdd 系メソッドの重複チェックロジック（ServiceType + ServiceKey の組み合わせ）が正しいか
- [ ] TryAddEnumerable の実装型チェック（object型/ServiceType同一を拒否）が正しいか
- [ ] AsyncServiceScope の IAsyncDisposable 対応/非対応両方のパターンがテストされているか
- [ ] 各拡張メソッドの null チェック (ArgumentNullException) が網羅されているか
