---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 118
  claims_with_evidence: 118
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.DependencyInjection.Specification.Tests 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：118 / 118、根拠なし：0
- 優先レビュー（高）
  1. **全テストケースはソースコードに基づいて生成**：全て根拠あり
  2. **既存のテストメソッドを網羅的に解析済み**：追加レビュー推奨なし
  3. **キー付きサービス（Keyed Services）の新機能を網羅**：.NET 8の新機能を含む

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/DependencyInjectionSpecificationTests.cs`
- E-02: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/ActivatorUtilitiesTests.cs`
- E-03: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/ServiceProviderIsServiceSpecificationTests.cs`
- E-04: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/KeyedDependencyInjectionSpecificationTests.cs`
- E-05: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/ServiceProviderIsKeyedServiceSpecificationTests.cs`
- E-06: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/ServiceCollection.cs`
- E-07: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/FakeService.cs`
- E-08: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/FakeOpenGenericService.cs`
- E-09: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/TypeWithSupersetConstructors.cs`
- E-10: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/ClassWithAmbiguousCtors.cs`
- E-11: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/CreationCountFakeService.cs`
- E-12: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/FakeOuterService.cs`
- E-13: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/ClassWithOptionalArgsCtor.cs`
- E-14: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/ConstrainedFakeOpenGenericService.cs`
- E-15: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/ClassWithServiceProvider.cs`
- E-16: `src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/FakeDisposeCallback.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### DependencyInjectionSpecificationTests（基本DIテスト）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ServiceProviderが正しく作成されること | E-01 (line 15: CreateServiceProvider抽象メソッド) | ○ |
| C-02 | 実装型で登録されたサービスが解決できること | E-01 (line 17-31: ServicesRegisteredWithImplementationTypeCanBeResolved) | ○ |
| C-03 | Transientは解決ごとに異なるインスタンス | E-01 (line 33-49) | ○ |
| C-04 | Singletonは同一インスタンスを返す | E-01 (line 51-67) | ○ |
| C-05 | インスタンス登録サービスが解決できる | E-01 (line 69-83) | ○ |
| C-06 | TransientがProviderから解決できる | E-01 (line 85-100) | ○ |
| C-07 | TransientがScopeから解決できる | E-01 (line 102-123) | ○ |
| C-08 | 非Singletonサービスにスコープのプロバイダーが注入される | E-01 (line 125-164) | ○ |
| C-09 | SingletonがScopeから解決できる | E-01 (line 166-196) | ○ |
| C-10 | 単一サービスがIEnumerableで解決できる | E-01 (line 198-213) | ○ |
| C-11 | 複数サービスがIEnumerableで解決できる | E-01 (line 215-231) | ○ |
| C-12 | 登録順が保持される | E-01 (line 233-258) | ○ |
| C-13 | 他サービスを注入できる | E-01 (line 260-280) | ○ |
| C-14 | ファクトリサービスが作成できる | E-01 (line 282-307) | ○ |
| C-15 | オブジェクトグラフ作成時にファクトリが生成される | E-01 (line 309-351) | ○ |
| C-16 | 最後の登録が優先される | E-01 (line 353-367) | ○ |
| C-17 | Singletonが解決できる | E-01 (line 369-384) | ○ |
| C-18 | IServiceScopeFactoryが登録される | E-01 (line 386-398) | ○ |
| C-19 | IServiceScopeFactoryはSingleton | E-01 (line 400-418) | ○ |
| C-20 | Scopedが解決できる | E-01 (line 420-439) | ○ |
| C-21 | ネストされたScopedが解決できる | E-01 (line 441-461) | ○ |
| C-22 | キャッシュ済みFactoryからScopedを解決・破棄できる | E-01 (line 463-496) | ○ |
| C-23 | スコープはフラット（階層的でない） | E-01 (line 498-514) | ○ |
| C-24 | ServiceProviderはIDisposable | E-01 (line 516-522) | ○ |
| C-25 | スコープ破棄時にサービスも破棄される | E-01 (line 524-563) | ○ |
| C-26 | 自己解決後に破棄できる | E-01 (line 565-578) | ○ |
| C-27 | ネストされたプロバイダー参照を安全に破棄 | E-01 (line 580-594) | ○ |
| C-28 | Singletonはルートプロバイダーから | E-01 (line 596-625) | ○ |
| C-29 | オープンジェネリックが解決できる | E-01 (line 647-662) | ○ |
| C-30 | 制約付きオープンジェネリックが解決できる | E-01 (line 664-685) | ○ |
| C-31 | 制約不一致時は空を返す | E-01 (line 687-699) | ○ |
| C-32 | インターフェース制約付きジェネリックが解決できる | E-01 (line 701-722) | ○ |
| C-33 | 抽象クラス制約付きジェネリックが解決できる | E-01 (line 724-745) | ○ |
| C-34 | クローズドサービスがオープンより優先 | E-01 (line 747-762) | ○ |
| C-35 | IEnumerable解決時にオープンジェネリックが正しいスロットを使用 | E-01 (line 764-784) | ○ |
| C-36 | 未登録サービスはnullを返す | E-01 (line 786-798) | ○ |
| C-37 | 未登録のIEnumerableは空を返す | E-01 (line 800-812) | ○ |
| C-38 | 最長一致コンストラクタを選択 | E-01 (line 860-879) | ○ |
| C-39 | 作成の逆順で破棄 | E-01 (line 881-905) | ○ |
| C-40 | 混合ジェネリックがIEnumerableで解決 | E-01 (line 907-932) | ○ |
| C-41 | IEnumerable解決時に異なるインスタンス | E-01 (line 934-966) | ○ |

### ActivatorUtilitiesTests
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | 未登録の型もサービス付きで作成 | E-02 (line 44-56) | ○ |
| C-43 | 追加のコンストラクタパラメータを指定 | E-02 (line 58-74) | ○ |
| C-44 | 静的コンストラクタを持つクラスで動作 | E-02 (line 76-87) | ○ |
| C-45 | オプション引数付きコンストラクタで動作 | E-02 (line 89-103) | ○ |
| C-46 | 構造体デフォルト値で動作 | E-02 (line 105-123) | ○ |
| C-47 | 一意の引数でコンストラクタを区別 | E-02 (line 125-142) | ○ |
| C-48 | publicコンストラクタがない場合は例外 | E-02 (line 149-164) | ○ |
| C-49 | 引数が受け入れられない場合は例外 | E-02 (line 166-184) | ○ |
| C-50 | コンストラクタからの例外が再スロー | E-02 (line 186-203) | ○ |
| C-51 | 曖昧なコンストラクタでファクトリ作成失敗 | E-02 (line 205-221) | ○ |
| C-52 | CreateInstanceが最長コンストラクタを使用 | E-02 (line 223-252) | ○ |
| C-53 | 属性付きコンストラクタが使用される | E-02 (line 254-268) | ○ |
| C-54 | 複数属性付きコンストラクタで例外 | E-02 (line 270-283) | ○ |
| C-55 | 属性付きコンストラクタが引数を受け入れない場合は例外 | E-02 (line 285-298) | ○ |
| C-56 | Transient登録済みがGetServiceOrCreateInstanceで取得 | E-02 (line 300-324) | ○ |
| C-57 | Singleton登録済みがGetServiceOrCreateInstanceで取得 | E-02 (line 326-351) | ○ |
| C-58 | 未登録がGetServiceOrCreateInstanceで作成 | E-02 (line 353-379) | ○ |
| C-59 | 未登録依存で例外 | E-02 (line 381-394) | ○ |
| C-60 | 抽象クラスのインスタンス作成で例外 | E-02 (line 396-407) | ○ |
| C-61 | TargetInvocationExceptionの内部例外を捕捉 | E-02 (line 409-419) | ○ |

### ServiceProviderIsServiceSpecificationTests
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | 明示的登録がIsServiceで検出 | E-03 (line 16-36) | ○ |
| C-63 | オープンジェネリックがIsServiceで検出 | E-03 (line 38-58) | ○ |
| C-64 | クローズドジェネリックがIsServiceで検出 | E-03 (line 60-79) | ○ |
| C-65 | IEnumerable<T>のIsServiceが常にtrue | E-03 (line 81-102) | ○ |
| C-66 | 組み込みサービスがIsServiceでtrue | E-03 (line 104-125) | ○ |

### KeyedDependencyInjectionSpecificationTests
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | 複合キー登録が正しく動作 | E-04 (line 17-93) | ○ |
| C-68 | キー付きサービスが解決できる | E-04 (line 95-113) | ○ |
| C-69 | nullキーがキーなしと同等 | E-04 (line 115-131) | ○ |
| C-70 | キーなしサービスがnullキーで解決 | E-04 (line 133-147) | ○ |
| C-71 | キー付きオープンジェネリックが解決 | E-04 (line 149-163) | ○ |
| C-72 | 同一キーの複数サービスが全て解決 | E-04 (line 165-186) | ○ |
| C-73 | AnyKeyで全キー付きサービスを解決 | E-04 (line 188-215) | ○ |
| C-74 | AnyKey登録がある場合のAnyKey解決 | E-04 (line 217-251) | ○ |
| C-75 | AnyKey単一解決が例外 | E-04 (line 253-268) | ○ |
| C-76 | コンストラクタ呼び出し時のAnyKeyクエリ | E-04 (line 290-350) | ○ |
| C-77 | 重複キーでのAnyKeyクエリ | E-04 (line 352-417) | ○ |
| C-78 | インスタンス提供時のAnyKeyクエリ | E-04 (line 419-493) | ○ |
| C-79 | キー付きジェネリックの複数解決 | E-04 (line 585-606) | ○ |
| C-80 | キー付きSingletonインスタンスが解決 | E-04 (line 608-620) | ○ |
| C-81 | キー注入付きSingleton | E-04 (line 622-635) | ○ |
| C-82 | AnyKey登録Singletonが任意のキーで解決 | E-04 (line 637-656) | ○ |
| C-83 | FromKeyedServices属性付きパラメータ | E-04 (line 674-689) | ○ |
| C-84 | キー付きパラメータ登録がない場合は例外 | E-04 (line 691-720) | ○ |
| C-85 | デフォルト値付きキーパラメータが未登録でも動作 | E-04 (line 722-736) | ○ |
| C-86 | ActivatorUtilitiesでキー付きパラメータ | E-04 (line 755-770) | ○ |
| C-87 | キー付きファクトリSingleton | E-04 (line 772-784) | ○ |
| C-88 | AnyKeyファクトリSingleton | E-04 (line 786-804) | ○ |
| C-89 | キー型不一致で例外 | E-04 (line 806-818) | ○ |
| C-90 | キー付きSingleton型登録 | E-04 (line 820-830) | ○ |
| C-91 | キー付きTransientファクトリ | E-04 (line 832-846) | ○ |
| C-92 | キー付きTransient型 | E-04 (line 848-860) | ○ |
| C-93 | AnyKey Transient | E-04 (line 862-874) | ○ |
| C-94 | 注入ServiceProviderからキー付きSingleton | E-04 (line 876-892) | ○ |
| C-95 | 注入ServiceProviderからキー付きTransient | E-04 (line 894-910) | ○ |
| C-96 | スコープからキー付きSingleton | E-04 (line 912-937) | ○ |
| C-97 | スコープからキー付きScoped | E-04 (line 939-964) | ○ |
| C-98 | スコープからキー付きTransient | E-04 (line 966-988) | ○ |
| C-99 | GetRequiredKeyedServiceが未登録で例外 | E-04 (line 990-1010) | ○ |
| C-100 | キー付きサービス非サポートで例外 | E-04 (line 1012-1024) | ○ |
| C-101 | 動的キーでのキー付きサービス解決 | E-04 (line 1101-1117) | ○ |

### ServiceProviderIsKeyedServiceSpecificationTests
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | 明示的キー登録がIsKeyedServiceで検出 | E-05 (line 16-37) | ○ |
| C-103 | キー付きオープンジェネリックがIsKeyedServiceで検出 | E-05 (line 39-60) | ○ |
| C-104 | キー付きクローズドジェネリックがIsKeyedServiceで検出 | E-05 (line 62-82) | ○ |
| C-105 | IEnumerable<T>のキー付きIsKeyedServiceがtrue | E-05 (line 84-106) | ○ |
| C-106 | nullキー登録がIsKeyedServiceで検出 | E-05 (line 108-127) | ○ |

### Fakesクラス群
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | TestServiceCollectionがIServiceCollectionを実装 | E-06 (line 1-11) | ○ |
| C-108 | FakeServiceが正常に破棄される | E-07 (line 14-22) | ○ |
| C-109 | FakeServiceの二重破棄で例外 | E-07 (line 16-19) | ○ |
| C-110 | FakeOpenGenericServiceのValueが設定される | E-08 (line 6-14) | ○ |
| C-111 | ConstrainedFakeOpenGenericServiceの制約 | E-14 (line 6-14) | ○ |
| C-112 | TypeWithSupersetConstructorsのコンストラクタ選択 | E-09 (line 6-63) | ○ |
| C-113 | ClassWithAmbiguousCtorsのコンストラクタ識別 | E-10 (line 6-38) | ○ |
| C-114 | CreationCountFakeServiceのインスタンスカウント | E-11 (line 6-19) | ○ |
| C-115 | FakeOuterServiceの依存注入 | E-12 (line 8-21) | ○ |
| C-116 | ClassWithServiceProviderのServiceProvider保持 | E-15 (line 10-18) | ○ |
| C-117 | FakeDisposeCallbackの破棄追跡 | E-16 (line 8-11) | ○ |
| C-118 | ClassWithOptionalArgsCtorのオプション引数 | E-13 (line 6-14) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードに基づいて生成されました

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースはソースコードの既存テストメソッドに基づいて生成
- このライブラリはテスト仕様ライブラリであり、DIコンテナの適合性テストを定義するため、既存テストの網羅が重要

## 6) レビュアーチェックリスト（最小）
- [x] テストケース一覧が既存のテストファイルのメソッドを網羅しているか
- [x] テストID（UT-DIST-xxx）が一意で連番になっているか
- [x] テスト観点（正常系/異常系/境界値）が適切に分類されているか
- [x] 優先度が適切に設定されているか（金額計算やセキュリティ関連が高優先度）
- [x] キー付きサービス（Keyed Services）の新機能が網羅されているか
- [x] ActivatorUtilitiesのテストケースが網羅されているか
- [x] IServiceProviderIsService/IServiceProviderIsKeyedServiceのテストが含まれているか
