---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 128
  claims_with_evidence: 128
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.DependencyInjection 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：128 / 128、根拠なし：0
- 優先レビュー（高）
  1. **特になし**：すべてのテストケースはソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceProvider.cs`
- E-02: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceProviderOptions.cs`
- E-03: `src/libraries/Microsoft.Extensions.DependencyInjection/src/DefaultServiceProviderFactory.cs`
- E-04: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceCollectionContainerBuilderExtensions.cs`
- E-05: `src/libraries/Microsoft.Extensions.DependencyInjection/src/CallSiteJsonFormatter.cs`
- E-06: `src/libraries/Microsoft.Extensions.DependencyInjection/src/DependencyInjectionEventSource.cs`
- E-07: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/CallSiteFactory.cs`
- E-08: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ServiceProviderEngineScope.cs`
- E-09: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/CallSiteRuntimeResolver.cs`
- E-10: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/CallSiteValidator.cs`
- E-11: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ServiceIdentifier.cs`
- E-12: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/CallSiteChain.cs`
- E-13: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/CallSiteVisitor.cs`
- E-14: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ServiceCallSite.cs`
- E-15: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ConstructorCallSite.cs`
- E-16: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ConstantCallSite.cs`
- E-17: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/FactoryCallSite.cs`
- E-18: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/IEnumerableCallSite.cs`
- E-19: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ResultCache.cs`
- E-20: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ServiceCacheKey.cs`
- E-21: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/DynamicServiceProviderEngine.cs`
- E-22: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/StackGuard.cs`
- E-23: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ThrowHelper.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ServiceProvider関連 (UT-DI-001 - UT-DI-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetServiceで登録済みサービスが解決される | E-01 (L103-104: GetServiceメソッド) | ○ |
| C-02 | Dispose後のGetServiceでObjectDisposedExceptionがスロー | E-01 (L207-209: _disposed check, ThrowHelper) | ○ |
| C-03 | 未登録サービスでnullが返却される | E-01 (L258: RealizedService が null を返す) | ○ |
| C-04 | キー付きサービスが正しく解決される | E-01 (L114-128: GetKeyedService) | ○ |
| C-05 | AnyKeyで非IEnumerable解決時にInvalidOperationException | E-01 (L119-124: AnyKey check) | ○ |
| C-06 | GetRequiredKeyedServiceでキー付きサービス解決 | E-01 (L139-150: GetRequiredKeyedService) | ○ |
| C-07 | 未登録キー付きサービスでInvalidOperationException | E-01 (L154-164: service null check) | ○ |
| C-08 | Disposeでリソース解放 | E-01 (L173-177: Dispose) | ○ |
| C-09 | DisposeAsyncでリソース解放 | E-01 (L180-184: DisposeAsync) | ○ |
| C-10 | CreateScopeで新しいスコープ作成 | E-01 (L270-278: CreateScope) | ○ |
| C-11 | Dispose後のCreateScopeでObjectDisposedException | E-01 (L272-275: _disposed check) | ○ |
| C-12 | ValidateScopesオプションでスコープ検証有効化 | E-01 (L68-71: _callSiteValidator) | ○ |
| C-13 | ValidateOnBuildオプションでビルド時検証 | E-01 (L73-93: ValidateOnBuild) | ○ |
| C-14 | ValidateOnBuildで無効サービス時AggregateException | E-01 (L89-92: AggregateException) | ○ |

### ServiceProviderOptions関連 (UT-DI-015 - UT-DI-016)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | ValidateScopesプロパティの設定・取得 | E-02 (L19: ValidateScopes property) | ○ |
| C-16 | ValidateOnBuildプロパティの設定・取得 | E-02 (L27: ValidateOnBuild property) | ○ |

### DefaultServiceProviderFactory関連 (UT-DI-017 - UT-DI-021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | デフォルトコンストラクタで初期化 | E-03 (L19-22: constructor) | ○ |
| C-18 | オプション付きコンストラクタで初期化 | E-03 (L29-32: constructor with options) | ○ |
| C-19 | nullオプションでArgumentNullException | E-03 (L31: throw ArgumentNullException) | ○ |
| C-20 | CreateBuilderで入力がそのまま返却 | E-03 (L35-38: CreateBuilder) | ○ |
| C-21 | CreateServiceProviderでIServiceProvider作成 | E-03 (L41-44: CreateServiceProvider) | ○ |

### ServiceCollectionContainerBuilderExtensions関連 (UT-DI-022 - UT-DI-026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | BuildServiceProvider()でデフォルトオプション使用 | E-04 (L18-21: BuildServiceProvider) | ○ |
| C-23 | BuildServiceProvider(bool)でvalidateScopes設定 | E-04 (L32-35: BuildServiceProvider with bool) | ○ |
| C-24 | BuildServiceProvider(options)でオプション適用 | E-04 (L46-52: BuildServiceProvider with options) | ○ |
| C-25 | nullのservicesでArgumentNullException | E-04 (L48: ThrowIfNull services) | ○ |
| C-26 | nullのoptionsでArgumentNullException | E-04 (L49: ThrowIfNull options) | ○ |

### CallSiteFactory関連 (UT-DI-027 - UT-DI-040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | サービス記述子からCallSiteFactory初期化 | E-07 (L24-31: constructor) | ○ |
| C-28 | 登録済みサービスのCallSite取得 | E-07 (L162-164: GetCallSite) | ○ |
| C-29 | 未登録サービスでnull返却 | E-07 (L201-206: TryCreateExact/TryCreateOpenGeneric/TryCreateEnumerable) | ○ |
| C-30 | オープンジェネリックのCallSite作成 | E-07 (L229-251: TryCreateOpenGeneric) | ○ |
| C-31 | IEnumerableのCallSite作成 | E-07 (L253-457: TryCreateEnumerable) | ○ |
| C-32 | IsServiceで登録済みサービス確認 | E-07 (L782-821: IsService) | ○ |
| C-33 | IsServiceで未登録サービスfalse | E-07 (L782-821: IsService return false) | ○ |
| C-34 | IsServiceでオープンジェネリック型定義false | E-07 (L792-796: IsGenericTypeDefinition) | ○ |
| C-35 | IsServiceでIServiceProviderはtrue | E-07 (L817: typeof(IServiceProvider)) | ○ |
| C-36 | IsServiceでIServiceScopeFactoryはtrue | E-07 (L818: typeof(IServiceScopeFactory)) | ○ |
| C-37 | IsKeyedServiceでキー付きサービス確認 | E-07 (L784: IsKeyedService) | ○ |
| C-38 | オープンジェネリックにクローズド実装でArgumentException | E-07 (L44-49: OpenGenericServiceRequiresOpenGenericImplementation) | ○ |
| C-39 | 抽象クラス実装でArgumentException | E-07 (L51-55: TypeCannotBeActivated) | ○ |
| C-40 | インターフェース実装でArgumentException | E-07 (L51-55: TypeCannotBeActivated) | ○ |

### ServiceProviderEngineScope関連 (UT-DI-041 - UT-DI-052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | スコープ内でサービス解決 | E-08 (L43-51: GetService) | ○ |
| C-42 | Dispose後にObjectDisposedException | E-08 (L45-48: _disposed check) | ○ |
| C-43 | スコープ内でキー付きサービス解決 | E-08 (L53-61: GetKeyedService) | ○ |
| C-44 | スコープ内で必須キー付きサービス解決 | E-08 (L63-71: GetRequiredKeyedService) | ○ |
| C-45 | GetRequiredKeyedServiceでDispose後ObjectDisposedException | E-08 (L65-68: _disposed check) | ○ |
| C-46 | DisposeでIDisposableサービスがDispose | E-08 (L120-138: Dispose) | ○ |
| C-47 | IAsyncDisposableのみ実装でInvalidOperationException | E-08 (L134: AsyncDisposableServiceDispose) | ○ |
| C-48 | DisposeAsyncでIAsyncDisposableがDisposeAsync | E-08 (L140-197: DisposeAsync) | ○ |
| C-49 | CaptureDisposableでIDisposableキャプチャ | E-08 (L78-118: CaptureDisposable) | ○ |
| C-50 | 非IDisposableはキャプチャされない | E-08 (L80: IDisposable/IAsyncDisposable check) | ○ |
| C-51 | Dispose後のCaptureDisposableでObjectDisposedException | E-08 (L88-114: disposed check) | ○ |
| C-52 | CreateScopeで新しいスコープ作成 | E-08 (L75: CreateScope) | ○ |

### CallSiteRuntimeResolver関連 (UT-DI-053 - UT-DI-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | ResolveでCallSiteからサービス解決 | E-09 (L22-34: Resolve) | ○ |
| C-54 | VisitConstructorでコンストラクタ呼び出し | E-09 (L41-71: VisitConstructor) | ○ |
| C-55 | VisitConstantで定数値返却 | E-09 (L153-156: VisitConstant) | ○ |
| C-56 | VisitServiceProviderでスコープ返却 | E-09 (L158-161: VisitServiceProvider) | ○ |
| C-57 | VisitIEnumerableで配列生成 | E-09 (L163-184: VisitIEnumerable) | ○ |
| C-58 | VisitFactoryでファクトリ実行 | E-09 (L186-189: VisitFactory) | ○ |
| C-59 | VisitRootCacheでシングルトンキャッシュ | E-09 (L73-101: VisitRootCache) | ○ |
| C-60 | VisitScopeCacheでスコープキャッシュ | E-09 (L103-110: VisitScopeCache) | ○ |

### CallSiteValidator関連 (UT-DI-061 - UT-DI-065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | ValidateCallSiteで有効なCallSite検証パス | E-10 (L15: ValidateCallSite) | ○ |
| C-62 | ValidateResolutionでスコープ内解決検証パス | E-10 (L17-37: ValidateResolution) | ○ |
| C-63 | ルートスコープからScopedサービスでInvalidOperationException | E-10 (L26-35: DirectScopedResolvedFromRootException) | ○ |
| C-64 | シングルトンがScopedに依存でInvalidOperationException | E-10 (L54-62: ScopedInSingletonException) | ○ |
| C-65 | IServiceScopeFactory依存は許可 | E-10 (L98-102: IServiceScopeFactory special case) | ○ |

### CallSiteChain関連 (UT-DI-066 - UT-DI-069)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | CheckCircularDependencyで循環依存なし時は例外なし | E-12 (L20-26: CheckCircularDependency) | ○ |
| C-67 | 循環依存ありでInvalidOperationException | E-12 (L22-25: ContainsKey check, throw) | ○ |
| C-68 | Addでサービスがチェーンに追加 | E-12 (L33-36: Add) | ○ |
| C-69 | Removeでサービスがチェーンから削除 | E-12 (L28-31: Remove) | ○ |

### ServiceIdentifier関連 (UT-DI-070 - UT-DI-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | constructor(Type)でサービス型のみ初期化 | E-11 (L15-18: constructor) | ○ |
| C-71 | constructor(object?, Type)でキーとサービス型初期化 | E-11 (L20-24: constructor) | ○ |
| C-72 | FromDescriptorでServiceIdentifier作成 | E-11 (L26-27: FromDescriptor) | ○ |
| C-73 | FromServiceTypeでServiceIdentifier作成 | E-11 (L29: FromServiceType) | ○ |
| C-74 | Equalsで同一型・同一キーでtrue | E-11 (L31-42: Equals) | ○ |
| C-75 | Equalsで異なる型でfalse | E-11 (L35: ServiceType check) | ○ |
| C-76 | Equalsで同一型・異なるキーでfalse | E-11 (L39: ServiceKey.Equals check) | ○ |
| C-77 | GetHashCodeでキーなし時ServiceType.GetHashCode | E-11 (L51-53: GetHashCode) | ○ |
| C-78 | GetHashCodeでキーあり時複合ハッシュ | E-11 (L54-58: combined hash) | ○ |
| C-79 | GetGenericTypeDefinitionでジェネリック型定義取得 | E-11 (L61: GetGenericTypeDefinition) | ○ |

### ServiceCacheKey関連 (UT-DI-080 - UT-DI-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | constructor(ServiceIdentifier, int)で初期化 | E-20 (L35-39: constructor) | ○ |
| C-81 | Equalsで同一ServiceIdentifier・同一Slotでtrue | E-20 (L44-45: Equals) | ○ |
| C-82 | Equalsで異なるSlotでfalse | E-20 (L45: Slot check) | ○ |

### ResultCache関連 (UT-DI-083 - UT-DI-086)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | SingletonライフタイムでLocation=Root | E-19 (L27-29: Singleton case) | ○ |
| C-84 | ScopedライフタイムでLocation=Scope | E-19 (L30-32: Scoped case) | ○ |
| C-85 | TransientライフタイムでLocation=Dispose | E-19 (L33-35: Transient case) | ○ |
| C-86 | NoneでLocation=None | E-19 (L11-15: None static method) | ○ |

### ConstructorCallSite関連 (UT-DI-087 - UT-DI-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | constructorでサービス型とコンストラクタ情報で初期化 | E-15 (L14-28: constructors) | ○ |
| C-88 | 不整合なserviceTypeとconstructorInfoでArgumentException | E-15 (L20-23: IsAssignableFrom check) | ○ |
| C-89 | ServiceTypeが正しく返却 | E-15 (L30: ServiceType property) | ○ |
| C-90 | ImplementationTypeでDeclaringType返却 | E-15 (L32: ImplementationType property) | ○ |

### ConstantCallSite関連 (UT-DI-091 - UT-DI-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | constructorでサービス型とデフォルト値で初期化 | E-16 (L13-22: constructor) | ○ |
| C-92 | nullのserviceTypeでArgumentNullException | E-16 (L15: throw ArgumentNullException) | ○ |
| C-93 | 型不整合のdefaultValueでArgumentException | E-16 (L16-19: IsInstanceOfType check) | ○ |
| C-94 | DefaultValueで設定された値が返却 | E-16 (L11: DefaultValue property) | ○ |

### FactoryCallSite関連 (UT-DI-095 - UT-DI-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | constructorでファクトリ関数で初期化 | E-17 (L12-17: constructor) | ○ |
| C-96 | キー付きファクトリ関数で初期化 | E-17 (L18-22: keyed constructor) | ○ |
| C-97 | ImplementationTypeでnull返却 | E-17 (L25: ImplementationType) | ○ |

### IEnumerableCallSite関連 (UT-DI-098 - UT-DI-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | constructorでアイテム型とCallSite配列で初期化 | E-18 (L16-22: constructor) | ○ |
| C-99 | ServiceTypeでIEnumerable<T>型返却 | E-18 (L27: ServiceType property) | ○ |
| C-100 | ImplementationTypeで配列型返却 | E-18 (L32: ImplementationType property) | ○ |

### StackGuard関連 (UT-DI-101 - UT-DI-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | TryEnterOnCurrentStackで十分なスタック時true | E-22 (L17-33: TryEnterOnCurrentStack) | ○ |
| C-102 | スタック不足でfalse | E-22 (L35-38: return false) | ○ |
| C-103 | 最大実行スタック超過でInsufficientExecutionStackException | E-22 (L40: throw InsufficientExecutionStackException) | ○ |
| C-104 | RunOnEmptyStackで新しいスタック実行 | E-22 (L43-84: RunOnEmptyStack) | ○ |

### ThrowHelper関連 (UT-DI-105 - UT-DI-108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | ThrowObjectDisposedExceptionでObjectDisposedException | E-23 (L14-17: ThrowObjectDisposedException) | ○ |
| C-106 | ThrowInvalidOperationException_KeyedServiceAnyKeyでInvalidOperationException | E-23 (L19-24: method) | ○ |
| C-107 | ThrowInvalidOperationException_NoServiceRegisteredでInvalidOperationException | E-23 (L26-31: method) | ○ |
| C-108 | ThrowInvalidOperationException_NoKeyedServiceRegisteredでInvalidOperationException | E-23 (L33-39: method) | ○ |

### DynamicServiceProviderEngine関連 (UT-DI-109 - UT-DI-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | RealizeServiceで初回呼び出しはランタイム解決 | E-21 (L28: CallSiteRuntimeResolver.Instance.Resolve) | ○ |
| C-110 | 2回目呼び出し後にコンパイル済みアクセサ置換 | E-21 (L30-47: Interlocked.Increment, ThreadPool.UnsafeQueueUserWorkItem) | ○ |

### CallSiteJsonFormatter関連 (UT-DI-111 - UT-DI-115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | FormatでCallSiteがJSON形式フォーマット | E-05 (L18-26: Format) | ○ |
| C-112 | VisitConstructorでimplementationType含むJSON | E-05 (L28-46: VisitConstructor) | ○ |
| C-113 | VisitConstantでvalue含むJSON | E-05 (L72-77: VisitConstant) | ○ |
| C-114 | VisitIEnumerableでitemType, size, items含むJSON | E-05 (L84-102: VisitIEnumerable) | ○ |
| C-115 | VisitFactoryでmethod含むJSON | E-05 (L104-109: VisitFactory) | ○ |

### DependencyInjectionEventSource関連 (UT-DI-116 - UT-DI-121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | ServiceProviderBuiltイベント発火 | E-06 (L151-167: ServiceProviderBuilt) | ○ |
| C-117 | ServiceResolvedイベント発火 | E-06 (L105-111: ServiceResolved) | ○ |
| C-118 | CallSiteBuiltイベント発火 | E-06 (L114-130: CallSiteBuilt) | ○ |
| C-119 | ScopeDisposedイベント発火 | E-06 (L76-80: ScopeDisposed) | ○ |
| C-120 | ServiceRealizationFailedイベント発火 | E-06 (L142-148: ServiceRealizationFailed) | ○ |
| C-121 | ServiceProviderDisposedでプロバイダリストから削除 | E-06 (L170-189: ServiceProviderDisposed) | ○ |

### CallSiteVisitor関連 (UT-DI-122 - UT-DI-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | VisitCallSiteでキャッシュロケーションに応じたメソッド呼び出し | E-13 (L17-37: VisitCallSite) | ○ |
| C-123 | VisitCallSiteMainでCallSiteKindに応じたメソッド呼び出し | E-13 (L39-56: VisitCallSiteMain) | ○ |
| C-124 | スタック不足時にRunOnEmptyStackで実行 | E-13 (L19-22: _stackGuard.RunOnEmptyStack) | ○ |

### ServiceCallSite関連 (UT-DI-125 - UT-DI-128)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | IDisposable実装型でCaptureDisposable=true | E-14 (L26-29: CaptureDisposable) | ○ |
| C-126 | IAsyncDisposable実装型でCaptureDisposable=true | E-14 (L29: IAsyncDisposable.IsAssignableFrom) | ○ |
| C-127 | ImplementationType=nullでCaptureDisposable=true | E-14 (L27: ImplementationType == null) | ○ |
| C-128 | Disposable非実装型でCaptureDisposable=false | E-14 (L26-29: IsAssignableFrom returns false) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし：すべてのテストケースはソースコードの実装に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースはソースコードから直接導出されており、根拠が明確です

## 6) レビュアーチェックリスト（最小）
- [ ] ServiceProvider関連テストケース（UT-DI-001 - UT-DI-014）の入力値・期待結果が適切か
- [ ] スコープ検証関連テストケース（UT-DI-061 - UT-DI-065）の境界条件が網羅されているか
- [ ] 循環依存検出テストケース（UT-DI-066 - UT-DI-067）のシナリオが十分か
- [ ] Keyed Services関連テストケースでAnyKeyの扱いが適切か
- [ ] Dispose関連テストケースで非同期Disposeの順序が正しいか
- [ ] 優先度「高」のテストケースが重要な機能をカバーしているか
