---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 191
  claims_with_evidence: 191
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.DependencyModel 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードから根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象クラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：191 / 191、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースはソースコードから直接抽出したため、根拠不足の項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContext.cs`
- E-02: `src/libraries/Microsoft.Extensions.DependencyModel/src/Library.cs`
- E-03: `src/libraries/Microsoft.Extensions.DependencyModel/src/RuntimeLibrary.cs`
- E-04: `src/libraries/Microsoft.Extensions.DependencyModel/src/CompilationLibrary.cs`
- E-05: `src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContextLoader.cs`
- E-06: `src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContextJsonReader.cs`
- E-07: `src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContextWriter.cs`
- E-08: `src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContextExtensions.cs`
- E-09: `src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContextPaths.cs`
- E-10: `src/libraries/Microsoft.Extensions.DependencyModel/src/CompilationOptions.cs`
- E-11: `src/libraries/Microsoft.Extensions.DependencyModel/src/TargetInfo.cs`
- E-12: `src/libraries/Microsoft.Extensions.DependencyModel/src/Dependency.cs`
- E-13: `src/libraries/Microsoft.Extensions.DependencyModel/src/RuntimeAssetGroup.cs`
- E-14: `src/libraries/Microsoft.Extensions.DependencyModel/src/RuntimeFallbacks.cs`
- E-15: `src/libraries/Microsoft.Extensions.DependencyModel/src/RuntimeAssembly.cs`
- E-16: `src/libraries/Microsoft.Extensions.DependencyModel/src/RuntimeFile.cs`
- E-17: `src/libraries/Microsoft.Extensions.DependencyModel/src/ResourceAssembly.cs`
- E-18: `src/libraries/Microsoft.Extensions.DependencyModel/src/Resolution/AppBaseCompilationAssemblyResolver.cs`
- E-19: `src/libraries/Microsoft.Extensions.DependencyModel/src/Resolution/PackageCompilationAssemblyResolver.cs`
- E-20: `src/libraries/Microsoft.Extensions.DependencyModel/src/Resolution/ReferenceAssemblyPathResolver.cs`
- E-21: `src/libraries/Microsoft.Extensions.DependencyModel/src/Resolution/CompositeCompilationAssemblyResolver.cs`
- E-22: `src/libraries/Microsoft.Extensions.DependencyModel/src/Resolution/ResolverUtils.cs`
- E-23: `src/libraries/Microsoft.Extensions.DependencyModel/src/Resolution/DotNetReferenceAssembliesPathResolver.cs`
- E-24: `src/libraries/Microsoft.Extensions.DependencyModel/src/CollectionExtensions.cs`
- E-25: `src/libraries/Microsoft.Extensions.DependencyModel/src/HashCodeCombiner.cs`
- E-26: `src/libraries/Microsoft.Extensions.DependencyModel/src/Utf8JsonReaderExtensions.cs`
- E-27: `src/libraries/Microsoft.Extensions.DependencyModel/src/LinqHelpers.cs`
- E-28: `src/libraries/Microsoft.Extensions.DependencyModel/src/ApplicationEnvironment.cs`
- E-29: `src/libraries/Microsoft.Extensions.DependencyModel/src/EnvironmentWrapper.cs`
- E-30: `src/libraries/Microsoft.Extensions.DependencyModel/src/FileSystemWrapper.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### DependencyContext クラス（UT-DPM-001 〜 UT-DPM-014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでArgumentNullException.ThrowIfNullによるnull検証が行われる | E-01 (L25-29) | ○ |
| C-02 | Mergeメソッドでother引数のnull検証が行われる | E-01 (L53) | ○ |
| C-03 | MergeでLibraryMergeEqualityComparerを使用した重複排除が行われる | E-01 (L58-60) | ○ |
| C-04 | 各プロパティ（Target, CompilationOptions, CompileLibraries, RuntimeLibraries, RuntimeGraph）が正しく初期化される | E-01 (L31-35, L41-49) | ○ |

### Library クラス（UT-DPM-015 〜 UT-DPM-025）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | type, name, versionがstring.IsNullOrEmptyでバリデーションされる | E-02 (L43-54) | ○ |
| C-06 | dependenciesのnull検証がArgumentNullException.ThrowIfNullで行われる | E-02 (L55) | ○ |
| C-07 | hashはnullable（null許容）として処理される | E-02 (L60) | ○ |
| C-08 | 3つのコンストラクタオーバーロードが存在する | E-02 (L12, L22, L33) | ○ |

### RuntimeLibrary クラス（UT-DPM-026 〜 UT-DPM-033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | runtimeAssemblyGroups, nativeLibraryGroups, resourceAssembliesのnull検証が行われる | E-03 (L108-110) | ○ |
| C-10 | 親クラスLibraryのコンストラクタが呼び出される | E-03 (L98-106) | ○ |
| C-11 | RuntimeAssemblyGroups, NativeLibraryGroups, ResourceAssembliesプロパティが公開される | E-03 (L117-121) | ○ |

### CompilationLibrary クラス（UT-DPM-034 〜 UT-DPM-041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | assembliesのnull検証がArgumentNullException.ThrowIfNullで行われる | E-04 (L35) | ○ |
| C-13 | ResolveReferencePathsメソッドでデフォルトリゾルバが使用される | E-04 (L49-54) | ○ |
| C-14 | カスタムリゾルバでの解決失敗時にデフォルトリゾルバにフォールバックする | E-04 (L56-71) | ○ |
| C-15 | 解決失敗時にInvalidOperationExceptionがスローされる | E-04 (L78) | ○ |

### DependencyContextLoader クラス（UT-DPM-042 〜 UT-DPM-047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | Loadメソッドでassemblyのnull検証が行われる | E-05 (L57) | ○ |
| C-17 | エントリアセンブリ判定にIsEntryAssemblyメソッドが使用される | E-05 (L62, L44-47) | ○ |
| C-18 | 非エントリポイントパスからのDependencyContextがマージされる | E-05 (L71-78) | ○ |
| C-19 | Defaultプロパティがシングルトンとして実装される | E-05 (L42) | ○ |

### DependencyContextJsonReader クラス（UT-DPM-048 〜 UT-DPM-054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | ReadメソッドでstreamのArgumentNullException.ThrowIfNullが呼び出される | E-06 (L24) | ○ |
| C-21 | UTF-8 BOMの処理が実装されている | E-06 (L18, L92-96) | ○ |
| C-22 | targetsセクションがない場合にFormatExceptionがスローされる | E-06 (L220) | ○ |
| C-23 | 指定されたruntimeTargetNameが見つからない場合にFormatExceptionがスローされる | E-06 (L228) | ○ |
| C-24 | Disposeメソッドで_stringPoolがクリアされる | E-06 (L39-45) | ○ |

### DependencyContextWriter クラス（UT-DPM-055 〜 UT-DPM-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | Writeメソッドでcontext, streamのnull検証が行われる | E-07 (L18-19) | ○ |
| C-26 | ポータブル/非ポータブルターゲットで異なる書き込み処理が行われる | E-07 (L119-128) | ○ |
| C-27 | RuntimeGraphが存在する場合のみruntimesセクションが書き込まれる | E-07 (L33-36) | ○ |

### CompilationOptions クラス（UT-DPM-061 〜 UT-DPM-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | definesのnull検証がArgumentNullException.ThrowIfNullで行われる | E-10 (L63) | ○ |
| C-29 | Defaultプロパティがデフォルト値で初期化されたインスタンスを返す | E-10 (L36-48) | ○ |

### TargetInfo クラス（UT-DPM-065 〜 UT-DPM-070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | frameworkがstring.IsNullOrEmptyでバリデーションされる | E-11 (L14-17) | ○ |
| C-31 | Framework, Runtime, RuntimeSignature, IsPortableプロパティが公開される | E-11 (L25-31) | ○ |

### Dependency 構造体（UT-DPM-071 〜 UT-DPM-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | name, versionがstring.IsNullOrEmptyでバリデーションされる | E-12 (L14-21) | ○ |
| C-33 | IEquatable<Dependency>インターフェースが実装されている | E-12 (L10) | ○ |
| C-34 | Equals, GetHashCodeが正しく実装されている | E-12 (L29-37) | ○ |

### RuntimeAssetGroup クラス（UT-DPM-081 〜 UT-DPM-088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | 3つのコンストラクタオーバーロードが存在する | E-13 (L14, L16, L22) | ○ |
| C-36 | AssetPathsプロパティがstring[]またはRuntimeFile[]から適切に変換される | E-13 (L36-46) | ○ |
| C-37 | RuntimeFilesプロパティがRuntimeFile[]またはstring[]から適切に変換される | E-13 (L52-62) | ○ |

### RuntimeFallbacks クラス（UT-DPM-089 〜 UT-DPM-095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | runtimeがstring.IsNullOrEmptyでバリデーションされる | E-14 (L18-21) | ○ |
| C-39 | fallbacksのnull検証がArgumentNullException.ThrowIfNullで行われる | E-14 (L22) | ○ |

### RuntimeAssembly クラス（UT-DPM-096 〜 UT-DPM-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | assemblyName, pathがstring.IsNullOrEmptyでバリデーションされる | E-15 (L16-23) | ○ |
| C-41 | Createファクトリメソッドで.niサフィックスが除去される | E-15 (L40-43) | ○ |
| C-42 | 空のファイル名でArgumentExceptionがスローされる | E-15 (L35-38) | ○ |

### RuntimeFile クラス（UT-DPM-106 〜 UT-DPM-113）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | pathがstring.IsNullOrEmptyでバリデーションされる | E-16 (L16-19) | ○ |
| C-44 | Path, AssemblyVersion, FileVersion, LocalPathプロパティが公開される | E-16 (L29-36) | ○ |

### ResourceAssembly クラス（UT-DPM-114 〜 UT-DPM-122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | path, localeがstring.IsNullOrEmptyでバリデーションされる | E-17 (L16-23) | ○ |
| C-46 | Locale, Path, LocalPathプロパティが公開される | E-17 (L29-36) | ○ |

### AppBaseCompilationAssemblyResolver クラス（UT-DPM-123 〜 UT-DPM-133）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | project, msbuildproject, package, referenceassembly, referenceタイプが処理される | E-18 (L48-56) | ○ |
| C-48 | refsディレクトリが優先的に検索される | E-18 (L75-78) | ○ |
| C-49 | 全てのアセンブリが解決できない場合にfalseが返される | E-18 (L112-114) | ○ |

### PackageCompilationAssemblyResolver クラス（UT-DPM-134 〜 UT-DPM-142）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | packageタイプのみが処理される | E-19 (L74) | ○ |
| C-51 | PROBING_DIRECTORIES, NUGET_PACKAGES環境変数が優先される | E-19 (L43-57) | ○ |
| C-52 | デフォルトで.nuget/packagesが使用される | E-19 (L66) | ○ |

### ReferenceAssemblyPathResolver クラス（UT-DPM-143 〜 UT-DPM-152）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | referenceassemblyタイプのみが処理される | E-20 (L48) | ○ |
| C-54 | 参照アセンブリが見つからない場合にInvalidOperationExceptionがスローされる | E-20 (L56) | ○ |
| C-55 | DOTNET_REFERENCE_ASSEMBLIES_PATH環境変数が優先される | E-20 (L117-121) | ○ |
| C-56 | Windowsでのデフォルトパスが正しく設定される | E-20 (L130-148) | ○ |

### CompositeCompilationAssemblyResolver クラス（UT-DPM-153 〜 UT-DPM-157）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | resolversのnull検証が行われる | E-21 (L15) | ○ |
| C-58 | 最初に成功したリゾルバの結果が返される | E-21 (L22-28) | ○ |

### DotNetReferenceAssembliesPathResolver クラス（UT-DPM-158 〜 UT-DPM-162）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | DOTNET_REFERENCE_ASSEMBLIES_PATH環境変数が優先される | E-23 (L16-20) | ○ |
| C-60 | macOS, Linux固有のパスが正しく返される | E-23 (L43-61) | ○ |
| C-61 | Windowsではnullが返される | E-23 (L39-41) | ○ |

### DependencyContextExtensions クラス（UT-DPM-163 〜 UT-DPM-174）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | 各拡張メソッドでselfのnull検証が行われる | E-08 (L18, L25, L32-33, L40-41, L48, L55, L62-64, L69-71, L80, L87-88, L95-96, L103-105) | ○ |
| C-63 | RuntimeGraphを使用したフォールバック解決が実装されている | E-08 (L126-133, L136-143) | ○ |

### CollectionExtensions クラス（UT-DPM-175 〜 UT-DPM-185）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | GetDefaultGroupでRuntime=空文字列のグループが返される | E-24 (L11, L22-25) | ○ |
| C-65 | GetRuntimeGroupでruntime引数のバリデーションが行われる | E-24 (L15-18, L30-33, L54-57) | ○ |

### HashCodeCombiner 構造体（UT-DPM-186 〜 UT-DPM-191）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | Obsolete属性が付与されている | E-25 (L11-12) | ○ |
| C-67 | Startメソッドで初期シード値0x1505Lが設定される | E-25 (L59) | ○ |
| C-68 | Add(string)でnullが0として処理される | E-25 (L38) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接導出されており、実装との整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 各クラスのコンストラクタバリデーションテストが適切か
- [ ] null検証テストがArgumentNullExceptionとArgumentExceptionで正しく区別されているか
- [ ] 境界値テスト（空配列、空文字列）が適切にカバーされているか
- [ ] プラットフォーム固有のテスト（Windows/macOS/Linux）の前提条件が明確か
- [ ] 廃止予定API（HashCodeCombiner）のテスト優先度が適切か
