---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 72
  claims_with_evidence: 72
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Diagnostics.Abstractions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：72 / 72、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Diagnostics.Abstractions/src/Metrics/InstrumentRule.cs`
- E-02: `src/libraries/Microsoft.Extensions.Diagnostics.Abstractions/src/Metrics/MetricsOptions.cs`
- E-03: `src/libraries/Microsoft.Extensions.Diagnostics.Abstractions/src/Metrics/MeterScope.cs`
- E-04: `src/libraries/Microsoft.Extensions.Diagnostics.Abstractions/src/Metrics/MeasurementHandlers.cs`
- E-05: `src/libraries/Microsoft.Extensions.Diagnostics.Abstractions/src/Metrics/MetricsBuilderExtensions.Listeners.cs`
- E-06: `src/libraries/Microsoft.Extensions.Diagnostics.Abstractions/src/Metrics/MetricsBuilderExtensions.Rules.cs`
- E-07: `src/libraries/Microsoft.Extensions.Diagnostics.Abstractions/src/Metrics/IMetricsBuilder.cs`
- E-08: `src/libraries/Microsoft.Extensions.Diagnostics.Abstractions/src/Metrics/IMetricsListener.cs`
- E-09: `src/libraries/Microsoft.Extensions.Diagnostics.Abstractions/src/Metrics/IObservableInstrumentsSource.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### InstrumentRule クラス（UT-MEDA-001 〜 UT-MEDA-010, UT-MEDA-069 〜 UT-MEDA-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InstrumentRuleコンストラクタで全パラメータを指定できる | E-01 (25行目: primary constructor定義) | ○ |
| C-02 | null値を含むパラメータでインスタンス生成可能 | E-01 (33, 41, 49行目: nullable型定義) | ○ |
| C-03 | MeterScope.Global \| MeterScope.Localを指定可能 | E-01 (58-60行目: Scopes検証ロジック) | ○ |
| C-04 | MeterScope.NoneでArgumentOutOfRangeException | E-01 (58-60行目: throw new ArgumentOutOfRangeException) | ○ |
| C-05 | MeterNameプロパティが取得可能 | E-01 (33行目: public string? MeterName { get; }) | ○ |
| C-06 | InstrumentNameプロパティが取得可能 | E-01 (41行目: public string? InstrumentName { get; }) | ○ |
| C-07 | ListenerNameプロパティが取得可能 | E-01 (49行目: public string? ListenerName { get; }) | ○ |
| C-08 | Scopesプロパティが取得可能 | E-01 (58行目: public MeterScope Scopes { get; }) | ○ |
| C-09 | Enableプロパティがtrueを返却 | E-01 (65行目: public bool Enable { get; }) | ○ |
| C-10 | Enableプロパティがfalseを返却 | E-01 (65行目: public bool Enable { get; }) | ○ |
| C-69 | 空文字列のmeterNameを指定可能 | E-01 (33行目: string?型、null検証なし) | ○ |
| C-70 | 空文字列のinstrumentNameを指定可能 | E-01 (41行目: string?型、null検証なし) | ○ |
| C-71 | 空文字列のlistenerNameを指定可能 | E-01 (49行目: string?型、null検証なし) | ○ |

### MetricsOptions クラス（UT-MEDA-011 〜 UT-MEDA-014, UT-MEDA-072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | Rules初期状態が空リスト | E-02 (16行目: new List<InstrumentRule>()) | ○ |
| C-12 | Rulesにルール追加可能 | E-02 (16行目: IList<InstrumentRule>) | ○ |
| C-13 | 複数ルール追加可能 | E-02 (16行目: IList<InstrumentRule>) | ○ |
| C-14 | 追加したルールを取得可能 | E-02 (16行目: IList<InstrumentRule>) | ○ |
| C-72 | 大量ルール追加時も正常動作 | E-02 (16行目: List<T>ベース) | ○ |

### MeterScope 列挙型（UT-MEDA-015 〜 UT-MEDA-018）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | None値が0 | E-03 (19行目: None = 0) | ○ |
| C-16 | Global値が1 | E-03 (24行目: Global - 暗黙的に1) | ○ |
| C-17 | Local値が2 | E-03 (29行目: Local - 暗黙的に2) | ○ |
| C-18 | GlobalとLocalをOR結合可能 | E-03 (13行目: [Flags]属性) | ○ |

### MeasurementHandlers クラス（UT-MEDA-019 〜 UT-MEDA-032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | ByteHandler初期値がnull | E-04 (16行目: get; set;、初期値なし) | ○ |
| C-20 | ByteHandler設定・取得可能 | E-04 (16行目: MeasurementCallback<byte>? ByteHandler) | ○ |
| C-21 | ShortHandler初期値がnull | E-04 (21行目: get; set;、初期値なし) | ○ |
| C-22 | ShortHandler設定・取得可能 | E-04 (21行目: MeasurementCallback<short>? ShortHandler) | ○ |
| C-23 | IntHandler初期値がnull | E-04 (26行目: get; set;、初期値なし) | ○ |
| C-24 | IntHandler設定・取得可能 | E-04 (26行目: MeasurementCallback<int>? IntHandler) | ○ |
| C-25 | LongHandler初期値がnull | E-04 (31行目: get; set;、初期値なし) | ○ |
| C-26 | LongHandler設定・取得可能 | E-04 (31行目: MeasurementCallback<long>? LongHandler) | ○ |
| C-27 | FloatHandler初期値がnull | E-04 (36行目: get; set;、初期値なし) | ○ |
| C-28 | FloatHandler設定・取得可能 | E-04 (36行目: MeasurementCallback<float>? FloatHandler) | ○ |
| C-29 | DoubleHandler初期値がnull | E-04 (41行目: get; set;、初期値なし) | ○ |
| C-30 | DoubleHandler設定・取得可能 | E-04 (41行目: MeasurementCallback<double>? DoubleHandler) | ○ |
| C-31 | DecimalHandler初期値がnull | E-04 (46行目: get; set;、初期値なし) | ○ |
| C-32 | DecimalHandler設定・取得可能 | E-04 (46行目: MeasurementCallback<decimal>? DecimalHandler) | ○ |

### MetricsBuilderExtensions クラス - Listeners（UT-MEDA-033 〜 UT-MEDA-042）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | AddListener<T>でリスナー登録可能 | E-05 (22-27行目: AddListener<T>メソッド) | ○ |
| C-34 | 同一リスナー型の重複登録防止 | E-05 (25行目: TryAddEnumerable) | ○ |
| C-35 | AddListener<T>がbuilderを返却 | E-05 (26行目: return builder) | ○ |
| C-36 | AddListener<T>でbuilder null時に例外 | E-05 (24行目: ArgumentNullException.ThrowIfNull) | ○ |
| C-37 | AddListener(instance)でリスナー登録可能 | E-05 (35-40行目: AddListenerメソッド) | ○ |
| C-38 | AddListener(instance)がbuilderを返却 | E-05 (39行目: return builder) | ○ |
| C-39 | AddListener(instance)でbuilder null時に例外 | E-05 (37行目: ArgumentNullException.ThrowIfNull) | ○ |
| C-40 | ClearListenersで全リスナー削除 | E-05 (47-52行目: RemoveAll<IMetricsListener>) | ○ |
| C-41 | ClearListenersがbuilderを返却 | E-05 (51行目: return builder) | ○ |
| C-42 | ClearListenersでbuilder null時に例外 | E-05 (49行目: ArgumentNullException.ThrowIfNull) | ○ |

### MetricsBuilderExtensions クラス - Rules（UT-MEDA-043 〜 UT-MEDA-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | EnableMetrics(meterName)でメトリクス有効化 | E-06 (21-22行目: EnableMetricsメソッド) | ○ |
| C-44 | EnableMetrics(null)で全メーター有効化 | E-06 (19行目: A null value matches all meters) | ○ |
| C-45 | EnableMetrics(meterName)がbuilderを返却 | E-06 (22行目: ConfigureRule呼び出し) | ○ |
| C-46 | EnableMetrics(4引数)で詳細設定可能 | E-06 (33-35行目: EnableMetrics 4引数版) | ○ |
| C-47 | EnableMetricsのscopesデフォルト値 | E-06 (34行目: MeterScope.Global \| MeterScope.Local) | ○ |
| C-48 | DisableMetrics(meterName)でメトリクス無効化 | E-06 (65-66行目: DisableMetricsメソッド) | ○ |
| C-49 | DisableMetrics(null)で全メーター無効化 | E-06 (63行目: A null value matches all meters) | ○ |
| C-50 | DisableMetrics(meterName)がbuilderを返却 | E-06 (66行目: ConfigureRule呼び出し) | ○ |
| C-51 | DisableMetrics(4引数)で詳細設定可能 | E-06 (77-79行目: DisableMetrics 4引数版) | ○ |
| C-52 | DisableMetricsのscopesデフォルト値 | E-06 (78行目: MeterScope.Global \| MeterScope.Local) | ○ |
| C-53 | EnableMetrics(MetricsOptions)で有効化可能 | E-06 (43-44行目: MetricsOptions拡張) | ○ |
| C-54 | EnableMetrics(MetricsOptions)がoptionsを返却 | E-06 (44行目: => options.EnableMetrics) | ○ |
| C-55 | EnableMetrics(MetricsOptions, 4引数)で詳細設定 | E-06 (55-57行目: MetricsOptions拡張4引数版) | ○ |
| C-56 | DisableMetrics(MetricsOptions)で無効化可能 | E-06 (87-88行目: MetricsOptions拡張) | ○ |
| C-57 | DisableMetrics(MetricsOptions)がoptionsを返却 | E-06 (88行目: => options.DisableMetrics) | ○ |
| C-58 | DisableMetrics(MetricsOptions, 4引数)で詳細設定 | E-06 (99-101行目: MetricsOptions拡張4引数版) | ○ |
| C-59 | EnableMetrics(MetricsOptions)でnull時に例外 | E-06 (113行目: ArgumentNullException.ThrowIfNull(options)) | ○ |
| C-60 | DisableMetrics(MetricsOptions)でnull時に例外 | E-06 (113行目: ArgumentNullException.ThrowIfNull(options)) | ○ |

### インターフェース（UT-MEDA-061 〜 UT-MEDA-068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | IMetricsBuilder.Servicesが取得可能 | E-07 (17行目: IServiceCollection Services { get; }) | ○ |
| C-62 | IMetricsListener.Nameが取得可能 | E-08 (16行目: string Name { get; }) | ○ |
| C-63 | IMetricsListener.Initializeでsource受け取り | E-08 (22行目: Initialize(IObservableInstrumentsSource)) | ○ |
| C-64 | IMetricsListener.InstrumentPublishedの実装 | E-08 (31行目: InstrumentPublished(Instrument, out object?)) | ○ |
| C-65 | InstrumentPublishedでuserState設定可能 | E-08 (28-29行目: out object? userState) | ○ |
| C-66 | MeasurementsCompletedの実装 | E-08 (38行目: MeasurementsCompleted(Instrument, object?)) | ○ |
| C-67 | GetMeasurementHandlersの実装 | E-08 (44行目: MeasurementHandlers GetMeasurementHandlers()) | ○ |
| C-68 | RecordObservableInstrumentsの実装 | E-09 (19行目: RecordObservableInstruments()) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべてのテストケースがソースコードから直接導出されている）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] InstrumentRuleのMeterScope.None検証ロジックが正しいか（UT-MEDA-004）
- [ ] 拡張メソッドのnull検証がArgumentNullException.ThrowIfNullを使用しているか（UT-MEDA-036, 039, 042, 059, 060）
- [ ] TryAddEnumerableによる重複登録防止が期待通りか（UT-MEDA-034）
- [ ] MeterScopeのFlags属性によるOR結合が正しく動作するか（UT-MEDA-018）
- [ ] MetricsOptionsのRulesプロパティがIList<InstrumentRule>としてAddをサポートするか（UT-MEDA-012, 013）
