---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 84
  claims_with_evidence: 84
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Diagnostics 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：84 / 84、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/DefaultMeterFactory.cs`
- E-02: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/ListenerSubscription.cs`
- E-03: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/MetricsSubscriptionManager.cs`
- E-04: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/DebugConsoleMetricListener.cs`
- E-05: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/ConsoleMetrics.cs`
- E-06: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/MetricsBuilderConsoleExtensions.cs`
- E-07: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/Configuration/MetricsBuilderConfigurationExtensions.cs`
- E-08: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/Configuration/MetricsConfiguration.cs`
- E-09: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/Configuration/MetricsConfigureOptions.cs`
- E-10: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/Configuration/MetricListenerConfigurationFactory.cs`
- E-11: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/Configuration/IMetricListenerConfigurationFactory.cs`
- E-12: `src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/MetricsServiceExtensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### DefaultMeterFactory関連（UT-DIAG-001〜011）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-DIAG-001: 新規MeterOptionsでMeterが作成される | E-01 (Create method, line 19-60) | ○ |
| C-02 | UT-DIAG-002: 同名・同バージョン・同タグのMeterはキャッシュから返却 | E-01 (line 37-45: _cachedMeters.TryGetValue) | ○ |
| C-03 | UT-DIAG-003: 同名・異バージョンのMeterは新規作成 | E-01 (line 41: meter.Version == options.Version) | ○ |
| C-04 | UT-DIAG-004: 同名・異タグのMeterは新規作成 | E-01 (line 41: DiagnosticsHelper.CompareTags) | ○ |
| C-05 | UT-DIAG-005: optionsがnullでArgumentNullException | E-01 (line 21: ArgumentNullException.ThrowIfNull) | ○ |
| C-06 | UT-DIAG-006: Scopeが異なるFactoryでInvalidOperationException | E-01 (line 23-26: Scope検証) | ○ |
| C-07 | UT-DIAG-007: Dispose後CreateでObjectDisposedException | E-01 (line 32-35: _disposed検証) | ○ |
| C-08 | UT-DIAG-008: Disposeで全Meterがリリース | E-01 (line 63-84: Dispose method) | ○ |
| C-09 | UT-DIAG-009: 複数回Disposeで例外なし | E-01 (line 67-70: if (_disposed) return) | ○ |
| C-10 | UT-DIAG-010: FactoryMeter.ReleaseでDispose(true)が呼ばれる | E-01 (line 93: base.Dispose(true)) | ○ |
| C-11 | UT-DIAG-011: FactoryMeter.Disposeはno-op | E-01 (line 95-98: protected override Dispose) | ○ |

### ListenerSubscription関連（UT-DIAG-012〜031）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | UT-DIAG-012: Initializeでコールバック設定 | E-02 (line 28-42: Initialize method) | ○ |
| C-13 | UT-DIAG-013: GetMeasurementHandlersが呼ばれる | E-02 (line 32: var handlers = _metricsListener.GetMeasurementHandlers()) | ○ |
| C-14 | UT-DIAG-014: UpdateRulesでInstrument再評価 | E-02 (line 83-99: UpdateRules method) | ○ |
| C-15 | UT-DIAG-015: Dispose後UpdateRules無視 | E-02 (line 86-90: if (_disposed) return) | ○ |
| C-16 | UT-DIAG-016: ListenerName完全一致でtrue | E-02 (line 145-152: RuleMatches) | ○ |
| C-17 | UT-DIAG-017: ListenerNameが空で全マッチ | E-02 (line 148: string.IsNullOrEmpty(rule.ListenerName)) | ○ |
| C-18 | UT-DIAG-018: ListenerName不一致でfalse | E-02 (line 149-151: string.Equals比較) | ○ |
| C-19 | UT-DIAG-019: InstrumentName完全一致でtrue | E-02 (line 154-159: InstrumentName比較) | ○ |
| C-20 | UT-DIAG-020: MeterNameワイルドカードでマッチ | E-02 (line 170-199: ワイルドカード処理) | ○ |
| C-21 | UT-DIAG-021: 複数ワイルドカードでInvalidOperationException | E-02 (line 176-180: IndexOf WildcardChar) | ○ |
| C-22 | UT-DIAG-022: MeterScope.Globalでグローバルマッチ | E-02 (line 161-165: Scopes判定) | ○ |
| C-23 | UT-DIAG-023: MeterScope.Localでローカルマッチ | E-02 (line 162: MeterScope.Local判定) | ○ |
| C-24 | UT-DIAG-024: bestがnullでtrue | E-02 (line 206-211: IsMoreSpecific) | ○ |
| C-25 | UT-DIAG-025: ListenerName指定ありが優先 | E-02 (line 213-221: ListenerName比較) | ○ |
| C-26 | UT-DIAG-026: MeterName長い方が優先 | E-02 (line 223-240: MeterName.Length比較) | ○ |
| C-27 | UT-DIAG-027: InstrumentName指定ありが優先 | E-02 (line 242-250: InstrumentName比較) | ○ |
| C-28 | UT-DIAG-028: ローカルスコープでLocalのみが優先 | E-02 (line 254-266: isLocalScope判定) | ○ |
| C-29 | UT-DIAG-029: グローバルスコープでGlobalのみが優先 | E-02 (line 267-279: !isLocalScope判定) | ○ |
| C-30 | UT-DIAG-030: RecordObservableInstrumentsが呼ばれる | E-02 (line 285: _meterListener.RecordObservableInstruments()) | ○ |
| C-31 | UT-DIAG-031: DisposeでMeterListenerがDispose | E-02 (line 287-293: Dispose method) | ○ |

### MetricsSubscriptionManager関連（UT-DIAG-032〜037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | UT-DIAG-032: ListenerSubscription配列が作成 | E-03 (line 18-28: コンストラクタ) | ○ |
| C-33 | UT-DIAG-033: 全InitializeがS呼ばれる | E-03 (line 30-36: Initialize method) | ○ |
| C-34 | UT-DIAG-034: 全リスナーのルール更新 | E-03 (line 38-50: UpdateRules method) | ○ |
| C-35 | UT-DIAG-035: Dispose後UpdateRules無視 | E-03 (line 40-43: if (_disposed) return) | ○ |
| C-36 | UT-DIAG-036: 全ListenerSubscriptionがDispose | E-03 (line 52-65: Dispose method) | ○ |
| C-37 | UT-DIAG-037: 複数回Disposeで例外なし | E-03 (line 54-57: if (_disposed) return) | ○ |

### DebugConsoleMetricListener関連（UT-DIAG-038〜047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | UT-DIAG-038: NameがDebugConsoleを返す | E-04 (line 27: ConsoleMetrics.DebugListenerName) | ○ |
| C-39 | UT-DIAG-039: 非Observableでタイマー開始なし | E-04 (line 32: instrument.IsObservable条件) | ○ |
| C-40 | UT-DIAG-040: Observableでタイマー開始 | E-04 (line 32-35: タイマー開始処理) | ○ |
| C-41 | UT-DIAG-041: 2つ目Observableでタイマー再開始なし | E-04 (line 32: Interlocked.Exchange) | ○ |
| C-42 | UT-DIAG-042: Instrument開始メッセージ出力 | E-04 (line 37: WriteLine) | ○ |
| C-43 | UT-DIAG-043: Instrument停止メッセージ出力 | E-04 (line 42-46: MeasurementsCompleted) | ○ |
| C-44 | UT-DIAG-044: IObservableInstrumentsSource保存 | E-04 (line 48: _source = source) | ○ |
| C-45 | UT-DIAG-045: 全型ハンドラが設定 | E-04 (line 50-59: GetMeasurementHandlers) | ○ |
| C-46 | UT-DIAG-046: 測定値がコンソールに出力 | E-04 (line 61-65: MeasurementHandler<T>) | ○ |
| C-47 | UT-DIAG-047: タイマーがDispose | E-04 (line 81: _timer.Dispose()) | ○ |

### ConsoleMetrics関連（UT-DIAG-048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | UT-DIAG-048: DebugListenerNameが"DebugConsole"を返す | E-05 (line 14: "DebugConsole") | ○ |

### MetricsBuilderConsoleExtensions関連（UT-DIAG-049〜050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | UT-DIAG-049: DebugConsoleMetricListenerが追加 | E-06 (line 16: AddListener<DebugConsoleMetricListener>) | ○ |
| C-50 | UT-DIAG-050: メソッドチェーン可能 | E-06 (line 16: return builder.AddListener...) | ○ |

### MetricsBuilderConfigurationExtensions関連（UT-DIAG-051〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | UT-DIAG-051: MetricsConfigureOptionsがDI登録 | E-07 (line 31: AddSingleton<IConfigureOptions>) | ○ |
| C-52 | UT-DIAG-052: ConfigurationChangeTokenSourceがDI登録 | E-07 (line 32: AddSingleton<IOptionsChangeTokenSource>) | ○ |
| C-53 | UT-DIAG-053: MetricsConfigurationがDI登録 | E-07 (line 33: AddSingleton(new MetricsConfiguration)) | ○ |
| C-54 | UT-DIAG-054: builderがnullでArgumentNullException | E-07 (line 27: ArgumentNullException.ThrowIfNull(builder)) | ○ |
| C-55 | UT-DIAG-055: configurationがnullでArgumentNullException | E-07 (line 29: ArgumentNullException.ThrowIfNull(configuration)) | ○ |

### MetricsConfiguration関連（UT-DIAG-056〜057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | UT-DIAG-056: Configurationプロパティに値設定 | E-08 (line 11-14: コンストラクタ, line 16: プロパティ) | ○ |
| C-57 | UT-DIAG-057: configurationがnullでArgumentNullException | E-08 (line 13: throw new ArgumentNullException) | ○ |

### MetricsConfigureOptions関連（UT-DIAG-058〜070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | UT-DIAG-058: IConfigurationが保存 | E-09 (line 19-22: コンストラクタ) | ○ |
| C-59 | UT-DIAG-059: configurationがnullでArgumentNullException | E-09 (line 21: throw new ArgumentNullException) | ○ |
| C-60 | UT-DIAG-060: EnabledMetricsからルールロード | E-09 (line 30-34: EnabledMetricsKey判定) | ○ |
| C-61 | UT-DIAG-061: EnabledGlobalMetricsからグローバルルールロード | E-09 (line 35-39: EnabledGlobalMetricsKey判定) | ○ |
| C-62 | UT-DIAG-062: EnabledLocalMetricsからローカルルールロード | E-09 (line 40-44: EnabledLocalMetricsKey判定) | ○ |
| C-63 | UT-DIAG-063: リスナー固有ルールロード | E-09 (line 45-64: listenerName指定) | ○ |
| C-64 | UT-DIAG-064: Meter単位の有効/無効 | E-09 (line 69-91: LoadMeterRules) | ○ |
| C-65 | UT-DIAG-065: Defaultキーが全Meterに適用 | E-09 (line 83-87: DefaultKey判定) | ○ |
| C-66 | UT-DIAG-066: オブジェクト形式でLoadInstrumentRules呼び出し | E-09 (line 74-78: GetChildren().Any()) | ○ |
| C-67 | UT-DIAG-067: boolパース失敗でスキップ | E-09 (line 80: bool.TryParse) | ○ |
| C-68 | UT-DIAG-068: Instrument単位の有効/無効 | E-09 (line 95-111: LoadInstrumentRules) | ○ |
| C-69 | UT-DIAG-069: DefaultキーがInstrumentに適用 | E-09 (line 102-106: DefaultKey判定) | ○ |
| C-70 | UT-DIAG-070: boolパース失敗でスキップ | E-09 (line 99: bool.TryParse) | ○ |

### MetricListenerConfigurationFactory関連（UT-DIAG-071〜075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | UT-DIAG-071: configurationsが保存 | E-10 (line 14-17: コンストラクタ) | ○ |
| C-72 | UT-DIAG-072: configurationsがnullでArgumentNullException | E-10 (line 16: throw new ArgumentNullException) | ○ |
| C-73 | UT-DIAG-073: リスナー名の設定セクション返却 | E-10 (line 19-30: GetConfiguration) | ○ |
| C-74 | UT-DIAG-074: 複数設定からマージ | E-10 (line 24-28: foreach + AddConfiguration) | ○ |
| C-75 | UT-DIAG-075: listenerNameがnullでArgumentNullException | E-10 (line 21: ArgumentNullException.ThrowIfNull) | ○ |

### MetricsServiceExtensions関連（UT-DIAG-076〜084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | UT-DIAG-076: IMeterFactoryがDI登録 | E-12 (line 29: TryAddSingleton<IMeterFactory, DefaultMeterFactory>) | ○ |
| C-77 | UT-DIAG-077: MetricsSubscriptionManagerがDI登録 | E-12 (line 30: TryAddSingleton<MetricsSubscriptionManager>) | ○ |
| C-78 | UT-DIAG-078: IMetricListenerConfigurationFactoryがDI登録 | E-12 (line 37: TryAddSingleton<IMetricListenerConfigurationFactory>) | ○ |
| C-79 | UT-DIAG-079: servicesがnullでArgumentNullException | E-12 (line 25: ArgumentNullException.ThrowIfNull) | ○ |
| C-80 | UT-DIAG-080: configureコールバック実行 | E-12 (line 48-58: AddMetrics with Action) | ○ |
| C-81 | UT-DIAG-081: MetricsBuilderがconfigureに渡される | E-12 (line 54-55: new MetricsBuilder, configure(builder)) | ○ |
| C-82 | UT-DIAG-082: configureがnullでArgumentNullException | E-12 (line 50: ArgumentNullException.ThrowIfNull) | ○ |
| C-83 | UT-DIAG-083: Servicesプロパティが正しい値を返す | E-12 (line 60-63: MetricsBuilder class) | ○ |
| C-84 | UT-DIAG-084: Configure呼び出しでInitialize実行 | E-12 (line 67-70: SubscriptionActivator class) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースについてソースコード上の根拠を特定済み

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースが実際のソースコードから直接導出されている
- テストケースはソースコードの実装詳細に基づいており、要件定義書や外部仕様書への参照は含まれていない
- テスト対象のメソッドは全てソースコード内で確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] DefaultMeterFactory のキャッシュロジック（UT-DIAG-002〜004）が実際のビジネス要件を満たしているか確認
- [ ] ListenerSubscription.RuleMatches のワイルドカード処理（UT-DIAG-020〜021）が期待通りの動作か確認
- [ ] ListenerSubscription.IsMoreSpecific の優先度判定ロジック（UT-DIAG-024〜029）がドキュメント化されているか確認
- [ ] MetricsConfigureOptions の設定キー名（EnabledMetrics, EnabledGlobalMetrics, EnabledLocalMetrics）が公開ドキュメントと一致するか確認
- [ ] DebugConsoleMetricListener のタイマー間隔（1秒）が要件に適合するか確認
- [ ] 各クラスの Dispose パターンが正しく実装されているか（冪等性、リソース解放順序）確認
