---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 36
  claims_with_evidence: 36
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.FileProviders.Composite 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：36 / 36、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースはソースコードに基づいて生成されており、根拠が確認できています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.FileProviders.Composite/src/CompositeFileProvider.cs`
- E-02: `src/libraries/Microsoft.Extensions.FileProviders.Composite/src/CompositeDirectoryContents.cs`
- E-03: `src/libraries/Microsoft.Extensions.FileProviders.Composite/ref/Microsoft.Extensions.FileProviders.Composite.cs`
- E-04: `src/libraries/Microsoft.Extensions.FileProviders.Composite/tests/CompositeFileProviderTests.cs`
- E-05: `src/libraries/Microsoft.Extensions.FileProviders.Composite/tests/MockFileProvider.cs`
- E-06: `src/libraries/Microsoft.Extensions.FileProviders.Composite/tests/MockFileInfo.cs`
- E-07: `src/libraries/Microsoft.Extensions.FileProviders.Composite/tests/MockChangeToken.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CompositeFileProvider コンストラクタ関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | null配列でインスタンス生成できること | E-01 (line 23-26: `_fileProviders = fileProviders ?? Array.Empty<IFileProvider>();`) | ○ |
| C-02 | 空配列でインスタンス生成できること | E-01 (line 23-26) | ○ |
| C-03 | 複数のFileProviderでインスタンス生成できること | E-01, E-04 (line 44-64: `GetFileInfo_ReturnsTheFirstFoundFileInfo`) | ○ |
| C-04 | IEnumerableでインスタンス生成できること | E-01 (line 32-37) | ○ |
| C-05 | nullのIEnumerableで例外がスローされること | E-01 (line 34: `ArgumentNullException.ThrowIfNull(fileProviders);`) | ○ |

### CompositeFileProvider.GetFileInfo関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | 最初に見つかったファイル情報が返されること | E-01 (line 44-55), E-04 (line 42-64: `GetFileInfo_ReturnsTheFirstFoundFileInfo`) | ○ |
| C-07 | 2番目のproviderからファイルが見つかること | E-01 (line 46-53: foreachループでの順次検索) | ○ |
| C-08 | ファイルが存在しない場合NotFoundFileInfoが返されること | E-01 (line 54), E-04 (line 14-26, 28-40) | ○ |
| C-09 | 空文字列のパスでNotFoundFileInfoが返されること | E-01 (line 44-55: 存在チェックロジック) | ○ |
| C-10 | FileProviderが空の場合NotFoundFileInfoが返されること | E-01 (line 46-54), E-04 (line 14-26) | ○ |
| C-11 | FileProviderがnullを返した場合スキップされること | E-01 (line 49: `if (fileInfo != null && fileInfo.Exists)`) | ○ |

### CompositeFileProvider.GetDirectoryContents関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | 複数providerのディレクトリ内容がマージされること | E-01 (line 64-68), E-04 (line 96-123: `GetDirectoryContents_ReturnsCombinaisionOFFiles`) | ○ |
| C-13 | 同名ファイルは最初のものだけが含まれること | E-02 (line 63-72: HashSetによる重複排除), E-04 (line 96-123) | ○ |
| C-14 | 一部のproviderにのみ存在するディレクトリが取得できること | E-04 (line 125-154: `GetDirectoryContents_ReturnsCombinaitionOFFiles_WhenSomeFileProviderRetunsNoContent`) | ○ |
| C-15 | FileProviderが空の場合空のDirectoryContentsが返されること | E-04 (line 67-79: `GetDirectoryContents_ReturnsNonExistingEmptySequence_IfNoFileProviderSpecified`) | ○ |
| C-16 | 存在しないディレクトリでExists=falseが返されること | E-04 (line 81-94: `GetDirectoryContents_ReturnsNonExistingEmptySequence_IfResourcesDoNotExist`) | ○ |

### CompositeFileProvider.Watch関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | 複数providerのChangeTokenがCompositeChangeTokenとして返されること | E-01 (line 76-95), E-04 (line 185-218) | ○ |
| C-18 | 単一のChangeTokenのみの場合そのまま返されること | E-01 (line 91: `1 => changeTokens[0]`) | ○ |
| C-19 | どのproviderもChangeTokenを返さない場合NullChangeTokenが返されること | E-01 (line 90: `0 => NullChangeToken.Singleton`), E-04 (line 156-168, 170-183) | ○ |
| C-20 | FileProviderが空の場合NullChangeTokenが返されること | E-01 (line 89-91), E-04 (line 156-168) | ○ |
| C-21 | HasChangedが正しく伝播されること | E-04 (line 185-218: `Watch_CompositeChangeToken_HasChangedIsCorrectlyComputed`) | ○ |
| C-22 | RegisterChangeCallbackが全ChangeTokenに伝播されること | E-04 (line 220-259: `Watch_CompositeChangeToken_RegisterChangeCallbackCorrectlyTransmitsAllParameters`) | ○ |

### CompositeFileProvider.FileProviders関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | 登録されたFileProviderの一覧が取得できること | E-01 (line 100: `public IEnumerable<IFileProvider> FileProviders => _fileProviders;`) | ○ |
| C-24 | 空のCompositeFileProviderで空の一覧が返されること | E-01 (line 25, 100) | ○ |

### CompositeDirectoryContents コンストラクタ関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | 正しくインスタンス生成できること | E-02 (line 29-35) | ○ |
| C-26 | fileProvidersがnullの場合例外がスローされること | E-02 (line 31: `ArgumentNullException.ThrowIfNull(fileProviders);`) | ○ |

### CompositeDirectoryContents.Exists関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | 少なくとも1つのproviderにディレクトリが存在する場合trueが返されること | E-02 (line 98-105, line 46-48: `_exists = true;`) | ○ |
| C-28 | どのproviderにもディレクトリが存在しない場合falseが返されること | E-02 (line 20, 98-105: `_exists`は初期値false) | ○ |
| C-29 | FileProviderリストが空の場合falseが返されること | E-02 (line 40-52: foreachが実行されず_exists=false) | ○ |

### CompositeDirectoryContents.GetEnumerator関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | 全providerのファイルが列挙されること | E-02 (line 83-87, line 57-76) | ○ |
| C-31 | 同名ファイルは最初のもののみ列挙されること | E-02 (line 63-72: `var names = new HashSet<string>(); if (names.Add(file.Name))`) | ○ |
| C-32 | ファイルが存在しない場合空の列挙子が返されること | E-02 (line 62: `_files = new List<IFileInfo>();`) | ○ |
| C-33 | 非ジェネリック版GetEnumeratorが正しく動作すること | E-02 (line 89-93) | ○ |

### CompositeDirectoryContents 内部メソッド関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | EnsureDirectoriesAreInitialized遅延初期化が1回のみ実行されること | E-02 (line 40-52: `if (_directories == null)`) | ○ |
| C-35 | EnsureFilesAreInitialized遅延初期化が1回のみ実行されること | E-02 (line 60-75: `if (_files == null)`) | ○ |
| C-36 | ファイル名による重複排除がHashSetで行われること | E-02 (line 63: `var names = new HashSet<string>();`) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全テストケースはソースコードに根拠があります

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいており、既存テストコードとの整合性も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] テストID命名規則が一貫しているか確認（UT-FPC-xxx）
- [ ] 正常系/異常系/境界値の網羅性を確認
- [ ] 既存テストコード（CompositeFileProviderTests.cs）との重複・補完関係を確認
- [ ] 優先度の設定が適切か確認（金額計算・認証関連は高、表示用は低など）
- [ ] 入力値・期待結果の具体性が十分か確認

## 補足：モジュール構造

### 対象クラス一覧
| クラス名 | 名前空間 | 役割 |
|---------|---------|------|
| CompositeFileProvider | Microsoft.Extensions.FileProviders | 複数のIFileProviderを統合して1つのIFileProviderとして提供 |
| CompositeDirectoryContents | Microsoft.Extensions.FileProviders.Composite | 複数providerのディレクトリ内容を統合 |

### 主要メソッド・プロパティ
| メソッド/プロパティ | テストケース数 | 備考 |
|-------------------|--------------|------|
| CompositeFileProvider コンストラクタ | 5 | 2つのオーバーロード |
| GetFileInfo | 6 | ファイル検索の中心機能 |
| GetDirectoryContents | 5 | ディレクトリ内容取得 |
| Watch | 6 | 変更監視機能 |
| FileProviders | 2 | プロバイダー一覧取得 |
| CompositeDirectoryContents コンストラクタ | 2 | 入力検証含む |
| Exists | 3 | 存在確認 |
| GetEnumerator | 4 | ファイル列挙 |
| 内部メソッド | 3 | 遅延初期化 |
