---
generated_at: 2026-01-30 17:00:00
metrics:
  claims_total: 160
  claims_with_evidence: 160
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.FileSystemGlobbing 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：160 / 160、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

### 主要クラス（Public API）
- E-01: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Matcher.cs`
- E-02: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/MatcherExtensions.cs`
- E-03: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/FilePatternMatch.cs`
- E-04: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/PatternMatchingResult.cs`
- E-05: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/InMemoryDirectoryInfo.cs`

### 内部クラス（Internal）
- E-06: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/MatcherContext.cs`
- E-07: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/Patterns/PatternBuilder.cs`
- E-08: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternTestResult.cs`
- E-09: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/InMemoryFileInfo.cs`

### PathSegments
- E-10: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PathSegments/LiteralPathSegment.cs`
- E-11: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PathSegments/WildcardPathSegment.cs`
- E-12: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PathSegments/RecursiveWildcardSegment.cs`
- E-13: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PathSegments/CurrentPathSegment.cs`
- E-14: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PathSegments/ParentPathSegment.cs`

### PatternContexts
- E-15: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/PatternContext.cs`
- E-16: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/PatternContextLinear.cs`
- E-17: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/PatternContextRagged.cs`
- E-18: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/PatternContextLinearInclude.cs`
- E-19: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/PatternContextLinearExclude.cs`
- E-20: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/PatternContextRaggedInclude.cs`
- E-21: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/PatternContextRaggedExclude.cs`
- E-22: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/CompositePatternContext.cs`
- E-23: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/IncludesFirstCompositePatternContext.cs`
- E-24: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/PreserveOrderCompositePatternContext.cs`

### Abstractions
- E-25: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/FileSystemInfoBase.cs`
- E-26: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/DirectoryInfoBase.cs`
- E-27: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/FileInfoBase.cs`
- E-28: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/DirectoryInfoWrapper.cs`
- E-29: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/FileInfoWrapper.cs`

### Utility
- E-30: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Util/StringComparisonHelper.cs`

### インターフェース
- E-31: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IPattern.cs`
- E-32: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IPatternContext.cs`
- E-33: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IPathSegment.cs`
- E-34: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/ILinearPattern.cs`
- E-35: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IRaggedPattern.cs`
- E-36: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IncludeOrExcludeValue.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Matcher クラス (UT-FSG-001 〜 UT-FSG-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタでOrdinalIgnoreCase | E-01 (L110-113) | ○ |
| C-02 | StringComparison指定コンストラクタ | E-01 (L119-122) | ○ |
| C-03 | preserveFilterOrder=trueの動作 | E-01 (L132-147) | ○ |
| C-04 | preserveFilterOrder=falseの動作 | E-01 (L143-146) | ○ |
| C-05 | AddIncludeの基本動作 | E-01 (L161-169) | ○ |
| C-06 | 複数AddIncludeのチェーン | E-01 (L168 return this) | ○ |
| C-07 | AddExcludeの基本動作 | E-01 (L183-191) | ○ |
| C-08 | Executeの基本動作 | E-01 (L198-205) | ○ |
| C-09 | Execute null検証 | E-01 (L200) | ○ |

### MatcherExtensions (UT-FSG-015 〜 UT-FSG-027)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | AddExcludePatternsの動作 | E-02 (L19-28) | ○ |
| C-11 | AddIncludePatternsの動作 | E-02 (L35-44) | ○ |
| C-12 | GetResultsInFullPathの動作 | E-02 (L52-67) | ○ |
| C-13 | Match(string)の動作 | E-02 (L75-78) | ○ |
| C-14 | Match(string, string)の動作 | E-02 (L87-90) | ○ |
| C-15 | Match(IEnumerable)の動作 | E-02 (L98-101) | ○ |
| C-16 | Match null検証 | E-02 (L112) | ○ |

### FilePatternMatch (UT-FSG-028 〜 UT-FSG-038)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | コンストラクタの動作 | E-03 (L38-45) | ○ |
| C-18 | path null検証 | E-03 (L40) | ○ |
| C-19 | stem null検証 | E-03 (L41) | ○ |
| C-20 | Equals(FilePatternMatch)の動作 | E-03 (L52-56) | ○ |
| C-21 | Equals(object)の動作 | E-03 (L63-64) | ○ |
| C-22 | GetHashCodeの動作 | E-03 (L70-74) | ○ |

### PatternMatchingResult (UT-FSG-039 〜 UT-FSG-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | 単一コンストラクタ | E-04 (L19-23) | ○ |
| C-24 | hasMatches指定コンストラクタ | E-04 (L30-36) | ○ |
| C-25 | files null検証 | E-04 (L32) | ○ |

### InMemoryDirectoryInfo (UT-FSG-043 〜 UT-FSG-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | コンストラクタ基本動作 | E-05 (L27-83) | ○ |
| C-27 | rootDir null/空検証 | E-05 (L45-48) | ○ |
| C-28 | files null許容 | E-05 (L52) | ○ |
| C-29 | EnumerateFileSystemInfos | E-05 (L96-132) | ○ |
| C-30 | GetDirectory動作 | E-05 (L144-155) | ○ |
| C-31 | GetFile動作 | E-05 (L162-174) | ○ |

### MatcherContext (UT-FSG-057 〜 UT-FSG-062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | コンストラクタ | E-06 (L30-40, L42-57) | ○ |
| C-33 | Execute動作 | E-06 (L59-66) | ○ |
| C-34 | CombinePath動作 | E-06 (L169-179) | ○ |

### PatternBuilder (UT-FSG-063 〜 UT-FSG-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | デフォルトコンストラクタ | E-07 (L16-19) | ○ |
| C-36 | StringComparison指定 | E-07 (L21-24) | ○ |
| C-37 | Build基本動作 | E-07 (L28-204) | ○ |
| C-38 | pattern null検証 | E-07 (L30) | ○ |
| C-39 | ..の位置制限 | E-07 (L80-84) | ○ |
| C-40 | 末尾スラッシュ変換 | E-07 (L34-39) | ○ |

### LiteralPathSegment (UT-FSG-076 〜 UT-FSG-084)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | コンストラクタ | E-10 (L16-22) | ○ |
| C-42 | value null検証 | E-10 (L18) | ○ |
| C-43 | CanProduceStem | E-10 (L14) | ○ |
| C-44 | Match動作 | E-10 (L26-29) | ○ |
| C-45 | Equals/GetHashCode | E-10 (L31-41) | ○ |

### WildcardPathSegment (UT-FSG-085 〜 UT-FSG-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | コンストラクタ | E-11 (L18-32) | ○ |
| C-47 | null検証 | E-11 (L20-22) | ○ |
| C-48 | 非Ordinal検証 | E-11 (L24-28) | ○ |
| C-49 | Match動作 | E-11 (L42-80) | ○ |
| C-50 | MatchAll静的フィールド | E-11 (L13-14) | ○ |

### RecursiveWildcardSegment (UT-FSG-100 〜 UT-FSG-101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | CanProduceStem | E-12 (L10) | ○ |
| C-52 | Match | E-12 (L12) | ○ |

### CurrentPathSegment (UT-FSG-102 〜 UT-FSG-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | CanProduceStem | E-13 (L10) | ○ |
| C-54 | Match | E-13 (L12) | ○ |

### ParentPathSegment (UT-FSG-104 〜 UT-FSG-106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | CanProduceStem | E-14 (L12) | ○ |
| C-56 | Match動作 | E-14 (L14-17) | ○ |

### PatternTestResult (UT-FSG-107 〜 UT-FSG-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | Failed静的フィールド | E-08 (L14) | ○ |
| C-58 | Success動作 | E-08 (L26-29) | ○ |

### DirectoryInfoWrapper (UT-FSG-110 〜 UT-FSG-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | コンストラクタ | E-28 (L23-31) | ○ |
| C-60 | EnumerateFileSystemInfos | E-28 (L34-60) | ○ |
| C-61 | GetDirectory動作 | E-28 (L70-98) | ○ |
| C-62 | GetFile動作 | E-28 (L102-103) | ○ |
| C-63 | Name動作 | E-28 (L106) | ○ |
| C-64 | ParentDirectory動作 | E-28 (L122-123) | ○ |

### FileInfoWrapper (UT-FSG-121 〜 UT-FSG-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | コンストラクタ | E-29 (L20-25) | ○ |
| C-66 | null検証 | E-29 (L22) | ○ |
| C-67 | Name/FullName/ParentDirectory | E-29 (L33, L41, L49-50) | ○ |

### PatternContextLinear (UT-FSG-126 〜 UT-FSG-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | Test(FileInfoBase)動作 | E-16 (L20-33) | ○ |
| C-69 | PushDirectory動作 | E-16 (L35-65) | ○ |
| C-70 | スタック空エラー | E-16 (L22-25) | ○ |

### PatternContextRagged (UT-FSG-131 〜 UT-FSG-135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | Test(FileInfoBase)動作 | E-17 (L19-31) | ○ |
| C-72 | PushDirectory動作 | E-17 (L33-102) | ○ |
| C-73 | PopDirectory動作 | E-17 (L104-111) | ○ |

### PatternContextLinearInclude (UT-FSG-136 〜 UT-FSG-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | Declare動作 | E-18 (L16-32) | ○ |
| C-75 | Test(DirectoryInfoBase)動作 | E-18 (L34-47) | ○ |

### PatternContextLinearExclude (UT-FSG-141 〜 UT-FSG-142)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | Test(DirectoryInfoBase)動作 | E-19 (L16-29) | ○ |

### PatternContextRaggedInclude (UT-FSG-143 〜 UT-FSG-146)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | Declare動作 | E-20 (L17-37) | ○ |
| C-78 | Test(DirectoryInfoBase)動作 | E-20 (L39-58) | ○ |

### PatternContextRaggedExclude (UT-FSG-147 〜 UT-FSG-148)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | Test(DirectoryInfoBase)動作 | E-21 (L16-43) | ○ |

### IncludesFirstCompositePatternContext (UT-FSG-149 〜 UT-FSG-151)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | MatchPatternContexts動作 | E-23 (L28-59) | ○ |

### PreserveOrderCompositePatternContext (UT-FSG-152 〜 UT-FSG-153)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | MatchPatternContexts動作 | E-24 (L27-47) | ○ |

### StringComparisonHelper (UT-FSG-154 〜 UT-FSG-157)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | GetStringComparer動作 | E-30 (L10-19) | ○ |

### InMemoryFileInfo (UT-FSG-158 〜 UT-FSG-160)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | コンストラクタとプロパティ | E-09 (L13-24) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースに対してソースコードからの根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースはソースコードから直接導出されており、根拠が明確です
- 注意点：
  - Internal名前空間のクラスは公開APIではないため、将来のバージョンで変更される可能性があります
  - WildcardPathSegmentの比較タイプ制限（Ordinal/OrdinalIgnoreCaseのみ）は設計上の制約です

## 6) レビュアーチェックリスト（最小）
- [ ] Matcherクラスのコンストラクタバリエーション（デフォルト、StringComparison、preserveFilterOrder）が網羅されているか
- [ ] AddInclude/AddExcludeのチェーン呼び出しが検証されているか
- [ ] FilePatternMatchのEqualsとGetHashCodeの一貫性が検証されているか
- [ ] InMemoryDirectoryInfoのパス正規化ロジックが検証されているか
- [ ] PatternBuilderの各パターン変換（リテラル、ワイルドカード、再帰ワイルドカード）が網羅されているか
- [ ] WildcardPathSegmentのMatch条件（プレフィックス、サフィックス、中間）が網羅されているか
- [ ] PatternContextのスタック操作（Push/Pop）が検証されているか
- [ ] Include/Exclude優先度とpreserveFilterOrder動作の違いが検証されているか
- [ ] null/空文字入力に対する異常系テストが網羅されているか
- [ ] 境界値（空配列、単一要素、長い文字列）が検証されているか
