---
generated_at: 2026-01-30 14:30:00
metrics:
  claims_total: 63
  claims_with_evidence: 58
  claims_without_evidence: 5
confidence_derived: 0.92
---

# 根拠レポート：libraries-Microsoft.Extensions.HostFactoryResolver.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：58 / 63、根拠なし：5
- 優先レビュー（高）
  1. **UT-HFR-031**: デバッガアタッチ時の挙動検証が実機テスト困難
  2. **UT-HFR-016**: アセンブリロード失敗のモック困難
  3. **UT-HFR-017**: Hostingバージョン検証のモック困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/src/HostFactoryResolver.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/HostFactoryResolverTests.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/BuildWebHostPatternTestSite/Program.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/CreateWebHostBuilderPatternTestSite/Program.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/CreateHostBuilderPatternTestSite/Program.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/NoSpecialEntryPointPattern/Program.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/BuildWebHostInvalidSignature/Program.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/CreateWebHostBuilderInvalidSignature/Program.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/CreateHostBuilderInvalidSignature/Program.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/NoSpecialEntryPointPatternThrows/Program.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/NoSpecialEntryPointPatternExits/Program.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/NoSpecialEntryPointPatternHangs/Program.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/NoSpecialEntryPointPatternMainNoArgs/Program.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/TopLevelStatements/Program.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/NoSpecialEntryPointPatternBuildsThenThrows/Program.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.HostFactoryResolver/tests/MockHostTypes/WebHost.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-HFR-001: BuildWebHostパターンでWebHostファクトリが解決できること | E-01 (L41-44), E-02 (L21-27), E-03 | ○ |
| C-02 | UT-HFR-002: ファクトリ関数の実行でIWebHostが取得できること | E-02 (L26), E-03, E-16 | ○ |
| C-03 | UT-HFR-003: BuildWebHostシグネチャが不正な場合nullが返ること | E-01 (L112-119), E-02 (L40-47), E-07 | ○ |
| C-04 | UT-HFR-004: EntryPointがないアセンブリでnullが返ること | E-01 (L97-101) | ○ |
| C-05 | UT-HFR-005: CreateWebHostBuilderパターンでWebHostBuilderファクトリが解決できること | E-01 (L46-49), E-02 (L58-66), E-04 | ○ |
| C-06 | UT-HFR-006: ファクトリ関数の実行でIWebHostBuilderが取得できること | E-02 (L65), E-04 | ○ |
| C-07 | UT-HFR-007: CreateWebHostBuilderの戻り値型が不正な場合nullが返ること | E-01 (L115-116), E-02 (L79-86), E-08 | ○ |
| C-08 | UT-HFR-008: CreateHostBuilderパターンでHostBuilderファクトリが解決できること | E-01 (L51-54), E-02 (L98-106), E-05 | ○ |
| C-09 | UT-HFR-009: ファクトリ関数の実行でIHostBuilderが取得できること | E-02 (L105), E-05 | ○ |
| C-10 | UT-HFR-010: CreateHostBuilderシグネチャが不正な場合nullが返ること | E-01 (L117), E-02 (L119-126), E-09 | ○ |
| C-11 | UT-HFR-011: DiagnosticSource経由でホストが解決できること | E-01 (L62-93), E-02 (L138-146), E-06 | ○ |
| C-12 | UT-HFR-012: configureHostBuilderコールバックが呼び出されること | E-01 (L331-334), E-02 (L148-164) | ○ |
| C-13 | UT-HFR-013: stopApplication=falseでエントリポイント完了時にコールバックが呼ばれること | E-01 (L269-270), E-02 (L166-184) | ○ |
| C-14 | UT-HFR-014: エントリポイントが例外をスローした場合コールバックに例外が渡ること | E-01 (L253-266), E-02 (L186-204), E-15 | ○ |
| C-15 | UT-HFR-015: EntryPointがないアセンブリでnullが返ること | E-01 (L68-71) | ○ |
| C-16 | UT-HFR-016: Microsoft.Extensions.Hostingがロードできない場合nullが返ること | E-01 (L73-90) | △ |
| C-17 | UT-HFR-017: Hostingバージョンが6未満の場合nullが返ること | E-01 (L78-81) | △ |
| C-18 | UT-HFR-018: BuildWebHostパターンからIServiceProviderが取得できること | E-01 (L125-133), E-02 (L29-38) | ○ |
| C-19 | UT-HFR-019: CreateWebHostBuilderパターンからIServiceProviderが取得できること | E-01 (L135-144), E-02 (L68-77) | ○ |
| C-20 | UT-HFR-020: CreateHostBuilderパターンからIServiceProviderが取得できること | E-01 (L146-155), E-02 (L108-117) | ○ |
| C-21 | UT-HFR-021: DiagnosticSourceパターンからIServiceProviderが取得できること | E-01 (L157-174), E-02 (L138-146) | ○ |
| C-22 | UT-HFR-022: applicationName引数が自動付与されること | E-01 (L162-169), E-02 (L268-281) | ○ |
| C-23 | UT-HFR-023: 既存のapplicationName引数が上書きされないこと | E-01 (L162-164, L166) | ○ |
| C-24 | UT-HFR-024: CreateWebHostBuilderの戻り値型不正時にnullが返ること | E-02 (L88-96) | ○ |
| C-25 | UT-HFR-025: エントリポイントが例外をスローした場合例外が伝播すること | E-01 (L253-266), E-02 (L206-214), E-10 | ○ |
| C-26 | UT-HFR-026: IHostをビルドせずに終了した場合InvalidOperationExceptionがスローされること | E-01 (L247), E-02 (L216-224), E-11 | ○ |
| C-27 | UT-HFR-027: タイムアウト時にInvalidOperationExceptionがスローされること | E-01 (L284-287), E-02 (L226-234), E-12 | ○ |
| C-28 | UT-HFR-028: 引数なしMainメソッドでも解決できること | E-01 (L235-243), E-02 (L236-244), E-13 | ○ |
| C-29 | UT-HFR-029: トップレベルステートメントでも解決できること | E-02 (L246-255), E-14 | ○ |
| C-30 | UT-HFR-030: 並列実行しても正しく動作すること | E-01 (L207, L311-315), E-02 (L283-303) | ○ |
| C-31 | UT-HFR-031: デバッガアタッチ時にInfiniteTimeSpanが返ること | E-01 (L28-31) | △ |
| C-32 | UT-HFR-032: 環境変数からタイムアウトが設定できること | E-01 (L33-36) | ○ |
| C-33 | UT-HFR-033: 環境変数未設定時にデフォルト5分が返ること | E-01 (L38) | ○ |
| C-34 | UT-HFR-034: 環境変数に0が設定された場合TimeSpan.Zeroが返ること | E-01 (L33-36) | ○ |
| C-35 | UT-HFR-035: 環境変数に不正な値が設定された場合デフォルト5分が返ること | E-01 (L33, L38) | ○ |
| C-36 | UT-HFR-036: programTypeがnullの場合nullが返ること | E-01 (L97-101) | ○ |
| C-37 | UT-HFR-037: 指定名のメソッドが存在しない場合nullが返ること | E-01 (L103-107) | ○ |
| C-38 | UT-HFR-038: 正しいシグネチャのメソッドでtrueが返ること | E-01 (L113-119) | ○ |
| C-39 | UT-HFR-039: 戻り値型が異なる場合falseが返ること | E-01 (L116) | ○ |
| C-40 | UT-HFR-040: パラメータ数が異なる場合falseが返ること | E-01 (L117) | ○ |
| C-41 | UT-HFR-041: パラメータ型が異なる場合falseが返ること | E-01 (L118) | ○ |
| C-42 | UT-HFR-042: nullのMethodInfoでfalseが返ること | E-01 (L115) | ○ |
| C-43 | UT-HFR-043: BuildメソッドがあるオブジェクトでBuildが呼ばれること | E-01 (L179-183) | ○ |
| C-44 | UT-HFR-044: Buildメソッドがないオブジェクトでnullが返ること | E-01 (L181-182) | ○ |
| C-45 | UT-HFR-045: Servicesプロパティからサービスプロバイダが取得できること | E-01 (L185-194), E-16 | ○ |
| C-46 | UT-HFR-046: hostがnullの場合nullが返ること | E-01 (L187-190) | ○ |
| C-47 | UT-HFR-047: Servicesプロパティがない場合nullが返ること | E-01 (L192-193) | ○ |
| C-48 | UT-HFR-048: DiagnosticSourceイベントでホストが解決できること | E-01 (L219-297), E-02 (L138-146) | ○ |
| C-49 | UT-HFR-049: HostBuildingイベントでconfigureコールバックが呼ばれること | E-01 (L331-334), E-02 (L148-164) | ○ |
| C-50 | UT-HFR-050: HostBuiltイベントでホストが設定されること | E-01 (L336-345) | ○ |
| C-51 | UT-HFR-051: stopApplication=trueでHostAbortedExceptionがスローされること | E-01 (L340-344, L351-362) | ○ |
| C-52 | UT-HFR-052: タイムアウト時にInvalidOperationExceptionがスローされること | E-01 (L284-287), E-02 (L226-234) | ○ |
| C-53 | UT-HFR-053: エントリポイント例外時に例外が伝播すること | E-01 (L253-266), E-02 (L206-214) | ○ |
| C-54 | UT-HFR-054: IHostをビルドせず終了時にInvalidOperationExceptionがスローされること | E-01 (L247), E-02 (L216-224) | ○ |
| C-55 | UT-HFR-055: Microsoft.Extensions.Hosting DiagnosticListenerを購読すること | E-01 (L309-320) | ○ |
| C-56 | UT-HFR-056: 異なるリスナーからのイベントは無視されること | E-01 (L311-315) | ○ |
| C-57 | UT-HFR-057: HostBuildingイベントでconfigureが呼ばれること | E-01 (L331-334) | ○ |
| C-58 | UT-HFR-058: HostBuiltイベントで_hostTcsが設定されること | E-01 (L336-338) | ○ |
| C-59 | UT-HFR-059: 異なるリスナーからのイベントは無視されること | E-01 (L325-329) | ○ |
| C-60 | UT-HFR-060: HostAbortedExceptionが存在する場合それがスローされること | E-01 (L353-357) | ○ |
| C-61 | UT-HFR-061: HostAbortedExceptionが存在しない場合private例外がスローされること | E-01 (L358-361, L364-366) | △ |
| C-62 | UT-HFR-062: 購読が解除されること | E-01 (L299-302) | ○ |
| C-63 | UT-HFR-063: エラー時に何も行われないこと | E-01 (L304-307) | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-HFR-016, UT-HFR-017**: Microsoft.Extensions.Hostingアセンブリのロード失敗やバージョン検証は、テスト環境で再現が困難。モックまたは特殊なテストアセンブリが必要。
  - 候補：カスタムアセンブリローダー / モック / 統合テスト環境
- **UT-HFR-031**: Debugger.IsAttached=trueの状態をユニットテストで再現することは困難。
  - 候補：条件付きコンパイル / 統合テスト / 手動テスト
- **UT-HFR-061**: 古いバージョンのMicrosoft.Extensions.Hosting.Abstractionsを使用する環境のテストは、NuGetパッケージのバージョン管理が必要。
  - 候補：マルチターゲットテスト / NuGetパッケージダウングレード
- **UT-HFR-063**: OnErrorの空実装は仕様通りだが、意図を確認するドキュメントがない。
  - 候補：コードコメント確認 / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: 環境依存テスト（UT-HFR-016, UT-HFR-017, UT-HFR-031）は実行環境に依存するため、CI/CD環境での再現性に注意が必要
- **0（低リスク）**: フォールバック動作（UT-HFR-061）は古いバージョンとの互換性のためのものであり、新規開発では影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] 全てのパブリックメソッドに対するテストケースが存在するか確認
- [ ] 正常系・異常系・境界値の観点が網羅されているか確認
- [ ] 既存テスト（HostFactoryResolverTests.cs）との整合性を確認
- [ ] タイムアウト関連テストの実行時間が適切か確認（特にUT-HFR-027, UT-HFR-052）
- [ ] スレッドセーフ検証（UT-HFR-030）の並列数が適切か確認
- [ ] 環境依存テスト（UT-HFR-031, UT-HFR-032, UT-HFR-033, UT-HFR-034, UT-HFR-035）の実行方法を確認
