---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 102
  claims_with_evidence: 102
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Hosting.Abstractions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：102 / 102、根拠なし：0
- 優先レビュー（高）
  1. **BackgroundServiceのライフサイクル管理**：StartAsync/StopAsyncの動作確認が重要
  2. **HostEnvironmentEnvExtensionsのnullチェック**：ArgumentNullException.ThrowIfNullの動作確認
  3. **ServiceCollectionHostedServiceExtensionsのDI登録**：TryAddEnumerableの動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/BackgroundService.cs`
- E-02: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostingAbstractionsHostBuilderExtensions.cs`
- E-03: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostingAbstractionsHostExtensions.cs`
- E-04: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostEnvironmentEnvExtensions.cs`
- E-05: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostingEnvironmentExtensions.cs`
- E-06: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/ServiceCollectionHostedServiceExtensions.cs`
- E-07: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostAbortedException.cs`
- E-08: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostBuilderContext.cs`
- E-09: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostDefaults.cs`
- E-10: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/Environments.cs`
- E-11: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/EnvironmentName.cs`
- E-12: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHost.cs`
- E-13: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostBuilder.cs`
- E-14: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostEnvironment.cs`
- E-15: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostedService.cs`
- E-16: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostedLifecycleService.cs`
- E-17: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostLifetime.cs`
- E-18: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostApplicationLifetime.cs`
- E-19: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IApplicationLifetime.cs`
- E-20: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostingEnvironment.cs`
- E-21: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostApplicationBuilder.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### BackgroundService (UT-HOST-001 - UT-HOST-011)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExecuteTaskプロパティはStartAsync前はnullを返す | E-01 (line 24: `public virtual Task? ExecuteTask => _executeTask;`) | ○ |
| C-02 | StartAsync後はExecuteTaskが設定される | E-01 (line 46: `_executeTask = Task.Run(...)`) | ○ |
| C-03 | StartAsyncはTask.CompletedTaskを返す | E-01 (line 49: `return Task.CompletedTask;`) | ○ |
| C-04 | StartAsyncでExecuteAsyncがバックグラウンド実行される | E-01 (line 46: `Task.Run(() => ExecuteAsync(...))`) | ○ |
| C-05 | StopAsyncは_executeTaskがnullなら即座に戻る | E-01 (lines 60-63: `if (_executeTask == null) { return; }`) | ○ |
| C-06 | StopAsyncは_stoppingCtsをキャンセルする | E-01 (line 68: `_stoppingCts!.Cancel();`) | ○ |
| C-07 | StopAsyncはタスク完了を待機する | E-01 (lines 72-80: WaitAsyncまたはTask.WhenAny使用) | ○ |
| C-08 | DisposeはstoppingCtsをキャンセルする | E-01 (line 88: `_stoppingCts?.Cancel();`) | ○ |

### HostingAbstractionsHostBuilderExtensions (UT-HOST-012 - UT-HOST-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | StartはStartAsyncを同期的に呼び出す | E-02 (line 21: `return hostBuilder.StartAsync().GetAwaiter().GetResult();`) | ○ |
| C-10 | StartAsyncはBuildしてからStartAsyncを呼ぶ | E-02 (lines 32-34: `IHost host = hostBuilder.Build(); await host.StartAsync(...)`) | ○ |

### HostingAbstractionsHostExtensions (UT-HOST-015 - UT-HOST-024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | StartはStartAsyncを同期的に呼び出す | E-03 (line 22: `host.StartAsync().GetAwaiter().GetResult();`) | ○ |
| C-12 | StopAsync(TimeSpan)はCancellationTokenSourceを使用 | E-03 (lines 34-35: `using CancellationTokenSource cts = new CancellationTokenSource(timeout);`) | ○ |
| C-13 | WaitForShutdownはWaitForShutdownAsyncを同期呼び出し | E-03 (line 44: `host.WaitForShutdownAsync().GetAwaiter().GetResult();`) | ○ |
| C-14 | RunはRunAsyncを同期呼び出し | E-03 (line 53: `host.RunAsync().GetAwaiter().GetResult();`) | ○ |
| C-15 | RunAsyncはIAsyncDisposable対応 | E-03 (lines 73-79: `if (host is IAsyncDisposable asyncDisposable) { await asyncDisposable.DisposeAsync()...}`) | ○ |
| C-16 | WaitForShutdownAsyncはApplicationStoppingを監視 | E-03 (line 101/104: `applicationLifetime.ApplicationStopping`) | ○ |
| C-17 | WaitForShutdownAsyncはStopAsyncにCancellationToken.Noneを渡す | E-03 (line 115: `await host.StopAsync(CancellationToken.None)`) | ○ |

### HostEnvironmentEnvExtensions (UT-HOST-025 - UT-HOST-037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | IsDevelopmentはEnvironments.Developmentと比較 | E-04 (line 22: `return hostEnvironment.IsEnvironment(Environments.Development);`) | ○ |
| C-19 | IsStagingはEnvironments.Stagingと比較 | E-04 (line 34: `return hostEnvironment.IsEnvironment(Environments.Staging);`) | ○ |
| C-20 | IsProductionはEnvironments.Productionと比較 | E-04 (line 46: `return hostEnvironment.IsEnvironment(Environments.Production);`) | ○ |
| C-21 | IsEnvironmentはOrdinalIgnoreCaseで比較 | E-04 (lines 61-64: `string.Equals(..., StringComparison.OrdinalIgnoreCase)`) | ○ |
| C-22 | 各メソッドはnullチェックを行う | E-04 (lines 20, 32, 44, 59: `ArgumentNullException.ThrowIfNull(hostEnvironment)`) | ○ |

### HostingEnvironmentExtensions (UT-HOST-038 - UT-HOST-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | 非推奨APIも同様の動作をする | E-05 (lines 19-66: HostEnvironmentEnvExtensionsと同等のロジック) | ○ |
| C-24 | EnvironmentName定数を使用 | E-05 (lines 23, 35, 47: `EnvironmentName.Development/Staging/Production`) | ○ |

### ServiceCollectionHostedServiceExtensions (UT-HOST-043 - UT-HOST-048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | AddHostedServiceはTryAddEnumerableを使用 | E-06 (line 25: `services.TryAddEnumerable(ServiceDescriptor.Singleton<IHostedService, THostedService>())`) | ○ |
| C-26 | ファクトリ版もTryAddEnumerableを使用 | E-06 (line 40: `services.TryAddEnumerable(ServiceDescriptor.Singleton<IHostedService>(implementationFactory))`) | ○ |
| C-27 | IServiceCollectionを返却する | E-06 (lines 27, 42: `return services;`) | ○ |

### HostAbortedException (UT-HOST-049 - UT-HOST-053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | デフォルトコンストラクタはSR.HostAbortedExceptionMessageを使用 | E-07 (line 23: `public HostAbortedException() : base(SR.HostAbortedExceptionMessage) { }`) | ○ |
| C-29 | messageがnullの場合デフォルトメッセージを使用 | E-07 (lines 37, 55: `message ?? SR.HostAbortedExceptionMessage`) | ○ |
| C-30 | 内部例外を設定できる | E-07 (line 55: `base(message ?? SR.HostAbortedExceptionMessage, innerException)`) | ○ |

### HostBuilderContext (UT-HOST-054 - UT-HOST-058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | コンストラクタはpropertiesのnullチェックを行う | E-08 (line 21: `ArgumentNullException.ThrowIfNull(properties);`) | ○ |
| C-32 | Propertiesはコンストラクタで設定される | E-08 (line 23: `Properties = properties;`) | ○ |
| C-33 | HostingEnvironmentプロパティが存在 | E-08 (line 29: `public IHostEnvironment HostingEnvironment { get; set; }`) | ○ |
| C-34 | Configurationプロパティが存在 | E-08 (line 34: `public IConfiguration Configuration { get; set; }`) | ○ |

### HostDefaults (UT-HOST-059 - UT-HOST-061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | ApplicationKeyは"applicationName" | E-09 (line 14: `public static readonly string ApplicationKey = "applicationName";`) | ○ |
| C-36 | EnvironmentKeyは"environment" | E-09 (line 19: `public static readonly string EnvironmentKey = "environment";`) | ○ |
| C-37 | ContentRootKeyは"contentRoot" | E-09 (line 25: `public static readonly string ContentRootKey = "contentRoot";`) | ○ |

### Environments (UT-HOST-062 - UT-HOST-064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | Developmentは"Development" | E-10 (line 15: `public static readonly string Development = "Development";`) | ○ |
| C-39 | Stagingは"Staging" | E-10 (line 20: `public static readonly string Staging = "Staging";`) | ○ |
| C-40 | Productionは"Production" | E-10 (line 25: `public static readonly string Production = "Production";`) | ○ |

### EnvironmentName (UT-HOST-065 - UT-HOST-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | 非推奨のEnvironmentName定数が存在 | E-11 (lines 19, 24, 29: 各環境名の定義) | ○ |
| C-42 | Obsolete属性が付与されている | E-11 (line 13: `[System.Obsolete("EnvironmentName has been deprecated...")]`) | ○ |

### インターフェース (UT-HOST-068 - UT-HOST-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | IHostはServices, StartAsync, StopAsync, Disposeを持つ | E-12 (lines 18, 26, 33) | ○ |
| C-44 | IHostBuilderはProperties, Build等のメソッドを持つ | E-13 (lines 19, 28, 38, 46, 54, 62, 71, 77) | ○ |
| C-45 | IHostEnvironmentは環境情報プロパティを持つ | E-14 (lines 18, 24, 29, 34) | ○ |
| C-46 | IHostedServiceはStartAsync, StopAsyncを持つ | E-15 (lines 19, 26) | ○ |
| C-47 | IHostedLifecycleServiceはライフサイクルメソッドを持つ | E-16 (lines 21, 28, 35, 42) | ○ |
| C-48 | IHostLifetimeはWaitForStartAsync, StopAsyncを持つ | E-17 (lines 20, 27) | ○ |
| C-49 | IHostApplicationLifetimeはライフサイクルトークンを持つ | E-18 (lines 16, 22, 28, 33) | ○ |
| C-50 | IHostApplicationBuilderは各種ビルダーを持つ | E-21 (lines 21, 29, 34, 39, 44, 49, 70) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし
  - 全てのテストケースにソースコードの根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースが実際のソースコードに基づいている
- 備考：
  - BackgroundServiceのキャンセル処理はプラットフォーム依存（NET vs 非NET）のため、両方のパスをテストする必要がある
  - 非推奨API（IHostingEnvironment, IApplicationLifetime, EnvironmentName）のテストは互換性維持のために含まれているが、優先度は低い

## 6) レビュアーチェックリスト（最小）
- [ ] BackgroundServiceのStartAsync/StopAsyncのテストケースが非同期処理を適切にカバーしているか
- [ ] HostEnvironmentEnvExtensionsのnullチェックテストが全メソッドに対して定義されているか
- [ ] ServiceCollectionHostedServiceExtensionsのTryAddEnumerableの重複登録防止テストが含まれているか
- [ ] インターフェース（IHost, IHostBuilder等）に対するテストケースが具体的な実装クラスを想定しているか
- [ ] 非推奨APIのテストケースの優先度が適切に「低」に設定されているか
- [ ] CancellationTokenの各種状態（None, キャンセル済み, タイムアウト）に対するテストが網羅されているか
