---
generated_at: 2026-01-30 16:45:00
metrics:
  claims_total: 57
  claims_with_evidence: 57
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Hosting.Systemd.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：57 / 57、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Hosting.Systemd/src/ServiceState.cs`
- E-02: `src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdNotifier.cs`
- E-03: `src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdLifetime.cs`
- E-04: `src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdLifetime.netcoreapp.cs`
- E-05: `src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdLifetime.netstandard.cs`
- E-06: `src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdHelpers.cs`
- E-07: `src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdHostBuilderExtensions.cs`
- E-08: `src/libraries/Microsoft.Extensions.Hosting.Systemd/src/ISystemdNotifier.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ServiceState構造体（UT-SYS-001〜009）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ServiceState(string)コンストラクタでUTF8エンコードされたバイト配列が保持される | E-01: L30-35 `_data = Encoding.UTF8.GetBytes(state)` | ○ |
| C-02 | nullが渡された場合ArgumentNullExceptionがスローされる | E-01: L32 `ArgumentNullException.ThrowIfNull(state)` | ○ |
| C-03 | 空文字列でServiceStateが生成できる | E-01: L34 バリデーションで空文字列は許可 | ○ |
| C-04 | マルチバイト文字がUTF8エンコードで処理される | E-01: L34 `Encoding.UTF8.GetBytes(state)` | ○ |
| C-05 | ToStringで状態文字列が返却される | E-01: L41-42 `Encoding.UTF8.GetString(_data)` | ○ |
| C-06 | デフォルト初期化で空文字列が返却される | E-01: L42 `_data == null ? string.Empty` | ○ |
| C-07 | GetDataで内部バイト配列が返却される | E-01: L44 `internal byte[] GetData() => _data` | ○ |
| C-08 | Ready定数が"READY=1"を表す | E-01: L19 `public static readonly ServiceState Ready = new ServiceState("READY=1")` | ○ |
| C-09 | Stopping定数が"STOPPING=1"を表す | E-01: L24 `public static readonly ServiceState Stopping = new ServiceState("STOPPING=1")` | ○ |

### SystemdNotifierクラス（UT-SYS-010〜020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | NOTIFY_SOCKET環境変数からソケットパスを取得 | E-02: L63 `Environment.GetEnvironmentVariable(NOTIFY_SOCKET)` | ○ |
| C-11 | 環境変数未設定時にIsEnabled=false | E-02: L65-68 null/空チェックでnull返却、L34 `IsEnabled => _socketPath != null` | ○ |
| C-12 | 空文字列でIsEnabled=false | E-02: L65 `string.IsNullOrEmpty(socketPath)` | ○ |
| C-13 | 内部コンストラクタでソケットパス設定 | E-02: L28-31 internal constructor | ○ |
| C-14 | 内部コンストラクタnull入力でIsEnabled=false | E-02: L30 `_socketPath = socketPath`、L34 nullチェック | ○ |
| C-15 | IsEnabledプロパティの動作 | E-02: L34 `public bool IsEnabled => _socketPath != null` | ○ |
| C-16 | IsEnabled=falseでNotifyがスキップ | E-02: L39-42 `if (!IsEnabled) return` | ○ |
| C-17 | 抽象ソケットパス（@プレフィックス）の変換 | E-02: L70-78 `if (socketPath[0] == '@')` で先頭を`\0`に変換 | ○ |
| C-18 | 通常パスはそのまま返却 | E-02: L80 `return socketPath` | ○ |
| C-19 | Notifyメソッドでソケット送信 | E-02: L50-58 Socket作成、Connect、Send | ○ |
| C-20 | 抽象ソケットパス先頭@がnull文字に変換 | E-02: L73-77 `buffer[0] = '\0'` | ○ |

### SystemdLifetimeクラス（UT-SYS-021〜038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | コンストラクタで全依存関係設定 | E-03: L32-43 コンストラクタでプロパティ設定 | ○ |
| C-22 | environment null検証 | E-03: L34 `ArgumentNullException.ThrowIfNull(environment)` | ○ |
| C-23 | applicationLifetime null検証 | E-03: L35 `ArgumentNullException.ThrowIfNull(applicationLifetime)` | ○ |
| C-24 | systemdNotifier null検証 | E-03: L36 `ArgumentNullException.ThrowIfNull(systemdNotifier)` | ○ |
| C-25 | loggerFactory null検証 | E-03: L37 `ArgumentNullException.ThrowIfNull(loggerFactory)` | ○ |
| C-26 | WaitForStartAsyncでApplicationStartedハンドラ登録 | E-03: L75-79 `ApplicationLifetime.ApplicationStarted.Register` | ○ |
| C-27 | WaitForStartAsyncでApplicationStoppingハンドラ登録 | E-03: L80-84 `ApplicationLifetime.ApplicationStopping.Register` | ○ |
| C-28 | SIGTERMシグナルハンドラ登録（.NET Core） | E-04: L18 `PosixSignalRegistration.Create(PosixSignal.SIGTERM, HandlePosixSignal)` | ○ |
| C-29 | StopAsyncはTask.CompletedTask返却 | E-03: L59-62 `return Task.CompletedTask` | ○ |
| C-30 | OnApplicationStartedでServiceState.Ready通知 | E-03: L101 `SystemdNotifier.Notify(ServiceState.Ready)` | ○ |
| C-31 | OnApplicationStartedでログ出力 | E-03: L97-98 `Logger.LogInformation("Application started..."` | ○ |
| C-32 | OnApplicationStoppingでServiceState.Stopping通知 | E-03: L108 `SystemdNotifier.Notify(ServiceState.Stopping)` | ○ |
| C-33 | OnApplicationStoppingでシャットダウンログ出力 | E-03: L106 `Logger.LogInformation("Application is shutting down...")` | ○ |
| C-34 | DisposeでCancellationTokenRegistration解放 | E-03: L118-119 `_applicationStartedRegistration.Dispose()` | ○ |
| C-35 | DisposeでPosixSignalRegistration解放 | E-04: L31 `_sigTermRegistration?.Dispose()` | ○ |
| C-36 | HandlePosixSignalでStopApplication呼び出し | E-04: L26 `ApplicationLifetime.StopApplication()` | ○ |
| C-37 | OnProcessExit（netstandard）でStopApplication呼び出し | E-05: L21 `ApplicationLifetime.StopApplication()` | ○ |
| C-38 | OnProcessExit（netstandard）でExitCode=0設定 | E-05: L27 `System.Environment.ExitCode = 0` | ○ |

### SystemdHelpersクラス（UT-SYS-039〜044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | Unix以外でfalse返却 | E-06: L32-35 `if (Environment.OSVersion.Platform != PlatformID.Unix) return false` | ○ |
| C-40 | PID 1でNOTIFY_SOCKET設定時にtrue | E-06: L46-49 `if (processId == 1) ... !string.IsNullOrEmpty(Environment.GetEnvironmentVariable("NOTIFY_SOCKET"))` | ○ |
| C-41 | PID 1でLISTEN_PID設定時にtrue | E-06: L49 `!string.IsNullOrEmpty(Environment.GetEnvironmentVariable("LISTEN_PID"))` | ○ |
| C-42 | 親プロセスがsystemdでtrue | E-06: L57-58 `File.ReadAllBytes("/proc/" + ppidString + "/comm")` → `"systemd\n"u8` 比較 | ○ |
| C-43 | 親プロセスが非systemdでfalse | E-06: L58 SequenceEqual比較失敗時 | ○ |
| C-44 | /proc読み取りエラー時false | E-06: L60-62 `catch { }` で例外握りつぶし、L64 `return false` | ○ |

### SystemdHostBuilderExtensionsクラス（UT-SYS-045〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | UseSystemdでsystemd環境時にサービス登録 | E-07: L37-43 `if (SystemdHelpers.IsSystemdService()) { AddSystemdLifetime(services) }` | ○ |
| C-46 | UseSystemdで非systemd環境時に登録スキップ | E-07: L37 if条件で分岐 | ○ |
| C-47 | UseSystemd null検証 | E-07: L35 `ArgumentNullException.ThrowIfNull(hostBuilder)` | ○ |
| C-48 | UseSystemdでhostBuilder返却 | E-07: L44 `return hostBuilder` | ○ |
| C-49 | AddSystemdでsystemd環境時にサービス登録 | E-07: L72-74 `if (SystemdHelpers.IsSystemdService()) { AddSystemdLifetime(services) }` | ○ |
| C-50 | AddSystemdで非systemd環境時に登録スキップ | E-07: L72 if条件で分岐 | ○ |
| C-51 | AddSystemd null検証 | E-07: L70 `ArgumentNullException.ThrowIfNull(services)` | ○ |
| C-52 | AddSystemdでservices返却 | E-07: L76 `return services` | ○ |
| C-53 | AddSystemdLifetimeでConsoleLoggerOptions設定 | E-07: L81-84 `services.Configure<ConsoleLoggerOptions>(options => { options.FormatterName = ConsoleFormatterNames.Systemd })` | ○ |
| C-54 | ISystemdNotifierシングルトン登録 | E-07: L88 `services.AddSingleton<ISystemdNotifier, SystemdNotifier>()` | ○ |
| C-55 | IHostLifetimeシングルトン登録 | E-07: L89 `services.AddSingleton<IHostLifetime, SystemdLifetime>()` | ○ |

### ISystemdNotifierインターフェース（UT-SYS-056〜057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | Notifyメソッドのインターフェース定義 | E-08: L15 `void Notify(ServiceState state)` | ○ |
| C-57 | IsEnabledプロパティのインターフェース定義 | E-08: L19 `bool IsEnabled { get; }` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースについてソースコードの根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり
- 注意点：
  - プラットフォーム依存のテスト（Unix/Windows、.NET Core/.NET Standard）は実行環境に依存
  - ソケット通信を伴うテスト（SystemdNotifier.Notify）は実際のsystemd環境またはモックが必要
  - PosixSignalRegistrationのテストはLinux/macOS環境が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ServiceStateのnullハンドリングが仕様通りか確認
- [ ] SystemdNotifierの抽象ソケットパス変換ロジックが正しいか確認
- [ ] SystemdLifetimeの各イベントハンドラが適切なタイミングで呼ばれるか確認
- [ ] SystemdHelpersのプラットフォーム判定ロジックが網羅的か確認
- [ ] DIコンテナへのサービス登録が正しいライフタイム（Singleton）か確認
- [ ] プラットフォーム依存テストの実行環境要件を確認
