---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 43
  claims_with_evidence: 43
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Hosting.WindowsServices 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で該当の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：43 / 43、根拠なし：0
- 優先レビュー（高）
  1. **Win32.GetParentProcess**：プラットフォーム依存のためWindows環境でのみテスト可能
  2. **WindowsServiceHelpers.IsWindowsService**：静的フィールドによるキャッシュのためテスト分離が必要
  3. **WindowsServiceLifetime.WaitForStartAsync**：スレッド起動を伴うため非同期テストの設計に注意

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Hosting.WindowsServices/src/WindowsServiceLifetime.cs`
- E-02: `src/libraries/Microsoft.Extensions.Hosting.WindowsServices/src/WindowsServiceHelpers.cs`
- E-03: `src/libraries/Microsoft.Extensions.Hosting.WindowsServices/src/WindowsServiceLifetimeOptions.cs`
- E-04: `src/libraries/Microsoft.Extensions.Hosting.WindowsServices/src/WindowsServiceLifetimeHostBuilderExtensions.cs`
- E-05: `src/libraries/Microsoft.Extensions.Hosting.WindowsServices/src/Internal/Win32.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### WindowsServiceLifetime クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタ(4引数)で全パラメータが有効な場合に正常に初期化される | E-01 (L33-36) | ○ |
| C-02 | コンストラクタでenvironmentがnullの場合ArgumentNullExceptionがスローされる | E-01 (L48) | ○ |
| C-03 | コンストラクタでapplicationLifetimeがnullの場合ArgumentNullExceptionがスローされる | E-01 (L49) | ○ |
| C-04 | コンストラクタでloggerFactoryがnullの場合ArgumentNullExceptionがスローされる | E-01 (L50) | ○ |
| C-05 | コンストラクタでoptionsAccessorがnullの場合ArgumentNullExceptionがスローされる | E-01 (L51) | ○ |
| C-06 | コンストラクタ(5引数)で全パラメータが有効な場合に正常に初期化される | E-01 (L46-60) | ○ |
| C-07 | コンストラクタでwindowsServiceOptionsAccessorがnullの場合ArgumentNullExceptionがスローされる | E-01 (L52) | ○ |
| C-08 | WaitForStartAsyncでキャンセルトークンとイベントハンドラが登録される | E-01 (L75-97) | ○ |
| C-09 | WaitForStartAsyncでキャンセルされた場合TaskCanceledExceptionがスローされる | E-01 (L77) | ○ |
| C-10 | StopAsyncでサービス停止が正常に完了する | E-01 (L123-134) | ○ |
| C-11 | StopAsyncでキャンセルされた場合OperationCanceledExceptionがスローされる | E-01 (L125) | ○ |
| C-12 | _serviceStopRequested=trueの場合Stop()が重複呼び出しされない | E-01 (L127-130) | ○ |
| C-13 | OnStartで_delayStartが完了する | E-01 (L138-142) | ○ |
| C-14 | OnStartでargsが空配列の場合も正常に動作する | E-01 (L138-142) | ○ |
| C-15 | OnStopでApplicationLifetime.StopApplicationが呼び出される | E-01 (L151-158) | ○ |
| C-16 | OnStopで_serviceStopRequestedがtrueに設定される | E-01 (L153) | ○ |
| C-17 | ShutdownTimeout超過時もbase.OnStopが呼び出される | E-01 (L156-157) | ○ |
| C-18 | OnShutdownでApplicationLifetime.StopApplicationが呼び出される | E-01 (L167-174) | ○ |
| C-19 | OnShutdownで_serviceStopRequestedがtrueに設定される | E-01 (L169) | ○ |
| C-20 | Dispose時に_delayStopがSetされる | E-01 (L180-188) | ○ |
| C-21 | disposing=falseの場合_delayStopがSetされない | E-01 (L182-185) | ○ |

### WindowsServiceHelpers クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | Windowsサービスとして実行中の場合trueが返却される | E-02 (L24, L26-47) | ○ |
| C-23 | 通常プロセスとして実行中の場合falseが返却される | E-02 (L46) | ○ |
| C-24 | 非Windowsプラットフォームの場合falseが返却される | E-02 (L28-39) | ○ |
| C-25 | 親プロセスが取得できない場合falseが返却される | E-02 (L42-45) | ○ |

### WindowsServiceLifetimeOptions クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | ServiceNameのデフォルト値が空文字列である | E-03 (L16) | ○ |
| C-27 | ServiceNameに値を設定できる | E-03 (L16) | ○ |
| C-28 | ServiceNameにnullを設定できる | E-03 (L16) | ○ |

### WindowsServiceLifetimeHostBuilderExtensions クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | UseWindowsService(IHostBuilder)でWindowsServiceLifetimeが登録される | E-04 (L29-58) | ○ |
| C-30 | 非サービス時は何も登録されない | E-04 (L49-55) | ○ |
| C-31 | hostBuilderがnullの場合ArgumentNullExceptionがスローされる | E-04 (L47) | ○ |
| C-32 | UseWindowsService(IHostBuilder, Action)でconfigureアクションが実行される | E-04 (L45-58) | ○ |
| C-33 | EventLogロギングが追加される | E-04 (L113-119) | ○ |
| C-34 | AddWindowsService(IServiceCollection)でWindowsServiceLifetimeが登録される | E-04 (L75-105) | ○ |
| C-35 | AddWindowsService非サービス時は何も登録されない | E-04 (L99-103) | ○ |
| C-36 | servicesがnullの場合ArgumentNullExceptionがスローされる | E-04 (L97) | ○ |
| C-37 | AddWindowsService(IServiceCollection, Action)でconfigureアクションが実行される | E-04 (L95-105) | ○ |
| C-38 | EventLogSettingsSetup.ConfigureでSourceNameが空の場合アプリケーション名が設定される | E-04 (L134-143) | ○ |
| C-39 | EventLogSettingsSetup.ConfigureでSourceNameが設定済みの場合上書きされない | E-04 (L140-143) | ○ |

### Internal.Win32 クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | GetParentProcessで親プロセスが取得できる | E-05 (L14-51) | ○ |
| C-41 | スナップショット取得失敗時nullが返却される | E-05 (L42-44) | ○ |
| C-42 | 現在のプロセスが見つからない場合nullが返却される | E-05 (L50) | ○ |
| C-43 | 親プロセスが存在しない場合例外がキャッチされnullが返却される | E-05 (L42-44) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードに基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全テストケースにソースコードの根拠が存在
- 1（中リスク）：Win32クラスのテストはプラットフォーム依存のため、モック化やスキップ条件が必要
- 1（中リスク）：WindowsServiceHelpers.IsWindowsServiceは静的フィールドでキャッシュされるため、テスト間の分離に注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] WindowsServiceLifetimeのコンストラクタで全ての依存関係のnullチェックがテストされているか
- [ ] WaitForStartAsync/StopAsyncの非同期動作とキャンセル処理が適切にテストされているか
- [ ] OnStop/OnShutdownでShutdownTimeoutの待機動作が正しくテストされているか
- [ ] WindowsServiceHelpersのプラットフォーム判定ロジックが全てのケースをカバーしているか
- [ ] Win32.GetParentProcessのエラーハンドリングが網羅されているか
- [ ] EventLogSettingsSetupのSourceName設定ロジックが正しくテストされているか
- [ ] 拡張メソッド（UseWindowsService/AddWindowsService）の条件分岐が全てテストされているか
