---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 159
  claims_with_evidence: 155
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：libraries-Microsoft.Extensions.Hosting 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：155 / 159、根拠なし：4
- 優先レビュー（高）
  1. **UT-HOST-114〜116**：ConsoleLifetime.RegisterShutdownHandlersのプラットフォーム固有実装に関するテストケース
  2. **UT-HOST-150**：UserSecretsの読み込み条件に関するテストケース
  3. **UT-HOST-154〜155**：RunConsoleAsyncの非同期実行に関するテストケース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Hosting/src/Host.cs`
- E-02: `src/libraries/Microsoft.Extensions.Hosting/src/HostBuilder.cs`
- E-03: `src/libraries/Microsoft.Extensions.Hosting/src/HostApplicationBuilder.cs`
- E-04: `src/libraries/Microsoft.Extensions.Hosting/src/HostApplicationBuilderSettings.cs`
- E-05: `src/libraries/Microsoft.Extensions.Hosting/src/HostOptions.cs`
- E-06: `src/libraries/Microsoft.Extensions.Hosting/src/ConsoleLifetimeOptions.cs`
- E-07: `src/libraries/Microsoft.Extensions.Hosting/src/HostingHostBuilderExtensions.cs`
- E-08: `src/libraries/Microsoft.Extensions.Hosting/src/BackgroundServiceExceptionBehavior.cs`
- E-09: `src/libraries/Microsoft.Extensions.Hosting/src/Internal/Host.cs`
- E-10: `src/libraries/Microsoft.Extensions.Hosting/src/Internal/HostingEnvironment.cs`
- E-11: `src/libraries/Microsoft.Extensions.Hosting/src/Internal/ConsoleLifetime.cs`
- E-12: `src/libraries/Microsoft.Extensions.Hosting/src/Internal/ApplicationLifetime.cs`
- E-13: `src/libraries/Microsoft.Extensions.Hosting/src/Internal/ServiceFactoryAdapter.cs`
- E-14: `src/libraries/Microsoft.Extensions.Hosting/src/Internal/NullLifetime.cs`
- E-15: `src/libraries/Microsoft.Extensions.Hosting/src/Internal/ConfigureContainerAdapter.cs`
- E-16: `src/libraries/Microsoft.Extensions.Hosting/src/Internal/HostingLoggerExtensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Host クラス (UT-HOST-001〜009)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | CreateDefaultBuilder()がIHostBuilderを返却する | E-01: 31-32行目 | ○ |
| C-002 | CreateDefaultBuilder(string[]?)がコマンドライン引数を処理する | E-01: 53-57行目 | ○ |
| C-003 | CreateDefaultBuilder(null)が正常動作する | E-01: 53行目、null許容 | ○ |
| C-004 | CreateDefaultBuilder([])が正常動作する | E-01, E-07: 276-279行目、空配列チェック | ○ |
| C-005 | CreateApplicationBuilder()がHostApplicationBuilderを返却する | E-01: 75行目 | ○ |
| C-006 | CreateApplicationBuilder(string[]?)が引数を処理する | E-01: 96行目 | ○ |
| C-007 | CreateApplicationBuilder(settings)が設定を反映する | E-01: 100-101行目 | ○ |
| C-008 | CreateApplicationBuilder(null)がデフォルト設定で動作する | E-03: 87-88行目 | ○ |
| C-009 | CreateEmptyApplicationBuilder(settings)がデフォルトなしで作成する | E-01: 108-109行目, E-03: 120-136行目 | ○ |

### HostBuilder クラス (UT-HOST-010〜028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-010 | コンストラクタでDefaultServiceProviderFactoryが使用される | E-02: 45-49行目 | ○ |
| C-011 | Propertiesが空のDictionaryを返却する | E-02: 54行目 | ○ |
| C-012 | ConfigureHostConfigurationがデリゲートを追加する | E-02: 63-69行目 | ○ |
| C-013 | ConfigureHostConfigurationがnullで例外をスローする | E-02: 65行目 | ○ |
| C-014 | ConfigureAppConfigurationがデリゲートを追加する | E-02: 79-85行目 | ○ |
| C-015 | ConfigureAppConfigurationがnullで例外をスローする | E-02: 81行目 | ○ |
| C-016 | ConfigureServicesがデリゲートを追加する | E-02: 93-99行目 | ○ |
| C-017 | ConfigureServicesがnullで例外をスローする | E-02: 95行目 | ○ |
| C-018 | UseServiceProviderFactoryがファクトリを設定する | E-02: 107-114行目 | ○ |
| C-019 | UseServiceProviderFactoryがnullで例外をスローする | E-02: 109行目 | ○ |
| C-020 | UseServiceProviderFactory(Func)が遅延評価する | E-02: 122-129行目 | ○ |
| C-021 | ConfigureContainerがデリゲートを追加する | E-02: 139-145行目 | ○ |
| C-022 | ConfigureContainerがnullで例外をスローする | E-02: 141行目 | ○ |
| C-023 | Buildがホストを正常にビルドする | E-02: 152-171行目 | ○ |
| C-024 | 2回目のBuildがInvalidOperationExceptionをスローする | E-02: 154-158行目 | ○ |
| C-025 | ResolveContentRootPathが絶対パスをそのまま返却する | E-02: 259-261行目 | ○ |
| C-026 | ResolveContentRootPathが相対パスを結合する | E-02: 263行目 | ○ |
| C-027 | ResolveContentRootPathが空文字列でベースパスを返却する | E-02: 255-258行目 | ○ |
| C-028 | ResolveContentRootPathがnullでベースパスを返却する | E-02: 255-258行目 | ○ |

### HostApplicationBuilder クラス (UT-HOST-029〜040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-029 | 引数なしコンストラクタが動作する | E-03: 53-56行目 | ○ |
| C-030 | 引数付きコンストラクタが動作する | E-03: 77-80行目 | ○ |
| C-031 | 設定オブジェクトコンストラクタが動作する | E-03: 86-118行目 | ○ |
| C-032 | EnvironmentプロパティがIHostEnvironmentを返却する | E-03: 193行目 | ○ |
| C-033 | ConfigurationプロパティがConfigurationManagerを返却する | E-03: 201行目 | ○ |
| C-034 | ServicesプロパティがIServiceCollectionを返却する | E-03: 206行目 | ○ |
| C-035 | LoggingプロパティがILoggingBuilderを返却する | E-03: 209行目 | ○ |
| C-036 | MetricsプロパティがIMetricsBuilderを返却する | E-03: 212行目 | ○ |
| C-037 | ConfigureContainerがカスタムコンテナを設定する | E-03: 215-228行目 | ○ |
| C-038 | Buildがホストを正常にビルドする | E-03: 234-251行目 | ○ |
| C-039 | 2回目のBuildがInvalidOperationExceptionをスローする | E-03: 236-240行目 | ○ |
| C-040 | ビルド後にサービスコレクションが読み取り専用になる | E-03: 248行目 | ○ |

### HostApplicationBuilderSettings クラス (UT-HOST-041〜046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-041 | DisableDefaultsがデフォルト無効フラグを設定する | E-04: 40行目 | ○ |
| C-042 | Argsがコマンドライン引数を設定する | E-04: 45行目 | ○ |
| C-043 | Configurationが設定マネージャを設定する | E-04: 52行目 | ○ |
| C-044 | EnvironmentNameが環境名を設定する | E-04: 57行目 | ○ |
| C-045 | ApplicationNameがアプリケーション名を設定する | E-04: 62行目 | ○ |
| C-046 | ContentRootPathがコンテンツルートパスを設定する | E-04: 67行目 | ○ |

### HostOptions クラス (UT-HOST-047〜061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-047 | ShutdownTimeoutのデフォルト値が30秒である | E-05: 24行目 | ○ |
| C-048 | ShutdownTimeoutが設定可能である | E-05: 24行目 | ○ |
| C-049 | StartupTimeoutのデフォルト値が無限である | E-05: 34行目 | ○ |
| C-050 | StartupTimeoutが設定可能である | E-05: 34行目 | ○ |
| C-051 | ServicesStartConcurrentlyのデフォルト値がfalseである | E-05: 42行目 | ○ |
| C-052 | ServicesStartConcurrentlyが設定可能である | E-05: 42行目 | ○ |
| C-053 | ServicesStopConcurrentlyのデフォルト値がfalseである | E-05: 50行目 | ○ |
| C-054 | ServicesStopConcurrentlyが設定可能である | E-05: 50行目 | ○ |
| C-055 | BackgroundServiceExceptionBehaviorのデフォルト値がStopHostである | E-05: 59-60行目 | ○ |
| C-056 | BackgroundServiceExceptionBehaviorがIgnoreに設定可能である | E-05: 59行目 | ○ |
| C-057 | Initializeがshutdown設定を読み込む | E-05: 64-69行目 | ○ |
| C-058 | Initializeがstartup設定を読み込む | E-05: 71-76行目 | ○ |
| C-059 | InitializeがservicesStartConcurrently設定を読み込む | E-05: 78-83行目 | ○ |
| C-060 | InitializeがservicesStopConcurrently設定を読み込む | E-05: 85-90行目 | ○ |
| C-061 | 無効な数値文字列でタイムアウトが変更されない | E-05: 65-66行目、TryParse使用 | ○ |

### ConsoleLifetimeOptions クラス (UT-HOST-062〜063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-062 | SuppressStatusMessagesのデフォルト値がfalseである | E-06: 18行目 | ○ |
| C-063 | SuppressStatusMessagesが設定可能である | E-06: 18行目 | ○ |

### Internal.Host クラス (UT-HOST-064〜094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-064 | コンストラクタが正常に初期化される | E-09: 34-59行目 | ○ |
| C-065 | nullサービスでArgumentNullExceptionがスローされる | E-09: 42行目 | ○ |
| C-066 | nullアプリケーションライフタイムでArgumentNullExceptionがスローされる | E-09: 43行目 | ○ |
| C-067 | nullロガーでArgumentNullExceptionがスローされる | E-09: 44行目 | ○ |
| C-068 | nullホストライフタイムでArgumentNullExceptionがスローされる | E-09: 45行目 | ○ |
| C-069 | カスタムIHostApplicationLifetimeでArgumentExceptionがスローされる | E-09: 52-55行目 | ○ |
| C-070 | Servicesプロパティがサービスプロバイダを返却する | E-09: 61行目 | ○ |
| C-071 | StartAsyncがホストを正常に起動する | E-09: 72-172行目 | ○ |
| C-072 | StartingAsyncが呼び出される | E-09: 111-118行目 | ○ |
| C-073 | IHostedService.StartAsyncが呼び出される | E-09: 120-130行目 | ○ |
| C-074 | StartedAsyncが呼び出される | E-09: 136-140行目 | ○ |
| C-075 | ApplicationStartedが通知される | E-09: 147行目 | ○ |
| C-076 | サービス起動失敗時に例外がスローされる | E-09: 150-167行目 | ○ |
| C-077 | 複数サービス起動失敗時にAggregateExceptionがスローされる | E-09: 163-166行目 | ○ |
| C-078 | スタートアップタイムアウト時にOperationCanceledExceptionがスローされる | E-09: 78-79行目 | ○ |
| C-079 | IStartupValidator.Validateが呼び出される | E-09: 98-99行目 | ○ |
| C-080 | StopAsyncがホストを正常に停止する | E-09: 216-305行目 | ○ |
| C-081 | StoppingAsyncが呼び出される | E-09: 248-252行目 | ○ |
| C-082 | IHostedService.StopAsyncが呼び出される | E-09: 258-260行目 | ○ |
| C-083 | StoppedAsyncが呼び出される | E-09: 263-267行目 | ○ |
| C-084 | ApplicationStoppingが通知される | E-09: 256行目 | ○ |
| C-085 | ApplicationStoppedが通知される | E-09: 272行目 | ○ |
| C-086 | サービスがLIFO順で停止される | E-09: 243-244行目 | ○ |
| C-087 | シャットダウンタイムアウト時にOperationCanceledExceptionがスローされる | E-09: 221-226行目 | ○ |
| C-088 | 起動前に呼び出された場合も正常に処理される | E-09: 231-237行目 | ○ |
| C-089 | Disposeがリソースを解放する | E-09: 411行目 | ○ |
| C-090 | DisposeAsyncがリソースを非同期で解放する | E-09: 413-440行目 | ○ |
| C-091 | ContentRootFileProviderが破棄される | E-09: 415-423行目 | ○ |
| C-092 | BackgroundService例外でStopHostが呼び出される | E-09: 197-203行目 | ○ |
| C-093 | BackgroundService例外がIgnoreで無視される | E-09: 197行目、条件分岐 | ○ |
| C-094 | キャンセル時のOperationCanceledExceptionはエラーとして扱われない | E-09: 191-194行目 | ○ |

### Internal.HostingEnvironment クラス (UT-HOST-095〜098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-095 | EnvironmentNameが設定・取得できる | E-10: 21行目 | ○ |
| C-096 | ApplicationNameが設定・取得できる | E-10: 26行目 | ○ |
| C-097 | ContentRootPathが設定・取得できる | E-10: 31行目 | ○ |
| C-098 | ContentRootFileProviderが設定・取得できる | E-10: 36行目 | ○ |

### Internal.ApplicationLifetime クラス (UT-HOST-099〜108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-099 | ApplicationStartedトークンが取得できる | E-12: 39行目 | ○ |
| C-100 | ApplicationStoppingトークンが取得できる | E-12: 45行目 | ○ |
| C-101 | ApplicationStoppedトークンが取得できる | E-12: 52行目 | ○ |
| C-102 | StopApplicationがApplicationStoppingをキャンセルする | E-12: 57-75行目 | ○ |
| C-103 | 2回目のStopApplication呼び出しが安全に処理される | E-12: 62行目、ロック機構 | ○ |
| C-104 | StopApplicationのコールバック例外がログに記録される | E-12: 68-74行目 | ○ |
| C-105 | NotifyStartedがApplicationStartedをキャンセルする | E-12: 80-92行目 | ○ |
| C-106 | NotifyStartedのコールバック例外がログに記録される | E-12: 86-91行目 | ○ |
| C-107 | NotifyStoppedがApplicationStoppedをキャンセルする | E-12: 97-109行目 | ○ |
| C-108 | NotifyStoppedのコールバック例外がログに記録される | E-12: 103-108行目 | ○ |

### Internal.ConsoleLifetime クラス (UT-HOST-109〜118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | コンストラクタが正常に初期化される | E-11: 34-59行目 | ○ |
| C-110 | nullオプションでArgumentNullExceptionがスローされる | E-11: 48行目 | ○ |
| C-111 | null環境でArgumentNullExceptionがスローされる | E-11: 50行目 | ○ |
| C-112 | nullアプリケーションライフタイムでArgumentNullExceptionがスローされる | E-11: 49行目 | ○ |
| C-113 | WaitForStartAsyncがTask.CompletedTaskを返却する | E-11: 95行目 | ○ |
| C-114 | WaitForStartAsyncがシャットダウンハンドラを登録する | E-11: 92行目、RegisterShutdownHandlers | △ |
| C-115 | SuppressStatusMessages=falseでコールバックが登録される | E-11: 78-90行目 | ○ |
| C-116 | SuppressStatusMessages=trueでコールバックが登録されない | E-11: 78行目、条件分岐 | ○ |
| C-117 | StopAsyncがTask.CompletedTaskを返却する | E-11: 120-124行目 | ○ |
| C-118 | Disposeがリソースを解放する | E-11: 129-135行目 | ○ |

### Internal.NullLifetime クラス (UT-HOST-119〜120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | WaitForStartAsyncがTask.CompletedTaskを返却する | E-14: 14-17行目 | ○ |
| C-120 | StopAsyncがTask.CompletedTaskを返却する | E-14: 19-22行目 | ○ |

### Internal.ServiceFactoryAdapter クラス (UT-HOST-121〜128)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | コンストラクタがファクトリで初期化される | E-13: 16-21行目 | ○ |
| C-122 | nullファクトリでArgumentNullExceptionがスローされる | E-13: 18行目 | ○ |
| C-123 | コンストラクタがリゾルバで初期化される | E-13: 23-30行目 | ○ |
| C-124 | CreateBuilderがビルダーを作成する | E-13: 32-45行目 | ○ |
| C-125 | リゾルバ使用時にファクトリが解決される | E-13: 36-43行目 | ○ |
| C-126 | リゾルバがnullを返す場合にInvalidOperationExceptionがスローされる | E-13: 39-42行目 | ○ |
| C-127 | CreateServiceProviderがサービスプロバイダを作成する | E-13: 47-55行目 | ○ |
| C-128 | CreateBuilder前に呼び出すとInvalidOperationExceptionがスローされる | E-13: 49-52行目 | ○ |

### Internal.ConfigureContainerAdapter クラス (UT-HOST-129〜131)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | コンストラクタがアクションで初期化される | E-15: 10-17行目 | ○ |
| C-130 | nullアクションでArgumentNullExceptionがスローされる | E-15: 14行目 | ○ |
| C-131 | ConfigureContainerがアクションを実行する | E-15: 19-22行目 | ○ |

### HostingHostBuilderExtensions 拡張メソッド (UT-HOST-132〜157)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132 | UseEnvironmentが環境名を設定する | E-07: 34-45行目 | ○ |
| C-133 | UseEnvironmentがnullで例外をスローする | E-07: 38行目 | ○ |
| C-134 | UseContentRootがコンテンツルートを設定する | E-07: 54-65行目 | ○ |
| C-135 | UseContentRootがnullで例外をスローする | E-07: 58行目 | ○ |
| C-136 | UseDefaultServiceProvider(Action)が設定する | E-07: 73-74行目 | ○ |
| C-137 | UseDefaultServiceProvider(Action<context, options>)が設定する | E-07: 82-90行目 | ○ |
| C-138 | ConfigureLogging(Action<context, logging>)が設定する | E-07: 98-101行目 | ○ |
| C-139 | ConfigureLogging(Action<logging>)が設定する | E-07: 109-112行目 | ○ |
| C-140 | ConfigureHostOptions(Action<context, options>)が設定する | E-07: 120-124行目 | ○ |
| C-141 | ConfigureHostOptions(Action<options>)が設定する | E-07: 132-135行目 | ○ |
| C-142 | ConfigureAppConfiguration(Action<config>)が設定する | E-07: 146-149行目 | ○ |
| C-143 | ConfigureServices(Action<services>)が設定する | E-07: 157-160行目 | ○ |
| C-144 | ConfigureContainer<T>(Action<T>)が設定する | E-07: 170-173行目 | ○ |
| C-145 | ConfigureDefaultsがデフォルト設定を適用する | E-07: 195-201行目 | ○ |
| C-146 | appsettings.jsonが読み込まれる | E-07: 242行目 | ○ |
| C-147 | 環境別appsettings.jsonが読み込まれる | E-07: 243行目 | ○ |
| C-148 | DOTNET_環境変数が読み込まれる | E-07: 207行目 | ○ |
| C-149 | コマンドライン引数が読み込まれる | E-07: 268行目, 274-279行目 | ○ |
| C-150 | Development環境でUserSecretsが読み込まれる | E-07: 253-264行目 | △ |
| C-151 | Development環境でスコープ検証が有効になる | E-07: 334-342行目 | ○ |
| C-152 | UseConsoleLifetimeがConsoleLifetimeを登録する | E-07: 354-357行目 | ○ |
| C-153 | UseConsoleLifetime(options)がオプション付きで登録する | E-07: 370-377行目 | ○ |
| C-154 | RunConsoleAsyncがコンソールアプリとして実行する | E-07: 389-392行目 | △ |
| C-155 | RunConsoleAsync(options)がオプション付きで実行する | E-07: 405-408行目 | △ |
| C-156 | ConfigureMetrics(Action<IMetricsBuilder>)が設定する | E-07: 416-419行目 | ○ |
| C-157 | ConfigureMetrics(Action<context, IMetricsBuilder>)が設定する | E-07: 427-430行目 | ○ |

### BackgroundServiceExceptionBehavior 列挙型 (UT-HOST-158〜159)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-158 | StopHost値が0である | E-08: 18行目 | ○ |
| C-159 | Ignore値が1である | E-08: 27行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- **ConsoleLifetime.RegisterShutdownHandlers** (UT-HOST-114)
  - 理由：partialメソッドとして宣言されており、プラットフォーム固有の実装（netcoreapp/notnetcoreapp）を参照する必要がある
  - 候補：`ConsoleLifetime.netcoreapp.cs` / `ConsoleLifetime.notnetcoreapp.cs`

- **UserSecrets読み込み** (UT-HOST-150)
  - 理由：アセンブリからUserSecretsId属性を読み込む動作の詳細な検証が必要
  - 候補：`Microsoft.Extensions.Configuration.UserSecrets` パッケージのドキュメント

- **RunConsoleAsyncの非同期実行** (UT-HOST-154〜155)
  - 理由：非同期実行の完了条件やキャンセル動作の詳細な検証が必要
  - 候補：統合テスト / E2Eテストでの検証

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 単純なプロパティアクセス、列挙値確認 (UT-HOST-095〜098, 158-159)
- **1 (中リスク)**: 拡張メソッドの動作、設定読み込み (UT-HOST-132〜157)
- **2 (高リスク)**: ライフサイクル処理、タイムアウト処理、例外ハンドリング (UT-HOST-071〜094)

## 6) レビュアーチェックリスト（最小）
- [ ] HostBuilder.Buildの二重呼び出し防止が正しく検証されているか
- [ ] Host.StartAsync/StopAsyncのサービス実行順序が正しいか
- [ ] BackgroundServiceExceptionBehaviorの動作が正しく検証されているか
- [ ] タイムアウト処理（StartupTimeout/ShutdownTimeout）が正しく検証されているか
- [ ] IHostedLifecycleServiceのライフサイクルメソッド呼び出し順序が正しいか
- [ ] ConsoleLifetimeのプラットフォーム固有実装を考慮した追加テストが必要か
- [ ] Development環境固有の動作（スコープ検証、UserSecrets）が正しく検証されているか
